/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.am.console.user.model;

import com.iplanet.am.console.base.model.AMConsoleException;
import com.iplanet.am.console.base.model.AMFormatUtils;
import com.iplanet.am.console.base.model.AMModelBase;
import com.iplanet.am.console.settings.RoleSettings;
import com.iplanet.am.console.user.model.UMDisplayOptionsModelImpl;
import com.iplanet.am.console.user.model.UMRoleDisplayOptionsModel;
import com.iplanet.am.sdk.AMRole;
import com.iplanet.sso.SSOException;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;

public class UMRoleDisplayOptionsModelImpl
extends UMDisplayOptionsModelImpl
implements UMRoleDisplayOptionsModel {
    private AMRole role = null;

    public UMRoleDisplayOptionsModelImpl(HttpServletRequest httpServletRequest, Map map) {
        super(httpServletRequest, map);
    }

    public String getSuccessMessage() {
        return this.getLocalizedString("updateRoleDisplayOptions.message");
    }

    public String getHelpAnchorTag() {
        String string = this.getLocalizedString("displayOptions.help");
        if (string.equals("displayOptions.help")) {
            string = "contents.html";
        }
        return this.getHelpURL(string);
    }

    public boolean isRoleExists() {
        return this.getAMRole() != null;
    }

    public String getInvalidRoleMessage() {
        return this.getLocalizedString("invalidRoleProfile.message");
    }

    private AMRole getAMRole() {
        block3: {
            if (this.role != null) break block3;
            try {
                this.role = this.dpStoreConn.getRole(this.profileDN);
                if (!this.role.isExists()) {
                    this.role = null;
                }
            }
            catch (SSOException sSOException) {
                AMModelBase.debug.error("UMRoleDisplayOptionsModelImpl.getAMRole", (Throwable)sSOException);
                this.role = null;
            }
        }
        return this.role;
    }

    public Map getSettings() {
        return RoleSettings.getSettings(this.profileDN);
    }

    public String getPageTitle() {
        return this.profileDN == null ? "" : AMFormatUtils.DNToName(this, this.profileDN, true);
    }

    public void setSettings(String string, Map map) throws AMConsoleException {
        RoleSettings.setSettings(this.dpStoreConn, this, string, map);
    }

    public String getAvailableActionsHelp() {
        return this.getLocalizedString("displayOptionsRoleAvailableActions.help");
    }

    public String getAvailableActionsHeaderString() {
        return this.getLocalizedString("displayOptionsRoleAvailableActions.header");
    }

    public boolean canEditSettings() {
        return true;
    }
}

