/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.am.console.user.model;

import com.iplanet.am.console.base.model.AMAdminUtils;
import com.iplanet.am.console.base.model.AMConsoleException;
import com.iplanet.am.console.base.model.AMFormatUtils;
import com.iplanet.am.console.base.model.AMModelBase;
import com.iplanet.am.console.user.model.UMNavModelImpl;
import com.iplanet.am.console.user.model.UMPCNavModel;
import com.iplanet.am.sdk.AMException;
import com.iplanet.am.sdk.AMObject;
import com.iplanet.am.sdk.AMOrganization;
import com.iplanet.am.sdk.AMOrganizationalUnit;
import com.iplanet.am.sdk.AMPeopleContainer;
import com.iplanet.am.sdk.AMSearchControl;
import com.iplanet.am.sdk.AMSearchResults;
import com.iplanet.am.util.Debug;
import com.iplanet.sso.SSOException;
import com.sun.identity.common.admin.AdminInterfaceUtils;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;

public class UMPCNavModelImpl
extends UMNavModelImpl
implements UMPCNavModel {
    private Set pcSet = null;

    public UMPCNavModelImpl(HttpServletRequest httpServletRequest, Map map) {
        super(httpServletRequest, map);
    }

    public String getSelectedOption() {
        return "peoplecontainers";
    }

    public Set getPeopleContainers(String string) {
        if (this.pcSet == null) {
            this.pcSet = Collections.EMPTY_SET;
            AMSearchResults aMSearchResults = null;
            AMSearchControl aMSearchControl = new AMSearchControl();
            aMSearchControl.setSearchScope(1);
            String[] stringArray = new String[]{AdminInterfaceUtils.getNamingAttribute((int)5, (Debug)AMModelBase.debug)};
            aMSearchControl.setSortKeys(stringArray);
            try {
                switch (this.locationType) {
                    case 2: {
                        AMOrganization aMOrganization = this.dpStoreConn.getOrganization(this.locationDN);
                        this.setSearchControlLimits((AMObject)aMOrganization, aMSearchControl);
                        aMSearchResults = aMOrganization.searchPeopleContainers(string, aMSearchControl);
                        break;
                    }
                    case 3: {
                        AMOrganizationalUnit aMOrganizationalUnit = this.dpStoreConn.getOrganizationalUnit(this.locationDN);
                        this.setSearchControlLimits((AMObject)aMOrganizationalUnit, aMSearchControl);
                        aMSearchResults = aMOrganizationalUnit.searchPeopleContainers(string, aMSearchControl);
                        break;
                    }
                    case 5: {
                        AMPeopleContainer aMPeopleContainer = this.dpStoreConn.getPeopleContainer(this.locationDN);
                        this.pcSet = aMPeopleContainer.searchSubPeopleContainers(string, 1);
                        break;
                    }
                    default: {
                        if (AMModelBase.debug.warningEnabled()) {
                            AMModelBase.debug.warning("UMPCNavModelImpl.getPeopleContainersinvalid location " + this.locationType);
                        }
                        break;
                    }
                }
            }
            catch (SSOException sSOException) {
                AMModelBase.debug.warning("UMPCNavModelImpl.getPeopleContainers", (Throwable)sSOException);
            }
            catch (AMException aMException) {
                AMModelBase.debug.warning("UMPCNavModelImpl.getPeopleContainers", (Throwable)aMException);
                this.searchErrorMsg = this.getErrorString((Exception)((Object)aMException));
            }
            if (aMSearchResults != null) {
                this.pcSet = aMSearchResults.getSearchResults();
                this.searchErrorMsg = AMAdminUtils.getSearchResultWarningMessage(aMSearchResults, this);
            }
        }
        return this.pcSet;
    }

    public boolean deletePeopleContainers(Set set) {
        boolean bl = false;
        if (set != null) {
            try {
                Map map = this.deleteUMObject(5, set, "peopleContainerDeleted.message");
                if (!map.isEmpty()) {
                    Iterator iterator = map.keySet().iterator();
                    this.setErrorMessage(this.getLocalizedString("deletePCFailed.message"));
                    while (iterator.hasNext()) {
                        String string = (String)iterator.next();
                        String string2 = AMFormatUtils.DNToName(this, string, false);
                        String string3 = (String)map.get(string);
                        this.setErrorMessage(string2 + " - " + string3);
                    }
                } else {
                    bl = true;
                }
            }
            catch (AMConsoleException aMConsoleException) {
                this.setErrorMessage(this.getErrorString(aMConsoleException));
            }
        } else {
            this.setErrorMessage(this.getLocalizedString("deleteFailed.message"));
        }
        return bl;
    }

    public String getHeaderLabel() {
        return this.getLocalizedString("peoplecontainers.header");
    }

    public String getNoEntrySelectedForDelTitle() {
        return this.getLocalizedString("noPCSelectForDeletion.title");
    }

    public String getNoEntrySelectedForDelMessage() {
        return this.getLocalizedString("noPCSelectForDeletion.message");
    }

    public Set getAttrList() {
        return this.pcSet;
    }

    public void setAttrList(Set set) {
        this.pcSet = set;
    }

    public String getPCDisplayOffMessage() {
        return this.getLocalizedString("peopleContainersDisplayOff.message");
    }

    protected boolean isCurrentLocationTypeValid() {
        boolean bl = false;
        switch (this.locationType) {
            case 2: 
            case 3: 
            case 5: {
                bl = true;
                break;
            }
            default: {
                if (!AMModelBase.debug.warningEnabled()) break;
                AMModelBase.debug.warning("UMPCNavModelImpl.isCurrentLocationTypeValid: invalid location type, " + this.locationType);
            }
        }
        return bl;
    }
}

