/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.am.console.user.model;

import com.iplanet.am.console.base.model.AMAdminUtils;
import com.iplanet.am.console.base.model.AMConsoleException;
import com.iplanet.am.console.base.model.AMModelBase;
import com.iplanet.am.console.base.model.DynamicGUIGenerator;
import com.iplanet.am.console.components.view.html.DynamicGUI;
import com.iplanet.am.console.settings.Setting;
import com.iplanet.am.console.user.model.UMDataModelImpl;
import com.iplanet.am.console.user.model.UMOrgUnitProfileModel;
import com.iplanet.am.sdk.AMException;
import com.iplanet.am.sdk.AMObject;
import com.iplanet.am.sdk.AMOrganizationalUnit;
import com.iplanet.sso.SSOException;
import com.sun.identity.sm.AttributeSchema;
import com.sun.identity.sm.SchemaType;
import com.sun.identity.sm.ServiceSchemaManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;

public class UMOrgUnitProfileModelImpl
extends UMDataModelImpl
implements UMOrgUnitProfileModel {
    private AMOrganizationalUnit orgUnit = null;

    public UMOrgUnitProfileModelImpl(HttpServletRequest httpServletRequest, Map map) {
        super(httpServletRequest, map);
    }

    public boolean modify(Map map) {
        AMModelBase.debug.message("UMOrgUnitProfileModelImpl.modify");
        boolean bl = false;
        try {
            AMOrganizationalUnit aMOrganizationalUnit = this.getOrganizationalUnit();
            if (aMOrganizationalUnit != null) {
                this.fireBeforeUpdateValuesEvent(3, (AMObject)aMOrganizationalUnit, map);
                bl = this.setAttributes((AMObject)aMOrganizationalUnit, map, "organizationalUnitChanged.message");
                this.fireAfterUpdateValuesEvent(3, (AMObject)aMOrganizationalUnit);
            } else if (AMModelBase.debug.warningEnabled()) {
                AMModelBase.debug.warning("UMOrgUnitProfileModelImpl.modify: organizational unit does not exists");
                this.errorMessage = this.getLocalizedString("noorganizationalunit.message");
            }
        }
        catch (AMConsoleException aMConsoleException) {
            this.errorMessage = this.getErrorString(aMConsoleException);
        }
        return bl;
    }

    public List getDynamicGUIComponents() {
        ArrayList<DynamicGUI> arrayList = Collections.EMPTY_LIST;
        ServiceSchemaManager serviceSchemaManager = this.getEntrySpecificSvcSchemaMgr();
        AMOrganizationalUnit aMOrganizationalUnit = this.getOrganizationalUnit();
        if (serviceSchemaManager != null && aMOrganizationalUnit != null) {
            Set set = this.getAttributesToDisplay(serviceSchemaManager, SchemaType.GLOBAL, "OrganizationalUnit");
            Map map = this.getOrgUnitAttributeValues(aMOrganizationalUnit, set);
            this.fireRetrieveAttributeValuesEvent((AMObject)aMOrganizationalUnit, 2, 3, "iPlanetAMEntrySpecificService", SchemaType.GLOBAL, map);
            AMAdminUtils.excludeAttributeSchemas(set, map.keySet());
            DynamicGUIGenerator dynamicGUIGenerator = DynamicGUIGenerator.getInstance();
            arrayList = new ArrayList<DynamicGUI>(set.size());
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                String string;
                Set set2;
                AttributeSchema attributeSchema = (AttributeSchema)iterator.next();
                DynamicGUI dynamicGUI = dynamicGUIGenerator.createDynamicGUI(attributeSchema, "iPlanetAMEntrySpecificService", set2 = (Set)map.get(string = attributeSchema.getName()), this, Setting.ACTION_ORGANIZATIONAL_UNIT);
                if (dynamicGUI == null) continue;
                arrayList.add(dynamicGUI);
            }
        }
        return arrayList;
    }

    private Map getOrgUnitAttributeValues(AMOrganizationalUnit aMOrganizationalUnit, Set set) {
        HashMap<String, Set> hashMap = new HashMap<String, Set>(set.size());
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            AttributeSchema attributeSchema = (AttributeSchema)iterator.next();
            String string = attributeSchema.getName();
            try {
                Set set2 = aMOrganizationalUnit.getAttribute(string);
                hashMap.put(string, set2);
            }
            catch (AMException aMException) {
                if (!AMModelBase.debug.warningEnabled()) continue;
                AMModelBase.debug.warning("UMOrgUnitProfileModelImpl.getOrgUnitAttributeValues: could not get value for " + string, (Throwable)aMException);
            }
            catch (SSOException sSOException) {
                AMModelBase.debug.warning("UMOrgUnitProfileModelImpl.getOrgUnitAttributeValues", (Throwable)sSOException);
            }
        }
        return hashMap;
    }

    public String getSuccessMessage() {
        return this.getLocalizedString("updateOrganizationalUnit.message");
    }

    public String getHelpAnchorTag() {
        String string = this.getLocalizedString("organizationUnitProfile.help");
        if (string.equals("organizationUnitProfile.help")) {
            string = "contents.html";
        }
        return this.getHelpURL(string);
    }

    public boolean isOrganizationalUnitValid() {
        return this.getOrganizationalUnit() != null;
    }

    public String getInvalidOrganizationalUnitMessage() {
        return this.getLocalizedString("invalidOrganizationalUnitProfile.message");
    }

    private AMOrganizationalUnit getOrganizationalUnit() {
        block3: {
            if (this.orgUnit != null) break block3;
            try {
                this.orgUnit = this.dpStoreConn.getOrganizationalUnit(this.profileDN);
                if (!this.orgUnit.isExists()) {
                    this.orgUnit = null;
                }
            }
            catch (SSOException sSOException) {
                AMModelBase.debug.error("UMOrgUnitProfileModelImpl.getOrganizationalUnit", (Throwable)sSOException);
                this.orgUnit = null;
            }
        }
        return this.orgUnit;
    }

    public String getDefaultSubView() {
        String string = null;
        Set set = this.getUserSettings(Setting.DEFAULT_ORGANIZATIONAL_UNIT_PROFILE_VIEW);
        if (set != null && !set.isEmpty()) {
            String string2 = (String)set.iterator().next();
            string = string2.toLowerCase();
        }
        if (string == null) {
            string = "general";
        }
        return string;
    }
}

