/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.am.console.user.model;

import com.iplanet.am.console.base.model.AMConsoleException;
import com.iplanet.am.console.base.model.AMModelBase;
import com.iplanet.am.console.settings.OrganizationalSettings;
import com.iplanet.am.console.settings.OrganizationalSettingsCache;
import com.iplanet.am.console.user.model.UMDisplayOptionsModelImpl;
import com.iplanet.am.console.user.model.UMOrgDisplayOptionsModel;
import com.iplanet.am.sdk.AMOrganization;
import com.iplanet.sso.SSOException;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;

public class UMOrgDisplayOptionsModelImpl
extends UMDisplayOptionsModelImpl
implements UMOrgDisplayOptionsModel {
    private AMOrganization organization = null;

    public UMOrgDisplayOptionsModelImpl(HttpServletRequest httpServletRequest, Map map) {
        super(httpServletRequest, map);
    }

    public String getSuccessMessage() {
        return this.getLocalizedString("updateOrganizationDisplayOptions.message");
    }

    public String getHelpAnchorTag() {
        String string = this.getLocalizedString("displayOptions.help");
        if (string.equals("displayOptions.help")) {
            string = "contents.html";
        }
        return this.getHelpURL(string);
    }

    public boolean isOrganizationExists() {
        return this.getAMOrganization() != null;
    }

    public String getInvalidOrganizationMessage() {
        return this.getLocalizedString("invalidOrganizationProfile.message");
    }

    private AMOrganization getAMOrganization() {
        block3: {
            if (this.organization != null) break block3;
            try {
                this.organization = this.dpStoreConn.getOrganization(this.profileDN);
                if (!this.organization.isExists()) {
                    this.organization = null;
                }
            }
            catch (SSOException sSOException) {
                AMModelBase.debug.error("UMOrgDisplayOptionsModelImpl.getAMOrganization", (Throwable)sSOException);
                this.organization = null;
            }
        }
        return this.organization;
    }

    public Map getSettings() {
        OrganizationalSettingsCache organizationalSettingsCache = OrganizationalSettingsCache.getInstance();
        return organizationalSettingsCache.getSettings(this.profileDN);
    }

    public void setSettings(String string, Map map) throws AMConsoleException {
        OrganizationalSettings.setSettings(this.dpStoreConn, this, string, map);
    }

    public String getAvailableActionsHeaderString() {
        return this.getLocalizedString("displayOptionsOrgAvailableActions.header");
    }

    public boolean canEditSettings() {
        AMOrganization aMOrganization = this.getAMOrganization();
        return aMOrganization != null && this.getOrgTemplate(aMOrganization) != null;
    }
}

