/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.am.console.user.model;

import com.iplanet.am.console.base.model.AMConsoleException;
import com.iplanet.am.console.user.model.UMGroupSelectionModel;
import com.iplanet.am.console.user.model.UMSelectionModelImpl;
import com.iplanet.am.sdk.AMException;
import com.iplanet.am.sdk.AMGroup;
import com.iplanet.am.sdk.AMStaticGroup;
import com.iplanet.sso.SSOException;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;

public class UMGroupSelectionModelImpl
extends UMSelectionModelImpl
implements UMGroupSelectionModel {
    public UMGroupSelectionModelImpl(HttpServletRequest httpServletRequest, Map map) {
        super(httpServletRequest, map);
    }

    public String getPageTitle() {
        return this.getLocalizedString("selectNestedGroup.label");
    }

    public String getGroupsTableHeader() {
        return this.getLocalizedString("searchResults.header");
    }

    public String getNameLabel() {
        return this.getLocalizedString("name.label");
    }

    public String getNoEntriesSelectedForNestingMessage() {
        return this.getLocalizedString("noGroupSelectedForNesting.message");
    }

    public void nestGroups(Set set) throws AMConsoleException {
        AMGroup aMGroup = this.getAMGroup();
        if (aMGroup != null) {
            try {
                aMGroup.addNestedGroups(set);
            }
            catch (AMException aMException) {
                throw new AMConsoleException(aMException);
            }
            catch (SSOException sSOException) {
                throw new AMConsoleException(sSOException);
            }
        }
    }

    private AMGroup getAMGroup() throws AMConsoleException {
        AMStaticGroup aMStaticGroup = null;
        try {
            switch (this.locationType) {
                case 9: 
                case 10: {
                    aMStaticGroup = this.dpStoreConn.getStaticGroup(this.locationDN);
                    break;
                }
                case 12: {
                    aMStaticGroup = this.dpStoreConn.getAssignableDynamicGroup(this.locationDN);
                    break;
                }
                case 11: {
                    aMStaticGroup = this.dpStoreConn.getDynamicGroup(this.locationDN);
                }
            }
        }
        catch (SSOException sSOException) {
            throw new AMConsoleException(sSOException);
        }
        return aMStaticGroup;
    }

    public String getSelectGroupsMessage() {
        return this.getLocalizedString("selectGroups.message");
    }
}

