/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.am.console.user.model;

import com.iplanet.am.console.base.model.AMAdminUtils;
import com.iplanet.am.console.base.model.AMConsoleException;
import com.iplanet.am.console.base.model.AMFormatUtils;
import com.iplanet.am.console.base.model.AMModelBase;
import com.iplanet.am.console.user.model.UMGroupSearchModel;
import com.iplanet.am.console.user.model.UMSearchModelImpl;
import com.iplanet.am.sdk.AMAssignableDynamicGroup;
import com.iplanet.am.sdk.AMDynamicGroup;
import com.iplanet.am.sdk.AMException;
import com.iplanet.am.sdk.AMGroup;
import com.iplanet.am.sdk.AMGroupContainer;
import com.iplanet.am.sdk.AMObject;
import com.iplanet.am.sdk.AMOrganization;
import com.iplanet.am.sdk.AMOrganizationalUnit;
import com.iplanet.am.sdk.AMSearchControl;
import com.iplanet.am.sdk.AMSearchResults;
import com.iplanet.am.sdk.AMStaticGroup;
import com.iplanet.am.util.Debug;
import com.iplanet.am.util.Locale;
import com.iplanet.sso.SSOException;
import com.sun.identity.common.admin.AdminInterfaceUtils;
import com.sun.identity.sm.AttributeSchema;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.SchemaType;
import com.sun.identity.sm.ServiceSchema;
import com.sun.identity.sm.ServiceSchemaManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;

public class UMGroupSearchModelImpl
extends UMSearchModelImpl
implements UMGroupSearchModel {
    private String errorMessage = null;

    public UMGroupSearchModelImpl(HttpServletRequest httpServletRequest, Map map) {
        super(httpServletRequest, map);
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public String getPageTitle() {
        return this.getLocalizedString("advancedGroupSearchPage.title");
    }

    public String getSearchButtonLabel() {
        return this.getLocalizedString("search.button");
    }

    public String getGroupLabel() {
        return this.getLocalizedString("name.label");
    }

    public String getAddNestedGroupTitle() {
        return this.getLocalizedString("addNestedGroup.label");
    }

    public String getSubscribableLabel() {
        return this.getLocalizedString("groupSubscribe.label");
    }

    public String[] getOptionLabels() {
        ArrayList<String> arrayList = new ArrayList<String>(3);
        arrayList.add("&nbsp;");
        arrayList.add(this.getLocalizedString("yes.label"));
        arrayList.add(this.getLocalizedString("no.label"));
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public String[] getOptionValues() {
        ArrayList<String> arrayList = new ArrayList<String>(3);
        arrayList.add("");
        arrayList.add("true");
        arrayList.add("false");
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public String getSearchFailedTitle() {
        return this.getLocalizedString("searchFailed.title");
    }

    public Set searchGroups(String string, Map map) {
        return this.searchGroups(string, "2", map);
    }

    private Map getSearchAttributeValues(Map map) {
        HashMap hashMap = new HashMap(1);
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            String string = (String)entry.getKey();
            Set set = (Set)entry.getValue();
            if (set == null || set.isEmpty()) continue;
            Iterator iterator2 = set.iterator();
            String string2 = (String)iterator2.next();
            HashSet<String> hashSet = new HashSet<String>(1);
            if (string2 == null || set.isEmpty()) continue;
            hashSet.add(string2);
            hashMap.put(string, hashSet);
        }
        return hashMap;
    }

    public Set searchGroupsInParentOrg(String string, String string2, Map map) throws AMConsoleException {
        this.resetSubscribableAttribute(map);
        Map map2 = this.getSearchAttributeValues(map);
        int n = 1;
        try {
            n = Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            AMModelBase.debug.warning("using default value of one for scope level");
        }
        AMSearchResults aMSearchResults = null;
        AMSearchControl aMSearchControl = new AMSearchControl();
        aMSearchControl.setSearchScope(n);
        String[] stringArray = new String[]{AdminInterfaceUtils.getNamingAttribute((int)9, (Debug)AMModelBase.debug)};
        aMSearchControl.setSortKeys(stringArray);
        try {
            String string3 = this.getAMObject(this.locationDN).getOrganizationDN();
            AMOrganization aMOrganization = this.dpStoreConn.getOrganization(string3);
            this.setSearchControlLimits((AMObject)aMOrganization, aMSearchControl);
            AMGroupContainer aMGroupContainer = null;
            if (n == 1) {
                aMGroupContainer = this.getDefaultGroupContainer(string3);
            }
            aMSearchResults = aMGroupContainer != null ? aMGroupContainer.searchGroups(string, map2, aMSearchControl) : aMOrganization.searchGroups(string, map2, aMSearchControl);
            Set set = Collections.EMPTY_SET;
            if (aMSearchResults != null) {
                set = aMSearchResults.getSearchResults();
                String string4 = AMAdminUtils.getSearchResultWarningMessage(aMSearchResults, this);
                if (string4 != null && string4.length() > 0) {
                    throw new AMConsoleException(string4);
                }
            }
            set.remove(this.locationDN);
            set.removeAll(this.getNestedGroupDNs());
            return set;
        }
        catch (AMException aMException) {
            throw new AMConsoleException(aMException);
        }
        catch (SSOException sSOException) {
            throw new AMConsoleException(sSOException);
        }
    }

    private void resetSubscribableAttribute(Map map) {
        String string;
        Set set;
        if (map != null && !map.isEmpty() && (set = (Set)map.get("iplanet-am-group-subscribable")) != null && !set.isEmpty() && (string = (String)set.iterator().next()).equals("false")) {
            map.put("iplanet-am-group-subscribable", Collections.EMPTY_SET);
        }
    }

    private Set getNestedGroupDNs() {
        Set set = Collections.EMPTY_SET;
        try {
            switch (this.locationType) {
                case 10: {
                    AMStaticGroup aMStaticGroup = this.dpStoreConn.getStaticGroup(this.locationDN);
                    set = aMStaticGroup.getNestedGroupDNs();
                    break;
                }
                case 11: {
                    AMDynamicGroup aMDynamicGroup = this.dpStoreConn.getDynamicGroup(this.locationDN);
                    set = aMDynamicGroup.getNestedGroupDNs();
                    break;
                }
                case 12: {
                    AMAssignableDynamicGroup aMAssignableDynamicGroup = this.dpStoreConn.getAssignableDynamicGroup(this.locationDN);
                    set = aMAssignableDynamicGroup.getNestedGroupDNs();
                }
            }
        }
        catch (AMException aMException) {
            AMModelBase.debug.warning("UMGroupSearchModelImpl.getNestedGroupDNs", (Throwable)aMException);
        }
        catch (SSOException sSOException) {
            AMModelBase.debug.warning("UMGroupSearchModelImpl.getNestedGroupDNs", (Throwable)sSOException);
        }
        return set;
    }

    public Set searchGroups(String string, String string2, Map map) {
        Object object;
        Map map2 = this.getSearchAttributeValues(map);
        int n = 1;
        try {
            n = Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            AMModelBase.debug.warning("using default value of one for scope level");
        }
        AMSearchResults aMSearchResults = null;
        AMSearchControl aMSearchControl = new AMSearchControl();
        aMSearchControl.setSearchScope(n);
        String[] stringArray = new String[]{AdminInterfaceUtils.getNamingAttribute((int)9, (Debug)AMModelBase.debug)};
        aMSearchControl.setSortKeys(stringArray);
        AMGroupContainer aMGroupContainer = null;
        try {
            switch (this.locationType) {
                case 2: {
                    object = this.dpStoreConn.getOrganization(this.locationDN);
                    this.setSearchControlLimits((AMObject)object, aMSearchControl);
                    if (n == 1) {
                        aMGroupContainer = this.getDefaultGroupContainer(this.locationDN);
                    }
                    if (aMGroupContainer != null) {
                        aMSearchResults = aMGroupContainer.searchGroups(string, map2, aMSearchControl);
                        break;
                    }
                    aMSearchResults = object.searchGroups(string, map2, aMSearchControl);
                    break;
                }
                case 3: {
                    AMOrganizationalUnit aMOrganizationalUnit = this.dpStoreConn.getOrganizationalUnit(this.locationDN);
                    this.setSearchControlLimits((AMObject)aMOrganizationalUnit, aMSearchControl);
                    if (n == 1) {
                        aMGroupContainer = this.getDefaultGroupContainer(this.locationDN);
                    }
                    if (aMGroupContainer != null) {
                        aMSearchResults = aMGroupContainer.searchGroups(string, map2, aMSearchControl);
                        break;
                    }
                    aMSearchResults = aMOrganizationalUnit.searchGroups(string, map2, aMSearchControl);
                    break;
                }
                case 4: {
                    aMGroupContainer = this.dpStoreConn.getGroupContainer(this.locationDN);
                    this.setSearchControlLimits((AMObject)this.dpStoreConn.getOrganization(aMGroupContainer.getOrganizationDN()), aMSearchControl);
                    aMSearchResults = aMGroupContainer.searchGroups(string, map2, aMSearchControl);
                    break;
                }
                case 9: 
                case 10: {
                    AMStaticGroup aMStaticGroup = this.dpStoreConn.getStaticGroup(this.locationDN);
                    this.setSearchControlLimits((AMObject)this.dpStoreConn.getOrganization(aMStaticGroup.getOrganizationDN()), aMSearchControl);
                    aMSearchResults = this.searchGroups((AMGroup)aMStaticGroup, string, map2, aMSearchControl);
                    break;
                }
                case 11: {
                    AMDynamicGroup aMDynamicGroup = this.dpStoreConn.getDynamicGroup(this.locationDN);
                    this.setSearchControlLimits((AMObject)this.dpStoreConn.getOrganization(aMDynamicGroup.getOrganizationDN()), aMSearchControl);
                    aMSearchResults = this.searchGroups((AMGroup)aMDynamicGroup, string, map2, aMSearchControl);
                    break;
                }
                case 12: {
                    AMAssignableDynamicGroup aMAssignableDynamicGroup = this.dpStoreConn.getAssignableDynamicGroup(this.locationDN);
                    this.setSearchControlLimits((AMObject)this.dpStoreConn.getOrganization(aMAssignableDynamicGroup.getOrganizationDN()), aMSearchControl);
                    aMSearchResults = this.searchGroups((AMGroup)aMAssignableDynamicGroup, string, map2, aMSearchControl);
                    break;
                }
                default: {
                    if (AMModelBase.debug.messageEnabled()) {
                        AMModelBase.debug.message("UMUserSearchModelImpl invalid location " + this.locationDN);
                    }
                    break;
                }
            }
        }
        catch (AMException aMException) {
            AMModelBase.debug.warning("UMGroupSearchModelImpl.searchGroups", (Throwable)aMException);
            this.errorMessage = this.getErrorString((Exception)((Object)aMException));
        }
        catch (SSOException sSOException) {
            AMModelBase.debug.warning("UMGroupSearchModelImpl.searchGroups", (Throwable)sSOException);
            this.errorMessage = this.getErrorString((Exception)((Object)sSOException));
        }
        object = Collections.EMPTY_SET;
        if (aMSearchResults != null) {
            object = aMSearchResults.getSearchResults();
            this.errorMessage = AMAdminUtils.getSearchResultWarningMessage(aMSearchResults, this);
        }
        return object;
    }

    private AMSearchResults searchGroups(AMGroup aMGroup, String string, Map map, AMSearchControl aMSearchControl) throws AMException, SSOException {
        AMSearchResults aMSearchResults = aMGroup.searchGroups(string, map, aMSearchControl);
        if (aMSearchResults != null) {
            Set set = aMSearchResults.getSearchResults();
            set.remove(aMGroup.getDN());
        }
        return aMSearchResults;
    }

    private AMGroupContainer getDefaultGroupContainer(String string) {
        AMGroupContainer aMGroupContainer = null;
        Set set = Collections.EMPTY_SET;
        String string2 = AdminInterfaceUtils.getNamingAttribute((int)4, (Debug)AMModelBase.debug) + "=" + AdminInterfaceUtils.defaultGroupContainerName() + "," + string;
        try {
            Iterator iterator;
            int n = this.getLocationType(string);
            switch (n) {
                case 2: {
                    AMOrganization aMOrganization = this.dpStoreConn.getOrganization(string);
                    aMGroupContainer = this.dpStoreConn.getGroupContainer(string2);
                    if (aMGroupContainer != null && aMGroupContainer.isExists()) break;
                    set = aMOrganization.getGroupContainers(1);
                    break;
                }
                case 3: {
                    AMOrganizationalUnit aMOrganizationalUnit = this.dpStoreConn.getOrganizationalUnit(string);
                    aMGroupContainer = this.dpStoreConn.getGroupContainer(string2);
                    if (aMGroupContainer != null && aMGroupContainer.isExists()) break;
                    set = aMOrganizationalUnit.getGroupContainers(1);
                    break;
                }
                default: {
                    AMModelBase.debug.warning("Unsupported object type for group containers");
                }
            }
            if (!set.isEmpty() && (iterator = set.iterator()).hasNext()) {
                aMGroupContainer = this.dpStoreConn.getGroupContainer((String)iterator.next());
            }
        }
        catch (AMException aMException) {
            AMModelBase.debug.warning("UMGroupSearchModel.getDefaultGroupContainer", (Throwable)aMException);
        }
        catch (SSOException sSOException) {
            AMModelBase.debug.warning("UMGroupSearchModel.getDefaultGroupContainer", (Throwable)sSOException);
        }
        return aMGroupContainer;
    }

    public String getHelpAnchorTag() {
        String string = this.getLocalizedString("groupSearch.help");
        if (string.equals("groupSearch.help")) {
            string = "contents.html";
        }
        return this.getHelpURL(string);
    }

    private void buildSchemaAttributeList(String string) {
        block5: {
            ServiceSchemaManager serviceSchemaManager = this.getEntrySpecificSvcMgr();
            if (serviceSchemaManager == null) {
                return;
            }
            try {
                String string2;
                Object object;
                ServiceSchema serviceSchema = serviceSchemaManager.getSchema(SchemaType.GLOBAL);
                ResourceBundle resourceBundle = ResourceBundle.getBundle(serviceSchemaManager.getI18NFileName(), this.getUserLocale());
                ServiceSchema serviceSchema2 = serviceSchema.getSubSchema(string);
                if (serviceSchema2 == null) break block5;
                List list = AMFormatUtils.sortAttrSchema(serviceSchema2.getAttributeSchemas(), this.getUserLocale());
                this.requiredAttributes = new ArrayList(list.size());
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    String string3;
                    object = (AttributeSchema)iterator.next();
                    string2 = object.getName();
                    if (string2.equals("uniquemember") || (string3 = object.getI18NKey()) == null || string3.length() <= 0) continue;
                    this.requiredAttributes.add(object);
                }
                this.attributeLabels = new ArrayList(this.requiredAttributes.size());
                object = this.requiredAttributes.iterator();
                while (object.hasNext()) {
                    string2 = (AttributeSchema)object.next();
                    this.attributeLabels.add(Locale.getString((ResourceBundle)resourceBundle, (String)string2.getI18NKey(), (Debug)AMModelBase.debug));
                }
            }
            catch (SMSException sMSException) {
                AMModelBase.debug.warning("failed to get required attributes", (Throwable)sMSException);
            }
        }
    }

    public int getNumStaticAttributes() {
        if (this.requiredAttributes == null) {
            this.buildSchemaAttributeList("Group");
        }
        return this.requiredAttributes.size();
    }

    public int getNumSearchAttributes() {
        if (this.requiredAttributes == null) {
            this.buildSchemaAttributeList("Group");
        }
        return this.requiredAttributes.size();
    }

    public String getNoMatchMsg() {
        return this.getLocalizedString("noMatchingEntries.message");
    }
}

