/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.am.console.user.model;

import com.iplanet.am.console.base.model.AMAdminUtils;
import com.iplanet.am.console.base.model.AMConsoleException;
import com.iplanet.am.console.base.model.AMFormatUtils;
import com.iplanet.am.console.base.model.AMModelBase;
import com.iplanet.am.console.user.model.UMDataModelImpl;
import com.iplanet.am.console.user.model.UMGroupMemberEntry;
import com.iplanet.am.console.user.model.UMGroupMembersModel;
import com.iplanet.am.sdk.AMAssignableDynamicGroup;
import com.iplanet.am.sdk.AMDynamicGroup;
import com.iplanet.am.sdk.AMException;
import com.iplanet.am.sdk.AMGroup;
import com.iplanet.am.sdk.AMStaticGroup;
import com.iplanet.am.sdk.AMUser;
import com.iplanet.sso.SSOException;
import com.sun.identity.common.DisplayUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;

public class UMGroupMembersModelImpl
extends UMDataModelImpl
implements UMGroupMembersModel {
    private AMGroup amGroup;

    public UMGroupMembersModelImpl(HttpServletRequest httpServletRequest, Map map) {
        super(httpServletRequest, map);
        this.amGroup = this.getAMGroup(this.locationDN);
    }

    public String getRowLabel() {
        return this.getLocalizedString("row.label");
    }

    public String getRowsLabel() {
        return this.getLocalizedString("rows.label");
    }

    public String getMembersTableHeader() {
        return this.getLocalizedString("members.header");
    }

    public String getActionLabel() {
        return this.getLocalizedString("action.label");
    }

    public String getAvailableActionsLabel() {
        return this.getLocalizedString("groupMembershipActions.label");
    }

    public String getCreateGroupActionLabel() {
        return this.getLocalizedString("groupCreateGroupAction.label");
    }

    public String getCreateUserActionLabel() {
        return this.getLocalizedString("groupCreateUserAction.label");
    }

    public String getAddGroupActionLabel() {
        return this.getLocalizedString("groupAddGroupAction.label");
    }

    public String getAddUserActionLabel() {
        return this.getLocalizedString("groupAddUserAction.label");
    }

    public String getDeleteMembersActionLabel() {
        return this.getLocalizedString("groupDeleteMembersAction.label");
    }

    public String getRemoveMembersActionLabel() {
        return this.getLocalizedString("groupRemoveMembersAction.label");
    }

    public String getMembershipTableNameHeader() {
        return this.getLocalizedString("groupMemberName.label");
    }

    public String getMembershipTableUserIDHeader() {
        return this.getLocalizedString("groupMemberUserID.label");
    }

    public String getNoEntriesMessage() {
        return this.getLocalizedString("noEntries.message");
    }

    public String getEditLabel() {
        return this.getLocalizedString("edit.label");
    }

    public String getNoEntriesSelectedForDeletionMessage() {
        return this.getLocalizedString("noGroupMemberSelectedForDeletion.message");
    }

    public String getNoEntriesSelectedForRemovalMessage() {
        return this.getLocalizedString("noGroupMemberSelectedForRemoval.message");
    }

    public List getMembers(String string) {
        ArrayList<UMGroupMemberEntry> arrayList;
        block7: {
            arrayList = Collections.EMPTY_LIST;
            if (this.amGroup == null) break block7;
            arrayList = new ArrayList<UMGroupMemberEntry>();
            try {
                UMGroupMemberEntry uMGroupMemberEntry;
                String string2;
                Iterator iterator;
                Set set = this.amGroup.getUserDNs();
                if (set != null && !set.isEmpty()) {
                    iterator = set.iterator();
                    while (iterator.hasNext()) {
                        string2 = (String)iterator.next();
                        uMGroupMemberEntry = this.getUserMemberEntry(string2, string);
                        if (uMGroupMemberEntry == null) continue;
                        arrayList.add(uMGroupMemberEntry);
                    }
                }
                if ((set = this.amGroup.getNestedGroupDNs()) != null && !set.isEmpty()) {
                    iterator = set.iterator();
                    while (iterator.hasNext()) {
                        string2 = (String)iterator.next();
                        uMGroupMemberEntry = this.getGroupMemberEntry(string2, string);
                        if (uMGroupMemberEntry == null) continue;
                        arrayList.add(uMGroupMemberEntry);
                    }
                }
                Collections.sort(arrayList, new UMGroupMemberEntry(this.getUserLocale()));
            }
            catch (SSOException sSOException) {
                AMModelBase.debug.warning("UMGroupMembersModelImpl.getMembers", (Throwable)sSOException);
            }
            catch (AMException aMException) {
                AMModelBase.debug.warning("UMGroupMembersModelImpl.getMembers", (Throwable)aMException);
            }
        }
        return arrayList;
    }

    private UMGroupMemberEntry getUserMemberEntry(String string, String string2) {
        UMGroupMemberEntry uMGroupMemberEntry = null;
        try {
            String string3;
            AMUser aMUser = this.dpStoreConn.getUser(string);
            if (aMUser != null && aMUser.isExists() && DisplayUtils.wildcardMatch((String)(string3 = AMAdminUtils.getFirstElement(aMUser.getAttribute("cn"))), (String)string2)) {
                String string4 = AMFormatUtils.DNToName(this, string);
                uMGroupMemberEntry = new UMGroupMemberEntry(string, string3, 1, string4);
            }
        }
        catch (SSOException sSOException) {
            AMModelBase.debug.warning("UMGroupMembersModelImpl.getUserMemberEntry", (Throwable)sSOException);
        }
        catch (AMException aMException) {
            AMModelBase.debug.warning("UMGroupMembersModelImpl.getUserMemberEntry", (Throwable)aMException);
        }
        return uMGroupMemberEntry;
    }

    private UMGroupMemberEntry getGroupMemberEntry(String string, String string2) {
        UMGroupMemberEntry uMGroupMemberEntry = null;
        AMGroup aMGroup = this.getAMGroup(string);
        try {
            String string3;
            if (aMGroup != null && aMGroup.isExists() && DisplayUtils.wildcardMatch((String)(string3 = AMFormatUtils.DNToName(this, string)), (String)string2)) {
                uMGroupMemberEntry = new UMGroupMemberEntry(string, string3, 9, "");
            }
        }
        catch (SSOException sSOException) {
            AMModelBase.debug.warning("UMGroupMembersModelImpl.getGroupMemberEntry", (Throwable)sSOException);
        }
        return uMGroupMemberEntry;
    }

    private AMGroup getAMGroup(String string) {
        AMGroup aMGroup = null;
        int n = this.getLocationType(string);
        switch (n) {
            case 11: {
                aMGroup = this.getDynamicGroup(string);
                break;
            }
            case 12: {
                aMGroup = this.getAssignableDynamicGroup(string);
                break;
            }
            case 9: 
            case 10: {
                aMGroup = this.getStaticGroup(string);
            }
        }
        return aMGroup;
    }

    private AMGroup getDynamicGroup(String string) {
        AMDynamicGroup aMDynamicGroup = null;
        try {
            aMDynamicGroup = this.dpStoreConn.getDynamicGroup(string);
        }
        catch (SSOException sSOException) {
            AMModelBase.debug.warning("UMGroupMembersModelImpl.getDynamicGroup", (Throwable)sSOException);
        }
        return aMDynamicGroup;
    }

    private AMGroup getAssignableDynamicGroup(String string) {
        AMAssignableDynamicGroup aMAssignableDynamicGroup = null;
        try {
            aMAssignableDynamicGroup = this.dpStoreConn.getAssignableDynamicGroup(string);
        }
        catch (SSOException sSOException) {
            AMModelBase.debug.warning("UMGroupMembersModelImpl.getAssignableDynamicGroup", (Throwable)sSOException);
        }
        return aMAssignableDynamicGroup;
    }

    private AMGroup getStaticGroup(String string) {
        AMStaticGroup aMStaticGroup = null;
        try {
            aMStaticGroup = this.dpStoreConn.getStaticGroup(string);
        }
        catch (SSOException sSOException) {
            AMModelBase.debug.warning("UMGroupMembersModelImpl.getStaticGroup", (Throwable)sSOException);
        }
        return aMStaticGroup;
    }

    public void removeUsers(Set set) throws AMConsoleException {
        if (set != null && !set.isEmpty()) {
            try {
                switch (this.locationType) {
                    case 9: 
                    case 10: {
                        AMStaticGroup aMStaticGroup = (AMStaticGroup)this.getAMObject(this.locationDN);
                        aMStaticGroup.removeUsers(set);
                        this.writeLog("removedUserFromGroup.message", aMStaticGroup.getDN(), set);
                    }
                    case 12: {
                        AMStaticGroup aMStaticGroup = (AMAssignableDynamicGroup)this.getAMObject(this.locationDN);
                        aMStaticGroup.removeUsers(set);
                        this.writeLog("removedUserFromGroup.message", aMStaticGroup.getDN(), set);
                    }
                }
            }
            catch (SSOException sSOException) {
                AMModelBase.debug.warning("UMGroupMembersModelImpl.removeUsers", (Throwable)sSOException);
                throw new AMConsoleException(sSOException);
            }
            catch (AMException aMException) {
                AMModelBase.debug.warning("UMGroupMembersModelImpl.removeUsers", (Throwable)aMException);
                throw new AMConsoleException(aMException);
            }
        }
    }

    public void removeNestedGroups(Set set) throws AMConsoleException {
        if (set != null && !set.isEmpty()) {
            try {
                if (this.amGroup != null) {
                    this.amGroup.removeNestedGroups(set);
                    this.writeLog("removedNestedGroupFromGroup.message", this.amGroup.getDN(), set);
                }
            }
            catch (SSOException sSOException) {
                AMModelBase.debug.warning("UMGroupMembersModelImpl.removeNestedGroups", (Throwable)sSOException);
                throw new AMConsoleException(sSOException);
            }
            catch (AMException aMException) {
                AMModelBase.debug.warning("UMGroupMembersModelImpl.removeNestedGroups", (Throwable)aMException);
                throw new AMConsoleException(aMException);
            }
        }
    }

    public void deleteUsers(Set set) throws AMConsoleException {
        if (set != null && !set.isEmpty()) {
            try {
                Iterator iterator = set.iterator();
                while (iterator.hasNext()) {
                    String string = (String)iterator.next();
                    AMUser aMUser = this.getAMUserForDeletion(string);
                    if (aMUser == null) continue;
                    aMUser.delete(true);
                    this.logger.doLog("userDeleted.message", string);
                }
            }
            catch (SSOException sSOException) {
                AMModelBase.debug.warning("UMGroupMembersModelImpl.deleteUsers", (Throwable)sSOException);
                throw new AMConsoleException(sSOException);
            }
            catch (AMException aMException) {
                AMModelBase.debug.warning("UMGroupMembersModelImpl.deleteUsers", (Throwable)aMException);
                throw new AMConsoleException(aMException);
            }
        }
    }

    private AMUser getAMUserForDeletion(String string) {
        AMUser aMUser = null;
        try {
            aMUser = (AMUser)this.getAMObject(string);
            if (aMUser == null || !aMUser.isExists()) {
                aMUser = null;
            }
        }
        catch (SSOException sSOException) {
            AMModelBase.debug.warning("UMGroupMembersModelImpl.getAMUserForDeletion", (Throwable)sSOException);
        }
        catch (AMException aMException) {
            AMModelBase.debug.warning("UMGroupMembersModelImpl.getAMUserForDeletion", (Throwable)aMException);
        }
        return aMUser;
    }

    private AMGroup getAMGroupForDeletion(String string) {
        AMGroup aMGroup = null;
        try {
            aMGroup = (AMGroup)this.getAMObject(string);
            if (aMGroup == null || !aMGroup.isExists()) {
                aMGroup = null;
            }
        }
        catch (SSOException sSOException) {
            AMModelBase.debug.warning("UMGroupMembersModelImpl.getAMGroupForDeletion", (Throwable)sSOException);
        }
        catch (AMException aMException) {
            AMModelBase.debug.warning("UMGroupMembersModelImpl.getAMGroupForDeletion", (Throwable)aMException);
        }
        return aMGroup;
    }

    public void deleteNestedGroups(Set set) throws AMConsoleException {
        if (set != null && !set.isEmpty()) {
            try {
                Iterator iterator = set.iterator();
                while (iterator.hasNext()) {
                    String string = (String)iterator.next();
                    AMGroup aMGroup = this.getAMGroupForDeletion(string);
                    if (aMGroup == null) continue;
                    aMGroup.delete(true);
                    this.logger.doLog("groupDeleted.message", string);
                }
            }
            catch (SSOException sSOException) {
                AMModelBase.debug.warning("UMGroupMembersModelImpl.deleteUsers", (Throwable)sSOException);
                throw new AMConsoleException(sSOException);
            }
            catch (AMException aMException) {
                AMModelBase.debug.warning("UMGroupMembersModelImpl.deleteUsers", (Throwable)aMException);
                throw new AMConsoleException(aMException);
            }
        }
    }

    public boolean isDynamicGroup() {
        return this.locationType == 11;
    }

    private void writeLog(String string, String string2, Set set) {
        if (this.logger.isEnabled()) {
            StringBuffer stringBuffer = new StringBuffer(100);
            stringBuffer.append(this.getLocalizedString(string)).append(" " + string2).append(":" + set);
            this.logger.doLog(stringBuffer.toString());
        }
    }
}

