/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.am.console.user.model;

import com.iplanet.am.console.base.model.AMConsoleException;
import com.iplanet.am.console.base.model.AMFormatUtils;
import com.iplanet.am.console.base.model.AMModelBase;
import com.iplanet.am.console.user.model.UMGCNavModel;
import com.iplanet.am.console.user.model.UMNavModelImpl;
import com.iplanet.am.sdk.AMException;
import com.iplanet.am.sdk.AMGroupContainer;
import com.iplanet.am.sdk.AMObject;
import com.iplanet.am.sdk.AMOrganization;
import com.iplanet.am.sdk.AMOrganizationalUnit;
import com.iplanet.am.sdk.AMSearchControl;
import com.iplanet.am.sdk.AMSearchResults;
import com.iplanet.am.util.Debug;
import com.iplanet.sso.SSOException;
import com.sun.identity.common.admin.AdminInterfaceUtils;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;

public class UMGCNavModelImpl
extends UMNavModelImpl
implements UMGCNavModel {
    private Set gcSet = null;

    public UMGCNavModelImpl(HttpServletRequest httpServletRequest, Map map) {
        super(httpServletRequest, map);
    }

    public boolean hasGroupContainers(String string) {
        this.gcSet = this.getGroupContainers(string);
        return this.gcSet != null && !this.gcSet.isEmpty();
    }

    public String getSelectedOption() {
        return "groupcontainers";
    }

    public Set getGroupContainers(String string) {
        if (this.gcSet == null) {
            AMSearchResults aMSearchResults = null;
            AMSearchControl aMSearchControl = new AMSearchControl();
            aMSearchControl.setSearchScope(1);
            String[] stringArray = new String[]{AdminInterfaceUtils.getNamingAttribute((int)4, (Debug)AMModelBase.debug)};
            aMSearchControl.setSortKeys(stringArray);
            try {
                switch (this.locationType) {
                    case 2: {
                        AMOrganization aMOrganization = this.dpStoreConn.getOrganization(this.locationDN);
                        this.setSearchControlLimits((AMObject)aMOrganization, aMSearchControl);
                        aMSearchResults = aMOrganization.searchGroupContainers(string, null, aMSearchControl);
                        break;
                    }
                    case 3: {
                        AMOrganizationalUnit aMOrganizationalUnit = this.dpStoreConn.getOrganizationalUnit(this.locationDN);
                        this.setSearchControlLimits((AMObject)aMOrganizationalUnit, aMSearchControl);
                        aMSearchResults = aMOrganizationalUnit.searchGroupContainers(string, null, aMSearchControl);
                        break;
                    }
                    case 4: {
                        AMGroupContainer aMGroupContainer = this.dpStoreConn.getGroupContainer(this.locationDN);
                        this.setSearchControlLimits((AMObject)aMGroupContainer, aMSearchControl);
                        aMSearchResults = aMGroupContainer.searchSubGroupContainers(string, null, aMSearchControl);
                        break;
                    }
                    default: {
                        if (AMModelBase.debug.warningEnabled()) {
                            AMModelBase.debug.warning("UMGCNavModelImpl.getGroupContainersinvalid location " + this.locationType);
                        }
                        break;
                    }
                }
            }
            catch (SSOException sSOException) {
                AMModelBase.debug.warning("UMGCNavModelImpl.getGroupContainers", (Throwable)sSOException);
            }
            catch (AMException aMException) {
                AMModelBase.debug.warning("UMGCNavModelImpl.getGroupContainers", (Throwable)aMException);
                this.searchErrorMsg = this.getErrorString((Exception)((Object)aMException));
            }
            this.gcSet = this.getSearchResultsSet(aMSearchResults);
        }
        return this.gcSet;
    }

    public boolean deleteGroupContainers(Set set) {
        boolean bl = false;
        if (set != null) {
            try {
                Map map = this.deleteUMObject(4, set, "groupContainerDeleted.message");
                if (!map.isEmpty()) {
                    Iterator iterator = map.keySet().iterator();
                    this.setErrorMessage(this.getLocalizedString("deleteGCFailed.message"));
                    while (iterator.hasNext()) {
                        String string = (String)iterator.next();
                        String string2 = AMFormatUtils.DNToName(this, string, false);
                        String string3 = (String)map.get(string);
                        this.setErrorMessage(string2 + " - " + string3);
                    }
                } else {
                    bl = true;
                }
            }
            catch (AMConsoleException aMConsoleException) {
                this.setErrorMessage(this.getErrorString(aMConsoleException));
            }
        } else {
            this.setErrorMessage(this.getLocalizedString("deleteFailed.message"));
        }
        return bl;
    }

    public String getHeaderLabel() {
        return this.getLocalizedString("groupcontainers.header");
    }

    public String getNoEntrySelectedForDelTitle() {
        return this.getLocalizedString("noGCSelectForDeletion.title");
    }

    public String getNoEntrySelectedForDelMessage() {
        return this.getLocalizedString("noGCSelectForDeletion.message");
    }

    public Set getAttrList() {
        return this.gcSet;
    }

    public void setAttrList(Set set) {
        this.gcSet = set;
    }

    public String getGCDisplayOffMessage() {
        return this.getLocalizedString("groupContainersDisplayOff.message");
    }

    protected boolean isCurrentLocationTypeValid() {
        boolean bl = false;
        switch (this.locationType) {
            case 2: 
            case 3: 
            case 4: {
                bl = true;
                break;
            }
            default: {
                if (!AMModelBase.debug.warningEnabled()) break;
                AMModelBase.debug.warning("UMGCNavModelImpl.isCurrentLocationTypeValid: invalid location type, " + this.locationType);
            }
        }
        return bl;
    }
}

