/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.am.console.user.model;

import com.iplanet.am.console.base.model.AMConsoleException;
import com.iplanet.am.console.base.model.AMModelBase;
import com.iplanet.am.console.base.model.DynamicGUIGenerator;
import com.iplanet.am.console.components.view.html.DynamicGUI;
import com.iplanet.am.console.settings.Setting;
import com.iplanet.am.console.user.model.UMFilteredRoleProfileModel;
import com.iplanet.am.console.user.model.UMRoleProfileModelImpl;
import com.iplanet.am.sdk.AMException;
import com.iplanet.am.sdk.AMFilteredRole;
import com.iplanet.am.sdk.AMObject;
import com.iplanet.sso.SSOException;
import com.sun.identity.sm.AttributeSchema;
import com.sun.identity.sm.SchemaType;
import com.sun.identity.sm.ServiceSchemaManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;

public class UMFilteredRoleProfileModelImpl
extends UMRoleProfileModelImpl
implements UMFilteredRoleProfileModel {
    public UMFilteredRoleProfileModelImpl(HttpServletRequest httpServletRequest, Map map) {
        super(httpServletRequest, map);
    }

    public boolean modify(Map map) {
        boolean bl;
        block11: {
            if (map == null || map.isEmpty()) {
                AMModelBase.debug.warning("modify called with empty data set");
                return true;
            }
            if (AMModelBase.debug.messageEnabled()) {
                AMModelBase.debug.message("modifying filtered role : " + map);
            }
            AMFilteredRole aMFilteredRole = null;
            try {
                aMFilteredRole = this.dpStoreConn.getFilteredRole(this.profileDN);
            }
            catch (SSOException sSOException) {
                AMModelBase.debug.warning("UMFilteredRoleProfileModelImpl.modify", (Throwable)sSOException);
                return false;
            }
            ServiceSchemaManager serviceSchemaManager = this.getEntrySpecificSvcSchemaMgr();
            Set set = this.getAttributesToDisplay(serviceSchemaManager, SchemaType.GLOBAL, "FilteredRole");
            if (set == null || set.isEmpty()) {
                AMModelBase.debug.warning("attribute schema is empty in modify");
                return false;
            }
            bl = true;
            try {
                if (aMFilteredRole.isExists()) {
                    this.setRoleFilter(aMFilteredRole, (Set)map.remove("filterinfo"));
                    this.setAttributes((AMObject)aMFilteredRole, map, "attribute.change");
                    break block11;
                }
                this.errorMessage = this.getLocalizedString("norole.message");
                bl = false;
            }
            catch (AMException aMException) {
                if (AMModelBase.debug.warningEnabled()) {
                    AMModelBase.debug.warning("Could not set the filter for " + aMFilteredRole.getDN(), (Throwable)aMException);
                }
                bl = false;
                this.errorMessage = this.getErrorString((Exception)((Object)aMException));
            }
            catch (AMConsoleException aMConsoleException) {
                bl = false;
                this.errorMessage = this.getErrorString(aMConsoleException);
            }
            catch (SSOException sSOException) {
                bl = false;
                AMModelBase.debug.warning("UMFilteredRoleProfileModelImpl.modify", (Throwable)sSOException);
            }
        }
        return bl;
    }

    private void setRoleFilter(AMFilteredRole aMFilteredRole, Set set) throws AMException, SSOException, AMConsoleException {
        String string = null;
        if (set != null && !set.isEmpty()) {
            string = (String)set.iterator().next();
        }
        if (string != null && string.length() > 0) {
            if (!string.startsWith("(") && !string.endsWith(")")) {
                string = "(" + string + ")";
            }
        } else {
            throw new AMConsoleException(this.getLocalizedString("cannotRemoveFilter.message"));
        }
        aMFilteredRole.setFilter(string);
        this.logger.doLog("roleFilterModified.message", aMFilteredRole.getDN());
    }

    private AMFilteredRole getFilteredRoleObject() {
        AMFilteredRole aMFilteredRole = null;
        try {
            aMFilteredRole = this.dpStoreConn.getFilteredRole(this.profileDN);
            if (aMFilteredRole == null || !aMFilteredRole.isExists()) {
                AMModelBase.debug.warning("role does not exists in createComponentList");
                aMFilteredRole = null;
            }
        }
        catch (SSOException sSOException) {
            AMModelBase.debug.warning("UMFilteredRoleProfileModelImpl.createComponentList", (Throwable)sSOException);
        }
        return aMFilteredRole;
    }

    public List getDynamicGUIComponents() {
        Set set;
        ArrayList<DynamicGUI> arrayList = Collections.EMPTY_LIST;
        ServiceSchemaManager serviceSchemaManager = this.getEntrySpecificSvcSchemaMgr();
        AMFilteredRole aMFilteredRole = this.getFilteredRoleObject();
        if (serviceSchemaManager != null && aMFilteredRole != null && (set = this.getAttributesToDisplay(serviceSchemaManager, SchemaType.GLOBAL, "FilteredRole")) != null && !set.isEmpty()) {
            arrayList = new ArrayList<DynamicGUI>(set.size());
            DynamicGUIGenerator dynamicGUIGenerator = DynamicGUIGenerator.getInstance();
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                HashSet<String> hashSet;
                AttributeSchema attributeSchema;
                block8: {
                    attributeSchema = (AttributeSchema)iterator.next();
                    String string = attributeSchema.getName();
                    hashSet = null;
                    try {
                        if (string.equals("filterinfo")) {
                            hashSet = new HashSet<String>(1);
                            hashSet.add(aMFilteredRole.getFilter());
                        } else {
                            hashSet = aMFilteredRole.getAttribute(string);
                        }
                    }
                    catch (AMException aMException) {
                        if (AMModelBase.debug.warningEnabled()) {
                            AMModelBase.debug.warning("Could not get value for " + string, (Throwable)aMException);
                        }
                    }
                    catch (SSOException sSOException) {
                        if (!AMModelBase.debug.warningEnabled()) break block8;
                        AMModelBase.debug.warning("Could not get value for " + string, (Throwable)sSOException);
                    }
                }
                DynamicGUI dynamicGUI = dynamicGUIGenerator.createDynamicGUI(attributeSchema, "iPlanetAMEntrySpecificService", hashSet, this, Setting.ACTION_ROLE);
                if (dynamicGUI == null) continue;
                arrayList.add(dynamicGUI);
            }
        }
        return arrayList;
    }

    public String getSuccessMessage() {
        return this.getLocalizedString("updateRole.message");
    }

    public String getHelpAnchorTag() {
        String string = this.getLocalizedString("filteredRoleProfile.help");
        if (string.equals("filteredRoleProfile.help")) {
            string = "contents.html";
        }
        return this.getHelpURL(string);
    }
}

