/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.am.console.user.model;

import com.iplanet.am.console.base.model.AMAdminUtils;
import com.iplanet.am.console.base.model.AMAttributeDisplayImpl;
import com.iplanet.am.console.base.model.AMConsoleException;
import com.iplanet.am.console.base.model.AMFormatUtils;
import com.iplanet.am.console.base.model.AMModelBase;
import com.iplanet.am.console.base.model.AMProfileModelBase;
import com.iplanet.am.console.base.model.AMServiceDisplayModelImpl;
import com.iplanet.am.console.user.model.UMEditRoleServiceAttrConfigModel;
import com.iplanet.am.sdk.AMException;
import com.iplanet.am.sdk.AMRole;
import com.iplanet.am.sdk.AMStoreConnection;
import com.iplanet.sso.SSOException;
import com.sun.identity.sm.AttributeSchema;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.SchemaType;
import com.sun.identity.sm.ServiceSchema;
import com.sun.identity.sm.ServiceSchemaManager;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.servlet.http.HttpServletRequest;

public class UMEditRoleServiceAttrConfigModelImpl
extends AMProfileModelBase
implements UMEditRoleServiceAttrConfigModel {
    private String roleDN;
    private AMRole role;
    private int roleType = 3;
    private String serviceName;
    private List attributeNames;
    private Map attrNameToOptions;
    private Map attrNameToLocalizedName = new HashMap();

    public UMEditRoleServiceAttrConfigModelImpl(HttpServletRequest httpServletRequest, Map map, String string, String string2) {
        super(httpServletRequest, map);
        this.roleDN = string;
        this.serviceName = string2;
    }

    public String getRoleName() {
        String string = null;
        if (this.roleDN != null) {
            string = AMFormatUtils.DNToName(this, this.roleDN, this.isRoleType(this.locationDN));
        }
        return string != null ? string : "";
    }

    public String getLocalizedServiceName() {
        return this.getLocalizedServiceName(this.serviceName);
    }

    public String getAttributeNameLabel() {
        return this.getLocalizedString("attributeName.label");
    }

    public String getReadWriteLabel() {
        return this.getLocalizedString("roleDisplayProfileDisplay.label");
    }

    public String getReadOnlyLabel() {
        return this.getLocalizedString("readOnly.label");
    }

    public List getAttributeNames() {
        if (this.attributeNames == null) {
            this.attributeNames = new ArrayList();
            this.createRoleHandle();
            if (this.role != null) {
                this.setAttributeNames();
            }
        }
        return this.attributeNames;
    }

    public String getLocalizedAttributeName(String string) {
        return (String)this.attrNameToLocalizedName.get(string);
    }

    private void setAttributeNames() {
        try {
            ServiceSchemaManager serviceSchemaManager = this.getServiceSchemaManager(this.serviceName);
            if (this.roleType != 3) {
                this.registerAttributeSchemas(serviceSchemaManager, this.getAttributeSchemas(serviceSchemaManager, SchemaType.ORGANIZATION));
            }
            this.registerAttributeSchemas(serviceSchemaManager, this.getAttributeSchemas(serviceSchemaManager, SchemaType.DYNAMIC));
            this.registerAttributeSchemas(serviceSchemaManager, this.getAttributeSchemas(serviceSchemaManager, SchemaType.USER));
        }
        catch (SSOException sSOException) {
            AMModelBase.debug.warning("UMEditRoleServiceAttrConfigModelImpl.getAttributeNames", (Throwable)sSOException);
        }
        catch (SMSException sMSException) {
            AMModelBase.debug.warning("UMEditRoleServiceAttrConfigModelImpl.getAttributeNames", (Throwable)sMSException);
        }
    }

    private void registerAttributeSchemas(ServiceSchemaManager serviceSchemaManager, Set set) {
        AttributeSchema attributeSchema;
        HashMap<String, String> hashMap = new HashMap<String, String>(set.size() * 2);
        TreeSet<String> treeSet = new TreeSet<String>();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            attributeSchema = (AttributeSchema)iterator.next();
            String string = attributeSchema.getName();
            String string2 = attributeSchema.getI18NKey();
            if (string2 == null || string2.length() <= 0) continue;
            String string3 = this.getL10NAttributeName(serviceSchemaManager, string2);
            this.attrNameToLocalizedName.put(string, string3);
            hashMap.put(string2, string);
            treeSet.add(string2);
        }
        attributeSchema = treeSet.iterator();
        while (attributeSchema.hasNext()) {
            this.attributeNames.add(hashMap.get(attributeSchema.next()));
        }
    }

    private Set getAttributeSchemas(ServiceSchemaManager serviceSchemaManager, SchemaType schemaType) {
        HashSet<AttributeSchema> hashSet;
        block4: {
            hashSet = Collections.EMPTY_SET;
            try {
                ServiceSchema serviceSchema;
                Set set = serviceSchemaManager.getSchemaTypes();
                if (set == null || !AMAdminUtils.containsSchemaType(set, schemaType) || (serviceSchema = serviceSchemaManager.getSchema(schemaType)) == null) break block4;
                Set set2 = serviceSchema.getAttributeSchemaNames();
                hashSet = new HashSet<AttributeSchema>(set2.size() * 2);
                if (set2 != null && !set2.isEmpty()) {
                    Iterator iterator = set2.iterator();
                    while (iterator.hasNext()) {
                        String string = (String)iterator.next();
                        AttributeSchema attributeSchema = serviceSchema.getAttributeSchema(string);
                        if (attributeSchema == null) continue;
                        hashSet.add(attributeSchema);
                    }
                }
            }
            catch (SMSException sMSException) {
                AMModelBase.debug.warning("UMEditRoleServiceAttrConfigModelImpl.getAttributeSchemas", (Throwable)sMSException);
            }
        }
        return hashSet;
    }

    public boolean isAttrDisplay(String string) {
        boolean bl = false;
        this.getDisplayOptions();
        Set set = (Set)this.attrNameToOptions.get(string);
        if (set != null && !set.isEmpty() && !set.contains("readOnly")) {
            if ((this.isAdministrator() || this.isTopLevelAdministrator()) && (set.contains("adminDisplay") || set.contains("display") || set.contains("userReadOnly"))) {
                bl = true;
            } else if (set.contains("display") && !set.contains("userReadOnly")) {
                bl = true;
            }
        }
        return bl;
    }

    public boolean isAttrReadOnly(String string) {
        boolean bl = false;
        this.getDisplayOptions();
        Set set = (Set)this.attrNameToOptions.get(string);
        if (set != null && !set.isEmpty()) {
            bl = !this.isAttrDisplay(string);
        }
        return bl;
    }

    private void getDisplayOptions() {
        if (this.attrNameToOptions == null) {
            if (this.role != null) {
                try {
                    AMAttributeDisplayImpl aMAttributeDisplayImpl = new AMAttributeDisplayImpl(this.dpStoreConn, this.ssoToken);
                    HashSet<String> hashSet = new HashSet<String>(2);
                    hashSet.add(this.serviceName);
                    this.attrNameToOptions = (Map)aMAttributeDisplayImpl.getRoleOptions(this, this.role, hashSet).get(this.serviceName);
                }
                catch (AMException aMException) {
                    AMModelBase.debug.warning("UMEditRoleServiceAttrConfigModelImpl.getAttributeNames", (Throwable)aMException);
                }
                catch (SMSException sMSException) {
                    AMModelBase.debug.warning("UMEditRoleServiceAttrConfigModelImpl.getAttributeNames", (Throwable)sMSException);
                }
                catch (SSOException sSOException) {
                    AMModelBase.debug.warning("UMEditRoleServiceAttrConfigModelImpl.getAttributeNames", (Throwable)sSOException);
                }
            }
            if (this.attrNameToOptions == null) {
                this.attrNameToOptions = Collections.EMPTY_MAP;
            }
        }
    }

    public void saveDisplayOptions(Map map) throws AMConsoleException {
        this.createRoleHandle();
        if (this.role != null) {
            try {
                AMAttributeDisplayImpl aMAttributeDisplayImpl = new AMAttributeDisplayImpl(this.dpStoreConn, this.ssoToken);
                Map map2 = aMAttributeDisplayImpl.getRoleOptions(this, this.role, this.getServiceNames());
                HashMap<String, Map> hashMap = new HashMap<String, Map>(2);
                hashMap.put(this.serviceName, map);
                map2.putAll(hashMap);
                aMAttributeDisplayImpl.setRoleOptions(this.role, map2);
                this.logger.doLog("roleServiceAttrModified.message", this.role.getDN());
            }
            catch (AMException aMException) {
                throw new AMConsoleException(this.getErrorString((Exception)((Object)aMException)));
            }
            catch (SSOException sSOException) {
                throw new AMConsoleException(this.getErrorString((Exception)((Object)sSOException)));
            }
            catch (SMSException sMSException) {
                throw new AMConsoleException(this.getErrorString((Exception)((Object)sMSException)));
            }
        }
    }

    private Set getServiceNames() throws AMException, SSOException, SMSException {
        HashSet<String> hashSet = Collections.EMPTY_SET;
        if (this.role != null) {
            Set set = this.getAvailableServices(this.role);
            AMServiceDisplayModelImpl aMServiceDisplayModelImpl = new AMServiceDisplayModelImpl(this.dpStoreConn);
            Set set2 = aMServiceDisplayModelImpl.getDeniedServices(this.role);
            set.removeAll(set2);
            if (!set2.contains("iPlanetAMUserService")) {
                set.add("iPlanetAMUserService");
            }
            hashSet = new HashSet<String>(set.size());
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                if (!this.hasAttributes(string)) continue;
                hashSet.add(string);
            }
        }
        return hashSet;
    }

    private boolean hasAttributes(String string) {
        boolean bl = false;
        try {
            ServiceSchemaManager serviceSchemaManager = this.getServiceSchemaManager(string);
            if (this.roleType != 3) {
                bl = this.hasAttributes(serviceSchemaManager, SchemaType.ORGANIZATION);
            }
            if (!bl) {
                bl = this.hasAttributes(serviceSchemaManager, SchemaType.DYNAMIC);
            }
            if (!bl) {
                bl = this.hasAttributes(serviceSchemaManager, SchemaType.USER);
            }
        }
        catch (SSOException sSOException) {
            AMModelBase.debug.warning("UMEditRoleServiceAttrConfigModelImpl.hasAttributes", (Throwable)sSOException);
        }
        catch (SMSException sMSException) {
            AMModelBase.debug.warning("UMEditRoleServiceAttrConfigModelImpl.hasAttributes", (Throwable)sMSException);
        }
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean hasAttributes(ServiceSchemaManager serviceSchemaManager, SchemaType schemaType) {
        boolean bl = false;
        try {
            Set set = serviceSchemaManager.getSchemaTypes();
            if (set == null) return bl;
            if (!AMAdminUtils.containsSchemaType(set, schemaType)) return bl;
            ServiceSchema serviceSchema = serviceSchemaManager.getSchema(schemaType);
            if (serviceSchema == null) return bl;
            Set set2 = serviceSchema.getAttributeSchemaNames();
            if (set2 == null) return bl;
            if (set2.isEmpty()) return bl;
            Iterator iterator = set2.iterator();
            while (iterator.hasNext()) {
                if (bl) {
                    return bl;
                }
                String string = (String)iterator.next();
                AttributeSchema attributeSchema = serviceSchema.getAttributeSchema(string);
                if (attributeSchema == null) continue;
                String string2 = attributeSchema.getI18NKey();
                bl = string2 != null && string2.length() > 0;
            }
            return bl;
        }
        catch (SMSException sMSException) {
            AMModelBase.debug.error("UMEditRoleServiceAttrConfigModelImpl.hasAttributes", (Throwable)sMSException);
            return bl;
        }
    }

    private void createRoleHandle() {
        block4: {
            if (this.role != null) break block4;
            try {
                AMStoreConnection aMStoreConnection = this.getAdminStoreConnection();
                if (aMStoreConnection != null) {
                    this.role = aMStoreConnection.getRole(this.roleDN);
                    this.roleType = this.role.getRoleType();
                }
            }
            catch (AMException aMException) {
                AMModelBase.debug.error("UMEditRoleServiceAttrConfigModelImpl.createRoleHandle", (Throwable)aMException);
            }
            catch (SSOException sSOException) {
                AMModelBase.debug.error("UMEditRoleServiceAttrConfigModelImpl.createRoleHandle", (Throwable)sSOException);
            }
        }
    }

    private AMStoreConnection getAdminStoreConnection() {
        return (AMStoreConnection)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    return AMAdminUtils.getStoreConnAsAdmin();
                }
                catch (AMConsoleException aMConsoleException) {
                    AMModelBase.debug.error("UMEditRoleServiceAttrConfigModelImpl.createRoleHandle", (Throwable)aMConsoleException);
                    return null;
                }
            }
        });
    }
}

