/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.am.console.user.model;

import com.iplanet.am.console.base.model.AMAdminUtils;
import com.iplanet.am.console.base.model.AMModelBase;
import com.iplanet.am.console.settings.Setting;
import com.iplanet.am.console.user.model.UMDisplayOptionsModel;
import com.iplanet.am.console.user.model.UMProfileModelImpl;
import com.iplanet.am.sdk.AMException;
import com.iplanet.am.util.Debug;
import com.iplanet.am.util.Locale;
import com.iplanet.sso.SSOException;
import com.sun.identity.sm.AttributeSchema;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.SchemaType;
import com.sun.identity.sm.ServiceSchema;
import com.sun.identity.sm.ServiceSchemaManager;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;

public abstract class UMDisplayOptionsModelImpl
extends UMProfileModelImpl
implements UMDisplayOptionsModel {
    public UMDisplayOptionsModelImpl(HttpServletRequest httpServletRequest, Map map) {
        super(httpServletRequest, map);
    }

    public String getGeneralHeaderString() {
        return this.getLocalizedString("displayOptionsGeneral.header");
    }

    public String getNavViewMenusHeaderString() {
        return this.getLocalizedString("displayOptionsNavigationalViewMenu.header");
    }

    public String getNavViewMenusHelp() {
        return this.getLocalizedString("displayOptionsNavigationalViewMenu.help");
    }

    public String getProfileViewMenusHeaderString() {
        return this.getLocalizedString("displayOptionsProfileViewMenu.header");
    }

    public String getProfileViewMenusHelp() {
        return this.getLocalizedString("displayOptionsProfileViewMenu.help");
    }

    public String getDefaultProfileViewHeaderString() {
        return this.getLocalizedString("displayOptionsDefaultProfileView.header");
    }

    public String getDefaultProfileViewHelp() {
        return this.getLocalizedString("displayOptionsDefaultProfileView.help");
    }

    public String getAvailableActionsHeaderString() {
        return this.getLocalizedString("displayOptionsAvailableActions.header");
    }

    public String getAvailableActionsHelp() {
        return this.getLocalizedString("displayOptionsOrgAvailableActions.help");
    }

    public String getActionNameLabel() {
        return this.getLocalizedString("displayOptionsActionName.label");
    }

    public String getAutoGeneratUserFullNameLabel() {
        return this.getLocalizedString("displayOptionsAutoGeneratUserFullName.label");
    }

    public String getAutoGeneratUserFullNameDescription() {
        return this.getLocalizedString("displayOptionsAutoGeneratUserFullName.desc");
    }

    public String getAutoGeneratUserFullNameHelp() {
        return this.getLocalizedString("displayOptionsAutoGeneratUserFullName.help");
    }

    public String getDisableInitialSearchLabel() {
        return this.getLocalizedString("displayOptionsDisableInitialSearch.label");
    }

    public String getDisableInitialSearchHelp() {
        return this.getLocalizedString("displayOptionsDisableInitialSearch.help");
    }

    public String getUserProfileTitleLabel() {
        return this.getLocalizedString("displayOptionsUserProfileTitle.label");
    }

    public String getUserProfileTitleHelp() {
        return this.getLocalizedString("displayOptionsUserProfileTitle.help");
    }

    public String getAutoSelectEntryInNavViewLabel() {
        return this.getLocalizedString("displayOptionsAutoSelectEntryInNavView.label");
    }

    public String getAutoSelectEntryInNavViewDescription() {
        return this.getLocalizedString("displayOptionsAutoSelectEntryInNavView.desc");
    }

    public String getAutoSelectEntryInNavViewHelp() {
        return this.getLocalizedString("displayOptionsAutoSelectEntryInNavView.help");
    }

    public String getRootNavigationMenuLabel() {
        return this.getLocalizedString("rootNavigationMenu.label");
    }

    public String getOrganizationNavigationMenuLabel() {
        return this.getLocalizedString("organizationNavigationMenu.label");
    }

    public String getOrganizationalUnitNavigationMenuLabel() {
        return this.getLocalizedString("organizationalUnitNavigationMenu.label");
    }

    public String getGroupContainerNavigationMenuLabel() {
        return this.getLocalizedString("groupContainerNavigationMenu.label");
    }

    public String getPeopleContainerNavigationMenuLabel() {
        return this.getLocalizedString("peopleContainerNavigationMenu.label");
    }

    public String getFederationNavigationMenuLabel() {
        return this.getLocalizedString("federationNavigationMenu.label");
    }

    public String getOrganizationProfileMenuLabel() {
        return this.getLocalizedString("organizationProfileMenu.label");
    }

    public String getOrganizationalUnitProfileMenuLabel() {
        return this.getLocalizedString("organizationalUnitProfileMenu.label");
    }

    public String getUserProfileMenuLabel() {
        return this.getLocalizedString("userProfileMenu.label");
    }

    public String getGroupProfileMenuLabel() {
        return this.getLocalizedString("groupProfileMenu.label");
    }

    public String getRoleProfileMenuLabel() {
        return this.getLocalizedString("roleProfileMenu.label");
    }

    public String getPolicyProfileMenuLabel() {
        return this.getLocalizedString("policyProfileMenu.label");
    }

    public String getEntityDescriptorProfileMenuLabel() {
        return this.getLocalizedString("entityDescriptorProfileMenu.label");
    }

    public String getOrganizationDefaultProfileViewLabel() {
        return this.getLocalizedString("organizationDefaultProfileView.label");
    }

    public String getOrganizationDefaultProfileViewHelp() {
        return this.getLocalizedString("organizationDefaultProfileView.help");
    }

    public String getOrganizationalUnitDefaultProfileViewLabel() {
        return this.getLocalizedString("organizationalUnitDefaultProfileView.label");
    }

    public String getOrganizationalUnitDefaultProfileViewHelp() {
        return this.getLocalizedString("organizationalUnitDefaultProfileView.help");
    }

    public String getUserDefaultProfileViewLabel() {
        return this.getLocalizedString("userDefaultProfileView.label");
    }

    public String getUserDefaultProfileViewHelp() {
        return this.getLocalizedString("userDefaultProfileView.help");
    }

    public String getGroupDefaultProfileViewLabel() {
        return this.getLocalizedString("groupDefaultProfileView.label");
    }

    public String getGroupDefaultProfileViewHelp() {
        return this.getLocalizedString("groupDefaultProfileView.help");
    }

    public String getRoleDefaultProfileViewLabel() {
        return this.getLocalizedString("roleDefaultProfileView.label");
    }

    public String getRoleDefaultProfileViewHelp() {
        return this.getLocalizedString("roleDefaultProfileView.help");
    }

    public String getPolicyDefaultProfileViewLabel() {
        return this.getLocalizedString("policyDefaultProfileView.label");
    }

    public String getPolicyDefaultProfileViewHelp() {
        return this.getLocalizedString("policyDefaultProfileView.help");
    }

    public String getEntityDescriptorDefaultProfileViewLabel() {
        return this.getLocalizedString("entityDescriptorDefaultProfileView.label");
    }

    public String getEntityDescriptorDefaultProfileViewHelp() {
        return this.getLocalizedString("entityDescriptorDefaultProfileView.help");
    }

    public String getSelectedLabel() {
        return this.getLocalizedString("selectableListSelected.label");
    }

    public String getAddButtonLabel() {
        return this.getLocalizedString("selectableListAdd.button");
    }

    public String getAddAllButtonLabel() {
        return this.getLocalizedString("selectableListAddAll.button");
    }

    public String getRemoveButtonLabel() {
        return this.getLocalizedString("selectableListRemove.button");
    }

    public String getRemoveAllButtonLabel() {
        return this.getLocalizedString("selectableListRemoveAll.button");
    }

    public String getMenuOptionsLabel(String string) {
        return Setting.getLocalizedOptionName(string, this);
    }

    public String getDefaultLabel() {
        return this.getLocalizedString("default.label");
    }

    public String getNameLabel() {
        return this.getLocalizedString("name.label");
    }

    public String getViewLabel() {
        return this.getLocalizedString("view.label");
    }

    public String getDisplayConfigSectionHeader() {
        return this.getLocalizedString("displayOptionsDisplayConf.header");
    }

    public String getDisplayConfigSectionHelpMessage() {
        return this.getLocalizedString("displayOptionsDisplayConf.help");
    }

    public Map getValidValues(Setting setting) {
        String[] stringArray = setting.getValidValues();
        HashMap<String, String> hashMap = new HashMap<String, String>(stringArray.length * 2);
        int n = 0;
        while (n < stringArray.length) {
            String string = stringArray[n];
            if (this.isMenuOptionAllowed(string)) {
                if (string.equals("[user_service_attribute_name]")) {
                    this.getUserServiceAttributeNames(hashMap);
                } else if (string.equals("[user_assignable_services]")) {
                    this.getUserAssignableServices(hashMap);
                } else {
                    hashMap.put(Setting.getLocalizedOptionName(string, this), string);
                }
            }
            ++n;
        }
        return hashMap;
    }

    private boolean isMenuOptionAllowed(String string) {
        boolean bl = true;
        if (string.equals("organizationalunits")) {
            bl = this.showOrgUnits();
        } else if (string.equals("peoplecontainers")) {
            bl = this.showPeopleContainers();
        } else if (string.equals("groupcontainers")) {
            bl = this.showGroupContainers();
        } else if (string.equals("policyadministrator")) {
            bl = !this.isUserMgtEnabled();
        }
        return bl;
    }

    public String getEditNavOptionsButtonLabel() {
        return this.getLocalizedString("editNavOptions.button");
    }

    public String getEditProfileOptionsButtonLabel() {
        return this.getLocalizedString("editProfileOptions.button");
    }

    public String getIncorrectDefaultProfileMessage() {
        return this.getLocalizedString("incorrectDefaultProfile.message");
    }

    public String getProfileMenuCannotBeEmptyMessage() {
        return this.getLocalizedString("profileMenuCannotBeEmpty.message");
    }

    public String getModifiedMessageTitle() {
        return this.getLocalizedString("displayOptionsModified.title");
    }

    public String getModifiedMessage() {
        return this.getLocalizedString("displayOptionsModified.message");
    }

    public String getCannotModifiedDisplayOptionsTitle() {
        return this.getLocalizedString("cannotModifyDisplayOptions.title");
    }

    public String getCannotModifiedAvailableActionsTitle() {
        return this.getLocalizedString("cannotModifyAvailableActions.title");
    }

    public String getCannotModifiedSettingMessage() {
        return this.getLocalizedString("displayOptionNotAdminServiceTemplate.message");
    }

    private void getUserServiceAttributeNames(Map map) {
        block3: {
            ServiceSchemaManager serviceSchemaManager = this.getSvcSchemaMgr("iPlanetAMUserService");
            if (serviceSchemaManager == null) break block3;
            ResourceBundle resourceBundle = this.getSchemaResourceBundle("iPlanetAMUserService");
            try {
                ServiceSchema serviceSchema = serviceSchemaManager.getSchema(SchemaType.USER);
                Set set = serviceSchema.getAttributeSchemaNames();
                Iterator iterator = set.iterator();
                while (iterator.hasNext()) {
                    String string = (String)iterator.next();
                    AttributeSchema attributeSchema = serviceSchema.getAttributeSchema(string);
                    String string2 = attributeSchema.getI18NKey();
                    if (string2 == null || string2.length() <= 0) continue;
                    map.put(Locale.getString((ResourceBundle)resourceBundle, (String)string2, (Debug)AMModelBase.debug), string);
                }
            }
            catch (SMSException sMSException) {
                AMModelBase.debug.error("UMDisplayOptionsModelImpl.getUserServiceAttributeNames", (Throwable)sMSException);
            }
        }
    }

    private ServiceSchemaManager getSvcSchemaMgr(String string) {
        ServiceSchemaManager serviceSchemaManager = null;
        try {
            serviceSchemaManager = this.getServiceSchemaManager(string);
        }
        catch (SSOException sSOException) {
            AMModelBase.debug.warning("UMDisplayOptionsModelImpl.getSvcSchemaMgr", (Throwable)sSOException);
        }
        catch (SMSException sMSException) {
            AMModelBase.debug.error("UMDisplayOptionsModelImpl.getSvcSchemaMgr", (Throwable)sMSException);
        }
        return serviceSchemaManager;
    }

    private void getUserAssignableServices(Map map) {
        block3: {
            try {
                Set set = this.dpStoreConn.getServiceNames();
                if (set == null || set.isEmpty()) break block3;
                Iterator iterator = set.iterator();
                while (iterator.hasNext()) {
                    String string = (String)iterator.next();
                    ServiceSchemaManager serviceSchemaManager = this.getSvcSchemaMgr(string);
                    if (serviceSchemaManager == null || !this.hasSchemaType(serviceSchemaManager, SchemaType.USER)) continue;
                    map.put(this.getLocalizedServiceName(string), string.toLowerCase());
                }
            }
            catch (AMException aMException) {
                AMModelBase.debug.error("UMDisplayOptionsModelImpl.getUserassignableServices", (Throwable)aMException);
            }
        }
    }

    private boolean hasSchemaType(ServiceSchemaManager serviceSchemaManager, SchemaType schemaType) {
        boolean bl = false;
        try {
            Set set = serviceSchemaManager.getSchemaTypes();
            bl = AMAdminUtils.containsSchemaType(set, schemaType);
        }
        catch (SMSException sMSException) {
            AMModelBase.debug.error("UMDisplayOptionsModelImpl.hasSchemaType", (Throwable)sMSException);
        }
        return bl;
    }

    public String getAvailableOptionsUpdateSuccessMessage() {
        return this.getLocalizedString("updateAvailableOptions.message");
    }

    public String getHelpAnchorTag() {
        String string = this.getLocalizedString("displayOptions.help");
        if (string.equals("displayOptions.help")) {
            string = "contents.html";
        }
        return this.getHelpURL(string);
    }
}

