/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.am.console.user.model;

import com.iplanet.am.console.base.model.AMAdminUtils;
import com.iplanet.am.console.base.model.AMAttrSchemaComparator;
import com.iplanet.am.console.base.model.AMAttributeDisplayImpl;
import com.iplanet.am.console.base.model.AMCommonNameGenerator;
import com.iplanet.am.console.base.model.AMConsoleException;
import com.iplanet.am.console.base.model.AMModelBase;
import com.iplanet.am.console.base.model.AMSystemConfig;
import com.iplanet.am.console.base.model.DynamicGUIGenerator;
import com.iplanet.am.console.components.view.html.DynamicGUI;
import com.iplanet.am.console.user.model.UMCreateModelImpl;
import com.iplanet.am.console.user.model.UMCreateUserModel;
import com.iplanet.am.sdk.AMAssignableDynamicGroup;
import com.iplanet.am.sdk.AMException;
import com.iplanet.am.sdk.AMGroup;
import com.iplanet.am.sdk.AMObject;
import com.iplanet.am.sdk.AMOrganization;
import com.iplanet.am.sdk.AMOrganizationalUnit;
import com.iplanet.am.sdk.AMPeopleContainer;
import com.iplanet.am.sdk.AMRole;
import com.iplanet.am.sdk.AMStaticGroup;
import com.iplanet.am.sdk.AMStoreConnection;
import com.iplanet.am.sdk.AMUser;
import com.iplanet.am.util.Debug;
import com.iplanet.sso.SSOException;
import com.sun.identity.common.admin.AdminInterfaceUtils;
import com.sun.identity.sm.AttributeSchema;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.SchemaType;
import com.sun.identity.sm.ServiceSchema;
import com.sun.identity.sm.ServiceSchemaManager;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import javax.servlet.http.HttpServletRequest;
import netscape.ldap.util.DN;
import netscape.ldap.util.RDN;

public class UMCreateUserModelImpl
extends UMCreateModelImpl
implements UMCreateUserModel {
    public String helpTag = "createUser.help";
    public String errorTitle = null;
    protected Map customViewBeans = null;
    private String createdUserDN = null;
    public Map requiredServicesMap = null;
    public Set assignedServices = null;

    public UMCreateUserModelImpl(HttpServletRequest httpServletRequest, Map map) {
        super(httpServletRequest, map);
        HashSet<String> hashSet = (HashSet<String>)map.get("amSelectedServices");
        if (hashSet == null) {
            hashSet = new HashSet<String>(1);
        }
        hashSet.add("iPlanetAMUserService");
        this.displayOptions = this.getDisplayOptions();
    }

    public int getNumRequiredAttributes(String string) {
        List list = this.getRequiredAttributes(string);
        return list != null ? list.size() : 0;
    }

    public List getRequiredAttributes(String string) {
        List list;
        if (this.requiredServicesMap == null) {
            this.buildAttributeList();
        }
        return (list = (List)this.requiredServicesMap.get(string)) == null ? Collections.EMPTY_LIST : list;
    }

    private List getRequiredServiceAttributes(String string) {
        ArrayList arrayList = Collections.EMPTY_LIST;
        ServiceSchemaManager serviceSchemaManager = null;
        TreeSet<AttributeSchema> treeSet = null;
        try {
            Set set;
            ServiceSchema serviceSchema;
            serviceSchemaManager = this.getServiceSchemaManager(string);
            if (serviceSchemaManager != null && (serviceSchema = serviceSchemaManager.getSchema(SchemaType.USER)) != null && !(set = serviceSchema.getAttributeSchemas()).isEmpty()) {
                Collator collator = Collator.getInstance(this.getUserLocale());
                treeSet = new TreeSet<AttributeSchema>(new AMAttrSchemaComparator(collator));
                Iterator iterator = set.iterator();
                while (iterator.hasNext()) {
                    AttributeSchema attributeSchema = (AttributeSchema)iterator.next();
                    if (attributeSchema == null || !this.displayAttribute(attributeSchema)) continue;
                    if (string.equals("iPlanetAMUserService") && attributeSchema.getName().equals("cn") && this.getAutoGenerateCN()) {
                        AMModelBase.debug.message("skip cn, autogenerating");
                        continue;
                    }
                    treeSet.add(attributeSchema);
                }
            }
        }
        catch (SSOException sSOException) {
            AMModelBase.debug.warning("UMCreateUserModelImpl.getRequiredAttributes", (Throwable)sSOException);
        }
        catch (SMSException sMSException) {
            AMModelBase.debug.error("UMCreateUserModelImpl.getRequiredAttributes", (Throwable)sMSException);
        }
        if (treeSet != null && !treeSet.isEmpty()) {
            this.requiredAttributes = arrayList = new ArrayList(treeSet);
            this.fireRetrieveAttributeValuesEvent(1, 1, string, SchemaType.USER);
        }
        return arrayList;
    }

    private void buildAttributeList() {
        if (this.assignedServices == null || this.assignedServices.isEmpty()) {
            return;
        }
        Iterator iterator = this.assignedServices.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            ArrayList arrayList = new ArrayList(this.getRequiredServiceAttributes(string));
            if (this.mapAttributeValues == null) {
                this.mapAttributeValues = new HashMap(arrayList.size());
            }
            Iterator iterator2 = arrayList.iterator();
            while (iterator2.hasNext()) {
                AttributeSchema attributeSchema = (AttributeSchema)iterator2.next();
                this.mapAttributeValues.put(attributeSchema.getName(), this.getAttributeValues(attributeSchema));
            }
            if (AMModelBase.debug.messageEnabled()) {
                AMModelBase.debug.message("current value of requiredAttrs = " + arrayList);
            }
            if (arrayList == null || arrayList.isEmpty()) continue;
            if (this.requiredServicesMap == null) {
                this.requiredServicesMap = new HashMap();
            }
            this.requiredServicesMap.put(string, arrayList);
        }
    }

    private boolean displayAttribute(AttributeSchema attributeSchema) {
        String string;
        boolean bl = false;
        String string2 = attributeSchema.getI18NKey();
        if (string2 != null && string2.length() > 0 && (string = attributeSchema.getAny()) != null && (string.indexOf("required") != -1 || string.indexOf("optional") != -1)) {
            AttributeSchema.UIType uIType = attributeSchema.getUIType();
            bl = uIType != null ? !uIType.equals((Object)AttributeSchema.UIType.LINK) && !uIType.equals((Object)AttributeSchema.UIType.BUTTON) : true;
        }
        return bl;
    }

    public boolean createUser(Map map) {
        boolean bl = false;
        if (AMModelBase.debug.messageEnabled() && map != null) {
            AMModelBase.debug.message("createUser dataIn " + map.keySet());
        }
        if (map == null || map.isEmpty()) {
            AMModelBase.debug.error("data missing in create user routine.");
            this.errorMessage = this.getLocalizedString("createFailure.message");
            return bl;
        }
        String string = AdminInterfaceUtils.getNamingAttribute((int)1, (Debug)AMModelBase.debug);
        Set set = (Set)map.remove(string);
        if (set == null || set.isEmpty()) {
            AMModelBase.debug.error("Cannot create the user. The naming attribute is missing from the data.");
            this.errorMessage = this.getLocalizedString("createFailure.message");
            return bl;
        }
        String string2 = (String)set.iterator().next();
        if (string2 == null || string2.length() == 0) {
            AMModelBase.debug.error("Cannot create the user. The naming attribute is missing from the data.");
            this.errorMessage = this.getLocalizedString("createFailure.message");
            return bl;
        }
        if (this.isAttributeMultiValued(string)) {
            set.remove(string2);
            map.put(string, set);
        }
        HashMap<String, Map> hashMap = new HashMap<String, Map>(1);
        hashMap.put(string2, map);
        String string3 = (String)map.remove("container");
        if (string3 == null || string3.length() == 0) {
            this.errorMessage = this.getLocalizedString("nopeoplecontainers.message");
            return false;
        }
        this.generateUserCN(string3, map);
        AMPeopleContainer aMPeopleContainer = null;
        try {
            aMPeopleContainer = this.dpStoreConn.getPeopleContainer(string3);
            this.fireBeforeCreateObjectEvent(1, (AMObject)aMPeopleContainer, string2, map);
            Set set2 = (Set)map.remove("amSelectedServices");
            Set set3 = aMPeopleContainer.createUsers(hashMap, set2);
            String string4 = string + "=" + string2 + "," + string3;
            this.logger.doLog("userCreated.message", string4);
            bl = true;
            if (set3 != null && !set3.isEmpty()) {
                AMUser aMUser = (AMUser)set3.iterator().next();
                this.createdUserDN = aMUser.getDN();
                HashSet<String> hashSet = new HashSet<String>(2);
                hashSet.add(this.createdUserDN);
                this.assignDefaultRolesToUser(aMUser, hashSet);
                this.assignUserToGroup(hashSet);
                this.fireAfterCreateObjectEvent((AMObject)aMUser);
            }
        }
        catch (AMException aMException) {
            this.errorMessage = this.getErrorString((Exception)((Object)aMException));
        }
        catch (AMConsoleException aMConsoleException) {
            this.errorMessage = this.getErrorString(aMConsoleException);
        }
        catch (SSOException sSOException) {
            this.errorMessage = this.getErrorString((Exception)((Object)sSOException));
        }
        return bl;
    }

    private void generateUserCN(String string, Map map) {
        if (this.getAutoGenerateCN()) {
            Set set = (Set)map.get("preferredlocale");
            if (set == null || set.isEmpty()) {
                set = this.getAttrValues("preferredlocale", "iPlanetAMUserService", string, 301);
            }
            if (set != null && !set.isEmpty()) {
                map.put("preferredlocale", set);
            }
            HashSet<String> hashSet = new HashSet<String>(2);
            AMCommonNameGenerator aMCommonNameGenerator = AMCommonNameGenerator.getInstance();
            hashSet.add(aMCommonNameGenerator.generateCommonName(map, string, this));
            map.put("cn", hashSet);
        }
    }

    private void assignDefaultRolesToUser(AMUser aMUser, Set set) {
        Set set2 = this.getDefaultRoles(aMUser);
        if (AMModelBase.debug.messageEnabled()) {
            AMModelBase.debug.message("trying to assign " + set2 + "to " + this.createdUserDN);
        }
        Iterator iterator = set2.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            try {
                if (this.getObjectType(string) == 6) {
                    AMRole aMRole = this.dpStoreConn.getRole(string);
                    if (!aMRole.isExists()) continue;
                    aMRole.addUsers(set);
                    continue;
                }
                if (!AMModelBase.debug.warningEnabled()) continue;
                AMModelBase.debug.warning("tried to assign " + string + " to a user. This is not a static role");
            }
            catch (AMException aMException) {
                AMModelBase.debug.warning("UMCreateUserModelImpl.assignDefaultRolesToUser", (Throwable)aMException);
            }
            catch (SSOException sSOException) {
                AMModelBase.debug.warning("UMCreateUserModelImpl.assignDefaultRolesToUser", (Throwable)sSOException);
            }
        }
    }

    private void assignUserToGroup(Set set) {
        block7: {
            block6: {
                if (this.locationType != 9 && this.locationType != 10) break block6;
                try {
                    AMStaticGroup aMStaticGroup = this.dpStoreConn.getStaticGroup(this.locationDN);
                    aMStaticGroup.addUsers(set);
                }
                catch (AMException aMException) {
                    AMModelBase.debug.error("UMCreateUserModelImpl.assignUserToGroup", (Throwable)aMException);
                }
                catch (SSOException sSOException) {
                    AMModelBase.debug.error("UMCreateUserModelImpl.assignUserToGroup", (Throwable)sSOException);
                }
                break block7;
            }
            if (this.locationType != 12) break block7;
            try {
                AMAssignableDynamicGroup aMAssignableDynamicGroup = this.dpStoreConn.getAssignableDynamicGroup(this.locationDN);
                aMAssignableDynamicGroup.addUsers(set);
            }
            catch (AMException aMException) {
                AMModelBase.debug.error("UMCreateUserModelImpl.assignUserToGroup", (Throwable)aMException);
            }
            catch (SSOException sSOException) {
                AMModelBase.debug.error("UMCreateUserModelImpl.assignUserToGroup", (Throwable)sSOException);
            }
        }
    }

    public List getErrorList() {
        return this.errorMessageList;
    }

    public DynamicGUI getDynamicGUI(String string, int n) {
        List list;
        if (this.requiredServicesMap == null) {
            this.buildAttributeList();
        }
        if ((list = (List)this.requiredServicesMap.get(string)) == null) {
            return null;
        }
        AttributeSchema attributeSchema = (AttributeSchema)list.get(n);
        DynamicGUIGenerator dynamicGUIGenerator = DynamicGUIGenerator.getInstance();
        return dynamicGUIGenerator.createDynamicGUI(attributeSchema, string, (Set)this.mapAttributeValues.get(attributeSchema.getName()), false, this, null);
    }

    private Set getDefaultRoles(AMUser aMUser) {
        AMModelBase.debug.message("UMCreateUserModelImpl.getDefaultRoles()");
        Set set = Collections.EMPTY_SET;
        String string = null;
        try {
            string = aMUser.getOrganizationDN();
        }
        catch (SSOException sSOException) {
            if (AMModelBase.debug.warningEnabled()) {
                AMModelBase.debug.warning("UMCreateUserModelImpl.getDefaultRoles: cannot get user's organization DN", (Throwable)sSOException);
            }
        }
        catch (AMException aMException) {
            AMModelBase.debug.error("UMCreateUserModelImpl.getDefaultRoles: cannot get user's organization DN", (Throwable)aMException);
        }
        if (string != null) {
            set = this.getAttrValues("iplanet-am-admin-console-default-roles", "iPlanetAMAdminConsoleService", string);
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                String string2 = (String)iterator.next();
                if (string.equalsIgnoreCase(AMAdminUtils.getParent(string2))) continue;
                iterator.remove();
            }
        }
        return set;
    }

    public String getDefaultPeopleContainer() {
        String string = null;
        AMStaticGroup aMStaticGroup = null;
        try {
            switch (this.locationType) {
                case 2: 
                case 3: {
                    string = this.getDefaultPeopleContainer(this.locationDN);
                    break;
                }
                case 5: {
                    string = this.locationDN;
                    break;
                }
                case 9: 
                case 10: {
                    aMStaticGroup = this.dpStoreConn.getStaticGroup(this.locationDN);
                    string = this.getDefaultPeopleContainer(this.getGroupOrganizationDN((AMGroup)aMStaticGroup));
                    break;
                }
                case 12: {
                    aMStaticGroup = this.dpStoreConn.getAssignableDynamicGroup(this.locationDN);
                    string = this.getDefaultPeopleContainer(this.getGroupOrganizationDN((AMGroup)aMStaticGroup));
                    break;
                }
                default: {
                    string = "";
                    break;
                }
            }
        }
        catch (SSOException sSOException) {
            AMModelBase.debug.error("UMCreateUserModelImpl.getDefaultPeopleContainer", (Throwable)sSOException);
        }
        return string != null ? string : "";
    }

    public Set getPeopleContainers() {
        AMModelBase.debug.message("UMCreateUserModelImpl.getPeopleContainers()");
        Set<String> set = Collections.EMPTY_SET;
        try {
            switch (this.locationType) {
                case 2: {
                    AMOrganization aMOrganization = this.dpStoreConn.getOrganization(this.locationDN);
                    set = aMOrganization.getPeopleContainers(1);
                    break;
                }
                case 3: {
                    AMOrganizationalUnit aMOrganizationalUnit = this.dpStoreConn.getOrganizationalUnit(this.locationDN);
                    set = aMOrganizationalUnit.getPeopleContainers(1);
                    break;
                }
                case 5: {
                    set = new HashSet<String>(1);
                    set.add(this.locationDN);
                    break;
                }
                case 9: 
                case 10: {
                    AMStaticGroup aMStaticGroup = this.dpStoreConn.getStaticGroup(this.locationDN);
                    set = this.getGroupPCList((AMGroup)aMStaticGroup);
                    this.validatePCList(set);
                    break;
                }
                case 12: {
                    AMAssignableDynamicGroup aMAssignableDynamicGroup = this.dpStoreConn.getAssignableDynamicGroup(this.locationDN);
                    set = this.getGroupPCList((AMGroup)aMAssignableDynamicGroup);
                    this.validatePCList(set);
                }
            }
        }
        catch (AMException aMException) {
            AMModelBase.debug.warning("failed getting people containers", (Throwable)aMException);
        }
        catch (SSOException sSOException) {
            AMModelBase.debug.error("failed getting people containers", (Throwable)sSOException);
        }
        return set;
    }

    private String getDefaultPeopleContainer(String string) {
        DN dN = null;
        if (string.equalsIgnoreCase(AMSystemConfig.rootSuffix)) {
            if (AMSystemConfig.rootSuffix.equalsIgnoreCase(AMSystemConfig.defaultOrg)) {
                dN = new DN(AMSystemConfig.defaultOrg);
            } else {
                dN = new DN(AMSystemConfig.rootSuffix);
                dN.addRDN(new RDN(AMSystemConfig.defaultOrg));
            }
        } else {
            dN = new DN(string);
        }
        dN.addRDN(new RDN(AdminInterfaceUtils.getNamingAttribute((int)5, (Debug)AMModelBase.debug) + "=" + AdminInterfaceUtils.defaultPeopleContainerName()));
        return dN.toString();
    }

    private String getGroupOrganizationDN(AMGroup aMGroup) {
        String string = null;
        try {
            string = aMGroup.getOrganizationDN();
        }
        catch (SSOException sSOException) {
            AMModelBase.debug.warning("UMCreateUserModelImpl.getGroupOrganizationDN", (Throwable)sSOException);
        }
        catch (AMException aMException) {
            AMModelBase.debug.error("UMCreateUserModelImpl.getGroupOrganizationDN", (Throwable)aMException);
        }
        return string;
    }

    private Set getGroupPCList(AMGroup aMGroup) {
        HashSet<Object> hashSet = Collections.EMPTY_SET;
        DN dN = new DN(aMGroup.getDN());
        String string = this.getGroupOrganizationDN(aMGroup);
        if (string != null) {
            Object object;
            Object object2;
            Set set = this.getAttrValues("iplanet-am-admin-console-group-pclist", "iPlanetAMAdminConsoleService", string);
            if (set != null && !set.isEmpty()) {
                hashSet = new HashSet(set.size());
                object2 = set.iterator();
                while (object2.hasNext()) {
                    DN dN2;
                    object = new StringTokenizer((String)object2.next(), "|");
                    if (((StringTokenizer)object).countTokens() != 2 || !(dN2 = new DN(((StringTokenizer)object).nextToken().trim())).equals(dN)) continue;
                    hashSet.add(((StringTokenizer)object).nextToken().trim());
                }
            }
            if (hashSet.isEmpty()) {
                hashSet = new HashSet<Object>(1);
                object2 = this.getAttrValues("iplanet-am-admin-console-group-default-pc", "iPlanetAMAdminConsoleService", string);
                if (object2 != null && !object2.isEmpty() && ((String)(object = ((String)object2.iterator().next()).trim())).length() > 0) {
                    hashSet.add(object);
                }
                if (hashSet.isEmpty()) {
                    hashSet.add(this.getDefaultPeopleContainer(string));
                }
            }
        }
        return hashSet;
    }

    public boolean displayPeopleContainers() {
        return this.getPeopleContainers().size() > 1;
    }

    private void validatePCList(Set set) {
        if (set == null || set.isEmpty()) {
            return;
        }
        HashSet<String> hashSet = new HashSet<String>(set.size());
        AMStoreConnection aMStoreConnection = (AMStoreConnection)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    return AMAdminUtils.getStoreConnAsAdmin();
                }
                catch (AMConsoleException aMConsoleException) {
                    AMModelBase.debug.error("UMCreateUserModelImpl.validatePCList", (Throwable)aMConsoleException);
                    return null;
                }
            }
        });
        if (aMStoreConnection != null) {
            this.errorMessageList = new ArrayList(set.size());
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                try {
                    AMPeopleContainer aMPeopleContainer = aMStoreConnection.getPeopleContainer(string);
                    if (aMPeopleContainer != null && aMPeopleContainer.isExists() && this.isPeopleContainer(string)) continue;
                    if (this.errorMessageList.isEmpty()) {
                        this.errorMessage = this.getLocalizedString("peoplecontainerdn.error");
                        this.errorMessageList.add(this.errorMessage);
                    }
                    this.errorMessageList.add(string);
                    hashSet.add(string);
                    if (!AMModelBase.debug.warningEnabled()) continue;
                    AMModelBase.debug.warning(string + " is invalid, not adding to pc list");
                }
                catch (SSOException sSOException) {
                    AMModelBase.debug.error("UMCreateUserModelImpl.validateGroupPCList", (Throwable)sSOException);
                }
            }
            set.removeAll(hashSet);
        } else {
            set.clear();
        }
    }

    private Map getDisplayOptions() {
        Map map;
        block5: {
            map = null;
            AMAttributeDisplayImpl aMAttributeDisplayImpl = new AMAttributeDisplayImpl(this.dpStoreConn, this.ssoToken);
            try {
                ServiceSchemaManager serviceSchemaManager = this.getServiceSchemaManager("iPlanetAMUserService");
                if (serviceSchemaManager == null) break block5;
                map = aMAttributeDisplayImpl.getServiceDisplayOptions("iPlanetAMUserService", serviceSchemaManager, this.dpUser);
                if (AMModelBase.debug.messageEnabled()) {
                    AMModelBase.debug.message("getDisplayOptions: " + map);
                }
            }
            catch (SMSException sMSException) {
                AMModelBase.debug.warning("Error getting display options", (Throwable)sMSException);
            }
            catch (AMException aMException) {
                AMModelBase.debug.warning("Error getting display options", (Throwable)aMException);
            }
            catch (SSOException sSOException) {
                AMModelBase.debug.warning("Error getting display options", (Throwable)sSOException);
            }
        }
        return map;
    }

    public boolean hasCustomViewBean(String string) {
        if (this.customViewBeans == null) {
            this.customViewBeans = this.getCustomSvcViewBeans();
        }
        return this.customViewBeans.containsKey(string);
    }

    public String getCreatedUserDN() {
        return this.createdUserDN;
    }

    public Map getAttributeValues() {
        if (this.mapAttributeValues == null) {
            this.mapAttributeValues = new HashMap(0);
        }
        return this.mapAttributeValues;
    }

    public String getHelpAnchorTag() {
        String string = this.getLocalizedString("createUser.help");
        if (string.equals("createUser.help")) {
            string = "contents.html";
        }
        return this.getHelpURL(string);
    }

    protected Map getAllRegisteredServices() {
        if (this.allRegisteredServices == null) {
            this.allRegisteredServices = this.getAllRegisteredService(this.locationDN);
        }
        return this.allRegisteredServices;
    }

    public Map getAssignableServices() {
        return this.getAllRegisteredServices();
    }

    public Set getRequiredServices() {
        if (this.requiredServicesMap == null) {
            this.buildAttributeList();
        }
        if (this.requiredServicesMap == null || this.requiredServicesMap.isEmpty()) {
            return Collections.EMPTY_SET;
        }
        return this.requiredServicesMap.keySet();
    }

    public void setAssignedServices(Set set) {
        if (this.assignedServices == null) {
            this.assignedServices = new HashSet();
        }
        if (set != null && !set.isEmpty()) {
            this.assignedServices = set;
        }
    }

    public void addService(String string) {
        if (this.assignedServices == null) {
            this.assignedServices = new HashSet(5);
        }
        this.assignedServices.add(string);
    }

    public String getCreateTitle(int n) {
        return this.getLocalizedString("createUserTitle.step-" + n);
    }

    public String getTitle() {
        return this.getLocalizedString("");
    }

    public String getErrorTitle() {
        return this.getLocalizedString("createUserFailed.title");
    }

    public String getWarningTitle() {
        return this.getLocalizedString("invalidPeopleContainer.title");
    }

    public String getSelectMessage() {
        return this.getLocalizedString("select.message");
    }

    public String getRequiredAttributesMessage() {
        return this.getLocalizedString("requiredUserAttributes.message");
    }

    public String getSelectServiceMessage() {
        return this.getLocalizedString("selectService.message");
    }

    public String getAddRequiredServiceHelpMessage() {
        return this.getLocalizedString("addRequiredServiceHelp.message");
    }

    public String getPeopleContainerLabel() {
        return this.getLocalizedString("peopleContainer.label");
    }

    public String getAvailableServicesLabel() {
        return this.getLocalizedString("availableServices.label");
    }

    public String getContainersLabel() {
        return this.getLocalizedString("containers.label");
    }

    public String getGeneralPropertiesLabel() {
        return this.getLocalizedString("generalProperties.label");
    }

    public String getAvailableContainersLabel() {
        return this.getLocalizedString("availableContainers.label");
    }

    public String getConfirmPwdLabel() {
        return this.getLocalizedString("dynGUIConfirmPassword.label");
    }

    public String getPasswordMismatchMessage() {
        return this.getLocalizedString("passwordMismatch.message");
    }

    public void updateServices(Set set) throws AMConsoleException {
        HashMap hashMap = new HashMap(set.size() * 2);
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            hashMap.put((String)iterator.next(), new HashMap());
        }
        this.updateServices(hashMap);
    }

    public void updateServices(Map map) throws AMConsoleException {
        AMModelBase.debug.message("UMCreateUserModelImpl.updateServices");
        if (this.curUser == null || !this.isAdministrator()) {
            return;
        }
        String string = null;
        if (map != null && !map.isEmpty()) {
            if (AMModelBase.debug.messageEnabled()) {
                AMModelBase.debug.message("adding " + map + " to user profile");
            }
            try {
                this.curUser.assignServices(map);
                StringBuffer stringBuffer = new StringBuffer(100);
                stringBuffer.append(this.getLocalizedString("assignedServicesToUser.message")).append(" " + this.curUser.getDN()).append(":" + map.keySet());
                this.logger.doLog(stringBuffer.toString());
            }
            catch (AMException aMException) {
                AMModelBase.debug.warning("Could not assign services to " + this.curUser.getDN());
                string = this.getErrorString((Exception)((Object)aMException));
            }
            catch (SSOException sSOException) {
                AMModelBase.debug.error("assigning services to user ", (Throwable)sSOException);
                string = this.getErrorString((Exception)((Object)sSOException));
            }
        }
        if (string != null) {
            throw new AMConsoleException(string);
        }
    }

    public String getMissingPeopleContainerMessage() {
        return this.getLocalizedString("missingPeopleContainer.message");
    }
}

