/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.am.console.user.model;

import com.iplanet.am.console.base.model.AMConsoleException;
import com.iplanet.am.console.base.model.AMFormatUtils;
import com.iplanet.am.console.base.model.AMModelBase;
import com.iplanet.am.console.base.model.DynamicGUIGenerator;
import com.iplanet.am.console.components.view.html.DynamicGUI;
import com.iplanet.am.console.user.model.UMCreateModelImpl;
import com.iplanet.am.console.user.model.UMCreateRoleModel;
import com.iplanet.am.sdk.AMException;
import com.iplanet.am.sdk.AMObject;
import com.iplanet.am.sdk.AMOrganization;
import com.iplanet.am.sdk.AMOrganizationalUnit;
import com.iplanet.am.util.Debug;
import com.iplanet.am.util.Locale;
import com.iplanet.sso.SSOException;
import com.sun.identity.common.admin.AdminInterfaceUtils;
import com.sun.identity.sm.AttributeSchema;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.SchemaType;
import com.sun.identity.sm.ServiceSchema;
import com.sun.identity.sm.ServiceSchemaManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;

public class UMCreateRoleModelImpl
extends UMCreateModelImpl
implements UMCreateRoleModel {
    private Map defaultACIMap = null;
    private String roleName = null;
    private ServiceSchemaManager userSvcMgr = null;
    private boolean filter = false;
    private static final int ACI_DESCRIPTION = 0;
    private static final int DEFAULT_PERMISSION = 1;

    public UMCreateRoleModelImpl(HttpServletRequest httpServletRequest, Map map) {
        super(httpServletRequest, map);
    }

    public String getTitle() {
        return this.getTitle(1);
    }

    public String getTitle(int n) {
        String string = this.getLocalizedString("createRole.title");
        if (n == 2) {
            string = this.getLocalizedString("createRoleStep2.title");
        }
        return string;
    }

    public String getRoleDescriptionLabel() {
        return this.getLocalizedString("roleDescription.label");
    }

    public String getTypeLabel() {
        return this.getLocalizedString("roleType.label");
    }

    public String getAccessPermissionLabel() {
        return this.getLocalizedString("accessPermission.label");
    }

    public String getErrorTitle() {
        return this.getLocalizedString("createRoleFailed.title");
    }

    public String getAdvancedButtonLabel() {
        return this.getLocalizedString("showAdvanced.button");
    }

    public String getBasicButtonLabel() {
        return this.getLocalizedString("hideAdvanced.button");
    }

    public String getACIDescriptionLabel() {
        return this.getLocalizedString("aciDescription.label");
    }

    private Map getCreateRoleMap(Map map, Map map2) {
        String string = (String)map.remove("entryName");
        HashMap<String, Map> hashMap = new HashMap<String, Map>(1);
        hashMap.put(string, map2);
        return hashMap;
    }

    private Map getRoleMap(Map map) {
        HashSet<String> hashSet;
        Object object;
        String string = (String)map.remove("descriptionField");
        String string2 = (String)map.remove("roleType");
        String string3 = null;
        String string4 = "";
        String string5 = (String)map.remove("permission");
        if (string5 == null) {
            string4 = (String)map.remove("aciField");
            string3 = (String)map.remove("aciDescription");
        } else {
            if (this.defaultACIMap == null) {
                this.createACIMap();
            }
            object = (List)this.defaultACIMap.get(string5);
            string4 = (String)object.get(1);
            string3 = (String)object.get(0);
        }
        object = new HashMap(5);
        HashSet<String> hashSet2 = Collections.EMPTY_SET;
        if (string != null) {
            hashSet2 = new HashSet<String>(1);
            hashSet2.add(string);
        }
        object.put("iplanet-am-role-description", hashSet2);
        HashSet<String> hashSet3 = Collections.EMPTY_SET;
        if (string2 != null) {
            hashSet3 = new HashSet<String>(1);
            hashSet3.add(string2);
        }
        object.put("iplanet-am-role-type", hashSet3);
        if (string2 != null && string2.equals("2")) {
            hashSet = new HashSet<String>(1);
            hashSet.add(this.locationDN);
            object.put("iplanet-am-role-managed-container-dn", hashSet);
        }
        hashSet = Collections.EMPTY_SET;
        if (string4 != null) {
            hashSet = new HashSet(1);
            hashSet.add(string4);
        }
        object.put("iplanet-am-role-aci-list", hashSet);
        HashSet<String> hashSet4 = Collections.EMPTY_SET;
        if (string3 != null) {
            hashSet4 = new HashSet<String>(1);
            hashSet4.add(string3);
        }
        object.put("iplanet-am-role-aci-description", hashSet4);
        return object;
    }

    public boolean createRole(Map map) {
        boolean bl;
        block13: {
            bl = false;
            if (map == null || map.isEmpty()) {
                AMModelBase.debug.error("null or missing data values");
                this.errorMessage = this.getLocalizedString("createFailure.message");
                return bl;
            }
            Map map2 = this.getRoleMap(map);
            Map map3 = this.getCreateRoleMap(map, map2);
            String string = (String)map3.keySet().iterator().next();
            Set set = Collections.EMPTY_SET;
            String string2 = AdminInterfaceUtils.getNamingAttribute((int)6, (Debug)AMModelBase.debug) + "=" + string + "," + this.locationDN;
            int n = this.getRoleType(map);
            try {
                if (this.getLocationType() == 2) {
                    AMOrganization aMOrganization = this.dpStoreConn.getOrganization(this.locationDN);
                    this.fireBeforeCreateObjectEvent(n, (AMObject)aMOrganization, string, map2);
                    if (n == 8) {
                        this.createFilter(map, map3);
                        set = aMOrganization.createFilteredRoles(map3);
                    } else {
                        set = aMOrganization.createRoles(map3);
                    }
                } else {
                    AMOrganizationalUnit aMOrganizationalUnit = this.dpStoreConn.getOrganizationalUnit(this.locationDN);
                    this.fireBeforeCreateObjectEvent(n, (AMObject)aMOrganizationalUnit, string, map2);
                    if (n == 8) {
                        this.createFilter(map, map3);
                        set = aMOrganizationalUnit.createFilteredRoles(map3);
                    } else {
                        set = aMOrganizationalUnit.createRoles(map3);
                    }
                }
                if (set != null && !set.isEmpty()) {
                    this.setCreatedEntryDN(set);
                    this.logger.doLog("roleCreated.message", string2);
                    bl = true;
                    break block13;
                }
                this.errorMessage = this.getLocalizedString("createRoleFailed.message");
            }
            catch (AMException aMException) {
                this.errorMessage = this.getErrorString((Exception)((Object)aMException));
                if (AMModelBase.debug.warningEnabled()) {
                    AMModelBase.debug.warning("creating role failed.", (Throwable)aMException);
                }
                this.logger.doLog("roleCreateFailed.message", string2);
            }
            catch (SSOException sSOException) {
                AMModelBase.debug.error("error in sso ", (Throwable)sSOException);
            }
            catch (AMConsoleException aMConsoleException) {
                this.errorMessage = this.getErrorString(aMConsoleException);
                this.logger.doLog("roleCreateFailed.message", string2);
            }
        }
        return bl;
    }

    public Set getDefaultPermissions() {
        if (this.defaultACIMap == null) {
            this.createACIMap();
        }
        return this.defaultACIMap.keySet();
    }

    public Map getDefaultTypes() {
        HashMap<String, String> hashMap = new HashMap<String, String>(2);
        hashMap.put(this.getLocalizedString("roleType.2"), Integer.toString(2));
        hashMap.put(this.getLocalizedString("roleType.3"), Integer.toString(3));
        return hashMap;
    }

    private void createACIMap() {
        try {
            ServiceSchemaManager serviceSchemaManager = this.getServiceSchemaManager("iPlanetAMAdminConsoleService");
            ServiceSchema serviceSchema = serviceSchemaManager.getSchema(SchemaType.GLOBAL);
            Map map = serviceSchema.getAttributeDefaults();
            Set set = (Set)map.get("iplanet-am-admin-console-role-default-acis");
            Iterator iterator = set.iterator();
            this.defaultACIMap = new HashMap(set.size());
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                int n = 0;
                int n2 = string.indexOf("|");
                if (n2 == -1) {
                    if (!AMModelBase.debug.warningEnabled()) continue;
                    AMModelBase.debug.warning("invalid default aci entry found: " + string);
                    continue;
                }
                String string2 = string.substring(n, n2);
                n = n2 + 1;
                if ((n2 = string.indexOf("|", n)) == -1) {
                    if (!AMModelBase.debug.warningEnabled()) continue;
                    AMModelBase.debug.warning("invalid default aci entry found: " + string);
                    continue;
                }
                String string3 = string.substring(n, n2);
                n = n2 + 1;
                n2 = string.length();
                String string4 = string.substring(n, n2);
                ArrayList<String> arrayList = new ArrayList<String>(2);
                arrayList.add(0, string3);
                arrayList.add(1, string4);
                this.defaultACIMap.put(string2, arrayList);
            }
            if (AMModelBase.debug.messageEnabled()) {
                AMModelBase.debug.message("done creating map");
                AMModelBase.debug.message("defaultACIMap = " + this.defaultACIMap);
            }
        }
        catch (SMSException sMSException) {
            AMModelBase.debug.error("UMCreateRoleModelImpl::createACIMap", (Throwable)sMSException);
        }
        catch (SSOException sSOException) {
            AMModelBase.debug.warning("UMCreateRoleModelImpl::createACIMap", (Throwable)sSOException);
        }
    }

    public String getEmptyPermission() {
        return "No Permission";
    }

    public String getOptionString(String string) {
        String string2;
        String string3 = string;
        if ((string = string.trim().replace(' ', '-')).equals(string2 = this.getLocalizedString(string))) {
            string2 = string3;
            if (AMModelBase.debug.warningEnabled()) {
                AMModelBase.debug.warning("UMCreateRoleModelImpl.getOptionString() no localized value for " + string);
            }
        }
        return string2;
    }

    public String getRoleNameLabel() {
        return this.getLocalizedString("roleName.label");
    }

    public String getRoleTypeLabel() {
        return this.getLocalizedString("roleType.label");
    }

    public String getStaticRoleLabel() {
        return this.getLocalizedString("staticRole.label");
    }

    public String getFilteredRoleLabel() {
        return this.getLocalizedString("filteredRole.label");
    }

    public String getMissingRoleNameMessage() {
        return this.getLocalizedString("missingRoleName.message");
    }

    public void setRoleName(String string) {
        if (string != null && string.length() > 0) {
            this.roleName = string;
        } else {
            AMModelBase.debug.warning("trying to set role name, missing value");
        }
    }

    public String getLogicalOrOpValue() {
        return "OR";
    }

    public String getLogicalAndOpValue() {
        return "AND";
    }

    public String getLogicalOrOpLabel() {
        return this.getLocalizedString("logicalOR.label");
    }

    public String getLogicalAndOpLabel() {
        return this.getLocalizedString("logicalAND.label");
    }

    public String getFilterLabel() {
        return this.getLocalizedString("roleFilter.label");
    }

    public String getFilteredType() {
        return Integer.toString(8);
    }

    public String getOpLabel() {
        return this.getLocalizedString("operator.label");
    }

    public String getOpTextLabel() {
        return this.getLocalizedString("operatorText.label");
    }

    public String getRoleName() {
        return this.roleName;
    }

    public List getDynamicAttributes(String string) {
        if (this.requiredAttributes == null) {
            if (string.equals("advanced")) {
                this.buildSchemaAttributeList("FilteredRole");
            } else {
                this.buildFilterAttributeList();
            }
        }
        return this.requiredAttributes;
    }

    private void buildFilterAttributeList() {
        Object object;
        this.filter = true;
        this.requiredAttributes = Collections.EMPTY_LIST;
        this.attributeLabels = Collections.EMPTY_LIST;
        ServiceSchema serviceSchema = null;
        ResourceBundle resourceBundle = null;
        ServiceSchemaManager serviceSchemaManager = this.getUserSvcMgr();
        if (serviceSchemaManager == null) {
            AMModelBase.debug.warning("service schema mgr is null in buildFilterAttributeList");
            return;
        }
        try {
            serviceSchema = serviceSchemaManager.getSchema(SchemaType.USER);
            object = serviceSchemaManager.getI18NFileName();
            resourceBundle = ResourceBundle.getBundle((String)object, this.getUserLocale());
        }
        catch (SMSException sMSException) {
            AMModelBase.debug.warning("UMCreateRoleModelImpl.buildFilterAttributeList", (Throwable)sMSException);
            return;
        }
        if (serviceSchema == null) {
            AMModelBase.debug.warning("schema returned is null");
            return;
        }
        object = serviceSchema.getAttributeSchemaNames();
        if (object.isEmpty()) {
            AMModelBase.debug.warning("no attributes defined for filter list");
            return;
        }
        this.requiredAttributes = new ArrayList(object.size());
        this.attributeLabels = new ArrayList(object.size());
        Iterator iterator = object.iterator();
        while (iterator.hasNext()) {
            String string;
            AttributeSchema attributeSchema = serviceSchema.getAttributeSchema((String)iterator.next());
            if (attributeSchema == null || attributeSchema.getI18NKey() == null || attributeSchema.getI18NKey().length() == 0 || (string = attributeSchema.getAny()) == null || string.length() == 0 || string.indexOf("filter") == -1) continue;
            this.requiredAttributes.add(attributeSchema);
            String string2 = attributeSchema.getI18NKey();
            this.attributeLabels.add(Locale.getString((ResourceBundle)resourceBundle, (String)string2, (Debug)AMModelBase.debug));
        }
    }

    public int getNumDynamicAttributes(String string) {
        if (this.requiredAttributes == null) {
            if (string.equals("advanced")) {
                this.buildSchemaAttributeList("FilteredRole");
            } else {
                this.buildFilterAttributeList();
            }
        }
        if (this.requiredAttributes == null) {
            AMModelBase.debug.warning("required attributes is null in getNumDynamicAttributes");
            return 0;
        }
        return this.requiredAttributes.size();
    }

    private ServiceSchemaManager getUserSvcMgr() {
        block3: {
            if (this.userSvcMgr != null) break block3;
            try {
                this.userSvcMgr = this.getServiceSchemaManager("iPlanetAMUserService");
            }
            catch (SSOException sSOException) {
                AMModelBase.debug.warning("UMCreateRoleModelImpl.getUserSvcMgr", (Throwable)sSOException);
            }
            catch (SMSException sMSException) {
                AMModelBase.debug.error("UMCreateRoleModelImpl.getUserSvcMgr", (Throwable)sMSException);
            }
        }
        return this.userSvcMgr;
    }

    public DynamicGUI getDynamicGUI(int n) {
        AttributeSchema attributeSchema = (AttributeSchema)this.requiredAttributes.get(n);
        DynamicGUIGenerator dynamicGUIGenerator = DynamicGUIGenerator.getInstance();
        String string = this.filter ? "iPlanetAMUserService" : "iPlanetAMEntrySpecificService";
        return dynamicGUIGenerator.createDynamicGUI(attributeSchema, string, this.getAttributeValues(attributeSchema), this, null);
    }

    private void createFilter(Map map, Map map2) {
        Object object;
        Object object2;
        Cloneable cloneable;
        String string = (String)map.remove("logicalOp");
        Set set = (Set)map.remove("filterinfo");
        String string2 = null;
        if (set != null && !set.isEmpty()) {
            string2 = (String)set.iterator().next();
            if (!string2.startsWith("(") && !string2.endsWith(")")) {
                string2 = "(" + string2 + ")";
            }
        } else {
            CharSequence charSequence;
            cloneable = new HashMap(map);
            object2 = cloneable.keySet().iterator();
            object = new StringBuffer(100);
            while (object2.hasNext()) {
                charSequence = (String)object2.next();
                Set set2 = (Set)map.remove(charSequence);
                if (set2 == null || set2.isEmpty()) {
                    if (!((String)charSequence).equals("uid")) continue;
                    ((StringBuffer)object).append("(" + (String)charSequence + "=*)");
                    continue;
                }
                Iterator iterator = set2.iterator();
                String string3 = (String)iterator.next();
                if (((String)charSequence).equalsIgnoreCase("inetuserstatus")) {
                    if (string3.equalsIgnoreCase("active")) {
                        ((StringBuffer)object).append("(|(").append("inetuserstatus").append("=active)(!(").append("inetuserstatus").append("=*)))");
                        continue;
                    }
                    ((StringBuffer)object).append("(").append("inetuserstatus").append("=").append(string3).append(")");
                    continue;
                }
                ((StringBuffer)object).append("(").append((String)charSequence).append("=").append(string3).append(")");
            }
            charSequence = new StringBuffer(100);
            ((StringBuffer)charSequence).append("(&(objectclass=inetorgperson)");
            if (((StringBuffer)object).length() != 0) {
                if (cloneable.size() > 1) {
                    if (string != null && string.equalsIgnoreCase("AND")) {
                        ((StringBuffer)charSequence).append("(&");
                    } else {
                        ((StringBuffer)charSequence).append("(|");
                    }
                    ((StringBuffer)charSequence).append(object + ")");
                } else {
                    ((StringBuffer)charSequence).append((StringBuffer)object);
                }
            }
            ((StringBuffer)charSequence).append(")");
            string2 = ((StringBuffer)charSequence).toString();
        }
        if (string2 != null && string2.length() > 0) {
            cloneable = new HashSet(1);
            cloneable.add(string2);
            object2 = (String)map2.keySet().iterator().next();
            object = (Map)map2.get(object2);
            object.put("nsRoleFilter", cloneable);
        }
    }

    private int getRoleType(Map map) {
        int n;
        block2: {
            n = 6;
            String string = (String)map.remove("role");
            if (string == null || string.length() == 0) break block2;
            try {
                n = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                AMModelBase.debug.warning("UMCreateRoleModelImpl.getRoleType", (Throwable)numberFormatException);
            }
        }
        return n;
    }

    private void buildSchemaAttributeList(String string) {
        block4: {
            ServiceSchemaManager serviceSchemaManager = this.getEntrySpecificSvcMgr();
            if (serviceSchemaManager == null) {
                AMModelBase.debug.warning("schema mgr is null in method buildSchemaAttributeList");
                return;
            }
            try {
                ServiceSchema serviceSchema = serviceSchemaManager.getSchema(SchemaType.GLOBAL);
                ResourceBundle resourceBundle = ResourceBundle.getBundle(serviceSchemaManager.getI18NFileName(), this.getUserLocale());
                ServiceSchema serviceSchema2 = serviceSchema.getSubSchema(string);
                if (serviceSchema2 == null) break block4;
                List list = AMFormatUtils.sortAttrSchema(this.retainAttributeSchemasWithI18nKeys(serviceSchema2.getAttributeSchemas()), this.getUserLocale());
                Iterator iterator = list.iterator();
                this.requiredAttributes = new ArrayList(list.size());
                this.attributeLabels = new ArrayList(list.size());
                while (iterator.hasNext()) {
                    String string2;
                    AttributeSchema attributeSchema = (AttributeSchema)iterator.next();
                    String string3 = attributeSchema.getName();
                    if (string3.equals("uniquemember") || (string2 = attributeSchema.getI18NKey()) == null || string2.length() <= 0) continue;
                    this.requiredAttributes.add(attributeSchema);
                    this.attributeLabels.add(Locale.getString((ResourceBundle)resourceBundle, (String)string2, (Debug)AMModelBase.debug));
                }
            }
            catch (SMSException sMSException) {
                AMModelBase.debug.warning("UMCreateRoleModelImpl.buildSchemaAttributeList", (Throwable)sMSException);
            }
        }
    }

    public String getFilterRoleBasicButtonLabel() {
        return this.getLocalizedString("basicRole.button");
    }

    public String getFilterRoleAdvancedButtonLabel() {
        return this.getLocalizedString("advancedRole.button");
    }

    public String getHelpAnchorTag() {
        String string = this.getLocalizedString("createRole.help");
        if (string.equals("createRole.help")) {
            string = "contents.html";
        }
        return this.getHelpURL(string);
    }

    public int getNumRequiredAttributes() {
        return 0;
    }

    public List getRequiredAttributes() {
        return Collections.EMPTY_LIST;
    }

    public String getSelectRoleTypeMessage() {
        return this.getLocalizedString("selectRoleType.message");
    }

    public String getCreateStaticRoleMessage() {
        return this.getLocalizedString("createStaticRole.message");
    }

    public String getCreateDynamicRoleMessage() {
        return this.getLocalizedString("createDynamicRole.message");
    }
}

