/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.am.console.user.model;

import com.iplanet.am.console.base.model.AMConsoleException;
import com.iplanet.am.console.base.model.AMFormatUtils;
import com.iplanet.am.console.base.model.AMModelBase;
import com.iplanet.am.console.base.model.DynamicGUIGenerator;
import com.iplanet.am.console.components.view.html.DynamicGUI;
import com.iplanet.am.console.user.model.UMCreateGroupModel;
import com.iplanet.am.console.user.model.UMCreateModelImpl;
import com.iplanet.am.sdk.AMAssignableDynamicGroup;
import com.iplanet.am.sdk.AMDynamicGroup;
import com.iplanet.am.sdk.AMException;
import com.iplanet.am.sdk.AMGroup;
import com.iplanet.am.sdk.AMGroupContainer;
import com.iplanet.am.sdk.AMObject;
import com.iplanet.am.sdk.AMOrganization;
import com.iplanet.am.sdk.AMOrganizationalUnit;
import com.iplanet.am.sdk.AMStaticGroup;
import com.iplanet.am.util.Debug;
import com.iplanet.am.util.Locale;
import com.iplanet.sso.SSOException;
import com.sun.identity.common.admin.AdminInterfaceUtils;
import com.sun.identity.sm.AttributeSchema;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.SchemaType;
import com.sun.identity.sm.ServiceSchema;
import com.sun.identity.sm.ServiceSchemaManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;

public class UMCreateGroupModelImpl
extends UMCreateModelImpl
implements UMCreateGroupModel {
    private String groupContainerDN = null;
    private String groupName = null;
    private ServiceSchemaManager userSvcMgr = null;
    private boolean filter = false;

    public UMCreateGroupModelImpl(HttpServletRequest httpServletRequest, Map map) {
        super(httpServletRequest, map);
    }

    private ServiceSchemaManager getUserSvcMgr() {
        block3: {
            if (this.userSvcMgr != null) break block3;
            try {
                this.userSvcMgr = this.getServiceSchemaManager("iPlanetAMUserService");
            }
            catch (SSOException sSOException) {
                AMModelBase.debug.warning("UMCreateGroupModelImpl.getUserSvcMgr", (Throwable)sSOException);
            }
            catch (SMSException sMSException) {
                AMModelBase.debug.error("UMCreateGroupModelImpl.getUserSvcMgr", (Throwable)sMSException);
            }
        }
        return this.userSvcMgr;
    }

    public String getTitle() {
        return this.getTitle(1);
    }

    public String getTitle(int n) {
        String string = this.getLocalizedString("createGroup.title");
        if (n == 2) {
            string = this.getLocalizedString("createGroupStep2.title");
        }
        return string;
    }

    public String getGroupNameLabel() {
        return this.getLocalizedString("groupName.label");
    }

    public String getErrorTitle() {
        return this.getLocalizedString("createGroupFailed.title");
    }

    public String getGroupContainerLabel() {
        return this.getLocalizedString("groupContainer.label");
    }

    public String getAvailableContainersLabel() {
        return this.getLocalizedString("availableGroupContainers.label");
    }

    public boolean displayGroupContainers() {
        return this.getGroupContainers().size() > 1;
    }

    public Set getGroupContainers() {
        Set<String> set = Collections.EMPTY_SET;
        try {
            switch (this.locationType) {
                case 2: {
                    AMOrganization aMOrganization = this.dpStoreConn.getOrganization(this.locationDN);
                    set = aMOrganization.getGroupContainers(1);
                    break;
                }
                case 3: {
                    AMOrganizationalUnit aMOrganizationalUnit = this.dpStoreConn.getOrganizationalUnit(this.locationDN);
                    set = aMOrganizationalUnit.getGroupContainers(1);
                    break;
                }
                case 4: {
                    set = new HashSet<String>(1);
                    set.add(this.locationDN);
                }
            }
        }
        catch (AMException aMException) {
            AMModelBase.debug.warning("failed to get group containers", (Throwable)aMException);
        }
        catch (SSOException sSOException) {
            AMModelBase.debug.warning("failed to get group containers", (Throwable)sSOException);
        }
        return set;
    }

    public void setGroupContainer(String string) {
        this.groupContainerDN = string;
    }

    public int getNumDynamicAttributes(String string) {
        if (this.requiredAttributes == null) {
            if (string.equals("advanced")) {
                this.buildSchemaAttributeList("DynamicGroup");
            } else {
                this.buildFilterAttributeList();
            }
        }
        return this.requiredAttributes.size();
    }

    public int getNumStaticAttributes() {
        if (this.requiredAttributes == null) {
            this.buildSchemaAttributeList("Group");
        }
        return this.requiredAttributes.size();
    }

    public List getStaticAttributes() {
        if (this.requiredAttributes == null) {
            this.buildSchemaAttributeList("Group");
        }
        return this.requiredAttributes;
    }

    private void buildSchemaAttributeList(String string) {
        block5: {
            ServiceSchemaManager serviceSchemaManager = this.getEntrySpecificSvcMgr();
            if (serviceSchemaManager == null) {
                return;
            }
            try {
                String string2;
                Object object;
                ServiceSchema serviceSchema = serviceSchemaManager.getSchema(SchemaType.GLOBAL);
                ResourceBundle resourceBundle = ResourceBundle.getBundle(serviceSchemaManager.getI18NFileName(), this.getUserLocale());
                ServiceSchema serviceSchema2 = serviceSchema.getSubSchema(string);
                if (serviceSchema2 == null) break block5;
                List list = AMFormatUtils.sortAttrSchema(this.retainAttributeSchemasWithI18nKeys(serviceSchema2.getAttributeSchemas()), this.getUserLocale());
                this.requiredAttributes = new ArrayList(list.size());
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    AttributeSchema attributeSchema = (AttributeSchema)iterator.next();
                    object = attributeSchema.getName();
                    if (((String)object).equals("uniquemember") || (string2 = attributeSchema.getI18NKey()) == null || string2.length() <= 0) continue;
                    this.requiredAttributes.add(attributeSchema);
                }
                int n = string.equals("DynamicGroup") ? 11 : 10;
                this.fireRetrieveAttributeValuesEvent(1, n, "iPlanetAMEntrySpecificService", SchemaType.GLOBAL);
                this.attributeLabels = new ArrayList(this.requiredAttributes.size());
                object = this.requiredAttributes.iterator();
                while (object.hasNext()) {
                    string2 = (AttributeSchema)object.next();
                    this.attributeLabels.add(Locale.getString((ResourceBundle)resourceBundle, (String)string2.getI18NKey(), (Debug)AMModelBase.debug));
                }
            }
            catch (SMSException sMSException) {
                AMModelBase.debug.warning("failed to get required attributes", (Throwable)sMSException);
            }
        }
    }

    public List getDynamicAttributes(String string) {
        if (this.requiredAttributes == null) {
            if (string.equals("advanced")) {
                this.buildSchemaAttributeList("DynamicGroup");
            } else {
                this.buildFilterAttributeList();
            }
        }
        return this.requiredAttributes;
    }

    private void buildFilterAttributeList() {
        String string;
        Object object;
        Object object2;
        this.filter = true;
        this.requiredAttributes = Collections.EMPTY_LIST;
        this.attributeLabels = Collections.EMPTY_LIST;
        ServiceSchema serviceSchema = null;
        ResourceBundle resourceBundle = null;
        ServiceSchemaManager serviceSchemaManager = this.getUserSvcMgr();
        if (serviceSchemaManager == null) {
            return;
        }
        try {
            serviceSchema = serviceSchemaManager.getSchema(SchemaType.USER);
            object2 = serviceSchemaManager.getI18NFileName();
            resourceBundle = ResourceBundle.getBundle((String)object2, this.getUserLocale());
        }
        catch (SMSException sMSException) {
            AMModelBase.debug.warning("UMCreateGroupModelImpl.buildFilterAttributeList", (Throwable)sMSException);
            return;
        }
        if (serviceSchema == null) {
            AMModelBase.debug.warning("schema returned is null");
            return;
        }
        object2 = serviceSchema.getAttributeSchemaNames();
        if (object2.isEmpty()) {
            AMModelBase.debug.warning("no attributes defined for filter list");
            return;
        }
        this.requiredAttributes = new ArrayList(object2.size());
        Iterator iterator = object2.iterator();
        while (iterator.hasNext()) {
            object = serviceSchema.getAttributeSchema((String)iterator.next());
            if (object == null || object.getI18NKey() == null || object.getI18NKey().length() == 0 || (string = object.getAny()) == null || string.indexOf("filter") == -1) continue;
            if (AMModelBase.debug.messageEnabled()) {
                AMModelBase.debug.message("adding " + object.getName() + " to list");
            }
            this.requiredAttributes.add(object);
        }
        this.fireRetrieveAttributeValuesEvent(1, 11, "iPlanetAMUserService", SchemaType.USER);
        this.attributeLabels = new ArrayList(this.requiredAttributes.size());
        object = this.requiredAttributes.iterator();
        while (object.hasNext()) {
            string = (AttributeSchema)object.next();
            this.attributeLabels.add(Locale.getString((ResourceBundle)resourceBundle, (String)string.getI18NKey(), (Debug)AMModelBase.debug));
        }
    }

    public boolean createGroup(Map map) {
        boolean bl = false;
        if (AMModelBase.debug.messageEnabled()) {
            AMModelBase.debug.message("dataIn for createGroup is " + map);
        }
        if (this.groupContainerDN != null && this.groupContainerDN.length() != 0) {
            AMGroupContainer aMGroupContainer = null;
            try {
                aMGroupContainer = this.dpStoreConn.getGroupContainer(this.groupContainerDN);
                bl = this.createGroup(aMGroupContainer, map);
            }
            catch (AMException aMException) {
                AMModelBase.debug.warning("create of group failed", (Throwable)aMException);
                this.errorMessage = this.getErrorString((Exception)((Object)aMException));
            }
            catch (SSOException sSOException) {
                AMModelBase.debug.warning("create of group failed ", (Throwable)sSOException);
                this.errorMessage = this.getErrorString((Exception)((Object)sSOException));
            }
            catch (AMConsoleException aMConsoleException) {
                AMModelBase.debug.warning("create of group failed ", (Throwable)aMConsoleException);
                this.errorMessage = this.getErrorString(aMConsoleException);
            }
            return bl;
        }
        AMModelBase.debug.message("creating group under the parent ");
        try {
            switch (this.getLocationType()) {
                case 2: {
                    AMOrganization aMOrganization = (AMOrganization)this.getAMObject(this.locationDN);
                    bl = this.createGroup(aMOrganization, map);
                    break;
                }
                case 3: {
                    AMOrganizationalUnit aMOrganizationalUnit = (AMOrganizationalUnit)this.getAMObject(this.locationDN);
                    bl = this.createGroup(aMOrganizationalUnit, map);
                    break;
                }
                case 9: 
                case 10: {
                    AMStaticGroup aMStaticGroup = (AMStaticGroup)this.getAMObject(this.locationDN);
                    bl = this.createSubGroup((AMGroup)aMStaticGroup, map);
                    break;
                }
                case 11: {
                    AMDynamicGroup aMDynamicGroup = (AMDynamicGroup)this.getAMObject(this.locationDN);
                    bl = this.createSubGroup((AMGroup)aMDynamicGroup, map);
                    break;
                }
                case 12: {
                    AMAssignableDynamicGroup aMAssignableDynamicGroup = (AMAssignableDynamicGroup)this.getAMObject(this.locationDN);
                    bl = this.createSubGroup((AMGroup)aMAssignableDynamicGroup, map);
                }
            }
        }
        catch (AMException aMException) {
            AMModelBase.debug.warning("create of group failed", (Throwable)aMException);
            this.errorMessage = this.getErrorString((Exception)((Object)aMException));
        }
        catch (SSOException sSOException) {
            AMModelBase.debug.warning("create of group failed", (Throwable)sSOException);
            this.errorMessage = this.getErrorString((Exception)((Object)sSOException));
        }
        catch (AMConsoleException aMConsoleException) {
            AMModelBase.debug.warning("create of group failed", (Throwable)aMConsoleException);
            this.errorMessage = this.getErrorString(aMConsoleException);
        }
        return bl;
    }

    private boolean createGroup(AMGroupContainer aMGroupContainer, Map map) throws AMException, SSOException, AMConsoleException {
        AMModelBase.debug.message("creating group in container : " + aMGroupContainer.getDN());
        boolean bl = false;
        Set set = null;
        int n = this.getGroupType(map);
        String string = (String)map.remove("entryName");
        HashSet<String> hashSet = new HashSet<String>(1);
        hashSet.add(string);
        this.fireBeforeCreateObjectEvent(n, (AMObject)aMGroupContainer, string, map);
        switch (n) {
            case 9: 
            case 10: {
                AMModelBase.debug.message("static group");
                try {
                    set = aMGroupContainer.createStaticGroups(hashSet);
                    if (set != null && !set.isEmpty()) {
                        AMStaticGroup aMStaticGroup = (AMStaticGroup)set.iterator().next();
                        this.modify((AMGroup)aMStaticGroup, map);
                        bl = true;
                        break;
                    }
                    this.errorMessage = this.getLocalizedString("createGroupFailed.message");
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    this.errorMessage = this.getErrorString(illegalArgumentException);
                }
                break;
            }
            case 11: {
                AMModelBase.debug.message("dynamic group");
                HashMap<String, Map> hashMap = new HashMap<String, Map>(1);
                map.putAll(this.createMemberURL(aMGroupContainer.getDN(), map));
                hashMap.put(string, map);
                try {
                    set = aMGroupContainer.createDynamicGroups(hashMap);
                    if (set != null && !set.isEmpty()) {
                        bl = true;
                        break;
                    }
                    this.errorMessage = this.getLocalizedString("createGroupFailed.message");
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    this.errorMessage = this.getErrorString(illegalArgumentException);
                }
                break;
            }
            case 12: {
                AMModelBase.debug.message("assignable group");
                try {
                    set = aMGroupContainer.createAssignableDynamicGroups(hashSet);
                    if (set != null && !set.isEmpty()) {
                        AMAssignableDynamicGroup aMAssignableDynamicGroup = (AMAssignableDynamicGroup)set.iterator().next();
                        this.modify((AMGroup)aMAssignableDynamicGroup, map);
                        bl = true;
                        break;
                    }
                    this.errorMessage = this.getLocalizedString("createGroupFailed.message");
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    this.errorMessage = this.getErrorString(illegalArgumentException);
                }
                break;
            }
        }
        if (bl) {
            this.setCreatedEntryDN(set);
            this.writeLog(string, aMGroupContainer.getDN());
        }
        return bl;
    }

    private boolean createGroup(AMOrganizationalUnit aMOrganizationalUnit, Map map) throws AMException, SSOException, AMConsoleException {
        AMModelBase.debug.message("creating group in orgunit : " + aMOrganizationalUnit.getDN());
        Set set = null;
        String string = (String)map.remove("entryName");
        HashSet<String> hashSet = new HashSet<String>(1);
        hashSet.add(string);
        int n = this.getGroupType(map);
        switch (n) {
            case 9: 
            case 10: {
                AMModelBase.debug.message("static group");
                set = aMOrganizationalUnit.createStaticGroups(hashSet);
                Iterator iterator = set.iterator();
                if (!iterator.hasNext()) break;
                AMStaticGroup aMStaticGroup = (AMStaticGroup)iterator.next();
                this.modify((AMGroup)aMStaticGroup, map);
                break;
            }
            case 11: {
                AMModelBase.debug.message("dynamic group");
                map.putAll(this.createMemberURL(aMOrganizationalUnit.getDN(), map));
                HashMap<String, Map> hashMap = new HashMap<String, Map>(1);
                hashMap.put(string, map);
                set = aMOrganizationalUnit.createDynamicGroups(hashMap);
                break;
            }
            case 12: {
                AMModelBase.debug.message("assignable group");
                set = aMOrganizationalUnit.createAssignableDynamicGroups(hashSet);
                Iterator iterator = set.iterator();
                if (!iterator.hasNext()) break;
                AMAssignableDynamicGroup aMAssignableDynamicGroup = (AMAssignableDynamicGroup)iterator.next();
                this.modify((AMGroup)aMAssignableDynamicGroup, map);
            }
        }
        if (set == null || set.isEmpty()) {
            this.errorMessage = "Couldn't create the group";
            return false;
        }
        this.setCreatedEntryDN(set);
        this.writeLog(string, aMOrganizationalUnit.getDN());
        return true;
    }

    private boolean createGroup(AMOrganization aMOrganization, Map map) throws AMException, SSOException, AMConsoleException {
        AMModelBase.debug.message("creating group in org : " + aMOrganization.getDN());
        Set set = null;
        int n = this.getGroupType(map);
        String string = (String)map.remove("entryName");
        HashSet<String> hashSet = new HashSet<String>(1);
        hashSet.add(string);
        switch (n) {
            case 9: 
            case 10: {
                AMModelBase.debug.message("static group");
                set = aMOrganization.createStaticGroups(hashSet);
                Iterator iterator = set.iterator();
                if (!iterator.hasNext()) break;
                AMStaticGroup aMStaticGroup = (AMStaticGroup)iterator.next();
                this.modify((AMGroup)aMStaticGroup, map);
                break;
            }
            case 11: {
                AMModelBase.debug.message("creating dynamic group");
                map.putAll(this.createMemberURL(aMOrganization.getDN(), map));
                HashMap<String, Map> hashMap = new HashMap<String, Map>(1);
                hashMap.put(string, map);
                set = aMOrganization.createDynamicGroups(hashMap);
                break;
            }
            case 12: {
                AMModelBase.debug.message("creating assignable dynamic group");
                set = aMOrganization.createAssignableDynamicGroups(hashSet);
                Iterator iterator = set.iterator();
                if (!iterator.hasNext()) break;
                AMAssignableDynamicGroup aMAssignableDynamicGroup = (AMAssignableDynamicGroup)iterator.next();
                this.modify((AMGroup)aMAssignableDynamicGroup, map);
                break;
            }
            default: {
                AMModelBase.debug.message("unknown group type specified");
            }
        }
        if (set == null || set.isEmpty()) {
            this.errorMessage = "Couldn't create the group";
            return false;
        }
        this.setCreatedEntryDN(set);
        this.writeLog(string, aMOrganization.getDN());
        return true;
    }

    private boolean createSubGroup(AMGroup aMGroup, Map map) throws AMException, SSOException, AMConsoleException {
        Set set = null;
        int n = this.getGroupType(map);
        String string = (String)map.remove("entryName");
        HashMap<String, Map> hashMap = new HashMap<String, Map>(1);
        switch (n) {
            case 9: 
            case 10: {
                Iterator iterator;
                Set set2 = (Set)map.remove("uniquemember");
                hashMap.put(string, map);
                set = aMGroup.createStaticGroups(hashMap);
                if (set2 == null || set2.isEmpty() || !(iterator = set.iterator()).hasNext()) break;
                AMStaticGroup aMStaticGroup = (AMStaticGroup)iterator.next();
                aMStaticGroup.addUsers(set2);
                break;
            }
            case 11: {
                map.putAll(this.createMemberURL(aMGroup.getDN(), map));
                hashMap.put(string, map);
                set = aMGroup.createDynamicGroups(hashMap);
                break;
            }
            case 12: {
                Iterator iterator;
                Set set3 = (Set)map.remove("uniquemember");
                hashMap.put(string, map);
                set = aMGroup.createAssignableDynamicGroups(hashMap);
                if (set3 == null || set3.isEmpty() || !(iterator = set.iterator()).hasNext()) break;
                AMAssignableDynamicGroup aMAssignableDynamicGroup = (AMAssignableDynamicGroup)iterator.next();
                aMAssignableDynamicGroup.addUsers(set3);
                break;
            }
            default: {
                if (!AMModelBase.debug.messageEnabled()) break;
                AMModelBase.debug.message("invalid group " + n);
            }
        }
        if (set == null || set.isEmpty()) {
            this.errorMessage = "Couldn't create the group";
            return false;
        }
        this.setCreatedEntryDN(set);
        this.writeLog(string, aMGroup.getDN());
        return true;
    }

    private Map createMemberURL(String string, Map map) {
        HashSet<String> hashSet;
        String string2 = null;
        if (map.containsKey("logicalOp")) {
            string2 = this.createAVFilter(map);
            if (AMModelBase.debug.messageEnabled()) {
                AMModelBase.debug.message("returned filter " + string2);
            }
        } else {
            hashSet = (HashSet<String>)map.remove("filterinfo");
            string2 = hashSet == null || hashSet.isEmpty() ? AdminInterfaceUtils.getNamingAttribute((int)9, (Debug)AMModelBase.debug) + "=*" : (String)hashSet.iterator().next();
        }
        hashSet = new HashSet<String>(1);
        hashSet.add("ldap:///" + string + "??sub?" + string2);
        HashMap<String, HashSet<String>> hashMap = new HashMap<String, HashSet<String>>(1);
        hashMap.put("memberurl", hashSet);
        return hashMap;
    }

    private String createAVFilter(Map map) {
        CharSequence charSequence;
        Set set = (Set)map.remove("logicalOp");
        String string = (String)set.iterator().next();
        HashMap hashMap = new HashMap(map);
        Iterator iterator = hashMap.keySet().iterator();
        StringBuffer stringBuffer = new StringBuffer(100);
        while (iterator.hasNext()) {
            charSequence = (String)iterator.next();
            Set set2 = (Set)map.remove(charSequence);
            if (set2 == null || set2.isEmpty()) {
                if (!((String)charSequence).equals("uid")) continue;
                stringBuffer.append("(" + (String)charSequence + "=*)");
                continue;
            }
            Iterator iterator2 = set2.iterator();
            String string2 = (String)iterator2.next();
            if (((String)charSequence).equalsIgnoreCase("inetuserstatus")) {
                if (string2.equalsIgnoreCase("active")) {
                    stringBuffer.append("(|(").append("inetuserstatus").append("=active)(!(").append("inetuserstatus").append("=*)))");
                    continue;
                }
                stringBuffer.append("(").append("inetuserstatus").append("=").append(string2).append(")");
                continue;
            }
            stringBuffer.append("(").append((String)charSequence).append("=").append(string2).append(")");
        }
        charSequence = new StringBuffer(100);
        ((StringBuffer)charSequence).append("(&(objectclass=inetorgperson)");
        if (stringBuffer.length() != 0) {
            if (hashMap.size() > 1) {
                if (string != null && string.equalsIgnoreCase("AND")) {
                    ((StringBuffer)charSequence).append("(&");
                } else {
                    ((StringBuffer)charSequence).append("(|");
                }
                ((StringBuffer)charSequence).append(stringBuffer + ")");
            } else {
                ((StringBuffer)charSequence).append(stringBuffer);
            }
        }
        ((StringBuffer)charSequence).append(")");
        return ((StringBuffer)charSequence).toString();
    }

    private int getGroupType(Map map) {
        int n;
        block2: {
            n = this.getGroupConfiguration();
            String string = (String)map.remove("group");
            if (string == null || string.length() == 0) break block2;
            try {
                n = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                if (!AMModelBase.debug.warningEnabled()) break block2;
                AMModelBase.debug.warning("getGroupType defaulting to " + n, (Throwable)numberFormatException);
            }
        }
        return n;
    }

    private void modify(AMGroup aMGroup, Map map) throws AMException, SSOException {
        if (AMModelBase.debug.messageEnabled()) {
            AMModelBase.debug.message("modifying group with " + map);
        }
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            Set set = (Set)map.get(string);
            if (set == null || set.isEmpty()) continue;
            if (AMModelBase.debug.messageEnabled()) {
                AMModelBase.debug.message("att = " + string);
                AMModelBase.debug.message("value = " + set);
            }
            try {
                HashMap<String, Set> hashMap = new HashMap<String, Set>(1);
                hashMap.put(string, set);
                aMGroup.setAttributes(hashMap);
                aMGroup.store();
            }
            catch (AMException aMException) {
                if (!AMModelBase.debug.warningEnabled()) continue;
                AMModelBase.debug.warning("write profile failed for " + string, (Throwable)aMException);
            }
        }
    }

    public String getStaticType() {
        return Integer.toString(this.getGroupConfiguration());
    }

    public String getDynamicType() {
        return Integer.toString(11);
    }

    public String getGroupTypeLabel() {
        return this.getLocalizedString("groupType.label");
    }

    public String getStaticGroupLabel() {
        return this.getLocalizedString("staticGroup.label");
    }

    public String getDynamicGroupLabel() {
        return this.getLocalizedString("dynamicGroup.label");
    }

    public String getUniqueAttribute() {
        return "uniquemember";
    }

    public String getFilterLabel() {
        return this.getLocalizedString("groupFilter.label");
    }

    public String getAdvancedButtonLabel() {
        return this.getLocalizedString("advancedGroup.button");
    }

    public String getBasicButtonLabel() {
        return this.getLocalizedString("basicGroup.button");
    }

    public String getOpLabel() {
        return this.getLocalizedString("operator.label");
    }

    public String getOpTextLabel() {
        return this.getLocalizedString("operatorText.label");
    }

    public String getLogicalOrOpValue() {
        return "OR";
    }

    public String getLogicalAndOpValue() {
        return "AND";
    }

    public String getLogicalOrOpLabel() {
        return this.getLocalizedString("logicalOR.label");
    }

    public String getLogicalAndOpLabel() {
        return this.getLocalizedString("logicalAND.label");
    }

    public void setGroupName(String string) {
        if (string != null && string.length() > 0) {
            this.groupName = string;
        } else {
            AMModelBase.debug.warning("trying to set group name, missing value");
        }
    }

    public String getGroupName() {
        return this.groupName;
    }

    public void setAttributeValues(Map map) {
        this.mapAttributeValues = new HashMap(map);
    }

    public String getSearchLocationDN() {
        String string = this.getLocationDN();
        int n = this.getLocationType();
        try {
            switch (n) {
                case 4: {
                    AMGroupContainer aMGroupContainer = this.dpStoreConn.getGroupContainer(string);
                    string = aMGroupContainer.getOrganizationDN();
                    break;
                }
                case 9: 
                case 10: {
                    AMStaticGroup aMStaticGroup = this.dpStoreConn.getStaticGroup(string);
                    string = aMStaticGroup.getOrganizationDN();
                    break;
                }
                case 12: {
                    AMAssignableDynamicGroup aMAssignableDynamicGroup = this.dpStoreConn.getAssignableDynamicGroup(string);
                    string = aMAssignableDynamicGroup.getOrganizationDN();
                    break;
                }
                case 11: {
                    AMDynamicGroup aMDynamicGroup = this.dpStoreConn.getDynamicGroup(string);
                    string = aMDynamicGroup.getOrganizationDN();
                }
            }
        }
        catch (SSOException sSOException) {
            AMModelBase.debug.warning("UMCreateGroupModelImpl.getSearchLocationDN", (Throwable)sSOException);
        }
        catch (AMException aMException) {
            AMModelBase.debug.warning("UMCreateGroupModelImpl.getSearchLocationDN", (Throwable)aMException);
        }
        if (AMModelBase.debug.messageEnabled()) {
            AMModelBase.debug.message("UMCreateGroupModelImpl:getSearchLocationDN " + string);
        }
        return string;
    }

    public String getMissingGroupNameMessage() {
        return this.getLocalizedString("missingGroupName.message");
    }

    private void writeLog(String string, String string2) {
        if (this.logger.isEnabled()) {
            String string3 = AdminInterfaceUtils.getNamingAttribute((int)9, (Debug)AMModelBase.debug) + "=" + string + "," + string2;
            this.logger.doLog("groupCreated.message", string3);
        }
    }

    public DynamicGUI getDynamicGUI(int n) {
        AttributeSchema attributeSchema = (AttributeSchema)this.requiredAttributes.get(n);
        DynamicGUIGenerator dynamicGUIGenerator = DynamicGUIGenerator.getInstance();
        String string = this.filter ? "iPlanetAMUserService" : "iPlanetAMEntrySpecificService";
        return dynamicGUIGenerator.createDynamicGUI(attributeSchema, string, (Set)this.mapAttributeValues.get(attributeSchema.getName()), this, null);
    }

    public String getHelpAnchorTag(String string) {
        String string2 = this.getLocalizedString("createFilteredGroup.help");
        if (string.equals("static")) {
            string2 = this.getLocalizedString("createStaticGroup.help");
        }
        if (string2.endsWith(".help")) {
            string2 = "contents.html";
        }
        return this.getHelpURL(string2);
    }

    public String getHelpAnchorTag() {
        String string = this.getLocalizedString("createGroup.help");
        if (string.equals("createGroup.help")) {
            string = "contents.html";
        }
        return this.getHelpURL(string);
    }

    public int getNumRequiredAttributes() {
        return 0;
    }

    public List getRequiredAttributes() {
        return Collections.EMPTY_LIST;
    }

    public String getCreateGroupMessage() {
        return this.getLocalizedString("createGroupWizard.message");
    }

    public String getCreateStaticGroupMessage() {
        return this.getLocalizedString("createStaticGroupWizard.message");
    }

    public String getCreateDynamicGroupMessage() {
        return this.getLocalizedString("createDynamicGroupWizard.message");
    }
}

