/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.am.console.user.model;

import com.iplanet.am.console.base.model.AMConsoleException;
import com.iplanet.am.console.base.model.AMFormatUtils;
import com.iplanet.am.console.base.model.AMModelBase;
import com.iplanet.am.console.user.model.UMCreateGCModel;
import com.iplanet.am.console.user.model.UMCreateModelImpl;
import com.iplanet.am.sdk.AMException;
import com.iplanet.am.sdk.AMGroupContainer;
import com.iplanet.am.sdk.AMObject;
import com.iplanet.am.sdk.AMOrganization;
import com.iplanet.am.sdk.AMOrganizationalUnit;
import com.iplanet.am.util.Debug;
import com.iplanet.sso.SSOException;
import com.sun.identity.common.admin.AdminInterfaceUtils;
import com.sun.identity.sm.AttributeSchema;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.SchemaType;
import com.sun.identity.sm.ServiceSchema;
import com.sun.identity.sm.ServiceSchemaManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;

public class UMCreateGCModelImpl
extends UMCreateModelImpl
implements UMCreateGCModel {
    public UMCreateGCModelImpl(HttpServletRequest httpServletRequest, Map map) {
        super(httpServletRequest, map);
    }

    public String getTitle() {
        return this.getLocalizedString("createGC.title");
    }

    public String getErrorTitle() {
        return this.getLocalizedString("createGCFailed.title");
    }

    public boolean createGC(Map map) {
        String string;
        boolean bl = false;
        if (map == null || map.isEmpty()) {
            AMModelBase.debug.error("null or missing data values");
            this.errorMessage = this.getLocalizedString("createFailure.message");
            return bl;
        }
        if (AMModelBase.debug.messageEnabled()) {
            AMModelBase.debug.message("trying to create group container with " + map);
        }
        if ((string = (String)map.remove("entryName")) == null) {
            this.errorMessage = this.getLocalizedString("createFailure.message");
            return false;
        }
        Set set = Collections.EMPTY_SET;
        HashMap<String, Map> hashMap = new HashMap<String, Map>(1);
        hashMap.put(string, map);
        String string2 = AdminInterfaceUtils.getNamingAttribute((int)4, (Debug)AMModelBase.debug) + "=" + string + "," + this.locationDN;
        try {
            int n = this.getLocationType();
            if (n == 2) {
                AMOrganization aMOrganization = this.dpStoreConn.getOrganization(this.locationDN);
                this.fireBeforeCreateObjectEvent(4, (AMObject)aMOrganization, string, map);
                set = aMOrganization.createGroupContainers(hashMap);
            } else if (n == 3) {
                AMOrganizationalUnit aMOrganizationalUnit = this.dpStoreConn.getOrganizationalUnit(this.locationDN);
                this.fireBeforeCreateObjectEvent(4, (AMObject)aMOrganizationalUnit, string, map);
                set = aMOrganizationalUnit.createGroupContainers(hashMap);
            } else {
                AMGroupContainer aMGroupContainer = this.dpStoreConn.getGroupContainer(this.locationDN);
                this.fireBeforeCreateObjectEvent(4, (AMObject)aMGroupContainer, string, map);
                set = aMGroupContainer.createSubGroupContainers(hashMap);
            }
            bl = true;
            this.setCreatedEntryDN(set);
            this.logger.doLog("groupContainerCreated.message", string2);
        }
        catch (AMException aMException) {
            this.errorMessage = this.getErrorString((Exception)((Object)aMException));
            if (AMModelBase.debug.warningEnabled()) {
                AMModelBase.debug.warning("creating gc " + string + " failed.", (Throwable)aMException);
            }
            this.logger.doLog("groupContainerCreateFailed.message", string2);
        }
        catch (SSOException sSOException) {
            AMModelBase.debug.error("error in sso ", (Throwable)sSOException);
        }
        catch (AMConsoleException aMConsoleException) {
            this.errorMessage = this.getErrorString(aMConsoleException);
            this.logger.doLog("groupContainerCreateFailed.message", string2);
        }
        return bl;
    }

    public String getHelpAnchorTag() {
        String string = this.getLocalizedString("createGroupContainer.help");
        if (string.equals("createGroupContainer.help")) {
            string = "contents.html";
        }
        return this.getHelpURL(string);
    }

    public int getNumRequiredAttributes() {
        if (this.requiredAttributes == null) {
            this.buildRequiredAttributeList();
        }
        return this.requiredAttributes.size();
    }

    private void buildRequiredAttributeList() {
        block5: {
            this.requiredAttributes = Collections.EMPTY_LIST;
            ServiceSchemaManager serviceSchemaManager = this.getEntrySpecificSvcMgr();
            if (serviceSchemaManager == null) break block5;
            try {
                ServiceSchema serviceSchema;
                ServiceSchema serviceSchema2 = serviceSchemaManager.getSchema(SchemaType.GLOBAL);
                Set set = serviceSchema2.getSubSchemaNames();
                if (set != null && set.contains("GroupContainer") && (serviceSchema = serviceSchema2.getSubSchema("GroupContainer")) != null) {
                    List list = AMFormatUtils.sortAttrSchema(this.retainAttributeSchemasWithI18nKeys(serviceSchema.getAttributeSchemas()), this.getUserLocale());
                    this.requiredAttributes = new ArrayList(list.size());
                    Iterator iterator = list.iterator();
                    while (iterator.hasNext()) {
                        this.requiredAttributes.add(iterator.next());
                    }
                    this.fireRetrieveAttributeValuesEvent(1, 4, "iPlanetAMEntrySpecificService", SchemaType.GLOBAL);
                    this.attributeLabels = new ArrayList(this.requiredAttributes.size());
                    Iterator iterator2 = this.requiredAttributes.iterator();
                    while (iterator2.hasNext()) {
                        AttributeSchema attributeSchema = (AttributeSchema)iterator2.next();
                        this.attributeLabels.add(this.getL10NAttributeName(serviceSchemaManager, attributeSchema.getI18NKey()));
                    }
                }
            }
            catch (SMSException sMSException) {
                AMModelBase.debug.error("UMCreateOrgModelImpl.buildRequiredAttributeList", (Throwable)sMSException);
            }
        }
    }

    public List getRequiredAttributes() {
        if (this.requiredAttributes == null) {
            this.buildRequiredAttributeList();
        }
        return this.requiredAttributes;
    }
}

