/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.am.console.user.model;

import com.iplanet.am.console.base.model.AMFormatUtils;
import com.iplanet.am.console.base.model.AMModelBase;
import com.iplanet.am.console.base.model.DynamicGUIGenerator;
import com.iplanet.am.console.components.view.html.DynamicGUI;
import com.iplanet.am.console.user.model.UMCreateAgentModel;
import com.iplanet.am.console.user.model.UMCreateModelImpl;
import com.iplanet.am.sdk.AMEntity;
import com.iplanet.am.sdk.AMException;
import com.iplanet.am.sdk.AMOrganization;
import com.iplanet.am.sdk.AMOrganizationalUnit;
import com.iplanet.sso.SSOException;
import com.sun.identity.common.admin.AdminInterfaceUtils;
import com.sun.identity.sm.AttributeSchema;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.SchemaType;
import com.sun.identity.sm.ServiceSchema;
import com.sun.identity.sm.ServiceSchemaManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;

public class UMCreateAgentModelImpl
extends UMCreateModelImpl
implements UMCreateAgentModel {
    public UMCreateAgentModelImpl(HttpServletRequest httpServletRequest, Map map) {
        super(httpServletRequest, map);
    }

    public String getTitle() {
        return this.getLocalizedString("createAgent.title");
    }

    public String getErrorTitle() {
        return this.getLocalizedString("createAgentFailed.title");
    }

    public List getRequiredAttributes() {
        if (this.requiredAttributes == null) {
            this.buildRequiredAttributeList();
        }
        return this.requiredAttributes;
    }

    public int getNumRequiredAttributes() {
        if (this.requiredAttributes == null) {
            this.buildRequiredAttributeList();
        }
        return this.requiredAttributes.size();
    }

    private void buildRequiredAttributeList() {
        block3: {
            this.requiredAttributes = Collections.EMPTY_LIST;
            ServiceSchemaManager serviceSchemaManager = this.getServiceSchemaManager();
            if (serviceSchemaManager == null) break block3;
            try {
                ServiceSchema serviceSchema = serviceSchemaManager.getSchema(SchemaType.USER);
                if (serviceSchema != null) {
                    Set set = serviceSchema.getAttributeSchemas();
                    this.requiredAttributes = AMFormatUtils.sortAttrSchema(this.retainAttributeSchemasWithI18nKeys(set), this.getUserLocale());
                    this.getMapAttributeValues();
                    this.getAttributeLabels(serviceSchemaManager);
                }
            }
            catch (SMSException sMSException) {
                AMModelBase.debug.error("UMCreateAgentModelImpl.buildRequiredAttributeList", (Throwable)sMSException);
            }
        }
    }

    private void getAttributeLabels(ServiceSchemaManager serviceSchemaManager) {
        this.attributeLabels = new ArrayList(this.requiredAttributes.size());
        Iterator iterator = this.requiredAttributes.iterator();
        while (iterator.hasNext()) {
            AttributeSchema attributeSchema = (AttributeSchema)iterator.next();
            this.attributeLabels.add(this.getL10NAttributeName(serviceSchemaManager, attributeSchema.getI18NKey()));
        }
    }

    private void getMapAttributeValues() {
        if (this.mapAttributeValues == null) {
            this.mapAttributeValues = new HashMap(this.requiredAttributes.size() * 2);
            Iterator iterator = this.requiredAttributes.iterator();
            while (iterator.hasNext()) {
                AttributeSchema attributeSchema = (AttributeSchema)iterator.next();
                this.mapAttributeValues.put(attributeSchema.getName(), this.getAttributeValues(attributeSchema));
            }
        }
    }

    private ServiceSchemaManager getServiceSchemaManager() {
        ServiceSchemaManager serviceSchemaManager = null;
        try {
            serviceSchemaManager = this.getServiceSchemaManager("iPlanetAMAgentService");
        }
        catch (SSOException sSOException) {
            AMModelBase.debug.warning("UMCreateAgentModelImpl.getServiceSchemaManager", (Throwable)sSOException);
        }
        catch (SMSException sMSException) {
            AMModelBase.debug.warning("UMCreateAgentModelImpl.getServiceSchemaManager", (Throwable)sMSException);
        }
        return serviceSchemaManager;
    }

    public boolean createAgent(Map map) {
        boolean bl = false;
        if (map == null || map.isEmpty()) {
            AMModelBase.debug.error("null or missing data values");
            this.errorMessage = this.getLocalizedString("createFailure.message");
        } else {
            this.mapAttributeValues = new HashMap(map.size() * 2);
            this.mapAttributeValues.putAll(map);
            String string = (String)map.remove("entryName");
            if (string == null || string.length() == 0) {
                this.errorMessage = this.getLocalizedString("createFailure.message");
            } else {
                int n = this.getLocationType();
                try {
                    if (n == 2) {
                        AMOrganization aMOrganization = this.dpStoreConn.getOrganization(this.locationDN);
                        this.createAgent(aMOrganization, string, map);
                        bl = true;
                    } else if (n == 3) {
                        AMOrganizationalUnit aMOrganizationalUnit = this.dpStoreConn.getOrganizationalUnit(this.locationDN);
                        this.createAgent(aMOrganizationalUnit, string, map);
                        bl = true;
                    }
                }
                catch (AMException aMException) {
                    AMModelBase.debug.warning("UMCreateAgentModelImpl.createAgent", (Throwable)aMException);
                    this.errorMessage = this.getErrorString((Exception)((Object)aMException));
                }
                catch (SSOException sSOException) {
                    AMModelBase.debug.warning("UMCreateAgentModelImpl.createAgent", (Throwable)sSOException);
                    this.errorMessage = this.getErrorString((Exception)((Object)sSOException));
                }
            }
        }
        return bl;
    }

    private AMEntity createAgent(AMOrganization aMOrganization, String string, Map map) throws SSOException, AMException {
        AMOrganizationalUnit aMOrganizationalUnit = this.getAgentContainer(aMOrganization);
        return this.createAgent(aMOrganizationalUnit, string, map);
    }

    private AMEntity createAgent(AMOrganizationalUnit aMOrganizationalUnit, String string, Map map) throws SSOException, AMException {
        HashMap<String, Map> hashMap = new HashMap<String, Map>(2);
        hashMap.put(string, map);
        Set set = aMOrganizationalUnit.createEntities("Agent", hashMap);
        AMEntity aMEntity = (AMEntity)set.iterator().next();
        this.entryDN = aMEntity.getDN();
        this.logger.doLog("agentCreated.message", this.entryDN);
        return aMEntity;
    }

    private AMOrganizationalUnit getAgentContainer(AMOrganization aMOrganization) throws SSOException, AMException {
        AMOrganizationalUnit aMOrganizationalUnit;
        block3: {
            aMOrganizationalUnit = null;
            String string = "ou=" + AdminInterfaceUtils.defaultAgentContainerName() + "," + aMOrganization.getDN();
            try {
                aMOrganizationalUnit = this.dpStoreConn.getOrganizationalUnit(string);
            }
            catch (SSOException sSOException) {
                if (!AMModelBase.debug.messageEnabled()) break block3;
                AMModelBase.debug.message("UMCreateAgentModelImpl.getAgentContainer: agent container does not exist");
            }
        }
        if (aMOrganizationalUnit == null || !aMOrganizationalUnit.isExists()) {
            HashSet<String> hashSet = new HashSet<String>(2);
            hashSet.add(AdminInterfaceUtils.defaultAgentContainerName());
            Set set = aMOrganization.createOrganizationalUnits(hashSet);
            aMOrganizationalUnit = (AMOrganizationalUnit)set.iterator().next();
        }
        return aMOrganizationalUnit;
    }

    public DynamicGUI getDynamicGUI(int n) {
        AttributeSchema attributeSchema = (AttributeSchema)this.requiredAttributes.get(n);
        DynamicGUIGenerator dynamicGUIGenerator = DynamicGUIGenerator.getInstance();
        return dynamicGUIGenerator.createDynamicGUI(attributeSchema, "iPlanetAMAgentService", (Set)this.mapAttributeValues.get(attributeSchema.getName()), this, null);
    }

    public String getHelpAnchorTag() {
        String string = this.getLocalizedString("createAgent.help");
        if (string.equals("createAgent.help")) {
            string = "contents.html";
        }
        return this.getHelpURL(string);
    }
}

