/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.am.console.user.model;

import com.iplanet.am.console.base.model.AMAttrSchemaComparator;
import com.iplanet.am.console.base.model.AMModelBase;
import com.iplanet.am.console.base.model.DynamicGUIGenerator;
import com.iplanet.am.console.components.view.html.DynamicGUI;
import com.iplanet.am.console.settings.Setting;
import com.iplanet.am.console.user.model.UMAgentProfileModel;
import com.iplanet.am.console.user.model.UMProfileModelImpl;
import com.iplanet.am.sdk.AMEntity;
import com.iplanet.am.sdk.AMException;
import com.iplanet.sso.SSOException;
import com.sun.identity.sm.AttributeSchema;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.SchemaType;
import com.sun.identity.sm.ServiceSchema;
import com.sun.identity.sm.ServiceSchemaManager;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.servlet.http.HttpServletRequest;

public class UMAgentProfileModelImpl
extends UMProfileModelImpl
implements UMAgentProfileModel {
    private AMEntity agent = null;
    private ServiceSchemaManager agentSvcMgr;

    public UMAgentProfileModelImpl(HttpServletRequest httpServletRequest, Map map) {
        super(httpServletRequest, map);
    }

    public boolean modify(Map map) {
        boolean bl = false;
        AMEntity aMEntity = this.getAMAgent();
        if (aMEntity != null) {
            bl = this.setAttributes(aMEntity, map, "agentChanged.message");
        } else {
            this.errorMessage = this.getLocalizedString("noagent.message");
        }
        return bl;
    }

    public List getDynamicGUIComponents() {
        ArrayList<DynamicGUI> arrayList = Collections.EMPTY_LIST;
        AMEntity aMEntity = this.getAMAgent();
        Set set = this.getAttributeSchemas();
        if (aMEntity != null && !set.isEmpty()) {
            Map map = this.getAgentAttributeValues(aMEntity, set);
            DynamicGUIGenerator dynamicGUIGenerator = DynamicGUIGenerator.getInstance();
            arrayList = new ArrayList<DynamicGUI>(set.size());
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                String string;
                Set set2;
                AttributeSchema attributeSchema = (AttributeSchema)iterator.next();
                DynamicGUI dynamicGUI = dynamicGUIGenerator.createDynamicGUI(attributeSchema, "iPlanetAMAgentService", set2 = (Set)map.get(string = attributeSchema.getName()), this, Setting.ACTION_AGENT);
                if (dynamicGUI == null) continue;
                arrayList.add(dynamicGUI);
            }
        }
        return arrayList;
    }

    private ServiceSchemaManager getAgentSvcSchemaMgr() {
        block3: {
            if (this.agentSvcMgr != null) break block3;
            try {
                this.agentSvcMgr = this.getServiceSchemaManager("iPlanetAMAgentService");
            }
            catch (SSOException sSOException) {
                AMModelBase.debug.error("UMAgentProfileModelImpl.getEntrySpecificSvcSchemaMgr", (Throwable)sSOException);
            }
            catch (SMSException sMSException) {
                AMModelBase.debug.error("UMAgentProfileModelImpl.getEntrySpecificSvcSchemaMgr", (Throwable)sMSException);
            }
        }
        return this.agentSvcMgr;
    }

    private Set getAttributeSchemas() {
        Set set = null;
        ServiceSchemaManager serviceSchemaManager = this.getAgentSvcSchemaMgr();
        if (serviceSchemaManager != null) {
            set = this.getAttributesToDisplay(serviceSchemaManager, SchemaType.USER);
        }
        return set != null ? set : Collections.EMPTY_SET;
    }

    private Map getAgentAttributeValues(AMEntity aMEntity, Set set) {
        HashMap<String, Set> hashMap = new HashMap<String, Set>(set.size() * 2);
        Map map = this.getAttributes(aMEntity);
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            AttributeSchema attributeSchema = (AttributeSchema)iterator.next();
            String string = attributeSchema.getName();
            Set set2 = (Set)map.get(string);
            if (set2 == null) {
                set2 = Collections.EMPTY_SET;
            }
            hashMap.put(string, set2);
        }
        return hashMap;
    }

    public String getSuccessMessage() {
        return this.getLocalizedString("updateAgent.message");
    }

    public String getHelpAnchorTag() {
        String string = this.getLocalizedString("agentProfile.help");
        if (string.equals("agentProfile.help")) {
            string = "contents.html";
        }
        return this.getHelpURL(string);
    }

    public boolean isAgentExists() {
        return this.getAMAgent() != null;
    }

    public String getInvalidAgentMessage() {
        return this.getLocalizedString("invalidAgentProfile.message");
    }

    private AMEntity getAMAgent() {
        block3: {
            if (this.agent != null) break block3;
            try {
                this.agent = this.dpStoreConn.getEntity(this.profileDN);
                if (!this.agent.isExists()) {
                    this.agent = null;
                }
            }
            catch (SSOException sSOException) {
                AMModelBase.debug.error("UMAgentProfileModelImpl.getAMAgent", (Throwable)sSOException);
                this.agent = null;
            }
        }
        return this.agent;
    }

    private Set getAttributesToDisplay(ServiceSchemaManager serviceSchemaManager, SchemaType schemaType) {
        Set set;
        TreeSet<AttributeSchema> treeSet = Collections.EMPTY_SET;
        ServiceSchema serviceSchema = null;
        try {
            serviceSchema = serviceSchemaManager.getSchema(schemaType);
        }
        catch (SMSException sMSException) {
            AMModelBase.debug.warning("error getting schema", (Throwable)sMSException);
        }
        if (serviceSchema != null && (set = serviceSchema.getAttributeSchemaNames()) != null) {
            Collator collator = Collator.getInstance(this.getUserLocale());
            treeSet = new TreeSet<AttributeSchema>(new AMAttrSchemaComparator(collator));
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                AttributeSchema attributeSchema = serviceSchema.getAttributeSchema(string);
                if (!this.isDisplayed(attributeSchema)) continue;
                treeSet.add(attributeSchema);
            }
        }
        return treeSet;
    }

    protected boolean setAttributes(AMEntity aMEntity, Map map, String string) {
        boolean bl;
        block5: {
            bl = true;
            Map map2 = this.getAttributes(aMEntity);
            Map map3 = this.getChangedValues(map2, map);
            if (map3.isEmpty()) break block5;
            try {
                aMEntity.setAttributes(map3);
                aMEntity.store();
                Set set = this.getAttributeSchemas();
                Iterator iterator = map3.keySet().iterator();
                while (iterator.hasNext()) {
                    String string2 = (String)iterator.next();
                    AttributeSchema attributeSchema = this.getAttributeSchema(set, string2);
                    AttributeSchema.Syntax syntax = attributeSchema.getSyntax();
                    StringBuffer stringBuffer = new StringBuffer(100);
                    stringBuffer.append(string2);
                    if (!syntax.equals((Object)AttributeSchema.Syntax.PASSWORD) && !syntax.equals((Object)AttributeSchema.Syntax.ENCRYPTED_PASSWORD)) {
                        Set set2 = (Set)map.get(string2);
                        Set set3 = (Set)map2.get(string2);
                        stringBuffer.append(" " + set3 + "->" + set2);
                    }
                    this.writeFormatLog(string, stringBuffer.toString(), this.profileDN);
                }
            }
            catch (AMException aMException) {
                this.errorMessage = this.getErrorString((Exception)((Object)aMException));
                bl = false;
            }
            catch (SSOException sSOException) {
                this.errorMessage = this.getErrorString((Exception)((Object)sSOException));
                bl = false;
            }
        }
        return bl;
    }

    private AttributeSchema getAttributeSchema(Set set, String string) {
        AttributeSchema attributeSchema = null;
        Iterator iterator = set.iterator();
        while (iterator.hasNext() && attributeSchema == null) {
            AttributeSchema attributeSchema2 = (AttributeSchema)iterator.next();
            if (!attributeSchema2.getName().equals(string)) continue;
            attributeSchema = attributeSchema2;
        }
        return attributeSchema;
    }

    private Map getChangedValues(Map map, Map map2) {
        HashMap<String, Set> hashMap = Collections.EMPTY_MAP;
        if (map2 != null && !map2.isEmpty()) {
            hashMap = new HashMap<String, Set>(map2.size() * 2);
            Iterator iterator = map2.keySet().iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                Set set = (Set)map2.get(string);
                Set set2 = (Set)map.get(string);
                if (set2 == null) {
                    set2 = Collections.EMPTY_SET;
                }
                if (set.equals(set2)) {
                    if (!AMModelBase.debug.messageEnabled()) continue;
                    AMModelBase.debug.message(string + " didn't change, skipping.");
                    continue;
                }
                hashMap.put(string, set);
            }
        }
        return hashMap;
    }

    private Map getAttributes(AMEntity aMEntity) {
        Map map = null;
        try {
            map = aMEntity.getAttributes();
        }
        catch (AMException aMException) {
            AMModelBase.debug.warning("UMAgentProfileModelImpl.getAttributes", (Throwable)aMException);
        }
        catch (SSOException sSOException) {
            AMModelBase.debug.warning("UMAgentProfileModelImpl.getAttributes", (Throwable)sSOException);
        }
        return map != null ? map : Collections.EMPTY_MAP;
    }
}

