/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.am.console.user.model;

import com.iplanet.am.console.base.model.AMConsoleException;
import com.iplanet.am.console.base.model.AMFormatUtils;
import com.iplanet.am.console.base.model.AMModelBase;
import com.iplanet.am.console.user.model.UMAgentNavModel;
import com.iplanet.am.console.user.model.UMNavModelImpl;
import com.iplanet.am.sdk.AMEntity;
import com.iplanet.am.sdk.AMException;
import com.iplanet.am.sdk.AMObject;
import com.iplanet.am.sdk.AMOrganization;
import com.iplanet.am.sdk.AMOrganizationalUnit;
import com.iplanet.am.sdk.AMSearchControl;
import com.iplanet.am.sdk.AMSearchResults;
import com.iplanet.sso.SSOException;
import com.sun.identity.common.admin.AdminInterfaceUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;

public class UMAgentNavModelImpl
extends UMNavModelImpl
implements UMAgentNavModel {
    private Set agents = null;

    public UMAgentNavModelImpl(HttpServletRequest httpServletRequest, Map map) {
        super(httpServletRequest, map);
    }

    public String getSelectedOption() {
        return "agents";
    }

    public Set getAgents(String string) {
        if (this.agents == null) {
            AMSearchResults aMSearchResults = null;
            AMSearchControl aMSearchControl = new AMSearchControl();
            try {
                switch (this.locationType) {
                    case 2: {
                        AMOrganization aMOrganization = this.dpStoreConn.getOrganization(this.locationDN);
                        aMSearchResults = this.getAgents(aMOrganization, string, aMSearchControl);
                        break;
                    }
                    case 3: {
                        AMOrganizationalUnit aMOrganizationalUnit = this.dpStoreConn.getOrganizationalUnit(this.locationDN);
                        aMSearchResults = this.getAgents(aMOrganizationalUnit, string, aMSearchControl);
                        break;
                    }
                    default: {
                        if (AMModelBase.debug.warningEnabled()) {
                            AMModelBase.debug.warning("UMAgentNavModelImpl.getAgents invalid location " + this.locationType);
                        }
                        break;
                    }
                }
            }
            catch (SSOException sSOException) {
                AMModelBase.debug.warning("UMAgentNavModelImpl.getAgents", (Throwable)sSOException);
            }
            catch (AMException aMException) {
                AMModelBase.debug.warning("UMAgentNavModelImpl.getAgents", (Throwable)aMException);
                this.searchErrorMsg = this.getErrorString((Exception)((Object)aMException));
            }
            this.agents = aMSearchResults != null ? this.getSearchResultsSet(aMSearchResults) : Collections.EMPTY_SET;
        }
        return this.agents;
    }

    private AMSearchResults getAgents(AMOrganization aMOrganization, String string, AMSearchControl aMSearchControl) throws SSOException, AMException {
        AMOrganizationalUnit aMOrganizationalUnit;
        block2: {
            aMOrganizationalUnit = null;
            String string2 = "ou=" + AdminInterfaceUtils.defaultAgentContainerName() + "," + aMOrganization.getDN();
            try {
                aMOrganizationalUnit = this.dpStoreConn.getOrganizationalUnit(string2);
            }
            catch (SSOException sSOException) {
                if (!AMModelBase.debug.messageEnabled()) break block2;
                AMModelBase.debug.message("UMAgentNavModelImpl.getAgents: agent container does not exist");
            }
        }
        return aMOrganizationalUnit != null && aMOrganizationalUnit.isExists() ? this.getAgents(aMOrganizationalUnit, string, aMSearchControl) : null;
    }

    private AMSearchResults getAgents(AMOrganizationalUnit aMOrganizationalUnit, String string, AMSearchControl aMSearchControl) throws AMException, SSOException {
        this.setSearchControlLimits((AMObject)aMOrganizationalUnit, aMSearchControl);
        aMSearchControl.setSearchScope(1);
        String[] stringArray = new String[]{"uid"};
        aMSearchControl.setSortKeys(stringArray);
        return aMOrganizationalUnit.searchEntities(string, null, null, aMSearchControl);
    }

    public boolean deleteAgents(Set set) throws AMConsoleException {
        boolean bl = false;
        if (set != null) {
            Map map = this.deleteAgents(set, "agentsDeleted.message");
            if (!map.isEmpty()) {
                this.setErrorMessage(this.getLocalizedString("deleteAgentFailed.message"));
                Iterator iterator = map.keySet().iterator();
                while (iterator.hasNext()) {
                    String string = (String)iterator.next();
                    String string2 = AMFormatUtils.DNToName(this, string, false);
                    String string3 = (String)map.get(string);
                    this.setErrorMessage(string2 + " - " + string3);
                }
            } else {
                bl = true;
            }
        } else {
            this.setErrorMessage(this.getLocalizedString("deleteFailed.message"));
        }
        return bl;
    }

    public String getHeaderLabel() {
        return this.getLocalizedString("agents.header");
    }

    public String getNoEntrySelectedForDelTitle() {
        return this.getLocalizedString("noAgentSelectForDeletion.title");
    }

    public String getNoEntrySelectedForDelMessage() {
        return this.getLocalizedString("noAgentSelectForDeletion.message");
    }

    public Set getAttrList() {
        return this.agents;
    }

    public void setAttrList(Set set) {
        this.agents = set;
    }

    public String getAgentDisplayOffMessage() {
        return this.getLocalizedString("agentsDisplayOff.message");
    }

    protected boolean isCurrentLocationTypeValid() {
        boolean bl = false;
        switch (this.locationType) {
            case 2: 
            case 3: {
                bl = true;
                break;
            }
            default: {
                if (!AMModelBase.debug.warningEnabled()) break;
                AMModelBase.debug.warning("UMAgentNavModelImpl.isCurrentLocationTypeValid: invalid location type, " + this.locationType);
            }
        }
        return bl;
    }

    protected Map deleteAgents(Set set, String string) throws AMConsoleException {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        if (set != null && !set.isEmpty()) {
            int n = set.size();
            this.errorMessage = new ArrayList(n);
            HashSet<String> hashSet = new HashSet<String>(n);
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                AMEntity aMEntity;
                String string2;
                block8: {
                    string2 = (String)iterator.next();
                    aMEntity = null;
                    try {
                        aMEntity = this.dpStoreConn.getEntity(string2);
                        if (aMEntity == null || !aMEntity.isExists()) {
                            if (!AMModelBase.debug.warningEnabled()) continue;
                            AMModelBase.debug.warning("skipping " + string2 + ", no object found for it.");
                        }
                        break block8;
                    }
                    catch (SSOException sSOException) {
                        AMModelBase.debug.warning("UMAgentNavModelImpl.deleteAgents", (Throwable)sSOException);
                    }
                    continue;
                }
                try {
                    aMEntity.delete(true);
                    this.logger.doLog(string, string2);
                    hashSet.add(string2);
                }
                catch (AMException aMException) {
                    AMModelBase.debug.warning("UMAgentNavModelImpl.deleteAgents", (Throwable)aMException);
                    hashMap.put(string2, aMException.getLocalizedMessage());
                }
                catch (SSOException sSOException) {
                    AMModelBase.debug.warning("UMAgentNavModelImpl.deleteAgents", (Throwable)sSOException);
                    hashMap.put(string2, sSOException.getLocalizedMessage());
                }
            }
        }
        return hashMap;
    }
}

