/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.am.console.settings;

import com.iplanet.am.console.settings.ActionResolver;
import com.iplanet.am.console.settings.GlobalSettingsCache;
import com.iplanet.am.console.settings.OrganizationalSettingsCache;
import com.iplanet.am.console.settings.RoleSettings;
import com.iplanet.am.console.settings.ServiceAttributeSettings;
import com.iplanet.am.console.settings.ServiceSettings;
import com.iplanet.am.console.settings.Setting;
import com.iplanet.am.console.settings.SettingsResolver;
import com.iplanet.am.console.settings.UnionRoleIntersectOrgSettingsResolver;
import com.iplanet.am.sdk.AMException;
import com.iplanet.am.sdk.AMUser;
import com.iplanet.am.util.Debug;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenEvent;
import com.iplanet.sso.SSOTokenListener;
import java.util.Collections;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class UserSettings
implements SSOTokenListener {
    private static Debug debug = Debug.getInstance((String)"amConsole");
    private static Map cache = new Hashtable();
    private AMUser amUser;
    private Set roleSettings;
    private Map serviceAttributeSettings;
    private Map serviceSettings;
    private SettingsResolver settingsResolver = new UnionRoleIntersectOrgSettingsResolver();

    private UserSettings(AMUser aMUser) {
        this.amUser = aMUser;
        Set set = this.getRolesAssignedToUser();
        this.getRoleSettings(set);
        this.getServiceAttributeSettings(set);
        this.getServiceSettings(set);
    }

    public Set getSetting(Setting setting) {
        return this.getSetting(setting, false);
    }

    public Set getSetting(Setting setting, boolean bl) {
        Set set = null;
        Map map = null;
        if (bl) {
            GlobalSettingsCache globalSettingsCache = GlobalSettingsCache.getInstance();
            map = globalSettingsCache.getSettings();
        } else {
            OrganizationalSettingsCache organizationalSettingsCache = OrganizationalSettingsCache.getInstance();
            map = organizationalSettingsCache.getSettings(this.amUser);
        }
        map = this.settingsResolver.resolve(map, this.roleSettings);
        if (map != null && !map.isEmpty()) {
            set = (Set)map.get(setting.getName());
        }
        return set;
    }

    public Map getServiceAttributeDisplaySettings() {
        return this.serviceAttributeSettings;
    }

    public Map getServiceDisplaySettings() {
        return this.serviceSettings;
    }

    public boolean canPerform(Setting setting, String string) {
        Set set = this.getSetting(setting);
        boolean bl = true;
        if (set != null && !set.isEmpty()) {
            String string2 = (String)set.iterator().next();
            bl = ActionResolver.allow(string2, string);
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static UserSettings getUserSettings(SSOToken sSOToken, AMUser aMUser) {
        String string = sSOToken.getTokenID().toString();
        UserSettings userSettings = (UserSettings)cache.get(string);
        if (userSettings == null) {
            Map map = cache;
            synchronized (map) {
                userSettings = (UserSettings)cache.get(string);
                if (userSettings == null) {
                    userSettings = new UserSettings(aMUser);
                    try {
                        sSOToken.addSSOTokenListener((SSOTokenListener)userSettings);
                        cache.put(string, userSettings);
                    }
                    catch (SSOException sSOException) {
                        debug.error("UserSettings.getUserSettings", (Throwable)sSOException);
                        userSettings = null;
                    }
                }
            }
        }
        return userSettings;
    }

    public void ssoTokenChanged(SSOTokenEvent sSOTokenEvent) {
        try {
            int n = sSOTokenEvent.getType();
            switch (n) {
                case 1: 
                case 2: 
                case 3: {
                    SSOToken sSOToken = sSOTokenEvent.getToken();
                    cache.remove(sSOToken.getTokenID().toString());
                    if (!debug.messageEnabled()) break;
                    debug.message("UserSettings: removed from cache " + sSOToken.getTokenID());
                }
            }
        }
        catch (SSOException sSOException) {
            debug.warning("UserSettings.ssoTokenChanged", (Throwable)sSOException);
        }
    }

    private void getRoleSettings(Set set) {
        this.roleSettings = Collections.EMPTY_SET;
        if (set != null && !set.isEmpty()) {
            this.roleSettings = new HashSet(set.size() * 2);
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                Map map = RoleSettings.getSettings(string);
                if (map == null) continue;
                this.roleSettings.add(map);
            }
        }
    }

    private void getServiceAttributeSettings(Set set) {
        if (set != null && !set.isEmpty()) {
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                Map map = ServiceAttributeSettings.getSettings(string);
                if (map == null) continue;
                this.serviceAttributeSettings = this.serviceAttributeSettings == null ? map : ServiceAttributeSettings.aggregrateSettings(this.serviceAttributeSettings, map);
            }
        }
    }

    private void getServiceSettings(Set set) {
        if (set != null && !set.isEmpty()) {
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                Map map = ServiceSettings.getSettings(string);
                if (map == null) continue;
                this.serviceSettings = this.serviceSettings == null ? map : ServiceSettings.aggregrateSettings(this.serviceSettings, map);
            }
        }
    }

    private Set getRolesAssignedToUser() {
        Set set = Collections.EMPTY_SET;
        try {
            set = this.amUser.getRoleDNs();
        }
        catch (AMException aMException) {
            debug.error("UserSettings.getRolesAssignedToUser", (Throwable)aMException);
        }
        catch (SSOException sSOException) {
            debug.error("UserSettings.getRolesAssignedToUser", (Throwable)sSOException);
        }
        return set;
    }
}

