/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.am.console.settings;

import com.iplanet.am.util.Debug;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenManager;
import com.sun.identity.authentication.internal.AuthPrincipal;
import com.sun.identity.security.AdminDNAction;
import com.sun.identity.security.AdminPasswordAction;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.ServiceConfigManager;
import com.sun.identity.sm.ServiceListener;
import com.sun.identity.sm.ServiceSchemaManager;
import java.security.AccessController;
import java.security.Principal;

abstract class SettingsCache
implements ServiceListener {
    private static SSOToken adminSSOToken = SettingsCache.getAdminSSOToken();
    static Debug debug = Debug.getInstance((String)"amConsole");

    private SettingsCache() {
    }

    protected SettingsCache(boolean bl) {
        this.initialize(bl);
    }

    private void initialize(boolean bl) {
        block6: {
            try {
                if (adminSSOToken != null) {
                    if (bl) {
                        ServiceSchemaManager serviceSchemaManager = new ServiceSchemaManager("iPlanetAMAdminConsoleService", adminSSOToken);
                        serviceSchemaManager.addListener((ServiceListener)this);
                    } else {
                        ServiceConfigManager serviceConfigManager = new ServiceConfigManager("iPlanetAMAdminConsoleService", adminSSOToken);
                        serviceConfigManager.addListener((ServiceListener)this);
                    }
                    break block6;
                }
                debug.error("SettingsCache.initialize:cannot get application sso token");
            }
            catch (SMSException sMSException) {
                debug.error("SettingsCache.initManager", (Throwable)sMSException);
            }
            catch (SSOException sSOException) {
                debug.error("SettingsCache.initManager", (Throwable)sSOException);
            }
        }
    }

    private static SSOToken getAdminSSOToken() {
        SSOToken sSOToken = null;
        try {
            SSOTokenManager sSOTokenManager = SSOTokenManager.getInstance();
            String string = (String)AccessController.doPrivileged(new AdminDNAction());
            String string2 = (String)AccessController.doPrivileged(new AdminPasswordAction());
            return sSOTokenManager.createSSOToken((Principal)new AuthPrincipal(string), string2);
        }
        catch (Exception exception) {
            debug.error("AMCommonNameGenerator.getSSOToken", (Throwable)exception);
            return sSOToken;
        }
    }

    public void schemaChanged(String string, String string2) {
    }

    public void globalConfigChanged(String string, String string2, String string3, String string4, int n) {
    }

    public void organizationConfigChanged(String string, String string2, String string3, String string4, String string5, int n) {
    }
}

