/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.am.console.settings;

import com.iplanet.am.console.base.model.AMAdminUtils;
import com.iplanet.am.console.base.model.AMConsoleException;
import com.iplanet.am.console.settings.Setting;
import com.iplanet.am.sdk.AMStoreConnection;
import com.iplanet.am.util.Debug;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenManager;
import com.sun.identity.authentication.internal.AuthPrincipal;
import com.sun.identity.security.AdminDNAction;
import com.sun.identity.security.AdminPasswordAction;
import java.security.AccessController;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.util.Map;
import java.util.Set;

abstract class Settings {
    static SSOToken adminSSOToken = Settings.getAdminSSOToken();
    static AMStoreConnection storeConnection = Settings.getAdminStoreConnection();
    static Debug debug = Debug.getInstance((String)"amConsole");
    protected Map settings;

    Settings() {
    }

    Map getSettings() {
        return this.settings;
    }

    void init() {
        Set set = this.getSettingValues();
        if (set != null) {
            this.settings = Setting.parseSettingValues(set);
        }
    }

    protected abstract Set getSettingValues();

    private static AMStoreConnection getAdminStoreConnection() {
        AMStoreConnection aMStoreConnection = (AMStoreConnection)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    return AMAdminUtils.getStoreConnAsAdmin();
                }
                catch (AMConsoleException aMConsoleException) {
                    debug.error("GlobalSettings.init", (Throwable)aMConsoleException);
                    return null;
                }
            }
        });
        return aMStoreConnection;
    }

    private static SSOToken getAdminSSOToken() {
        SSOToken sSOToken = null;
        try {
            SSOTokenManager sSOTokenManager = SSOTokenManager.getInstance();
            String string = (String)AccessController.doPrivileged(new AdminDNAction());
            String string2 = (String)AccessController.doPrivileged(new AdminPasswordAction());
            return sSOTokenManager.createSSOToken((Principal)new AuthPrincipal(string), string2);
        }
        catch (Exception exception) {
            debug.error("OrganizationalSettings.getSSOToken", (Throwable)exception);
            return sSOToken;
        }
    }
}

