/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.am.console.settings;

import com.iplanet.am.console.base.model.AMConsoleException;
import com.iplanet.am.console.base.model.AMModel;
import com.iplanet.am.console.settings.Settings;
import com.iplanet.am.sdk.AMException;
import com.iplanet.am.sdk.AMRole;
import com.iplanet.am.sdk.AMStoreConnection;
import com.iplanet.sso.SSOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;

public class ServiceSettings
extends Settings {
    static final String ROLE_SERVICE_OPTIONS = "iplanet-am-role-service-options";
    static final String SERVICE_OPTIONS_SEPARATOR = "#";
    private String roleDN;
    private AMRole role;
    private AMStoreConnection storeConn;

    ServiceSettings(AMStoreConnection aMStoreConnection) {
        this.storeConn = aMStoreConnection;
    }

    ServiceSettings(String string) {
        this.storeConn = Settings.storeConnection;
        this.roleDN = string;
        this.settings = this.getServiceSettings();
    }

    protected Set getSettingValues() {
        return Collections.EMPTY_SET;
    }

    private Map getServiceSettings() {
        Map map;
        block4: {
            map = null;
            this.createRoleHandler();
            if (this.role == null) break block4;
            try {
                Set set = this.role.getAttribute(ROLE_SERVICE_OPTIONS);
                if (set != null && !set.isEmpty()) {
                    map = this.parseSettingValues(set);
                }
            }
            catch (AMException aMException) {
                Settings.debug.warning("ServiceSettngs.getServiceSettings", (Throwable)aMException);
            }
            catch (SSOException sSOException) {
                Settings.debug.warning("ServiceSettngs.getServiceSettings", (Throwable)sSOException);
            }
        }
        return map;
    }

    public static Map getSettings(String string) {
        ServiceSettings serviceSettings = new ServiceSettings(string);
        return serviceSettings.settings;
    }

    public static void setSettings(AMStoreConnection aMStoreConnection, AMModel aMModel, String string, Map map) throws AMConsoleException {
        ServiceSettings serviceSettings = new ServiceSettings(aMStoreConnection);
        serviceSettings.roleDN = string;
        serviceSettings.setSettings(map);
    }

    private void setSettings(Map map) throws AMConsoleException {
        this.createRoleHandler();
        if (this.role != null) {
            HashMap<String, Set> hashMap = new HashMap<String, Set>(2);
            hashMap.put(ROLE_SERVICE_OPTIONS, this.formatSettingValues(map));
            try {
                this.role.setAttributes(hashMap);
                this.role.store();
            }
            catch (AMException aMException) {
                throw new AMConsoleException(aMException);
            }
            catch (SSOException sSOException) {
                throw new AMConsoleException(sSOException);
            }
        }
    }

    private Set formatSettingValues(Map map) {
        Set set = Collections.EMPTY_SET;
        if (map != null && !map.isEmpty()) {
            Iterator iterator = map.keySet().iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                Set set2 = (Set)map.get(string);
                if (set2 == null || set2.isEmpty()) continue;
                set.add(this.formatSettingValues(string, set2));
            }
        }
        return set;
    }

    private String formatSettingValues(String string, Set set) {
        StringBuffer stringBuffer = new StringBuffer(50);
        stringBuffer.append(string).append(SERVICE_OPTIONS_SEPARATOR).append((String)set.iterator().next());
        return stringBuffer.toString();
    }

    private AMRole createRoleHandler() {
        block2: {
            if (this.role != null) break block2;
            try {
                this.role = this.storeConn.getRole(this.roleDN);
            }
            catch (SSOException sSOException) {
                Settings.debug.error("error getting role for " + this.roleDN, (Throwable)sSOException);
            }
        }
        return this.role;
    }

    private Map parseSettingValues(Set set) {
        HashMap<String, Set> hashMap = new HashMap<String, Set>();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            StringTokenizer stringTokenizer = new StringTokenizer((String)iterator.next(), SERVICE_OPTIONS_SEPARATOR);
            int n = stringTokenizer.countTokens();
            if (n < 1) continue;
            String string = stringTokenizer.nextToken();
            if (n == 1) {
                hashMap.put(string, Collections.EMPTY_SET);
                continue;
            }
            if (n != 2) continue;
            HashSet<String> hashSet = new HashSet<String>(2);
            hashSet.add(stringTokenizer.nextToken());
            hashMap.put(string, hashSet);
        }
        return hashMap;
    }

    public static Set getDefaultValuesFromAttributeSchemas(String string) {
        HashSet<String> hashSet = new HashSet<String>(2);
        hashSet.add("display");
        return hashSet;
    }

    public static Map aggregrateSettings(Map map, Map map2) {
        HashMap hashMap = new HashMap();
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            if (string == null || string.length() <= 0) continue;
            HashSet hashSet = new HashSet();
            Set set = (Set)map.get(string);
            Set set2 = (Set)map2.get(string);
            if (set != null && !set.isEmpty()) {
                if (set2 != null && !set2.isEmpty()) {
                    hashSet.addAll(set);
                    hashSet.addAll(set2);
                } else {
                    hashSet.addAll(set);
                }
            } else if (set2 != null && !set2.isEmpty()) {
                hashSet.addAll(set2);
            }
            hashMap.put(string, hashSet);
        }
        return hashMap;
    }
}

