/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.am.console.settings;

import com.iplanet.am.console.base.model.AMConsoleException;
import com.iplanet.am.console.base.model.AMModel;
import com.iplanet.am.console.settings.Setting;
import com.iplanet.am.console.settings.Settings;
import com.iplanet.am.sdk.AMException;
import com.iplanet.am.sdk.AMRole;
import com.iplanet.am.sdk.AMStoreConnection;
import com.iplanet.sso.SSOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class RoleSettings
extends Settings {
    private static final String ROLE_DISPLAY_OPTION_ATTRIBUTE_NAME = "iplanet-am-role-display-options";
    private String roleDN;
    private AMRole role;
    private AMStoreConnection storeConn;

    RoleSettings(AMStoreConnection aMStoreConnection) {
        this.storeConn = aMStoreConnection;
    }

    RoleSettings(String string) {
        this.storeConn = Settings.storeConnection;
        this.roleDN = string;
        this.init();
    }

    public static Map getSettings(String string) {
        RoleSettings roleSettings = new RoleSettings(string);
        return roleSettings.settings;
    }

    public static void setSettings(AMStoreConnection aMStoreConnection, AMModel aMModel, String string, Map map) throws AMConsoleException {
        RoleSettings roleSettings = new RoleSettings(aMStoreConnection);
        roleSettings.roleDN = string;
        roleSettings.setSettings(aMModel, map);
    }

    protected Set getSettingValues() {
        Set set;
        block3: {
            set = null;
            this.createRoleHandler();
            if (this.role == null) break block3;
            try {
                set = this.role.getAttribute(ROLE_DISPLAY_OPTION_ATTRIBUTE_NAME);
            }
            catch (AMException aMException) {
                Settings.debug.warning("RoleSettings.getSettingValues", (Throwable)aMException);
            }
            catch (SSOException sSOException) {
                Settings.debug.warning("RoleSettings.getSettingValues", (Throwable)sSOException);
            }
        }
        return set;
    }

    private void setSettings(AMModel aMModel, Map map) throws AMConsoleException {
        this.createRoleHandler();
        if (this.role != null) {
            HashMap<String, Set> hashMap = new HashMap<String, Set>(2);
            Map map2 = new HashMap(2);
            Set set = this.getSettingValues();
            if (set != null && !set.isEmpty()) {
                map2 = Setting.parseSettingValues(set);
            }
            map2.putAll(map);
            hashMap.put(ROLE_DISPLAY_OPTION_ATTRIBUTE_NAME, Setting.formatSettingValues(map2));
            try {
                this.role.setAttributes(hashMap);
                this.role.store();
            }
            catch (AMException aMException) {
                throw new AMConsoleException(aMException);
            }
            catch (SSOException sSOException) {
                throw new AMConsoleException(sSOException);
            }
        }
    }

    private AMRole createRoleHandler() {
        block2: {
            if (this.role != null) break block2;
            try {
                this.role = this.storeConn.getRole(this.roleDN);
            }
            catch (SSOException sSOException) {
                Settings.debug.error("error getting role for " + this.roleDN, (Throwable)sSOException);
            }
        }
        return this.role;
    }
}

