/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.am.console.settings;

import com.iplanet.am.console.base.model.AMConsoleException;
import com.iplanet.am.console.base.model.AMModel;
import com.iplanet.am.console.settings.Setting;
import com.iplanet.am.console.settings.Settings;
import com.iplanet.am.sdk.AMException;
import com.iplanet.am.sdk.AMOrganization;
import com.iplanet.am.sdk.AMOrganizationalUnit;
import com.iplanet.am.sdk.AMStoreConnection;
import com.iplanet.am.sdk.AMTemplate;
import com.iplanet.sso.SSOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class OrganizationalSettings
extends Settings {
    private String orgDN;
    private AMStoreConnection storeConn;

    OrganizationalSettings(AMStoreConnection aMStoreConnection) {
        this.storeConn = aMStoreConnection;
    }

    OrganizationalSettings(String string) {
        this.storeConn = Settings.storeConnection;
        this.orgDN = string;
        this.init();
    }

    public static void setSettings(AMStoreConnection aMStoreConnection, AMModel aMModel, String string, Map map) throws AMConsoleException {
        OrganizationalSettings organizationalSettings = new OrganizationalSettings(aMStoreConnection);
        organizationalSettings.orgDN = string;
        organizationalSettings.setSettings(aMModel, map);
    }

    protected Set getSettingValues() {
        Set set = null;
        AMTemplate aMTemplate = this.getOrganizationTemplate(Settings.storeConnection);
        if (aMTemplate != null) {
            set = this.getSettingsFromTemplate(aMTemplate);
        }
        return set;
    }

    private void setSettings(AMModel aMModel, Map map) throws AMConsoleException {
        AMTemplate aMTemplate = this.getOrganizationTemplate(this.storeConn);
        if (aMTemplate != null) {
            HashMap<String, Set> hashMap = new HashMap<String, Set>(2);
            Map map2 = new HashMap(2);
            Set set = this.getSettingValues();
            if (set != null && !set.isEmpty()) {
                map2 = Setting.parseSettingValues(set);
            }
            map2.putAll(map);
            hashMap.put("iplanet-am-admin-console-display-options", Setting.formatSettingValues(map2));
            try {
                aMTemplate.setAttributes(hashMap);
                aMTemplate.store();
            }
            catch (AMException aMException) {
                throw new AMConsoleException(aMException);
            }
            catch (SSOException sSOException) {
                throw new AMConsoleException(sSOException);
            }
        } else {
            throw new AMConsoleException(aMModel.getLocalizedString("cannotStoreDisplayOptions.message"));
        }
    }

    private AMTemplate getOrganizationTemplate(AMStoreConnection aMStoreConnection) {
        AMTemplate aMTemplate = null;
        try {
            int n = aMStoreConnection.getAMObjectType(this.orgDN);
            switch (n) {
                case 2: {
                    AMOrganization aMOrganization = aMStoreConnection.getOrganization(this.orgDN);
                    if (aMOrganization.orgTemplateExists("iPlanetAMAdminConsoleService")) {
                        aMTemplate = aMOrganization.getTemplate("iPlanetAMAdminConsoleService", 302);
                    }
                    break;
                }
                case 3: {
                    AMOrganizationalUnit aMOrganizationalUnit = aMStoreConnection.getOrganizationalUnit(this.orgDN);
                    if (aMOrganizationalUnit.orgTemplateExists("iPlanetAMAdminConsoleService")) {
                        aMTemplate = aMOrganizationalUnit.getTemplate("iPlanetAMAdminConsoleService", 302);
                    }
                    break;
                }
                default: {
                    Settings.debug.error("OrganizationalSettings.getOrganizationTemplate: user does not reside in an organization or container");
                    break;
                }
            }
        }
        catch (AMException aMException) {
            Settings.debug.error("OrganizationalSettings.getOrganizationTemplate", (Throwable)aMException);
        }
        catch (SSOException sSOException) {
            Settings.debug.error("OrganizationalSettings.getOrganizationTemplate", (Throwable)sSOException);
        }
        return aMTemplate;
    }

    private Set getSettingsFromTemplate(AMTemplate aMTemplate) {
        Set set = null;
        try {
            set = aMTemplate.getAttribute("iplanet-am-admin-console-display-options");
        }
        catch (AMException aMException) {
            Settings.debug.warning("OrganizationalSettings.getSettingsFromTemplate", (Throwable)aMException);
        }
        catch (SSOException sSOException) {
            Settings.debug.warning("OrganizationalSettings.getSettingsFromTemplate", (Throwable)sSOException);
        }
        return set;
    }
}

