/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.am.console.session.model;

import com.iplanet.am.console.base.model.AMAdminUtils;
import com.iplanet.am.console.base.model.AMConsoleException;
import com.iplanet.am.console.base.model.AMFormatUtils;
import com.iplanet.am.console.base.model.AMModelBase;
import com.iplanet.am.console.base.model.AMProfileModelBase;
import com.iplanet.am.console.base.model.AMSystemConfig;
import com.iplanet.am.console.session.model.SMProfileModel;
import com.iplanet.am.console.session.model.SMSessionData;
import com.iplanet.am.sdk.AMSearchResults;
import com.iplanet.dpro.session.Session;
import com.iplanet.dpro.session.SessionException;
import com.iplanet.dpro.session.SessionID;
import com.sun.identity.common.DisplayUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;

public class SMProfileModelImpl
extends AMProfileModelBase
implements SMProfileModel {
    private static final String USER_ID = "UserId";
    private String serverName = null;
    private List sessionsList = null;
    private boolean validSession = true;
    private String errorMessage = null;

    public SMProfileModelImpl(HttpServletRequest httpServletRequest, Map map) {
        super(httpServletRequest, "amAdminModuleMsgs", map);
    }

    public String getSelectLabel() {
        return this.getLocalizedString("select.label");
    }

    public String getUserIdLabel() {
        return this.getLocalizedString("userId.label");
    }

    public String getTimeLeftLabel() {
        return this.getLocalizedString("timeLeft.label");
    }

    public String getMaxSessionTimeLabel() {
        return this.getLocalizedString("maxSessionTime.label");
    }

    public String getIdleTimeLabel() {
        return this.getLocalizedString("idleTime.label");
    }

    public String getMaxIdleTimeLabel() {
        return this.getLocalizedString("maxIdleTime.label");
    }

    public String getInvalidateBtnLabel() {
        return this.getLocalizedString("invalidate.button");
    }

    public String getNumValidSessionsLabel() {
        return this.getLocalizedString("numValidSessions.label");
    }

    public String getTopOfListLabel() {
        return this.getLocalizedString("topList.label");
    }

    public String getBottomOfListLabel() {
        return this.getLocalizedString("bottomList.label");
    }

    public String getFilterBtnLabel() {
        return this.getLocalizedString("filter.button");
    }

    public String getTableCaptionLabel() {
        return this.getLocalizedString("userTableCaption.header");
    }

    public String getTerminateErrorMessage() {
        return this.getLocalizedString("deleteFailed.message");
    }

    public String getAlertTitle() {
        return this.getLocalizedString("alertMessage.title");
    }

    public boolean hasSessions() {
        return this.sessionsList != null && !this.sessionsList.isEmpty();
    }

    public void setProfileServerName(String string) {
        this.serverName = string;
    }

    public List getAttrList() {
        return this.sessionsList;
    }

    public void setAttrList(List list) {
        this.sessionsList = list;
    }

    public int getValidSessionCnt() {
        return this.sessionsList == null ? 0 : this.sessionsList.size();
    }

    public void populateSessionList(String string) {
        if (this.sessionsList == null) {
            this.sessionsList = this.getSessionsList(string);
        }
    }

    public boolean searchSessionList(String string) {
        this.sessionsList = this.getSessionsList(string);
        return this.sessionsList != null && !this.sessionsList.isEmpty();
    }

    public List getSessionDisplayList(String string, int n, int n2) {
        int n3;
        int n4;
        if (this.sessionsList == null) {
            this.sessionsList = this.getSessionsList(string);
        }
        if ((n4 = n2 + n) > (n3 = this.sessionsList.size())) {
            n4 = n3;
        }
        ArrayList arrayList = new ArrayList(n4);
        int n5 = n2;
        while (n5 < n4) {
            arrayList.add(this.sessionsList.get(n5));
            ++n5;
        }
        return arrayList;
    }

    public List getSessionsList(String string) {
        ArrayList arrayList = Collections.EMPTY_LIST;
        string = string.toLowerCase();
        try {
            String string2;
            Object object;
            Session session = Session.getSession((SessionID)new SessionID(this.ssoToken.getTokenID().toString()));
            AMSearchResults aMSearchResults = session.getValidSessions(this.serverName, string);
            Hashtable hashtable = (Hashtable)aMSearchResults.getResultAttributes();
            HashMap<String, SMSessionData> hashMap = new HashMap<String, SMSessionData>(hashtable.size());
            Iterator iterator = hashtable.values().iterator();
            while (iterator.hasNext()) {
                object = (Session)iterator.next();
                String string3 = object.getProperty(USER_ID);
                if (string3 == null || !DisplayUtils.wildcardMatch((String)(string3 = AMFormatUtils.DNToName(this, string3, false)), (String)string)) continue;
                SMSessionData sMSessionData = new SMSessionData();
                string2 = object.getID().toString();
                sMSessionData.setUserId(string3);
                sMSessionData.setId(string2);
                sMSessionData.setTimeRemain(String.valueOf(object.getTimeLeft() / 60L));
                sMSessionData.setMaxSessionTime(String.valueOf(object.getMaxSessionTime()));
                sMSessionData.setIdleTime(String.valueOf(object.getIdleTime() / 60L));
                sMSessionData.setMaxIdleTime(String.valueOf(object.getMaxIdleTime()));
                String string4 = string3 + string2;
                hashMap.put(string4, sMSessionData);
            }
            if (hashMap != null && !hashMap.isEmpty() && (object = AMFormatUtils.sortKeyInMap(hashMap, this.getUserLocale())) != null && !object.isEmpty()) {
                int n = object.size();
                arrayList = new ArrayList(n);
                int n2 = 0;
                while (n2 < n) {
                    string2 = (String)object.get(n2);
                    arrayList.add(hashMap.get(string2));
                    ++n2;
                }
            }
            this.errorMessage = AMAdminUtils.getSearchResultWarningMessage(aMSearchResults, this);
        }
        catch (SessionException sessionException) {
            AMModelBase.debug.error("SMProfileModelImple.getSessionsList", (Throwable)sessionException);
        }
        return arrayList;
    }

    private Session getCurrentSession() throws AMConsoleException {
        Session session = null;
        try {
            session = Session.getSession((SessionID)new SessionID(this.ssoToken.getTokenID().toString()));
        }
        catch (SessionException sessionException) {
            throw new AMConsoleException(this.getErrorString((Exception)((Object)sessionException)));
        }
        return session;
    }

    private Map getValidSessions(Session session, String string) throws AMConsoleException {
        HashMap<String, Session> hashMap = Collections.EMPTY_MAP;
        try {
            AMSearchResults aMSearchResults = session.getValidSessions(this.serverName, string);
            Hashtable hashtable = (Hashtable)aMSearchResults.getResultAttributes();
            if (hashtable != null && !hashtable.isEmpty()) {
                hashMap = new HashMap<String, Session>(hashtable.size());
                Iterator iterator = hashtable.values().iterator();
                while (iterator.hasNext()) {
                    Session session2 = (Session)iterator.next();
                    if (session2 == null) continue;
                    hashMap.put(session2.getID().toString(), session2);
                }
            }
        }
        catch (SessionException sessionException) {
            throw new AMConsoleException(this.getErrorString((Exception)((Object)sessionException)));
        }
        return hashMap;
    }

    public List invalidateSessions(List list, String string) throws AMConsoleException {
        ArrayList<String> arrayList = Collections.EMPTY_LIST;
        if (this.sessionsList != null && !this.sessionsList.isEmpty() && list != null && !list.isEmpty()) {
            Session session = this.getCurrentSession();
            Map map = this.getValidSessions(session, string);
            list.retainAll(map.keySet());
            if (!list.isEmpty()) {
                String string2 = null;
                try {
                    string2 = session.getProperty("SessionHandle");
                }
                catch (SessionException sessionException) {
                    throw new AMConsoleException(sessionException);
                }
                arrayList = new ArrayList<String>(list.size());
                Iterator iterator = this.sessionsList.iterator();
                while (iterator.hasNext()) {
                    SMSessionData sMSessionData = (SMSessionData)iterator.next();
                    String string3 = sMSessionData.getId();
                    String string4 = sMSessionData.getUserId();
                    if (string3 == null || !list.contains(string3)) continue;
                    Session session2 = (Session)map.get(string3);
                    boolean bl = false;
                    try {
                        bl = string2.equals(session2.getProperty("SessionHandle"));
                    }
                    catch (SessionException sessionException) {
                        throw new AMConsoleException(sessionException);
                    }
                    if (bl) {
                        this.validSession = false;
                        continue;
                    }
                    if (!this.destroySession(session, session2)) {
                        arrayList.add(string4);
                        continue;
                    }
                    iterator.remove();
                }
            }
            if (!this.validSession) {
                this.destroySession(session, session);
            }
        }
        return arrayList;
    }

    private boolean destroySession(Session session, Session session2) {
        boolean bl;
        block3: {
            bl = false;
            boolean bl2 = this.isSessionsEquals(session, session2);
            try {
                String string = session2.getProperty(USER_ID);
                session.destroySession(session2);
                if (!bl2) {
                    this.logger.doLog("destroyedSession.message", string);
                }
                bl = true;
            }
            catch (SessionException sessionException) {
                if (!AMModelBase.debug.warningEnabled()) break block3;
                AMModelBase.debug.warning("SMProfileModelImpl.destroySession", (Throwable)sessionException);
            }
        }
        return bl;
    }

    public String getLogoutURL() {
        return AMSystemConfig.serverURL + AMSystemConfig.serverDeploymentURI + "/UI/Logout";
    }

    public boolean isSessionValid() {
        return this.validSession;
    }

    public String getNoEntriesMsg() {
        return this.getLocalizedString("noSessionEntries.message");
    }

    public String getNoSessionSelectedForInvalidationTitle() {
        return this.getLocalizedString("noSesssionSelectedForInvalidation.title");
    }

    public String getNoSessionSelectedForInvalidationMessage() {
        return this.getLocalizedString("noSesssionSelectedForInvalidation.message");
    }

    public String getRowsLabel() {
        return this.getLocalizedString("rows.label");
    }

    public String getRowLabel() {
        return this.getLocalizedString("row.label");
    }

    public String getHelpAnchorTag() {
        String string = this.getLocalizedString("sessionData.help");
        if (string.equals("userProfile.help")) {
            string = "contents.html";
        }
        return this.getHelpURL(string);
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    private boolean isSessionsEquals(Session session, Session session2) {
        boolean bl = false;
        try {
            String string = session.getProperty("SessionHandle");
            bl = string.equals(session2.getProperty("SessionHandle"));
        }
        catch (SessionException sessionException) {
            AMModelBase.debug.error("Could not determined if the sessions are same ", (Throwable)sessionException);
        }
        return bl;
    }
}

