/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.am.console.session;

import com.iplanet.am.console.base.model.AMConsoleException;
import com.iplanet.am.console.components.view.html.IPlanetButton;
import com.iplanet.am.console.components.view.html.ListedMessageBox;
import com.iplanet.am.console.components.view.html.Pagination;
import com.iplanet.am.console.components.view.html.SerializedField;
import com.iplanet.am.console.session.SMProfileSessionsTiledView;
import com.iplanet.am.console.session.SMProfileViewBeanBase;
import com.iplanet.am.console.session.model.SMProfileModel;
import com.iplanet.am.console.session.model.SMProfileModelImpl;
import com.iplanet.jato.NavigationException;
import com.iplanet.jato.RequestContext;
import com.iplanet.jato.model.ModelControlException;
import com.iplanet.jato.view.ContainerView;
import com.iplanet.jato.view.View;
import com.iplanet.jato.view.event.ChildDisplayEvent;
import com.iplanet.jato.view.event.DisplayEvent;
import com.iplanet.jato.view.event.RequestInvocationEvent;
import com.iplanet.jato.view.html.HiddenField;
import com.iplanet.jato.view.html.StaticTextField;
import com.iplanet.jato.view.html.TextField;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;

public class SMProfileViewBean
extends SMProfileViewBeanBase {
    public static final String PAGE_NAME = "SMProfile";
    public static final String DEFAULT_DISPLAY_URL = "/console/session/SMProfile.jsp";
    public static final String CC_LIST_MSG_BOX = "ccListMsgBox";
    public static final String USER_SESSION_TILEDVIEW = "userSessionTiledView";
    public static final String LBL_USER_ID = "lblUserId";
    public static final String LBL_SELECT = "lblSelect";
    public static final String TIME_REMAIN = "lblTimeRemain";
    public static final String MAX_SESSION_TIME = "lblMaxSessionTime";
    public static final String IDLE_TIME = "lblIdleTime";
    public static final String MAX_IDLE_TIME = "lblMaxIdleTime";
    public static final String LBL_NUM_VALID_SESSIONS = "lblNumValidSessions";
    public static final String NUM_OF_VALID_SESSIONS = "numOfValidSessions";
    public static final String BTN_INVALIDATE = "btnInvalidate";
    public static final String TF_FILTER = "tfFilter";
    public static final String BTN_FILTER = "btnFilter";
    public static final String TABLE_CAPTION = "lblTableCaption";
    public static final String FLD_SERIALIZED = "fldSerialized";
    public static final String CC_PAGINATION = "ccPagination";
    public static final String CC_PAGINATION_PAGE = "ccPagination_page";
    public static final String LOGOUT_URL = "logoutLink";
    public static final String MSG_ENTRIES = "msgEntries";
    protected int curPage = 1;
    private SMProfileModel model = null;
    private boolean validSession = true;
    static /* synthetic */ Class class$com$iplanet$am$console$components$view$html$IPlanetButton;
    static /* synthetic */ Class class$com$iplanet$am$console$components$view$html$ListedMessageBox;
    static /* synthetic */ Class class$com$iplanet$jato$view$html$StaticTextField;
    static /* synthetic */ Class class$com$iplanet$am$console$session$SMProfileSessionsTiledView;
    static /* synthetic */ Class class$com$iplanet$jato$view$html$TextField;
    static /* synthetic */ Class class$com$iplanet$am$console$components$view$html$SerializedField;
    static /* synthetic */ Class class$com$iplanet$am$console$components$view$html$Pagination;

    public SMProfileViewBean() {
        super(PAGE_NAME, DEFAULT_DISPLAY_URL);
        this.registerChildren();
    }

    public void forwardTo(RequestContext requestContext) throws NavigationException {
        HttpServletRequest httpServletRequest = requestContext.getRequest();
        String string = httpServletRequest.getParameter("SessionServer");
        if (string != null && string.length() > 0) {
            this.serverName = string;
        }
        super.forwardTo(requestContext);
    }

    public void beginDisplay(DisplayEvent displayEvent) throws ModelControlException {
        if (!this.validSession) {
            return;
        }
        this.model = this.getModel();
        if (this.model == null) {
            return;
        }
        this.setChildValues(this.model);
        super.beginDisplay(displayEvent);
        String string = this.getFilterString();
        this.model.setProfileServerName(this.serverName);
        this.model.populateSessionList(string);
        String string2 = this.model.getErrorMessage();
        if (string2 != null && string2.length() > 0) {
            this.showMessageBox(1, this.model.getWarningTitle(), string2);
        }
        SMProfileSessionsTiledView sMProfileSessionsTiledView = (SMProfileSessionsTiledView)this.getChild(USER_SESSION_TILEDVIEW);
        sMProfileSessionsTiledView.setSessionData(string, this.model.getGlobalPageSize(), this.getBeginIndex(true));
        this.setAttrValues(this.model.getAttrList());
        this.setDisplayFieldValue("ProfileName", this.serverName);
        this.setDisplayFieldValue(LBL_SELECT, this.model.getSelectLabel());
        this.setDisplayFieldValue(LBL_USER_ID, this.model.getUserIdLabel());
        this.setDisplayFieldValue(TIME_REMAIN, this.model.getTimeLeftLabel());
        this.setDisplayFieldValue(MAX_SESSION_TIME, this.model.getMaxSessionTimeLabel());
        this.setDisplayFieldValue(IDLE_TIME, this.model.getIdleTimeLabel());
        this.setDisplayFieldValue(MAX_IDLE_TIME, this.model.getMaxIdleTimeLabel());
        this.setDisplayFieldValue(LBL_NUM_VALID_SESSIONS, this.model.getNumValidSessionsLabel());
        this.setDisplayFieldValue(NUM_OF_VALID_SESSIONS, this.getSessionCnt());
        this.setDisplayFieldValue(BTN_INVALIDATE, this.model.getInvalidateBtnLabel());
        this.setDisplayFieldValue(BTN_FILTER, this.model.getFilterBtnLabel());
        if (!this.model.hasSessions()) {
            IPlanetButton iPlanetButton = (IPlanetButton)this.getChild(BTN_INVALIDATE);
            iPlanetButton.setEnable(false);
        }
        this.setDisplayFieldValue("selectAllImage", this.model.getSelectAllMessage());
        this.setDisplayFieldValue("deSelectAllImage", this.model.getDeSelectAllMessage());
        this.displayTableHeader();
    }

    public boolean beginToLogoutDisplay(ChildDisplayEvent childDisplayEvent) {
        boolean bl = false;
        if (!this.validSession) {
            this.model = this.getModel();
            this.setDisplayFieldValue(LOGOUT_URL, this.model.getLogoutURL());
            bl = true;
        }
        return bl;
    }

    public boolean beginMsgEntriesDisplay(ChildDisplayEvent childDisplayEvent) {
        if (!this.validSession) {
            return false;
        }
        boolean bl = true;
        this.model = this.getModel();
        if (this.model.hasSessions()) {
            bl = false;
        } else {
            this.setDisplayFieldValue(MSG_ENTRIES, this.model.getNoEntriesMsg());
        }
        return bl;
    }

    public void displayTableHeader() {
        Object[] objectArray;
        if (!this.validSession) {
            return;
        }
        String string = null;
        this.model = this.getModel();
        int n = this.getSessionCnt();
        if (n > this.model.getGlobalPageSize()) {
            objectArray = new String[]{String.valueOf(this.getBeginIndex(false)), String.valueOf(this.getEndIndex()), String.valueOf(n)};
            string = MessageFormat.format(this.model.getPagingLabel(), objectArray);
        } else if (n == 1) {
            objectArray = new String[]{String.valueOf(n)};
            string = MessageFormat.format(this.model.getRowLabel(), objectArray);
        } else {
            objectArray = new String[]{String.valueOf(n)};
            string = MessageFormat.format(this.model.getRowsLabel(), objectArray);
        }
        objectArray = new String[]{string};
        String string2 = MessageFormat.format(this.model.getTableCaptionLabel(), objectArray);
        this.setDisplayFieldValue(TABLE_CAPTION, string2);
    }

    public boolean beginPaginationDisplay(ChildDisplayEvent childDisplayEvent) {
        if (!this.validSession) {
            return false;
        }
        this.model = this.getModel();
        int n = this.getSessionCnt();
        if (n > this.model.getGlobalPageSize()) {
            this.setPagination();
            return true;
        }
        return false;
    }

    private void setPagination() {
        int n = this.getPageCnt();
        if (n > 1) {
            Pagination pagination = (Pagination)this.getChild(CC_PAGINATION);
            pagination.setFirstPageIconTooltip(this.model.getFirstPageLabel());
            pagination.setLastPageIconTooltip(this.model.getLastPageLabel());
            pagination.setPreviousPageIconTooltip(this.model.getPreviousPageLabel());
            pagination.setNextPageIconTooltip(this.model.getNextPageLabel());
            pagination.setLabelForPage(this.model.getPageLabel());
            pagination.setLabelForOf(this.model.getOfLabel());
            pagination.setLabelForGotoBtn(this.model.getGoBtnLabel());
            pagination.setTotalPages(n);
            pagination.setCurrentPage(this.curPage);
        }
    }

    protected void registerChildren() {
        super.registerChildren();
        this.registerChild(BTN_INVALIDATE, class$com$iplanet$am$console$components$view$html$IPlanetButton == null ? (class$com$iplanet$am$console$components$view$html$IPlanetButton = SMProfileViewBean.class$("com.iplanet.am.console.components.view.html.IPlanetButton")) : class$com$iplanet$am$console$components$view$html$IPlanetButton);
        this.registerChild(CC_LIST_MSG_BOX, class$com$iplanet$am$console$components$view$html$ListedMessageBox == null ? (class$com$iplanet$am$console$components$view$html$ListedMessageBox = SMProfileViewBean.class$("com.iplanet.am.console.components.view.html.ListedMessageBox")) : class$com$iplanet$am$console$components$view$html$ListedMessageBox);
        this.registerChild(LBL_NUM_VALID_SESSIONS, class$com$iplanet$jato$view$html$StaticTextField == null ? (class$com$iplanet$jato$view$html$StaticTextField = SMProfileViewBean.class$("com.iplanet.jato.view.html.StaticTextField")) : class$com$iplanet$jato$view$html$StaticTextField);
        this.registerChild(NUM_OF_VALID_SESSIONS, class$com$iplanet$jato$view$html$StaticTextField == null ? (class$com$iplanet$jato$view$html$StaticTextField = SMProfileViewBean.class$("com.iplanet.jato.view.html.StaticTextField")) : class$com$iplanet$jato$view$html$StaticTextField);
        this.registerChild(LBL_USER_ID, class$com$iplanet$jato$view$html$StaticTextField == null ? (class$com$iplanet$jato$view$html$StaticTextField = SMProfileViewBean.class$("com.iplanet.jato.view.html.StaticTextField")) : class$com$iplanet$jato$view$html$StaticTextField);
        this.registerChild(TIME_REMAIN, class$com$iplanet$jato$view$html$StaticTextField == null ? (class$com$iplanet$jato$view$html$StaticTextField = SMProfileViewBean.class$("com.iplanet.jato.view.html.StaticTextField")) : class$com$iplanet$jato$view$html$StaticTextField);
        this.registerChild(MAX_SESSION_TIME, class$com$iplanet$jato$view$html$StaticTextField == null ? (class$com$iplanet$jato$view$html$StaticTextField = SMProfileViewBean.class$("com.iplanet.jato.view.html.StaticTextField")) : class$com$iplanet$jato$view$html$StaticTextField);
        this.registerChild(LBL_SELECT, class$com$iplanet$jato$view$html$StaticTextField == null ? (class$com$iplanet$jato$view$html$StaticTextField = SMProfileViewBean.class$("com.iplanet.jato.view.html.StaticTextField")) : class$com$iplanet$jato$view$html$StaticTextField);
        this.registerChild(IDLE_TIME, class$com$iplanet$jato$view$html$StaticTextField == null ? (class$com$iplanet$jato$view$html$StaticTextField = SMProfileViewBean.class$("com.iplanet.jato.view.html.StaticTextField")) : class$com$iplanet$jato$view$html$StaticTextField);
        this.registerChild(MAX_IDLE_TIME, class$com$iplanet$jato$view$html$StaticTextField == null ? (class$com$iplanet$jato$view$html$StaticTextField = SMProfileViewBean.class$("com.iplanet.jato.view.html.StaticTextField")) : class$com$iplanet$jato$view$html$StaticTextField);
        this.registerChild(USER_SESSION_TILEDVIEW, class$com$iplanet$am$console$session$SMProfileSessionsTiledView == null ? (class$com$iplanet$am$console$session$SMProfileSessionsTiledView = SMProfileViewBean.class$("com.iplanet.am.console.session.SMProfileSessionsTiledView")) : class$com$iplanet$am$console$session$SMProfileSessionsTiledView);
        this.registerChild(TF_FILTER, class$com$iplanet$jato$view$html$TextField == null ? (class$com$iplanet$jato$view$html$TextField = SMProfileViewBean.class$("com.iplanet.jato.view.html.TextField")) : class$com$iplanet$jato$view$html$TextField);
        this.registerChild(BTN_FILTER, class$com$iplanet$am$console$components$view$html$IPlanetButton == null ? (class$com$iplanet$am$console$components$view$html$IPlanetButton = SMProfileViewBean.class$("com.iplanet.am.console.components.view.html.IPlanetButton")) : class$com$iplanet$am$console$components$view$html$IPlanetButton);
        this.registerChild(TABLE_CAPTION, class$com$iplanet$jato$view$html$StaticTextField == null ? (class$com$iplanet$jato$view$html$StaticTextField = SMProfileViewBean.class$("com.iplanet.jato.view.html.StaticTextField")) : class$com$iplanet$jato$view$html$StaticTextField);
        this.registerChild(FLD_SERIALIZED, class$com$iplanet$am$console$components$view$html$SerializedField == null ? (class$com$iplanet$am$console$components$view$html$SerializedField = SMProfileViewBean.class$("com.iplanet.am.console.components.view.html.SerializedField")) : class$com$iplanet$am$console$components$view$html$SerializedField);
        this.registerChild(LOGOUT_URL, class$com$iplanet$jato$view$html$StaticTextField == null ? (class$com$iplanet$jato$view$html$StaticTextField = SMProfileViewBean.class$("com.iplanet.jato.view.html.StaticTextField")) : class$com$iplanet$jato$view$html$StaticTextField);
        this.registerChild(CC_PAGINATION, class$com$iplanet$am$console$components$view$html$Pagination == null ? (class$com$iplanet$am$console$components$view$html$Pagination = SMProfileViewBean.class$("com.iplanet.am.console.components.view.html.Pagination")) : class$com$iplanet$am$console$components$view$html$Pagination);
        this.registerChild(CC_PAGINATION_PAGE, class$com$iplanet$jato$view$html$TextField == null ? (class$com$iplanet$jato$view$html$TextField = SMProfileViewBean.class$("com.iplanet.jato.view.html.TextField")) : class$com$iplanet$jato$view$html$TextField);
        this.registerChild(MSG_ENTRIES, class$com$iplanet$jato$view$html$StaticTextField == null ? (class$com$iplanet$jato$view$html$StaticTextField = SMProfileViewBean.class$("com.iplanet.jato.view.html.StaticTextField")) : class$com$iplanet$jato$view$html$StaticTextField);
    }

    protected View createChild(String string) {
        if (string.equals(BTN_INVALIDATE)) {
            return new IPlanetButton((ContainerView)this, BTN_INVALIDATE, "");
        }
        if (string.equals(CC_LIST_MSG_BOX)) {
            return new ListedMessageBox((ContainerView)this, CC_LIST_MSG_BOX, "");
        }
        if (string.equals(LBL_NUM_VALID_SESSIONS)) {
            return new StaticTextField((ContainerView)this, LBL_NUM_VALID_SESSIONS, (Object)"");
        }
        if (string.equals(NUM_OF_VALID_SESSIONS)) {
            return new StaticTextField((ContainerView)this, NUM_OF_VALID_SESSIONS, (Object)"");
        }
        if (string.equals(LBL_USER_ID)) {
            return new StaticTextField((ContainerView)this, LBL_USER_ID, (Object)"");
        }
        if (string.equals(TIME_REMAIN)) {
            return new StaticTextField((ContainerView)this, TIME_REMAIN, (Object)"");
        }
        if (string.equals(MAX_SESSION_TIME)) {
            return new StaticTextField((ContainerView)this, MAX_SESSION_TIME, (Object)"");
        }
        if (string.equals(LBL_SELECT)) {
            return new StaticTextField((ContainerView)this, LBL_SELECT, (Object)"");
        }
        if (string.equals(IDLE_TIME)) {
            return new StaticTextField((ContainerView)this, IDLE_TIME, (Object)"");
        }
        if (string.equals(MAX_IDLE_TIME)) {
            return new StaticTextField((ContainerView)this, MAX_IDLE_TIME, (Object)"");
        }
        if (string.equals(USER_SESSION_TILEDVIEW)) {
            return new SMProfileSessionsTiledView((View)this, USER_SESSION_TILEDVIEW);
        }
        if (string.equals(TF_FILTER)) {
            return new TextField((ContainerView)this, TF_FILTER, (Object)"*");
        }
        if (string.equals(BTN_FILTER)) {
            return new IPlanetButton((ContainerView)this, BTN_FILTER, "");
        }
        if (string.equals(TABLE_CAPTION)) {
            return new StaticTextField((ContainerView)this, TABLE_CAPTION, (Object)"");
        }
        if (string.equals(FLD_SERIALIZED)) {
            return new SerializedField((ContainerView)this, FLD_SERIALIZED, null);
        }
        if (string.equals(LOGOUT_URL)) {
            return new StaticTextField((ContainerView)this, LOGOUT_URL, (Object)"");
        }
        if (string.equals(CC_PAGINATION)) {
            return new Pagination((ContainerView)this, CC_PAGINATION, null);
        }
        if (string.equals(CC_PAGINATION_PAGE)) {
            return new TextField((ContainerView)this, CC_PAGINATION_PAGE, null);
        }
        if (string.equals(MSG_ENTRIES)) {
            return new StaticTextField((ContainerView)this, MSG_ENTRIES, (Object)"");
        }
        return super.createChild(string);
    }

    protected String getFilterString() {
        String string = (String)this.getDisplayFieldValue(TF_FILTER);
        if (string == null) {
            string = "*";
        } else if ((string = string.trim()).length() == 0) {
            string = "*";
        }
        this.setDisplayFieldValue(TF_FILTER, string);
        return string;
    }

    protected SMProfileModel getModel() {
        HttpServletRequest httpServletRequest = this.getRequestContext().getRequest();
        if (this.model == null) {
            this.model = new SMProfileModelImpl(httpServletRequest, this.getPageSessionAttributes());
        }
        return this.model;
    }

    public void handleBtnFilterRequest(RequestInvocationEvent requestInvocationEvent) {
        String string = this.getFilterString();
        this.model = this.getModel();
        HiddenField hiddenField = (HiddenField)this.getChild("ProfileServerName");
        this.serverName = (String)hiddenField.getValue();
        this.model.setProfileServerName(this.serverName);
        this.model.searchSessionList(string);
        this.forwardTo();
    }

    public void handleBtnInvalidateRequest(RequestInvocationEvent requestInvocationEvent) {
        this.model = this.getModel();
        this.setAttributesForModel();
        SMProfileSessionsTiledView sMProfileSessionsTiledView = (SMProfileSessionsTiledView)this.getChild(USER_SESSION_TILEDVIEW);
        List list = sMProfileSessionsTiledView.getSelectedSessions();
        if (list != null && !list.isEmpty()) {
            this.invalidateSessions(this.model, list);
        } else {
            this.showMessageBox(0, this.model.getNoSessionSelectedForInvalidationTitle(), this.model.getNoSessionSelectedForInvalidationMessage());
        }
        this.forwardTo();
    }

    private void invalidateSessions(SMProfileModel sMProfileModel, List list) {
        boolean bl = false;
        List list2 = null;
        try {
            list2 = sMProfileModel.invalidateSessions(list, this.getFilterString());
        }
        catch (AMConsoleException aMConsoleException) {
            bl = true;
            this.showMessageBox(0, sMProfileModel.getErrorTitle(), aMConsoleException.getMessage());
        }
        if (!bl && list2 != null && !list2.isEmpty()) {
            ListedMessageBox listedMessageBox = (ListedMessageBox)this.getDisplayField(CC_LIST_MSG_BOX);
            listedMessageBox.setType(0);
            listedMessageBox.setTitle(sMProfileModel.getErrorTitle());
            listedMessageBox.setMessage(sMProfileModel.getTerminateErrorMessage());
            listedMessageBox.setItems(list2);
            listedMessageBox.setEnabled(true);
        }
        if (!sMProfileModel.isSessionValid()) {
            this.validSession = false;
        }
    }

    public void handleCcPaginationRequest(RequestInvocationEvent requestInvocationEvent) {
        this.setAttributesForModel();
        String string = (String)this.getDisplayFieldValue(CC_PAGINATION);
        if (string == null || string.equals("goto")) {
            string = (String)this.getDisplayFieldValue(CC_PAGINATION_PAGE);
        }
        try {
            this.curPage = Integer.parseInt(string);
            if (this.curPage < 1) {
                this.curPage = 1;
            } else {
                int n = this.getPageCnt();
                if (this.curPage > n) {
                    this.curPage = n;
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
            this.curPage = 1;
        }
        this.forwardTo();
    }

    public void setAttrValues(List list) {
        if (list == null || list.size() == 0) {
            return;
        }
        SerializedField serializedField = (SerializedField)this.getChild(FLD_SERIALIZED);
        serializedField.setValue((ArrayList)list);
    }

    private int getBeginIndex(boolean bl) {
        this.model = this.getModel();
        int n = this.getSessionCnt();
        int n2 = 0;
        if (n > 0) {
            n2 = (this.curPage - 1) * this.model.getGlobalPageSize() + 1;
        }
        if (bl && n2 > 0) {
            return n2 - 1;
        }
        return n2;
    }

    private int getEndIndex() {
        int n;
        int n2 = this.getSessionCnt();
        int n3 = 0;
        int n4 = 0;
        this.model = this.getModel();
        if (n2 > 0 && (n4 = (n = this.model.getGlobalPageSize()) + (n3 = (this.curPage - 1) * n + 1) - 1) > n2) {
            n4 = n2;
        }
        return n4;
    }

    private int getSessionCnt() {
        this.model = this.getModel();
        return this.model.getValidSessionCnt();
    }

    private int getPageCnt() {
        this.model = this.getModel();
        int n = this.getSessionCnt();
        int n2 = this.model.getGlobalPageSize();
        int n3 = n / n2;
        if (n % n2 != 0) {
            ++n3;
        }
        return n3;
    }

    private void setAttributesForModel() {
        this.model = this.getModel();
        HiddenField hiddenField = (HiddenField)this.getChild("ProfileServerName");
        this.serverName = (String)hiddenField.getValue();
        this.model.setProfileServerName(this.serverName);
        SerializedField serializedField = (SerializedField)this.getChild(FLD_SERIALIZED);
        List list = (List)serializedField.getSerializedObj();
        this.model.setAttrList(list);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

