/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.am.console.service.model;

import com.iplanet.am.console.base.model.AMConsoleException;
import com.iplanet.am.console.base.model.AMModelBase;
import com.iplanet.am.console.base.model.AMProfileModelBase;
import com.iplanet.am.console.service.model.SMDescriptionData;
import com.iplanet.am.console.service.model.SMDiscoEntryData;
import com.iplanet.am.console.service.model.SMDiscoveryServiceData;
import com.iplanet.am.console.service.model.SMResourceOfferingModel;
import com.iplanet.am.sdk.AMException;
import com.iplanet.am.sdk.AMUser;
import com.iplanet.sso.SSOException;
import com.sun.identity.liberty.ws.disco.jaxb.AuthenticateRequesterElement;
import com.sun.identity.liberty.ws.disco.jaxb.AuthenticateSessionContextElement;
import com.sun.identity.liberty.ws.disco.jaxb.AuthorizeRequesterElement;
import com.sun.identity.liberty.ws.disco.jaxb.DescriptionType;
import com.sun.identity.liberty.ws.disco.jaxb.DirectiveType;
import com.sun.identity.liberty.ws.disco.jaxb.EncryptResourceIDElement;
import com.sun.identity.liberty.ws.disco.jaxb.OptionsType;
import com.sun.identity.liberty.ws.disco.jaxb.ResourceIDType;
import com.sun.identity.liberty.ws.disco.jaxb.ResourceOfferingType;
import com.sun.identity.liberty.ws.disco.jaxb.ServiceInstanceType;
import com.sun.identity.liberty.ws.disco.plugins.jaxb.DiscoEntryElement;
import com.sun.identity.liberty.ws.soapbinding.Utils;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;

public class SMResourceOfferingModelImpl
extends AMProfileModelBase
implements SMResourceOfferingModel {
    private static final String USER_RESOURCE_OFFERING_ATTR = "sunIdentityServerDiscoEntries";

    public SMResourceOfferingModelImpl(HttpServletRequest httpServletRequest, Map map) {
        super(httpServletRequest, map);
    }

    public String getTableCaptionLabel() {
        return this.getLocalizedString("resourceTableCaption.header");
    }

    public boolean hasResources(SMDiscoveryServiceData sMDiscoveryServiceData) {
        if (sMDiscoveryServiceData != null) {
            return sMDiscoveryServiceData.hasResources();
        }
        return false;
    }

    public String getNoResourceEntryMessage() {
        return this.getLocalizedString("noResourceEntry.message");
    }

    public String getResourceOfferingHeader(int n) {
        String string = "";
        if (n == 2) {
            string = this.getLocalizedString("resourceOfferingUser.header");
        } else if (n == 1) {
            string = this.getLocalizedString("resourceOfferingDynamic.header");
        } else if (n == 0) {
            string = this.getLocalizedString("resourceOfferingGlobal.header");
        }
        return string;
    }

    public String getServiceTypeLabel() {
        return this.getLocalizedString("discoServiceEntryServiceType.label");
    }

    public String getNewBtnLabel() {
        return this.getLocalizedString("new.button");
    }

    public String getDeleteBtnLabel() {
        return this.getLocalizedString("delete.button");
    }

    public String getRowsLabel() {
        return this.getLocalizedString("rows.label");
    }

    public String getRowLabel() {
        return this.getLocalizedString("row.label");
    }

    public String getEditLabel() {
        return this.getLocalizedString("discoveryServiceEdit.label");
    }

    public String getNoResourceOfferingSelectedForDeletionTitle() {
        return this.getLocalizedString("noResourceOfferingSelectedForDeletion.title");
    }

    public String getNoResourceOfferingSelectedForDeletionMessage() {
        return this.getLocalizedString("noResourceOfferingSelectedForDeletion.message");
    }

    public Set getDiscoEntrySet(SMDiscoveryServiceData sMDiscoveryServiceData) {
        HashSet<String> hashSet = Collections.EMPTY_SET;
        List list = sMDiscoveryServiceData.getResourceData();
        if (list != null && !list.isEmpty()) {
            int n = list.size();
            hashSet = new HashSet<String>(n);
            int n2 = 0;
            while (n2 < n) {
                SMDiscoEntryData sMDiscoEntryData = (SMDiscoEntryData)list.get(n2);
                String string = sMDiscoEntryData.getDiscoStr();
                hashSet.add(string);
                ++n2;
            }
        }
        return hashSet;
    }

    public SMDiscoveryServiceData getEntries(Set set) {
        SMDiscoveryServiceData sMDiscoveryServiceData;
        block3: {
            sMDiscoveryServiceData = new SMDiscoveryServiceData();
            if (set == null || set.isEmpty()) break block3;
            try {
                JAXBContext jAXBContext = JAXBContext.newInstance((String)Utils.getJAXBPackages());
                Unmarshaller unmarshaller = jAXBContext.createUnmarshaller();
                Iterator iterator = set.iterator();
                while (iterator.hasNext()) {
                    String string = (String)iterator.next();
                    SMDiscoEntryData sMDiscoEntryData = new SMDiscoEntryData();
                    sMDiscoEntryData.setDiscoStr(string);
                    DiscoEntryElement discoEntryElement = (DiscoEntryElement)unmarshaller.unmarshal((Source)new StreamSource(new StringReader(string)));
                    this.setDiscoEntryData(discoEntryElement, sMDiscoEntryData);
                    sMDiscoveryServiceData.addResourceData(sMDiscoEntryData);
                }
            }
            catch (JAXBException jAXBException) {
                AMModelBase.debug.error("SMResourceOfferingModelImpl.getEntries", (Throwable)jAXBException);
            }
        }
        return sMDiscoveryServiceData;
    }

    public void setSMDiscoEntryDataHandler(SMDiscoveryServiceData sMDiscoveryServiceData, int n) {
        List list = sMDiscoveryServiceData.getResourceData();
        SMDiscoEntryData sMDiscoEntryData = (SMDiscoEntryData)list.get(n);
        sMDiscoEntryData.setNewEntry(false);
        sMDiscoveryServiceData.setSMDiscoEntryDataHandler(sMDiscoEntryData);
    }

    public void deleteDiscoEntries(List list, SMDiscoveryServiceData sMDiscoveryServiceData) {
        List list2;
        if (list != null && !list.isEmpty() && sMDiscoveryServiceData != null && (list2 = sMDiscoveryServiceData.getResourceData()) != null && !list2.isEmpty()) {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                if (!this.deleteDiscoEntries(string, list2) || !AMModelBase.debug.messageEnabled()) continue;
                AMModelBase.debug.message("SMResourceOfferingModelImpl.deleteDiscoEntries: " + string + "is deleted");
            }
        }
    }

    private boolean deleteDiscoEntries(String string, List list) {
        boolean bl = false;
        Iterator iterator = list.iterator();
        while (iterator.hasNext() && !bl) {
            SMDiscoEntryData sMDiscoEntryData = (SMDiscoEntryData)iterator.next();
            String string2 = sMDiscoEntryData.getDiscoStr();
            if (string2.equals(string)) {
                iterator.remove();
                bl = true;
                continue;
            }
            String string3 = string2.replace('\n', ' ');
            if (!string3.equals(string)) continue;
            iterator.remove();
            bl = true;
        }
        return bl;
    }

    private void setDescriptionEntry(SMDescriptionData sMDescriptionData, DescriptionType descriptionType) {
        if (sMDescriptionData != null) {
            sMDescriptionData.setDescriptionID(descriptionType.getId());
            sMDescriptionData.setSecurityMechId(descriptionType.getSecurityMechID());
            String string = descriptionType.getWsdlURI();
            if (string != null && string.length() > 0) {
                sMDescriptionData.setBriefSoapHttp(false);
                sMDescriptionData.setWSDLURI(descriptionType.getWsdlURI());
                QName qName = descriptionType.getServiceNameRef();
                String string2 = qName.getLocalPart();
                String string3 = qName.getNamespaceURI();
                sMDescriptionData.setServiceNameReferenceNameSpace(string3);
                sMDescriptionData.setServiceNameReferenceLocalPart(string2);
            } else {
                sMDescriptionData.setBriefSoapHttp(true);
                sMDescriptionData.setEndPointUrl(descriptionType.getEndpoint());
                sMDescriptionData.setSoapAction(descriptionType.getSoapAction());
            }
        }
    }

    private Map getDirectiveEntry(DiscoEntryElement discoEntryElement) {
        HashMap hashMap = Collections.EMPTY_MAP;
        List list = discoEntryElement.getAny();
        if (list != null && !list.isEmpty()) {
            int n = list.size();
            hashMap = new HashMap(n);
            int n2 = 0;
            while (n2 < n) {
                AuthenticateRequesterElement authenticateRequesterElement;
                Object e = list.get(n2);
                if (e instanceof AuthenticateRequesterElement) {
                    authenticateRequesterElement = (AuthenticateRequesterElement)e;
                    this.setDirectiveData((DirectiveType)authenticateRequesterElement, hashMap, "AuthenticateRequester");
                } else if (e instanceof EncryptResourceIDElement) {
                    authenticateRequesterElement = (EncryptResourceIDElement)e;
                    this.setDirectiveData((DirectiveType)authenticateRequesterElement, hashMap, "EncryptResourceID");
                } else if (e instanceof AuthenticateSessionContextElement) {
                    authenticateRequesterElement = (AuthenticateSessionContextElement)e;
                    this.setDirectiveData((DirectiveType)authenticateRequesterElement, hashMap, "AuthenticateSessionContext");
                } else if (e instanceof AuthorizeRequesterElement) {
                    authenticateRequesterElement = (AuthorizeRequesterElement)e;
                    this.setDirectiveData((DirectiveType)authenticateRequesterElement, hashMap, "AuthorizeRequester");
                } else {
                    AMModelBase.debug.error("unsupported directive type");
                }
                ++n2;
            }
        }
        return hashMap;
    }

    private void setDirectiveData(DirectiveType directiveType, Map map, String string) {
        List list = directiveType.getDescriptionIDRefs();
        ArrayList arrayList = Collections.EMPTY_LIST;
        if (list != null && !list.isEmpty()) {
            int n = list.size();
            arrayList = new ArrayList(n);
            int n2 = 0;
            while (n2 < n) {
                DescriptionType descriptionType = (DescriptionType)list.get(n2);
                List list2 = descriptionType.getSecurityMechID();
                arrayList.add(list2.get(0));
                ++n2;
            }
        }
        map.put(string, arrayList);
    }

    private void setDiscoEntryData(DiscoEntryElement discoEntryElement, SMDiscoEntryData sMDiscoEntryData) {
        Object object;
        ResourceOfferingType resourceOfferingType = discoEntryElement.getResourceOffering();
        ResourceIDType resourceIDType = resourceOfferingType.getResourceID();
        ServiceInstanceType serviceInstanceType = resourceOfferingType.getServiceInstance();
        String string = serviceInstanceType.getProviderID();
        String string2 = serviceInstanceType.getServiceType();
        sMDiscoEntryData.setEntryId(resourceOfferingType.getEntryID());
        sMDiscoEntryData.setResourceIdAttribute(resourceIDType.getId());
        sMDiscoEntryData.setResourceIdValue(resourceIDType.getValue());
        sMDiscoEntryData.setServiceType(string2);
        sMDiscoEntryData.setProviderId(string);
        sMDiscoEntryData.setAbstract(resourceOfferingType.getAbstract());
        OptionsType optionsType = resourceOfferingType.getOptions();
        if (optionsType != null) {
            sMDiscoEntryData.setOptions(optionsType.getOption());
        } else {
            sMDiscoEntryData.setNoOptionFlag(true);
        }
        List list = serviceInstanceType.getDescription();
        if (list != null && !list.isEmpty()) {
            object = list.iterator();
            while (object.hasNext()) {
                SMDescriptionData sMDescriptionData = new SMDescriptionData();
                DescriptionType descriptionType = (DescriptionType)object.next();
                this.setDescriptionEntry(sMDescriptionData, descriptionType);
                sMDiscoEntryData.addDescriptionData(sMDescriptionData);
            }
        } else {
            AMModelBase.debug.error("SMResourceOfferingModelImpl.setDiscoEntryData: No description exists in the disco entry");
        }
        object = this.getDirectiveEntry(discoEntryElement);
        sMDiscoEntryData.setDirectives((Map)object);
    }

    public String getAbstractLabel() {
        return this.getLocalizedString("abstract.label");
    }

    public String getAbstractValue(SMDiscoveryServiceData sMDiscoveryServiceData, String string) {
        List list;
        String string2 = null;
        if (sMDiscoveryServiceData != null && string != null && string.length() > 0 && (list = sMDiscoveryServiceData.getResourceData()) != null && !list.isEmpty()) {
            int n = list.size();
            int n2 = 0;
            while (n2 < n) {
                SMDiscoEntryData sMDiscoEntryData = (SMDiscoEntryData)list.get(n2);
                if (string.equals(sMDiscoEntryData.getDiscoStr())) {
                    string2 = sMDiscoEntryData.getAbstract();
                    break;
                }
                ++n2;
            }
        }
        return string2 == null ? "" : string2;
    }

    public void updateUserDiscoEntry(SMDiscoveryServiceData sMDiscoveryServiceData, String string) throws AMConsoleException {
        Set set = this.getDiscoEntrySet(sMDiscoveryServiceData);
        if (set != null) {
            try {
                HashMap<String, Set> hashMap = new HashMap<String, Set>(2);
                hashMap.put(USER_RESOURCE_OFFERING_ATTR, set);
                AMUser aMUser = this.dpStoreConn.getUser(string);
                aMUser.setAttributes(hashMap);
                aMUser.store();
                this.writeFormatLog("userResourceOfferingChanged.message", USER_RESOURCE_OFFERING_ATTR, string);
            }
            catch (SSOException sSOException) {
                if (AMModelBase.debug.warningEnabled()) {
                    AMModelBase.debug.warning("SMResourceOfferingModel.updateUserDiscoEntry could not update resource offering for " + string, (Throwable)sSOException);
                }
                throw new AMConsoleException(this.getErrorString((Exception)((Object)sSOException)));
            }
            catch (AMException aMException) {
                if (AMModelBase.debug.warningEnabled()) {
                    AMModelBase.debug.warning("SMResourceOfferingModel.updateUserDiscoEntry could not update resource offering for " + string, (Throwable)aMException);
                }
                throw new AMConsoleException(this.getErrorString((Exception)((Object)aMException)));
            }
        }
    }

    public void deleteUserDiscoEntries(List list, SMDiscoveryServiceData sMDiscoveryServiceData, String string) throws AMConsoleException {
        this.deleteDiscoEntries(list, sMDiscoveryServiceData);
        this.updateUserDiscoEntry(sMDiscoveryServiceData, string);
    }

    public String getResourceOfferingModifiedTitle() {
        return this.getLocalizedString("resourceOfferingIsModified.title");
    }

    public String getResourceOfferingModifiedMessage() {
        return this.getLocalizedString("resourceOfferingIsModified.message");
    }
}

