/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.am.console.service.model;

import com.iplanet.am.console.base.model.AMAdminConstants;
import com.iplanet.am.console.base.model.AMAdminUtils;
import com.iplanet.am.console.base.model.AMAttrSchemaComparator;
import com.iplanet.am.console.base.model.AMAttributeDisplayImpl;
import com.iplanet.am.console.base.model.AMConsoleException;
import com.iplanet.am.console.base.model.AMDisplayTypeConverter;
import com.iplanet.am.console.base.model.AMModelBase;
import com.iplanet.am.console.base.model.AMOrgCustomDirCacher;
import com.iplanet.am.console.base.model.AMProfileModelBase;
import com.iplanet.am.console.base.model.AMResBundleCacher;
import com.iplanet.am.console.base.model.AMServiceDisplayModelImpl;
import com.iplanet.am.console.base.model.DynamicGUIGenerator;
import com.iplanet.am.console.components.view.html.DynamicGUI;
import com.iplanet.am.console.service.model.SMDataModel;
import com.iplanet.am.console.settings.Setting;
import com.iplanet.am.sdk.AMException;
import com.iplanet.am.sdk.AMObject;
import com.iplanet.am.sdk.AMTemplate;
import com.iplanet.am.util.Debug;
import com.iplanet.am.util.Locale;
import com.iplanet.sso.SSOException;
import com.sun.identity.sm.AttributeSchema;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.SchemaType;
import com.sun.identity.sm.ServiceSchema;
import com.sun.identity.sm.ServiceSchemaManager;
import java.text.Collator;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.TreeSet;
import javax.servlet.http.HttpServletRequest;

public class SMDataModelImpl
extends AMProfileModelBase
implements SMDataModel {
    private static final String HELP_DOC_PROPERTY = "helptoc.doc";
    private boolean processTemplate;
    protected boolean processed;
    protected String svcName;
    protected ServiceSchemaManager svcSchemaMgr;
    private String lSvcName;
    protected String errorMessage;
    protected String errorTitle;
    private int globalSize;
    protected int orgSize;
    protected int dynSize;
    protected ResourceBundle svcResBundle;
    private ServiceSchema globalSvcSchema;
    protected ServiceSchema orgSvcSchema;
    protected ServiceSchema dynSvcSchema;
    private List globalAttrSchemaList;
    protected List orgAttrSchemaList;
    protected List dynAttrSchemaList;
    protected Map globalAttrs;
    protected Map orgAttrs;
    protected Map dynAttrs;
    private AttributeSchema rowAttrSchema;
    private int currentType;
    private AMTemplate orgTemplate;
    private AMTemplate dynTemplate;
    private int priority;
    private boolean hasSchema;
    private boolean hasTemplate;
    protected Map attrOptions;
    public static final int TEMPLATE_PRIORITY_COUNT = 7;
    public static final String TEMPLATE_PRIORITY_PREFIX = "amTemplatePriority";
    protected static String[] templatePriorities = null;
    private Set passwordAttrs;
    private Set encryptedAttrs;

    public SMDataModelImpl(HttpServletRequest httpServletRequest, String string, Map map, String string2, boolean bl) {
        block6: {
            super(httpServletRequest, string, map);
            this.processTemplate = false;
            this.processed = false;
            this.svcName = "";
            this.svcSchemaMgr = null;
            this.lSvcName = "";
            this.errorMessage = null;
            this.errorTitle = null;
            this.globalSize = 0;
            this.orgSize = 0;
            this.dynSize = 0;
            this.svcResBundle = null;
            this.globalSvcSchema = null;
            this.orgSvcSchema = null;
            this.dynSvcSchema = null;
            this.globalAttrSchemaList = Collections.EMPTY_LIST;
            this.orgAttrSchemaList = Collections.EMPTY_LIST;
            this.dynAttrSchemaList = Collections.EMPTY_LIST;
            this.globalAttrs = new HashMap(1);
            this.orgAttrs = new HashMap(1);
            this.dynAttrs = new HashMap(1);
            this.rowAttrSchema = null;
            this.currentType = 1;
            this.orgTemplate = null;
            this.dynTemplate = null;
            this.priority = -1;
            this.hasSchema = true;
            this.hasTemplate = false;
            this.attrOptions = null;
            this.passwordAttrs = null;
            this.encryptedAttrs = null;
            if (string2 == null || string2.length() == 0) {
                AMModelBase.debug.error("SMDataModelImpl: Invalid service name.");
            } else {
                this.svcName = string2;
                this.processTemplate = bl;
                try {
                    this.svcSchemaMgr = this.getServiceSchemaManager(string2);
                    if (!bl) break block6;
                    this.attrOptions = this.getDisplayOptions();
                    if (AMModelBase.debug.messageEnabled()) {
                        AMModelBase.debug.message("SMDataModelImpl: attrOptions " + this.attrOptions);
                    }
                }
                catch (SSOException sSOException) {
                    AMModelBase.debug.error("SMDataModelImpl", (Throwable)sSOException);
                }
                catch (SMSException sMSException) {
                    AMModelBase.debug.error("SMDataModelImpl", (Throwable)sMSException);
                }
            }
        }
    }

    public void process() throws AMConsoleException {
        if (this.svcSchemaMgr == null) {
            this.errorTitle = this.getLocalizedString("errorMessage.title");
            throw new AMConsoleException(this.getLocalizedString("missingServiceName.message"));
        }
        if (this.processTemplate) {
            if (this.isServiceDenied()) {
                this.errorTitle = this.getLocalizedString("errorMessage.title");
                throw new AMConsoleException(this.getLocalizedString("deniedServiceName.message"));
            }
            this.processTemplate();
        } else {
            this.getSvcResBundle();
            this.getGlobalSchema();
            this.getOrgSchema();
            this.getDynamicSchema();
            this.lSvcName = this.getL10Name();
            boolean bl = this.hasSchema = this.globalSize > 0 || this.orgSize > 0 || this.dynSize > 0;
            if (AMModelBase.debug.messageEnabled()) {
                this.debugMessage("SMDataModelImpl.process\nglobal attributes = " + this.globalSize + "\norg attributes = " + this.orgSize + "\ndyn attributes = " + this.dynSize);
            }
            this.processed = true;
        }
    }

    private void getSvcResBundle() {
        this.svcResBundle = null;
        String string = this.svcSchemaMgr.getI18NFileName();
        if (string != null) {
            this.svcResBundle = AMResBundleCacher.getBundle(string, this.getUserLocale());
        }
        if (this.svcResBundle == null) {
            this.svcResBundle = this.resBundle;
        }
    }

    private void getGlobalSchema() {
        try {
            this.globalSvcSchema = this.svcSchemaMgr.getSchema(SchemaType.GLOBAL);
            this.globalAttrSchemaList = this.getAttributeSchemas(this.globalSvcSchema);
            this.globalAttrs = this.getAttributes(this.globalSvcSchema);
            this.fireRetrieveAttributeValuesEvent(null, 3, 15, this.svcName, SchemaType.GLOBAL, this.globalAttrs);
            this.removeAttrsNotInSet(this.globalAttrSchemaList, this.globalAttrs.keySet());
            this.globalSize = this.globalAttrSchemaList.size();
        }
        catch (SMSException sMSException) {
            this.globalAttrSchemaList = Collections.EMPTY_LIST;
            this.globalSize = 0;
            AMModelBase.debug.warning("SMDataModelImpl.getGlobalSchema", (Throwable)sMSException);
        }
    }

    protected void getOrgSchema() {
        try {
            this.orgSvcSchema = this.svcSchemaMgr.getSchema(SchemaType.ORGANIZATION);
            this.orgAttrSchemaList = this.getAttributeSchemas(this.orgSvcSchema);
            this.orgAttrs = this.getAttributes(this.orgSvcSchema);
            this.fireRetrieveAttributeValuesEvent(null, 3, 15, this.svcName, SchemaType.ORGANIZATION, this.orgAttrs);
            this.removeAttrsNotInSet(this.orgAttrSchemaList, this.orgAttrs.keySet());
            this.orgSize = this.orgAttrSchemaList.size();
        }
        catch (SMSException sMSException) {
            this.orgAttrSchemaList = Collections.EMPTY_LIST;
            this.orgSize = 0;
            AMModelBase.debug.warning("SMDataModelImpl.getOrgSchema", (Throwable)sMSException);
        }
    }

    private void getDynamicSchema() {
        try {
            this.dynSvcSchema = this.svcSchemaMgr.getSchema(SchemaType.DYNAMIC);
            this.dynAttrSchemaList = this.getAttributeSchemas(this.dynSvcSchema);
            this.dynAttrs = this.getAttributes(this.dynSvcSchema);
            this.fireRetrieveAttributeValuesEvent(null, 3, 15, this.svcName, SchemaType.DYNAMIC, this.dynAttrs);
            this.removeAttrsNotInSet(this.dynAttrSchemaList, this.dynAttrs.keySet());
            this.dynSize = this.dynAttrSchemaList.size();
        }
        catch (SMSException sMSException) {
            this.dynAttrSchemaList = Collections.EMPTY_LIST;
            this.dynSize = 0;
            AMModelBase.debug.warning("SMDataModelImpl.getDynamicSchema", (Throwable)sMSException);
        }
    }

    private void processTemplate() {
        this.hasSchema = false;
        this.orgSize = 0;
        this.dynSize = 0;
        Set set = AMAdminUtils.getUserManagementSchemaTypes(this.svcSchemaMgr, this.locationType);
        this.getSvcResBundle();
        if (!set.isEmpty()) {
            this.hasSchema = true;
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                SchemaType schemaType = (SchemaType)iterator.next();
                AMTemplate aMTemplate = this.getSvcTemplate(schemaType);
                if (aMTemplate == null) continue;
                if (aMTemplate.getType() == 301) {
                    this.hasTemplate = this.doesTemplateExist(aMTemplate);
                    this.priority = this.getPriorityFromTemplate(aMTemplate);
                    this.dynTemplate = aMTemplate;
                    this.dynSvcSchema = this.getSchema(schemaType);
                    if (!this.hasTemplate) continue;
                    this.dynAttrSchemaList = this.getAttributeSchemas(this.dynSvcSchema);
                    this.dynAttrs = this.getAttributes(aMTemplate, this.dynSvcSchema.getAttributeSchemaNames());
                    this.fireRetrieveAttributeValuesEvent((AMObject)aMTemplate, 2, 15, this.svcName, SchemaType.DYNAMIC, this.dynAttrs);
                    this.removeAttrsNotInSet(this.dynAttrSchemaList, this.dynAttrs.keySet());
                    this.dynSize = this.dynAttrSchemaList.size();
                    continue;
                }
                this.hasTemplate = true;
                this.orgTemplate = aMTemplate;
                this.orgSvcSchema = this.getSchema(schemaType);
                this.orgAttrSchemaList = this.getAttributeSchemas(this.orgSvcSchema);
                this.orgAttrs = this.getAttributes(aMTemplate, this.orgSvcSchema.getAttributeSchemaNames());
                this.fireRetrieveAttributeValuesEvent((AMObject)aMTemplate, 2, 15, this.svcName, SchemaType.DYNAMIC, this.orgAttrs);
                this.removeAttrsNotInSet(this.orgAttrSchemaList, this.orgAttrs.keySet());
                this.orgSize = this.orgAttrSchemaList.size();
            }
        }
        this.lSvcName = this.getL10Name();
        if (AMModelBase.debug.messageEnabled()) {
            this.debugMessage("SMDataModelImpl: processTemplate\norg attributes = " + this.orgSize + "\ndyn attributes = " + this.dynSize);
        }
        this.processed = true;
    }

    private boolean doesTemplateExist(AMTemplate aMTemplate) {
        boolean bl = false;
        try {
            bl = aMTemplate.isExists();
        }
        catch (SSOException sSOException) {
            AMModelBase.debug.warning("SMDataModelImpl.doesTemplateExist", (Throwable)sSOException);
        }
        return bl;
    }

    private int getPriorityFromTemplate(AMTemplate aMTemplate) {
        int n = -1;
        try {
            n = aMTemplate.getPriority();
        }
        catch (SSOException sSOException) {
            AMModelBase.debug.warning("SMDataModelImpl.getPriorityFromTemplate", (Throwable)sSOException);
        }
        return n;
    }

    private AMTemplate getSvcTemplate(SchemaType schemaType) {
        AMTemplate aMTemplate = null;
        try {
            aMTemplate = this.getServiceTemplate(this.svcName, schemaType);
        }
        catch (AMException aMException) {
            AMModelBase.debug.error("SMDataModelImpl.getSvcTemplate", (Throwable)aMException);
        }
        catch (SSOException sSOException) {
            AMModelBase.debug.error("SMDataModelImpl.getSvcTemplate", (Throwable)sSOException);
        }
        return aMTemplate;
    }

    private ServiceSchema getSchema(SchemaType schemaType) {
        ServiceSchema serviceSchema = null;
        try {
            serviceSchema = this.svcSchemaMgr.getSchema(schemaType);
        }
        catch (SMSException sMSException) {
            AMModelBase.debug.error("SMDataModelImpl.getSchema", (Throwable)sMSException);
        }
        return serviceSchema;
    }

    private Map getAttributes(AMTemplate aMTemplate, Set set) {
        AMModelBase.debug.message("getting attributes from tempate");
        Map map = null;
        if (AMModelBase.debug.messageEnabled()) {
            AMModelBase.debug.message("attribute to retrieve from template = " + set);
        }
        if (aMTemplate != null) {
            try {
                map = aMTemplate.getAttributes(set);
            }
            catch (AMException aMException) {
                AMModelBase.debug.error("SMDataModelImpl.getAttributes", (Throwable)aMException);
            }
            catch (SSOException sSOException) {
                AMModelBase.debug.error("SMDataModelImpl.getAttributes", (Throwable)sSOException);
            }
        }
        if (map == null) {
            map = Collections.EMPTY_MAP;
        }
        if (AMModelBase.debug.messageEnabled()) {
            AMModelBase.debug.message("attributes returned from the template = " + map);
        }
        return map;
    }

    protected Map getAttributes(ServiceSchema serviceSchema) {
        HashMap hashMap = null;
        if (serviceSchema != null) {
            hashMap = serviceSchema.getAttributeDefaults();
        }
        if (hashMap == null) {
            hashMap = new HashMap(1);
        }
        return hashMap;
    }

    private List getSortedAttrSchemaList(Collection collection) {
        ArrayList arrayList = Collections.EMPTY_LIST;
        if (collection != null && collection.size() > 0) {
            Collator collator;
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                collator = (AttributeSchema)iterator.next();
                if (collator != null && collator.getI18NKey() != null && collator.getI18NKey().length() != 0) continue;
                iterator.remove();
            }
            collator = Collator.getInstance(this.getUserLocale());
            TreeSet treeSet = new TreeSet(new AMAttrSchemaComparator(collator));
            treeSet.addAll(collection);
            ArrayList arrayList2 = new ArrayList(treeSet);
            arrayList2.trimToSize();
            arrayList = arrayList2;
        }
        if (arrayList == null) {
            arrayList = Collections.EMPTY_LIST;
        }
        return arrayList;
    }

    protected List getAttributeSchemas(ServiceSchema serviceSchema) {
        Set set;
        List list = Collections.EMPTY_LIST;
        if (serviceSchema != null && (set = serviceSchema.getAttributeSchemas()) != null) {
            if (this.processTemplate) {
                set = this.getDisplayedAttr(set);
            }
            list = this.getSortedAttrSchemaList(set);
        }
        return list;
    }

    private String getL10Name() {
        String string = "";
        if (this.svcResBundle != null) {
            String string2 = null;
            if (this.globalSvcSchema != null) {
                string2 = this.globalSvcSchema.getI18NKey();
            } else if (this.orgSvcSchema != null) {
                string2 = this.orgSvcSchema.getI18NKey();
            } else if (this.dynSvcSchema != null) {
                string2 = this.dynSvcSchema.getI18NKey();
            }
            if (string2 != null && string2.length() > 0 && (string = Locale.getString((ResourceBundle)this.svcResBundle, (String)string2, (Debug)AMModelBase.debug)) == null) {
                string = "";
            }
        }
        return string;
    }

    private AttributeSchema getAttrSchema(int n, int n2) {
        AttributeSchema attributeSchema = null;
        switch (n) {
            case 0: {
                if (n2 < 0 || n2 >= this.globalSize) break;
                attributeSchema = (AttributeSchema)this.globalAttrSchemaList.get(n2);
                break;
            }
            case 1: {
                if (n2 < 0 || n2 >= this.orgSize) break;
                attributeSchema = (AttributeSchema)this.orgAttrSchemaList.get(n2);
                break;
            }
            case 2: {
                if (n2 < 0 || n2 >= this.dynSize) break;
                attributeSchema = (AttributeSchema)this.dynAttrSchemaList.get(n2);
            }
        }
        return attributeSchema;
    }

    public void store(int n, Map map) throws AMConsoleException {
        if (map != null && !map.isEmpty()) {
            if (!this.processed) {
                this.process();
            }
            try {
                switch (n) {
                    case 0: {
                        this.setAttributeDefaults(this.globalSvcSchema, map, this.globalAttrs);
                        break;
                    }
                    case 1: {
                        if (this.processTemplate) {
                            this.storeTemplate(this.orgTemplate, map, this.orgAttrs);
                            break;
                        }
                        this.setAttributeDefaults(this.orgSvcSchema, map, this.orgAttrs);
                        break;
                    }
                    case 2: {
                        if (this.processTemplate) {
                            this.storeTemplate(this.dynTemplate, map, this.dynAttrs);
                            break;
                        }
                        this.setAttributeDefaults(this.dynSvcSchema, map, this.dynAttrs);
                        break;
                    }
                    default: {
                        this.errorTitle = this.getLocalizedString("errorMessage.title");
                        String string = this.getLocalizedString("invalidServiceType.message");
                        if (AMModelBase.debug.warningEnabled()) {
                            AMModelBase.debug.warning("SMDataModelImpl.store" + string);
                        }
                        throw new AMConsoleException(string);
                    }
                }
            }
            catch (AMException aMException) {
                this.errorTitle = this.getLocalizedString("errorMessage.title");
                this.errorMessage = this.getErrorString((Exception)((Object)aMException));
                AMModelBase.debug.error("SMDataModelImpl.store", (Throwable)aMException);
                throw new AMConsoleException(this.errorMessage);
            }
        }
    }

    public String getErrorMessage() {
        if (this.errorMessage == null) {
            this.errorMessage = "";
        }
        return this.errorMessage;
    }

    public String getErrorTitle() {
        if (this.errorTitle == null) {
            this.errorTitle = super.getErrorTitle();
        }
        return this.errorTitle;
    }

    private void storeTemplate(AMTemplate aMTemplate, Map map, Map map2) throws AMConsoleException {
        if (this.isServiceDenied()) {
            this.errorTitle = this.getLocalizedString("errorMessage.title");
            throw new AMConsoleException(this.getLocalizedString("deniedServiceName.message"));
        }
        if (aMTemplate != null && map != null && map2 != null) {
            String string = (String)map.remove("priority");
            this.fireBeforeUpdateValuesEvent(13, (AMObject)aMTemplate, map);
            if (string != null) {
                this.store(string);
            }
            ArrayList arrayList = new ArrayList(map.size());
            HashSet hashSet = new HashSet(5);
            int n = 0;
            Iterator<Object> iterator = map.keySet().iterator();
            while (iterator.hasNext()) {
                String string2 = (String)iterator.next();
                if (this.isAttrReadOnly(string2)) continue;
                Set set = (Set)map.get(string2);
                Set set2 = (Set)map2.get(string2);
                if (set2 == null) {
                    set2 = Collections.EMPTY_SET;
                }
                if (set.equals(set2)) continue;
                ++n;
                this.storeAttrToTempl(aMTemplate, string2, set, set2, hashSet, arrayList);
            }
            this.fireAfterUpdateValuesEvent(13, (AMObject)aMTemplate);
            if (AMModelBase.debug.messageEnabled()) {
                AMModelBase.debug.message("SMDataModelImpl.storeTemplate: Number of new attrs = " + n);
            }
            if (this.logger.isEnabled()) {
                iterator = hashSet.iterator();
                while (iterator.hasNext()) {
                    this.logger.doLog((String)iterator.next());
                }
            }
            if (!arrayList.isEmpty()) {
                this.errorTitle = this.getLocalizedString("errorMessage.title");
                throw new AMConsoleException(arrayList);
            }
        }
    }

    private void storeAttrToTempl(AMTemplate aMTemplate, String string, Set set, Set set2, Set set3, List list) {
        try {
            Object[] objectArray;
            if (this.isEncryptedAttribute(string)) {
                set = this.encryptString(set);
            }
            HashMap<String, Set> hashMap = new HashMap<String, Set>(1);
            hashMap.put(string, set);
            aMTemplate.setAttributes(hashMap);
            aMTemplate.store();
            if (AMModelBase.debug.messageEnabled()) {
                AMModelBase.debug.message("SMDataModelImpl.storeAttrToTempl" + string);
            }
            if (this.logger.isEnabled()) {
                objectArray = new String[2];
                objectArray[1] = this.locationDN;
                objectArray[0] = this.isPasswordAttribute(string) ? this.svcName + "." + string : this.svcName + "." + string + " " + set2 + "->" + set;
                String string2 = MessageFormat.format(this.getLocalizedString("template.changed"), objectArray);
                set3.add(string2);
            }
            if (string.equals("iplanet-am-admin-console-custom-jsp-dir")) {
                objectArray = aMTemplate.getOrganizationDN();
                AMOrgCustomDirCacher.getInstance().flushEntry((String)objectArray);
                AMModelBase.debug.message("Organization custom JSP directory name cache flushed");
            }
        }
        catch (AMException aMException) {
            AMModelBase.debug.warning("SMDataModelImpl.storeAttrToTempl", (Throwable)aMException);
            list.add(this.getErrorString((Exception)((Object)aMException)));
        }
        catch (SSOException sSOException) {
            AMModelBase.debug.warning("SMDataModelImpl.storeAttrToTempl", (Throwable)sSOException);
            list.add(this.getErrorString((Exception)((Object)sSOException)));
        }
    }

    protected void setAttributeDefaults(ServiceSchema serviceSchema, Map map, Map map2) throws AMException, AMConsoleException {
        if (serviceSchema != null && map != null && map2 != null) {
            Object object;
            this.fireBeforeUpdateDefaultServiceValues(this.svcName, map);
            HashMap<Object, Set> hashMap = new HashMap<Object, Set>(5);
            HashSet<String> hashSet = new HashSet<String>(5);
            Iterator iterator = map.keySet().iterator();
            while (iterator.hasNext()) {
                object = (String)iterator.next();
                Set set = (Set)map2.get(object);
                Set set2 = (Set)map.get(object);
                this.removeFirstEmptyEntryInSet(set);
                Object[] objectArray = new String[2];
                objectArray[1] = this.locationDN;
                if (set != null && (set2 == null || set2.equals(set))) continue;
                if (this.isEncryptedAttribute((String)object)) {
                    set2 = this.encryptString(set2);
                }
                hashMap.put(object, set2);
                if (this.logger.isEnabled()) {
                    objectArray[0] = this.isPasswordAttribute((String)object) ? this.svcName + "." + (String)object : this.svcName + "." + (String)object + " " + set + "->" + set2;
                    String string = MessageFormat.format(this.getLocalizedString("service.changed"), objectArray);
                    hashSet.add(string);
                }
                if (!AMModelBase.debug.messageEnabled()) continue;
                this.debugMessage("SMDataModelImpl.setAttributeDefaults: " + (String)object + " - " + set + " -> " + set2);
            }
            if (!hashMap.isEmpty()) {
                try {
                    serviceSchema.setAttributeDefaults(hashMap);
                    this.fireAfterUpdateDefaultServiceValues(this.svcName);
                    if (this.logger.isEnabled()) {
                        object = hashSet.iterator();
                        while (object.hasNext()) {
                            this.logger.doLog((String)object.next());
                        }
                    }
                }
                catch (SSOException sSOException) {
                    AMModelBase.debug.warning("SMDataModelImpl.setAttributeDefaults", (Throwable)sSOException);
                    this.errorTitle = this.getLocalizedString("errorMessage.title");
                    this.errorMessage = this.getErrorString((Exception)((Object)sSOException));
                    throw new AMConsoleException(this.errorMessage);
                }
                catch (SMSException sMSException) {
                    AMModelBase.debug.warning("SMDataModelImpl.setAttributeDefaults", (Throwable)sMSException);
                    this.errorTitle = this.getLocalizedString("errorMessage.title");
                    this.errorMessage = this.getErrorString((Exception)((Object)sMSException));
                    throw new AMConsoleException(this.errorMessage);
                }
            }
        }
    }

    private void removeFirstEmptyEntryInSet(Set set) {
        Iterator iterator;
        String string;
        if (set != null && set.size() == 1 && (string = (String)(iterator = set.iterator()).next()) != null && string.length() == 0) {
            iterator.remove();
        }
    }

    private void store(String string) throws AMConsoleException {
        block8: {
            if (!this.processTemplate || string == null || string.length() <= 0) break block8;
            if (!this.processed) {
                this.process();
            }
            if (this.hasTemplate && this.priority != -1 && this.dynTemplate != null) {
                int n = -1;
                try {
                    n = Integer.parseInt(string);
                    if (n != this.priority) {
                        this.dynTemplate.setPriority(n);
                        if (AMModelBase.debug.messageEnabled()) {
                            AMModelBase.debug.message("SMDataModelImpl.storePriority: New template priority = " + n);
                        }
                        Object[] objectArray = new String[]{this.svcName + "." + TEMPLATE_PRIORITY_PREFIX + " " + this.priority + "->" + n, this.locationDN};
                        this.writeFormatLog("template.changed", objectArray);
                        this.priority = n;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    AMModelBase.debug.warning("SMDataModelImpl.storePriority", (Throwable)numberFormatException);
                }
                catch (AMException aMException) {
                    AMModelBase.debug.warning("SMDataModelImpl.storePriority", (Throwable)aMException);
                }
                catch (SSOException sSOException) {
                    AMModelBase.debug.warning("SMDataModelImpl.storePriority", (Throwable)sSOException);
                }
            }
        }
    }

    public int getSize(int n) {
        if (n == 0) {
            return this.globalSize;
        }
        if (n == 1) {
            return this.orgSize;
        }
        if (n == 2) {
            return this.dynSize;
        }
        return 0;
    }

    public String getTitle(int n) {
        String string = "";
        if (n == 0) {
            string = this.getLocalizedString("globalSvcAttr.label");
        } else if (n == 1) {
            string = this.getLocalizedString("orgSvcAttr.label");
        } else if (n == 2) {
            string = this.getLocalizedString("dynamicSvcAttr.label");
        }
        return string;
    }

    public String getOkBtnLabel() {
        return this.getLocalizedString("ok.button");
    }

    public String getDeleteBtnLabel() {
        return this.getLocalizedString("delete.button");
    }

    public String getNoAttrsMessage() {
        return this.getLocalizedString("noSchema.message");
    }

    public String getPriority() {
        return "" + this.priority;
    }

    public String getPriorityLabel() {
        return this.getLocalizedString("priority.label");
    }

    public String[][] getPriorityOptions() {
        String[][] stringArray = new String[2][7];
        int n = 0;
        while (n < 7) {
            stringArray[0][n] = this.getTemplPriorityLabel(n);
            ++n;
        }
        int n2 = 0;
        while (n2 < 7) {
            stringArray[1][n2] = AMAdminConstants.PRIORITY_VALUES[n2];
            ++n2;
        }
        return stringArray;
    }

    protected String getTemplPriorityLabel(int n) {
        String string = "";
        if (templatePriorities == null) {
            templatePriorities = new String[7];
            int n2 = 0;
            while (n2 < 7) {
                SMDataModelImpl.templatePriorities[n2] = this.getLocalizedString(TEMPLATE_PRIORITY_PREFIX + n2 + ".label");
                ++n2;
            }
        }
        if (n < 7) {
            string = templatePriorities[n];
        } else if (AMModelBase.debug.warningEnabled()) {
            AMModelBase.debug.warning("SMDataModelImpl.getTemplPriorityLabel, invalid template priority level");
        }
        return string;
    }

    public boolean isTemplateLevel() {
        return this.processTemplate;
    }

    public boolean hasTemplate() {
        return this.hasTemplate;
    }

    public boolean hasSchema() {
        return this.hasSchema;
    }

    public void deleteTemplate() throws AMConsoleException {
        if (this.svcSchemaMgr == null) {
            this.debugError("SMDataModelImpl: Invalid service name.");
        } else {
            try {
                Set set = AMAdminUtils.getUserManagementSchemaTypes(this.svcSchemaMgr, this.locationType);
                if (set != null && !set.isEmpty()) {
                    Iterator iterator = set.iterator();
                    while (iterator.hasNext()) {
                        SchemaType schemaType = (SchemaType)iterator.next();
                        AMTemplate aMTemplate = this.getServiceTemplate(this.svcName, schemaType);
                        if (aMTemplate == null || !aMTemplate.isExists()) continue;
                        aMTemplate.delete();
                        Object[] objectArray = new String[]{this.svcName, this.locationDN};
                        this.writeFormatLog("template.deleted", objectArray);
                    }
                }
            }
            catch (AMException aMException) {
                throw new AMConsoleException(this.getErrorString((Exception)((Object)aMException)));
            }
            catch (SSOException sSOException) {
                throw new AMConsoleException(this.getErrorString((Exception)((Object)sSOException)));
            }
        }
    }

    public String getServiceDisplayName() {
        return this.lSvcName;
    }

    public String getServiceName() {
        return this.svcName;
    }

    public boolean setCurrentRow(int n, int n2) {
        boolean bl = false;
        this.rowAttrSchema = this.getAttrSchema(n, n2);
        if (this.rowAttrSchema != null) {
            this.currentType = n;
            bl = true;
        }
        return bl;
    }

    public DynamicGUI getDynamicGUI() {
        DynamicGUIGenerator dynamicGUIGenerator = DynamicGUIGenerator.getInstance();
        String string = this.getAttrName();
        return dynamicGUIGenerator.createDynamicGUI(this.rowAttrSchema, this.getServiceName(), this.getAttrValues(), this.isAttrReadOnly(string), this, Setting.ACTION_SERVICE);
    }

    public String getAttrName() {
        String string = "";
        if (this.rowAttrSchema != null) {
            string = this.rowAttrSchema.getName();
        }
        return string == null ? "" : string;
    }

    public int getAttrSyntax() {
        int n = AMDisplayTypeConverter.DEFAULT_SYNTAX;
        if (this.rowAttrSchema != null) {
            n = AMDisplayTypeConverter.getDisplaySyntax(this.rowAttrSchema);
        }
        return n;
    }

    public Set getAttrValues() {
        String string;
        Set set = Collections.EMPTY_SET;
        if (this.rowAttrSchema != null && (string = this.rowAttrSchema.getName()) != null && string.length() > 0) {
            Map map = null;
            if (this.currentType == 0) {
                map = this.globalAttrs;
            } else if (this.currentType == 1) {
                map = this.orgAttrs;
            } else if (this.currentType == 2) {
                map = this.dynAttrs;
            }
            if (map != null) {
                set = (Set)map.get(string);
                if (set == null) {
                    set = (Set)map.get(string.toLowerCase());
                }
                if (set == null) {
                    set = Collections.EMPTY_SET;
                } else if (this.rowAttrSchema.getSyntax() == AttributeSchema.Syntax.DATE) {
                    set = this.getDateInUserLocale(set);
                }
            }
        }
        return set;
    }

    private Map getDisplayOptions() {
        Map map = null;
        if (!this.isServiceDenied()) {
            AMAttributeDisplayImpl aMAttributeDisplayImpl = new AMAttributeDisplayImpl(this.dpStoreConn, this.ssoToken);
            try {
                map = aMAttributeDisplayImpl.getServiceDisplayOptions(this.svcName, this.svcSchemaMgr, this.dpUser);
                if (AMModelBase.debug.messageEnabled()) {
                    AMModelBase.debug.message("getDisplayOptions: " + map);
                }
            }
            catch (AMException aMException) {
                AMModelBase.debug.warning("Error getting display options", (Throwable)aMException);
            }
            catch (SMSException sMSException) {
                AMModelBase.debug.warning("Error getting display options", (Throwable)sMSException);
            }
            catch (SSOException sSOException) {
                AMModelBase.debug.warning("Error getting display options", (Throwable)sSOException);
            }
        }
        if (map == null) {
            map = new HashMap(1);
        }
        return map;
    }

    private boolean isServiceDenied() {
        if (this.svcSchemaMgr == null) {
            return true;
        }
        AMServiceDisplayModelImpl aMServiceDisplayModelImpl = new AMServiceDisplayModelImpl(this.dpStoreConn);
        Set set = Collections.EMPTY_SET;
        try {
            set = aMServiceDisplayModelImpl.getDeniedServices(this.dpUser);
        }
        catch (AMException aMException) {
            AMModelBase.debug.error("SMDataModelImpl.isServiceDenied", (Throwable)aMException);
        }
        catch (SSOException sSOException) {
            AMModelBase.debug.error("SMDataModelImpl.isServiceDenied", (Throwable)sSOException);
        }
        return set.contains(this.svcName);
    }

    private Set getDisplayedAttr(Set set) {
        if (this.attrOptions == null || this.attrOptions.isEmpty()) {
            return set;
        }
        HashSet<AttributeSchema> hashSet = new HashSet<AttributeSchema>(set.size());
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            AttributeSchema attributeSchema = (AttributeSchema)iterator.next();
            Set set2 = (Set)this.attrOptions.get(attributeSchema.getName());
            if (set2 == null || set2.isEmpty() || !set2.contains("display") && !set2.contains("readOnly") && !set2.contains("userReadOnly") && (this.getUserType() == 3 || !set2.contains("adminDisplay"))) continue;
            hashSet.add(attributeSchema);
        }
        return hashSet;
    }

    public boolean isAttrReadOnly(String string) {
        if (AMModelBase.debug.messageEnabled()) {
            AMModelBase.debug.message("isAttrReadOnly:attrOptions " + this.attrOptions);
        }
        if (this.attrOptions == null || this.attrOptions.isEmpty()) {
            return false;
        }
        Set set = (Set)this.attrOptions.get(string);
        if (set == null || set.isEmpty()) {
            return true;
        }
        if (set.contains("readOnly")) {
            return true;
        }
        if (set.contains("display") || set.contains("adminDisplay")) {
            return false;
        }
        return set.contains("userReadOnly");
    }

    public String getDynGUIAddToListEllipseBtnLabel() {
        return this.getLocalizedString("dynGUIAddToListEllipse.button");
    }

    public String getDynGUIEditListEllipseBtnLabel() {
        return this.getLocalizedString("dynGUIEditListEllipse.button");
    }

    public String getDynGUICopyListEllipseBtnLabel() {
        return this.getLocalizedString("dynGUICopyListEllipse.button");
    }

    public String getDynGUIRemoveFromListBtnLabel() {
        return this.getLocalizedString("dynGUIRemoveFromList.button");
    }

    public Set getDateInDefaultLocale(Set set) throws AMConsoleException {
        return super.getDateInDefaultLocale(set);
    }

    public Set getDateInUserLocale(Set set) {
        return super.getDateInUserLocale(set);
    }

    public Map getAttrRadioValues() {
        Map map = new HashMap(5);
        if (this.rowAttrSchema != null) {
            map = AMAdminUtils.getAttributeRadioValue(this.rowAttrSchema, this.svcResBundle);
        }
        return map;
    }

    public String getPropertiesViewBeanURL() {
        String string = "";
        if (this.rowAttrSchema != null) {
            string = this.rowAttrSchema.getPropertiesViewBeanURL();
        }
        return string;
    }

    public String getDynGUILinkLabel() {
        return this.getDynGUILinkBtnLabel(".link");
    }

    public String getDynGUIButtonLabel() {
        return this.getDynGUILinkBtnLabel(".button");
    }

    private String getDynGUILinkBtnLabel(String string) {
        String string2;
        String string3 = null;
        if (this.rowAttrSchema != null && (string2 = this.rowAttrSchema.getI18NKey()) != null) {
            string2 = string2 + string;
            string3 = Locale.getString((ResourceBundle)this.svcResBundle, (String)string2, (Debug)AMModelBase.debug);
        }
        return string3 == null ? "" : string3;
    }

    public String getSuccessMessage() {
        return this.getLocalizedString("updateServiceGeneric.message");
    }

    public String getGenericErrorMessage() {
        return this.getLocalizedString("serviceProfileError.message");
    }

    public boolean isPrimaryTitle() {
        int n = this.getLocationType();
        return n == 2 || n == 3;
    }

    public void addEncryptedAttribute(String string) {
        if (this.encryptedAttrs == null) {
            this.encryptedAttrs = new HashSet(5);
        }
        this.encryptedAttrs.add(string);
    }

    public void addPasswordAttribute(String string) {
        if (this.passwordAttrs == null) {
            this.passwordAttrs = new HashSet(5);
        }
        this.passwordAttrs.add(string);
    }

    public boolean isLocationRole() {
        return this.locationType == 6 || this.locationType == 8;
    }

    private boolean isEncryptedAttribute(String string) {
        return this.encryptedAttrs != null && this.encryptedAttrs.contains(string);
    }

    private boolean isPasswordAttribute(String string) {
        return this.isEncryptedAttribute(string) || this.passwordAttrs != null && this.passwordAttrs.contains(string);
    }

    private void removeAttrsNotInSet(List list, Set set) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            AttributeSchema attributeSchema = (AttributeSchema)iterator.next();
            if (set.contains(attributeSchema.getName())) continue;
            iterator.remove();
        }
    }

    public String getHelpAnchorTag() {
        if (this.svcResBundle == null) {
            this.getSvcResBundle();
        }
        return this.getHelpAnchorTag(this.svcResBundle, null);
    }

    public String getHelpDocURL() {
        if (this.svcResBundle == null) {
            this.getSvcResBundle();
        }
        return this.getHelpDocURL(this.svcResBundle);
    }
}

