/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.am.console.service.model;

import com.iplanet.am.console.base.model.AMConsoleException;
import com.iplanet.am.console.base.model.AMFormatUtils;
import com.iplanet.am.console.base.model.AMModelBase;
import com.iplanet.am.console.base.model.DynamicGUIGenerator;
import com.iplanet.am.console.components.view.html.DynamicGUI;
import com.iplanet.am.console.service.model.MAPConstants;
import com.iplanet.am.console.service.model.MAPModelBase;
import com.iplanet.am.console.service.model.MAPProfileModel;
import com.iplanet.am.console.settings.Setting;
import com.iplanet.services.cdm.DefaultClientTypesManager;
import com.iplanet.services.cdm.clientschema.AMClientCapData;
import com.iplanet.services.cdm.clientschema.AMClientCapException;
import com.sun.identity.sm.AttributeSchema;
import com.sun.identity.sm.SchemaType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;

public class MAPProfileModelImpl
extends MAPModelBase
implements MAPProfileModel,
MAPConstants {
    private static final String ADDITIONAL_PROPERTIES_CLASSIFICAIION = "additionalPropertiesNames";
    private boolean internalDB = false;
    private boolean readOnlyProfile = true;

    public MAPProfileModelImpl(HttpServletRequest httpServletRequest, Map map) {
        super(httpServletRequest, map);
        AMClientCapData aMClientCapData = this.getClientCapDataIntInstance();
        Map map2 = aMClientCapData.getProperties(this.getAssociatedClientType());
        this.internalDB = map2 != null;
        this.readOnlyProfile = this.internalDB && !this.isUserAgentSet();
    }

    public String[] getClassifications() {
        AMClientCapData aMClientCapData = this.getClientCapDataInstance();
        if (aMClientCapData != null) {
            return aMClientCapData.getClassifications();
        }
        return null;
    }

    public String getClassificationLocalizedName(String string) {
        String string2 = string;
        AttributeSchema attributeSchema = this.getAttributeSchemaFromSchemaManager(string, SchemaType.GLOBAL);
        if (attributeSchema != null) {
            string2 = this.getL10NStrFromSvcResourceBundle(attributeSchema.getI18NKey());
        }
        return string2;
    }

    public List getAttributeComponents(String string) throws AMConsoleException {
        String string2;
        Object object;
        String string3 = this.getAssociatedClientType();
        if (string3 == null) {
            return Collections.EMPTY_LIST;
        }
        Set set = this.getAttributeNames(string);
        Set set2 = this.getAttributeSchemas(set);
        DynamicGUIGenerator dynamicGUIGenerator = DynamicGUIGenerator.getInstance();
        List list = AMFormatUtils.sortAttrSchema(set2, this.getUserLocale());
        ArrayList<DynamicGUI> arrayList = new ArrayList<DynamicGUI>(list.size());
        if (string.equals(ADDITIONAL_PROPERTIES_CLASSIFICAIION)) {
            object = this.getAdditionalPropertyValues();
            if (object == null || object.isEmpty()) {
                object = new HashSet<String>(1);
                object.add("");
            }
            string2 = (String)set.iterator().next();
            this.attributeValues = new HashMap(2);
            this.attributeValues.put(string2, object);
        } else {
            object = this.getAttributeValues(set);
            if (this.attributeValues != null) {
                object.putAll(this.attributeValues);
            }
            this.attributeValues = object;
        }
        if (this.attributeValues != null) {
            object = list.iterator();
            while (object.hasNext()) {
                string2 = (AttributeSchema)object.next();
                DynamicGUI dynamicGUI = dynamicGUIGenerator.createDynamicGUI((AttributeSchema)string2, this.getMAPServiceName(), (Set)this.attributeValues.get(string2.getName()), this, Setting.ACTION_SERVICE);
                dynamicGUI.setReadOnly(this.isAttributeReadOnly(string2.getName()));
                arrayList.add(dynamicGUI);
            }
        }
        return arrayList;
    }

    private Map getAttributeValues(Set set) throws AMConsoleException {
        Map map = this.getPropertyValues(set);
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            if (map.keySet().contains(string)) continue;
            HashSet<String> hashSet = new HashSet<String>(1);
            AttributeSchema attributeSchema = this.getAttributeSchema(string);
            if (attributeSchema.getSyntax().equals((Object)AttributeSchema.Syntax.BOOLEAN)) {
                hashSet.add("false");
            } else {
                hashSet.add("");
            }
            map.put(string, hashSet);
        }
        return map;
    }

    private Set getAttributeNames(String string) {
        Set set = null;
        AMClientCapData aMClientCapData = this.getClientCapDataInstance();
        if (aMClientCapData != null) {
            set = aMClientCapData.getPropertyNames(string);
        }
        if (set == null) {
            set = Collections.EMPTY_SET;
        }
        return set;
    }

    protected boolean isAttributeReadOnly(String string) {
        return this.readOnlyProfile || string.equals("clientType") || string.equals("userAgent");
    }

    public boolean isDeviceProfileReadOnly() {
        return this.readOnlyProfile;
    }

    public boolean isClientOverride(String string) {
        return this.getClientCapDataExtInstance().isClientPresent(string) && this.getClientCapDataIntInstance().isClientPresent(string);
    }

    public void setAttributeValues(Map map) {
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            Set set = (Set)map.get(string);
            if (set != null && !set.isEmpty()) continue;
            HashSet<String> hashSet = new HashSet<String>(1);
            hashSet.add("");
            map.put(string, hashSet);
        }
        this.attributeValues = map;
    }

    public void modifyDevice() throws AMConsoleException {
        Map map = this.getAttributeValues(this.attributeValues.keySet());
        Map map2 = this.diffMaps(map, this.attributeValues);
        map2 = this.removeReadOnlyValues(map2);
        this.addClientTypeValuesToMap(map2);
        try {
            DefaultClientTypesManager defaultClientTypesManager = this.getClientTypesManager();
            defaultClientTypesManager.modifyClientExternal(this.ssoToken, map2);
        }
        catch (AMClientCapException aMClientCapException) {
            AMModelBase.debug.warning("MAPProfileModelImpl.modifyDevice", (Throwable)aMClientCapException);
            throw new AMConsoleException(this.getErrorString((Exception)((Object)aMClientCapException)));
        }
    }

    private Map diffMaps(Map map, Map map2) {
        HashMap<String, Set> hashMap = new HashMap<String, Set>(map2.size());
        Iterator iterator = map2.keySet().iterator();
        while (iterator.hasNext()) {
            Set set;
            Set set2;
            String string = (String)iterator.next();
            if (this.isAttributeReadOnly(string) || (set2 = (Set)map2.get(string)).equals(set = (Set)map.get(string))) continue;
            if (AMModelBase.debug.messageEnabled()) {
                AMModelBase.debug.message("MAPProfileModelImpl.diffMaps: value of " + string + " is altered");
            }
            hashMap.put(string, set2);
        }
        return hashMap;
    }

    private Map removeReadOnlyValues(Map map) {
        HashMap hashMap = new HashMap(map.size());
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            if (this.isAttributeReadOnly(string)) continue;
            hashMap.put(string, map.get(string));
        }
        return hashMap;
    }

    private AMClientCapData getClientCapDataInstance() {
        return this.internalDB ? this.getClientCapDataIntInstance() : this.getClientCapDataExtInstance();
    }

    private boolean isUserAgentSet() {
        Map map;
        boolean bl = true;
        AMClientCapData aMClientCapData = this.getClientCapDataInstance();
        if (aMClientCapData != null && (map = aMClientCapData.getProperties(this.getAssociatedClientType())) != null) {
            Set set = (Set)map.get("userAgent");
            bl = set != null;
        }
        return bl;
    }
}

