/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.am.console.service.model;

import com.iplanet.am.console.base.model.AMConsoleException;
import com.iplanet.am.console.base.model.AMModelBase;
import com.iplanet.am.console.base.model.AMProfileModelBase;
import com.iplanet.am.console.base.model.AMResBundleCacher;
import com.iplanet.am.console.service.model.MAPConstants;
import com.iplanet.am.console.service.model.MAPModel;
import com.iplanet.am.sdk.AMException;
import com.iplanet.am.util.AMClientDetector;
import com.iplanet.am.util.Debug;
import com.iplanet.am.util.Locale;
import com.iplanet.services.cdm.Client;
import com.iplanet.services.cdm.DefaultClientTypesManager;
import com.iplanet.services.cdm.clientschema.AMClientCapData;
import com.iplanet.services.cdm.clientschema.AMClientCapException;
import com.iplanet.sso.SSOException;
import com.sun.identity.sm.AttributeSchema;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.SchemaType;
import com.sun.identity.sm.ServiceSchema;
import com.sun.identity.sm.ServiceSchemaManager;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import netscape.ldap.util.DN;

public abstract class MAPModelBase
extends AMProfileModelBase
implements MAPModel,
MAPConstants {
    private static char[] invalidCharacters = new char[DN.ESCAPED_CHAR.length + 5];
    private AMClientCapData clientCapDataIntInstance = null;
    private AMClientCapData clientCapDataExtInstance = null;
    private DefaultClientTypesManager clientTypesManager = (DefaultClientTypesManager)AMClientDetector.getClientTypesManagerInstance();
    private String mapServiceName;
    private String styleName;
    private String clientType;
    private ResourceBundle serviceResourceBundle = null;
    protected Map attributeValues;

    public MAPModelBase(HttpServletRequest httpServletRequest, Map map) {
        super(httpServletRequest, map);
        this.initClientCapDataInstance();
        if (this.clientCapDataIntInstance != null) {
            this.mapServiceName = this.clientCapDataIntInstance.getServiceName();
        }
        this.getServiceResourceBundle();
        this.styleName = (String)map.get("mapStyleName");
        this.clientType = httpServletRequest.getParameter("mapClientType");
        if (this.clientType == null || this.clientType.length() == 0) {
            this.clientType = (String)map.get("mapClientType");
        } else {
            map.put("mapClientType", this.clientType);
        }
    }

    private void getServiceResourceBundle() {
        try {
            String string = this.dpStoreConn.getI18NPropertiesFileName(this.mapServiceName);
            if (string != null && string.length() > 0) {
                this.serviceResourceBundle = AMResBundleCacher.getBundle(string, this.getUserLocale());
            }
        }
        catch (AMException aMException) {
            AMModelBase.debug.warning("MAPModelBase.getServiceResourceBundle", (Throwable)aMException);
        }
        catch (MissingResourceException missingResourceException) {
            AMModelBase.debug.warning("MAPModelBase.getServiceResourceBundle", (Throwable)missingResourceException);
        }
    }

    private void initClientCapDataInstance() {
        try {
            this.clientCapDataExtInstance = AMClientCapData.getExternalInstance();
            this.clientCapDataIntInstance = AMClientCapData.getInternalInstance();
        }
        catch (AMClientCapException aMClientCapException) {
            AMModelBase.debug.error("MAPModelBase.getClientCapDataInstance", (Throwable)aMClientCapException);
        }
    }

    protected static String canonicalize(String string) {
        int n = 0;
        while (n < invalidCharacters.length) {
            string = string.replace(invalidCharacters[n], '_');
            ++n;
        }
        return string;
    }

    protected static boolean isClientTypeValid(String string) {
        boolean bl = true;
        int n = 0;
        while (n < invalidCharacters.length && bl) {
            bl = string.indexOf(invalidCharacters[n]) == -1;
            ++n;
        }
        return bl;
    }

    protected String getL10NStrFromSvcResourceBundle(String string) {
        if (this.serviceResourceBundle != null) {
            return Locale.getString((ResourceBundle)this.serviceResourceBundle, (String)string, (Debug)AMModelBase.debug);
        }
        return string;
    }

    protected AMClientCapData getClientCapDataExtInstance() {
        return this.clientCapDataExtInstance;
    }

    protected AMClientCapData getClientCapDataIntInstance() {
        return this.clientCapDataIntInstance;
    }

    protected DefaultClientTypesManager getClientTypesManager() {
        return this.clientTypesManager;
    }

    protected String getMAPServiceName() {
        return this.mapServiceName;
    }

    protected String getAssociatedStyleName() {
        return this.styleName;
    }

    public String getAssociatedClientType() {
        return this.clientType;
    }

    public void setAttributeValues(Map map) {
        this.attributeValues = map;
    }

    protected Set getAttributeSchemas(Set set) {
        HashSet<AttributeSchema> hashSet = new HashSet<AttributeSchema>(set.size());
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            AttributeSchema attributeSchema = this.getAttributeSchema((String)iterator.next());
            if (attributeSchema == null) continue;
            hashSet.add(attributeSchema);
        }
        return hashSet;
    }

    protected AttributeSchema getAttributeSchema(String string) {
        AttributeSchema attributeSchema = null;
        if (this.clientCapDataIntInstance != null && this.clientCapDataExtInstance != null) {
            String string2;
            attributeSchema = this.clientCapDataIntInstance.getAttributeSchema(string);
            if (attributeSchema == null) {
                attributeSchema = this.clientCapDataExtInstance.getAttributeSchema(string);
            }
            if (attributeSchema != null && ((string2 = attributeSchema.getI18NKey()) == null || string2.length() == 0)) {
                attributeSchema = null;
            }
        }
        return attributeSchema;
    }

    protected AttributeSchema getAttributeSchemaFromSchemaManager(String string, SchemaType schemaType) {
        AttributeSchema attributeSchema = null;
        try {
            ServiceSchema serviceSchema;
            ServiceSchemaManager serviceSchemaManager = this.getServiceSchemaManager(this.mapServiceName);
            if (serviceSchemaManager != null && (serviceSchema = serviceSchemaManager.getSchema(schemaType)) != null) {
                attributeSchema = serviceSchema.getAttributeSchema(string);
            }
        }
        catch (SSOException sSOException) {
            AMModelBase.debug.warning("MAPModelBase.getAttributeSchemaFromSchemaManager", (Throwable)sSOException);
        }
        catch (SMSException sMSException) {
            AMModelBase.debug.warning("MAPModelBase.getAttributeSchemaFromSchemaManager", (Throwable)sMSException);
        }
        return attributeSchema;
    }

    protected void addClientTypeValuesToMap(Map map) {
        HashSet<String> hashSet = new HashSet<String>(1);
        hashSet.add(this.clientType);
        map.put("clientType", hashSet);
    }

    Map getPropertyValues(Set set) throws AMConsoleException {
        HashMap<String, Set> hashMap = Collections.EMPTY_MAP;
        if (set != null && !set.isEmpty()) {
            hashMap = new HashMap<String, Set>(set.size() * 2);
            String string = this.getAssociatedClientType();
            DefaultClientTypesManager defaultClientTypesManager = this.getClientTypesManager();
            if (defaultClientTypesManager != null && string != null) {
                Client client = defaultClientTypesManager.getClientInstance(string);
                if (client != null) {
                    Iterator iterator = set.iterator();
                    while (iterator.hasNext()) {
                        String string2 = (String)iterator.next();
                        Set set2 = client.getProperties(string2);
                        if (set2 == null || set2.isEmpty()) continue;
                        hashMap.put(string2, set2);
                    }
                } else {
                    throw new AMConsoleException(this.getLocalizedString("mapClientTypeNotFound.message"));
                }
            }
        }
        return hashMap;
    }

    Set getAdditionalPropertyValues() throws AMConsoleException {
        Set set = Collections.EMPTY_SET;
        String string = this.getAssociatedClientType();
        DefaultClientTypesManager defaultClientTypesManager = this.getClientTypesManager();
        if (defaultClientTypesManager != null && string != null) {
            Client client = defaultClientTypesManager.getClientInstance(string);
            if (client != null) {
                set = client.getAdditionalProperties();
            } else {
                throw new AMConsoleException(this.getLocalizedString("mapClientTypeNotFound.message"));
            }
        }
        return set;
    }

    static {
        int n = 0;
        while (n < DN.ESCAPED_CHAR.length) {
            MAPModelBase.invalidCharacters[n] = DN.ESCAPED_CHAR[n];
            ++n;
        }
        MAPModelBase.invalidCharacters[n++] = 32;
        MAPModelBase.invalidCharacters[n++] = 47;
        MAPModelBase.invalidCharacters[n++] = 58;
        MAPModelBase.invalidCharacters[n++] = 61;
        MAPModelBase.invalidCharacters[n] = 92;
    }
}

