/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.am.console.service.model;

import com.iplanet.am.console.base.model.AMModelBase;
import com.iplanet.am.console.service.model.MAPClientDataModel;
import com.iplanet.am.util.AMClientDetector;
import com.iplanet.services.cdm.DefaultClientTypesManager;
import com.iplanet.services.cdm.clientschema.AMClientCapData;
import com.iplanet.services.cdm.clientschema.AMClientCapException;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;

public class MAPClientDataModelImpl
extends AMModelBase
implements MAPClientDataModel {
    private static final String CLASS_NAME = "MAPClientDataModelImpl";
    private static String DEFAULT_BASE_CLIENT = "HTML";
    private AMClientCapData internalDB = null;
    private AMClientCapData externalDB = null;
    private Set devices = Collections.EMPTY_SET;
    private DefaultClientTypesManager clientTypesManager = null;

    public MAPClientDataModelImpl(HttpServletRequest httpServletRequest, Map map) {
        super(httpServletRequest, map);
        this.initialize(httpServletRequest);
    }

    protected void initialize(HttpServletRequest httpServletRequest) {
        this.clientTypesManager = (DefaultClientTypesManager)AMClientDetector.getClientTypesManagerInstance();
        try {
            this.externalDB = AMClientCapData.getExternalInstance();
        }
        catch (AMClientCapException aMClientCapException) {
            AMModelBase.debug.error("MAPClientDataModelImplgetExternalDB:", (Throwable)aMClientCapException);
        }
        try {
            this.internalDB = AMClientCapData.getInternalInstance();
        }
        catch (AMClientCapException aMClientCapException) {
            AMModelBase.debug.error("MAPClientDataModelImplgetInternalDB:", (Throwable)aMClientCapException);
        }
    }

    public String getDefaultBase() {
        return DEFAULT_BASE_CLIENT;
    }

    public Set getBaseNames() {
        if (this.clientTypesManager != null) {
            return this.clientTypesManager.getBaseProfileNames();
        }
        return Collections.EMPTY_SET;
    }

    public Set getStyleNames(String string) {
        if (this.clientTypesManager != null) {
            return this.clientTypesManager.getStyles(string);
        }
        return Collections.EMPTY_SET;
    }

    public Set getDeviceNames(String string, String string2) {
        Map map;
        if (string == null) {
            string = this.getDefaultBase();
        }
        if (string2 == null) {
            string2 = string;
        }
        if (this.clientTypesManager != null && (map = this.clientTypesManager.getClients(string, string2)) != null) {
            this.devices = map.keySet();
        }
        return this.devices;
    }

    public int removeClient(String string) {
        int n = 0;
        try {
            n = this.clientTypesManager.removeClientExternal(this.ssoToken, string);
        }
        catch (AMClientCapException aMClientCapException) {
            AMModelBase.debug.error("MAPClientDataModelImplremoveClient:", (Throwable)aMClientCapException);
        }
        return n;
    }

    public boolean isClientExternal(String string) {
        if (this.externalDB != null) {
            return this.externalDB.isClientPresent(string);
        }
        return false;
    }

    public boolean isClientInternal(String string) {
        if (this.internalDB != null) {
            return this.internalDB.isClientPresent(string);
        }
        return false;
    }

    public String getStyleLabel() {
        return this.getLocalizedString("mapStyle.label");
    }

    public String getPropertiesLabel() {
        return this.getLocalizedString("mapProperties.label");
    }

    public String getDeviceLabel() {
        return this.getLocalizedString("mapClientType.label");
    }

    public String getActionLabel() {
        return this.getLocalizedString("mapAction.label");
    }

    public String getTitleLabel() {
        return this.getLocalizedString("map.title");
    }

    public String getCustomMessage() {
        return this.getLocalizedString("mapCustomize.message");
    }

    public String getCustomLabel() {
        return this.getLocalizedString("mapCustomize.label");
    }

    public String getFilterLabel() {
        return this.getLocalizedString("mapFilter.label");
    }

    public String getNewLabel() {
        return this.getLocalizedString("mapNewDevice.label");
    }

    public String getEditLabel() {
        return this.getLocalizedString("mapEdit.link");
    }

    public String getDeleteLabel() {
        return this.getLocalizedString("mapDelete.link");
    }

    public String getDefaultLabel() {
        return this.getLocalizedString("mapDefault.link");
    }

    public String getDuplicateLabel() {
        return this.getLocalizedString("mapDuplicate.link");
    }

    public String getNoDeviceMessage() {
        return this.getLocalizedString("mapNoDevice.message");
    }
}

