/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.am.console.policy.model;

import com.iplanet.am.console.base.model.AMConsoleException;
import com.iplanet.am.console.base.model.AMMenuValidator;
import com.iplanet.am.console.base.model.AMMenuValidatorImpl;
import com.iplanet.am.console.base.model.AMModelBase;
import com.iplanet.am.console.base.model.AMProfileModelBase;
import com.iplanet.am.console.policy.model.PMCachedPolicy;
import com.iplanet.am.console.policy.model.PMPolicyCacher;
import com.iplanet.am.console.policy.model.PMProfileModel;
import com.iplanet.am.console.settings.Setting;
import com.iplanet.am.util.Debug;
import com.iplanet.am.util.Locale;
import com.iplanet.sso.SSOException;
import com.sun.identity.policy.ActionSchema;
import com.sun.identity.policy.NoPermissionException;
import com.sun.identity.policy.Policy;
import com.sun.identity.policy.PolicyException;
import com.sun.identity.policy.PolicyManager;
import com.sun.identity.policy.ResourceManager;
import com.sun.identity.policy.ServiceTypeManager;
import com.sun.identity.sm.AttributeSchema;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;

public abstract class PMProfileModelBase
extends AMProfileModelBase
implements PMProfileModel {
    private PolicyManager policyMgr = null;
    protected String cachedID = "";
    protected Policy policy = null;
    protected boolean modified = false;
    static /* synthetic */ Class class$com$iplanet$am$console$policy$PMProfileGeneralViewBean;
    static /* synthetic */ Class class$com$iplanet$am$console$policy$PMProfileRulesViewBean;
    static /* synthetic */ Class class$com$iplanet$am$console$policy$PMProfileSubjectsViewBean;
    static /* synthetic */ Class class$com$iplanet$am$console$policy$PMProfileReferralsViewBean;
    static /* synthetic */ Class class$com$iplanet$am$console$policy$PMProfileConditionsViewBean;

    public PMProfileModelBase(HttpServletRequest httpServletRequest, Map map) {
        super(httpServletRequest, map);
        PMPolicyCacher pMPolicyCacher = PMPolicyCacher.getInstance();
        this.cachedID = (String)map.get("am-cached_policy_id");
        if (this.cachedID == null) {
            String string = httpServletRequest.getParameter("Policy");
            if (string != null && string.length() > 0) {
                this.policy = this.getPolicy(string);
                if (this.policy != null) {
                    this.cachedID = pMPolicyCacher.cachePolicy(this.ssoToken, new PMCachedPolicy(this.policy));
                    map.put("am-cached_policy_id", this.cachedID);
                }
            }
        } else {
            PMCachedPolicy pMCachedPolicy = pMPolicyCacher.getPolicy(this.ssoToken, this.cachedID);
            if (pMCachedPolicy != null) {
                this.modified = pMCachedPolicy.isPolicyModified();
                this.policy = pMCachedPolicy.getPolicy();
            }
        }
    }

    public void clearCachedPolicy() {
        PMPolicyCacher pMPolicyCacher = PMPolicyCacher.getInstance();
        pMPolicyCacher.clearCachedPolicy(this.ssoToken, this.cachedID);
        this.cachedID = null;
        this.policy = null;
        this.modified = false;
    }

    public String getPolicyCachedID() {
        return this.cachedID;
    }

    public String getPolicyName() {
        String string = "";
        if (this.policy != null) {
            return this.policy.getName();
        }
        return string;
    }

    public String getCreatePolicyTitle() {
        return this.getLocalizedString("createPolicy.title");
    }

    public String getShowLabel() {
        return this.getLocalizedString("view.label");
    }

    public String getViewTypeLocalizedName(String string) {
        String string2 = this.getLocalizedString("general-menuitem.label");
        if (string.equals("rules")) {
            string2 = this.getLocalizedString("rules-menuitem.label");
        } else if (string.equals("subjects")) {
            string2 = this.getLocalizedString("subjects-menuitem.label");
        } else if (string.equals("referrals")) {
            string2 = this.getLocalizedString("referrals-menuitem.label");
        } else if (string.equals("conditions")) {
            string2 = this.getLocalizedString("conditions-menuitem.label");
        }
        return string2;
    }

    public void addPolicy() throws AMConsoleException {
        PolicyManager policyManager = this.getPolicyManager();
        if (policyManager != null && this.policy != null) {
            try {
                policyManager.addPolicy(this.policy);
                this.writeFormatLog("policyCreated.message", this.policy.getName(), this.locationDN);
                PMPolicyCacher pMPolicyCacher = PMPolicyCacher.getInstance();
                PMCachedPolicy pMCachedPolicy = pMPolicyCacher.getPolicy(this.ssoToken, this.cachedID);
                if (pMCachedPolicy != null) {
                    pMCachedPolicy.setPolicyModified(false);
                }
                this.modified = false;
            }
            catch (PolicyException policyException) {
                throw new AMConsoleException(this.getErrorString((Exception)((Object)policyException)));
            }
            catch (SSOException sSOException) {
                throw new AMConsoleException(this.getErrorString((Exception)((Object)sSOException)));
            }
        }
    }

    private Policy getPolicy(String string) {
        Policy policy = null;
        try {
            PolicyManager policyManager = this.getPolicyManager();
            if (policyManager != null && string != null && string.length() > 0) {
                policy = policyManager.getPolicy(string);
            }
        }
        catch (PolicyException policyException) {
            AMModelBase.debug.error("PMPorfileModelBase.getPolicy", (Throwable)policyException);
        }
        catch (SSOException sSOException) {
            AMModelBase.debug.error("PMPorfileModelBase.getPolicy", (Throwable)sSOException);
        }
        catch (AMConsoleException aMConsoleException) {
            AMModelBase.debug.error("PMPorfileModelBase.getPolicy", (Throwable)aMConsoleException);
        }
        return policy;
    }

    protected PolicyManager getPolicyManager() throws AMConsoleException {
        if (this.policyMgr == null) {
            try {
                this.policyMgr = new PolicyManager(this.ssoToken, this.locationDN);
            }
            catch (SSOException sSOException) {
                AMModelBase.debug.error("PMPorfileModelBase.getPolicyManager", (Throwable)sSOException);
                throw new AMConsoleException(this.getErrorString((Exception)((Object)sSOException)));
            }
            catch (PolicyException policyException) {
                AMModelBase.debug.error("PMPorfileModelBase.getPolicyManager", (Throwable)policyException);
                throw new AMConsoleException(this.getErrorString((Exception)((Object)policyException)));
            }
        }
        return this.policyMgr;
    }

    public void replacePolicy() throws AMConsoleException {
        try {
            PolicyManager policyManager = this.getPolicyManager();
            if (policyManager != null && this.policy != null) {
                policyManager.replacePolicy(this.policy);
                PMPolicyCacher pMPolicyCacher = PMPolicyCacher.getInstance();
                PMCachedPolicy pMCachedPolicy = pMPolicyCacher.getPolicy(this.ssoToken, this.cachedID);
                if (pMCachedPolicy != null) {
                    pMCachedPolicy.setPolicyModified(false);
                    pMCachedPolicy.setTrackPolicyName(this.policy.getName());
                }
                this.modified = false;
                this.writeLog(this.policy.getName(), this.locationDN);
            }
        }
        catch (PolicyException policyException) {
            throw new AMConsoleException(this.getErrorString((Exception)((Object)policyException)));
        }
        catch (SSOException sSOException) {
            throw new AMConsoleException(this.getErrorString((Exception)((Object)sSOException)));
        }
    }

    public void refreshCachedPolicy() throws AMConsoleException {
        PMPolicyCacher pMPolicyCacher = PMPolicyCacher.getInstance();
        PMCachedPolicy pMCachedPolicy = pMPolicyCacher.getPolicy(this.ssoToken, this.cachedID);
        this.policy = this.getPolicy(pMCachedPolicy.getTrackPolicyName());
        if (this.policy == null) {
            throw new AMConsoleException(this.getLocalizedString("policyNotFound.message"));
        }
        pMPolicyCacher.setPolicy(this.ssoToken, this.cachedID, new PMCachedPolicy(this.policy));
        this.modified = false;
    }

    public boolean isReferralPolicy() {
        boolean bl = true;
        if (this.policy != null) {
            bl = this.policy.isReferralPolicy();
        }
        return bl;
    }

    public String getDynGUIAddToListBtnLabel() {
        return this.getLocalizedString("dynGUIAddToList.button");
    }

    public String getDynGUIAddToListEllipseBtnLabel() {
        return this.getLocalizedString("dynGUIAddToListEllipse.button");
    }

    public String getDynGUIEditListEllipseBtnLabel() {
        return this.getLocalizedString("dynGUIEditListEllipse.button");
    }

    public String getDynGUICopyListEllipseBtnLabel() {
        return this.getLocalizedString("dynGUICopyListEllipse.button");
    }

    public String getDynGUIRemoveFromListBtnLabel() {
        return this.getLocalizedString("dynGUIRemoveFromList.button");
    }

    public String getConfirmPwdLabel() {
        return this.getLocalizedString("dynGUIConfirmPassword.label");
    }

    public String getPasswordMismatchMessage() {
        return this.getLocalizedString("passwordMismatch.message");
    }

    public String getAlertTitle() {
        return this.getLocalizedString("alertMessage.title");
    }

    protected Map getAttributeRadioValue(ActionSchema actionSchema, ResourceBundle resourceBundle) {
        Map map = new HashMap(0);
        AttributeSchema.UIType uIType = actionSchema.getUIType();
        AttributeSchema.Syntax syntax = actionSchema.getSyntax();
        if (uIType != null && uIType == AttributeSchema.UIType.RADIO) {
            map = syntax == AttributeSchema.Syntax.BOOLEAN ? this.getAttributeRadioBooleanValue(actionSchema, resourceBundle) : this.getAttributeRadioOptionValue(actionSchema, resourceBundle);
        }
        return map;
    }

    private Map getAttributeRadioBooleanValue(ActionSchema actionSchema, ResourceBundle resourceBundle) {
        String string;
        HashMap<String, String> hashMap = new HashMap<String, String>(2);
        String string2 = actionSchema.getTrueValue();
        String string3 = actionSchema.getFalseValue();
        if (string2 == null) {
            string2 = "true";
        }
        if (string3 == null) {
            string3 = "false";
        }
        String string4 = actionSchema.getTrueValueI18NKey();
        String string5 = actionSchema.getFalseValueI18NKey();
        if (string4 != null) {
            string = Locale.getString((ResourceBundle)resourceBundle, (String)string4, (Debug)AMModelBase.debug);
            if (string == null || string.length() == 0) {
                hashMap.put(string2, string2);
            } else {
                hashMap.put(string, string2);
            }
        } else {
            hashMap.put(string2, string2);
        }
        if (string5 != null) {
            string = Locale.getString((ResourceBundle)resourceBundle, (String)string5, (Debug)AMModelBase.debug);
            if (string == null || string.length() == 0) {
                hashMap.put(string3, string3);
            } else {
                hashMap.put(string, string3);
            }
        } else {
            hashMap.put(string3, string3);
        }
        return hashMap;
    }

    private Map getAttributeRadioOptionValue(ActionSchema actionSchema, ResourceBundle resourceBundle) {
        HashMap<String, String> hashMap = null;
        String[] stringArray = actionSchema.getChoiceValues();
        if (stringArray != null && stringArray.length > 0) {
            int n = stringArray.length;
            hashMap = new HashMap(n);
            int n2 = 0;
            while (n2 < n) {
                String string = stringArray[n2];
                String string2 = actionSchema.getChoiceValueI18NKey(string);
                if (string2 != null && string2.length() > 0) {
                    hashMap.put(Locale.getString((ResourceBundle)resourceBundle, (String)string2, (Debug)AMModelBase.debug), string);
                }
                ++n2;
            }
        } else {
            hashMap = new HashMap<String, String>(0);
        }
        return hashMap;
    }

    public String getEditLabel() {
        return this.getLocalizedString("editTitle.label");
    }

    public String getSaveSucceededMsg() {
        return this.getLocalizedString("updatePolicy.message");
    }

    public void addLoggingMsgData(String string, String string2, String string3, String string4, int n, String string5) {
        if (this.cachedID != null && this.logger.isEnabled()) {
            PMPolicyCacher pMPolicyCacher = PMPolicyCacher.getInstance();
            PMCachedPolicy pMCachedPolicy = pMPolicyCacher.getPolicy(this.ssoToken, this.cachedID);
            pMCachedPolicy.addLoggingMsgData(string, string2, string3, string4, n, string5);
        }
    }

    private void writeLog(String string, String string2) {
        if (this.cachedID != null && this.logger.isEnabled()) {
            PMPolicyCacher pMPolicyCacher = PMPolicyCacher.getInstance();
            PMCachedPolicy pMCachedPolicy = pMPolicyCacher.getPolicy(this.ssoToken, this.cachedID);
            Set set = pMCachedPolicy.getLoggingMsg(this, string, string2);
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                this.logger.doLog((String)iterator.next());
            }
            pMCachedPolicy.clearMsg();
        }
    }

    public boolean isPolicyModified() {
        return this.modified;
    }

    public String getPolicyModifiedTitle() {
        return this.getLocalizedString("policyIsModified.title");
    }

    public String getPolicyModifiedMessage() {
        return this.getLocalizedString("policyIsModified.message");
    }

    protected void markPolicyModified() {
        PMPolicyCacher pMPolicyCacher;
        PMCachedPolicy pMCachedPolicy;
        if (this.cachedID != null && (pMCachedPolicy = (pMPolicyCacher = PMPolicyCacher.getInstance()).getPolicy(this.ssoToken, this.cachedID)) != null) {
            pMCachedPolicy.setPolicyModified(true);
            this.modified = true;
        }
    }

    public List getSubViews() {
        ArrayList<String> arrayList = new ArrayList<String>(4);
        arrayList.add("general");
        arrayList.add("rules");
        if (this.isReferralPolicy()) {
            arrayList.add("referrals");
        } else {
            arrayList.add("subjects");
            arrayList.add("conditions");
        }
        AMMenuValidator aMMenuValidator = AMMenuValidatorImpl.getInstance();
        Set set = aMMenuValidator.getPolicyProfileMenuOptions(this);
        if (set != null) {
            if (!set.isEmpty()) {
                Iterator iterator = arrayList.iterator();
                while (iterator.hasNext()) {
                    if (set.contains(iterator.next())) continue;
                    iterator.remove();
                }
            } else {
                arrayList.clear();
            }
        }
        return arrayList;
    }

    public String getDefaultSubView() {
        String string;
        String string2 = "general";
        Set set = this.getUserSettings(Setting.DEFAULT_POLICY_PROFILE_VIEW);
        if (set != null && !set.isEmpty() && ((string = (String)set.iterator().next()).equals("rules") || string.equals("referrals") || string.equals("subjects") || string.equals("conditions"))) {
            string2 = string;
        }
        return string2;
    }

    public Class getViewBeanTypeClass(String string) {
        Class clazz;
        Class clazz2 = clazz = class$com$iplanet$am$console$policy$PMProfileGeneralViewBean == null ? (class$com$iplanet$am$console$policy$PMProfileGeneralViewBean = PMProfileModelBase.class$("com.iplanet.am.console.policy.PMProfileGeneralViewBean")) : class$com$iplanet$am$console$policy$PMProfileGeneralViewBean;
        if (string.equals("rules")) {
            clazz = class$com$iplanet$am$console$policy$PMProfileRulesViewBean == null ? (class$com$iplanet$am$console$policy$PMProfileRulesViewBean = PMProfileModelBase.class$("com.iplanet.am.console.policy.PMProfileRulesViewBean")) : class$com$iplanet$am$console$policy$PMProfileRulesViewBean;
        } else if (string.equals("subjects")) {
            clazz = class$com$iplanet$am$console$policy$PMProfileSubjectsViewBean == null ? (class$com$iplanet$am$console$policy$PMProfileSubjectsViewBean = PMProfileModelBase.class$("com.iplanet.am.console.policy.PMProfileSubjectsViewBean")) : class$com$iplanet$am$console$policy$PMProfileSubjectsViewBean;
        } else if (string.equals("referrals")) {
            clazz = class$com$iplanet$am$console$policy$PMProfileReferralsViewBean == null ? (class$com$iplanet$am$console$policy$PMProfileReferralsViewBean = PMProfileModelBase.class$("com.iplanet.am.console.policy.PMProfileReferralsViewBean")) : class$com$iplanet$am$console$policy$PMProfileReferralsViewBean;
        } else if (string.equals("conditions")) {
            clazz = class$com$iplanet$am$console$policy$PMProfileConditionsViewBean == null ? (class$com$iplanet$am$console$policy$PMProfileConditionsViewBean = PMProfileModelBase.class$("com.iplanet.am.console.policy.PMProfileConditionsViewBean")) : class$com$iplanet$am$console$policy$PMProfileConditionsViewBean;
        }
        return clazz;
    }

    public boolean isPolicyExists() {
        return this.policy != null;
    }

    public String getInvalidPolicyMessage() {
        return this.getLocalizedString("invalidPolicyProfile.message");
    }

    public boolean canSaveProfile() {
        return this.canCreateNewResource() || this.hasReferredResources();
    }

    private boolean canCreateNewResource() {
        Set set;
        ResourceManager resourceManager;
        boolean bl = false;
        PolicyManager policyManager = null;
        try {
            policyManager = this.getPolicyManager();
        }
        catch (AMConsoleException aMConsoleException) {
            AMModelBase.debug.message("PMProfileModelBase.canCreateNewResource", (Throwable)aMConsoleException);
        }
        if (policyManager != null && (resourceManager = policyManager.getResourceManager()) != null && (set = this.getServiceTypeNames()) != null && !set.isEmpty()) {
            Iterator iterator = set.iterator();
            while (iterator.hasNext() && !bl) {
                String string = (String)iterator.next();
                try {
                    bl = resourceManager.canCreateNewResource(string);
                }
                catch (PolicyException policyException) {
                    AMModelBase.debug.error("PMProfileModelBase.canCreateNewResource", (Throwable)policyException);
                }
            }
        }
        return bl;
    }

    private boolean hasReferredResources() {
        boolean bl;
        block4: {
            bl = false;
            PolicyManager policyManager = null;
            try {
                policyManager = this.getPolicyManager();
            }
            catch (AMConsoleException aMConsoleException) {
                AMModelBase.debug.message("PMProfileModelBase.hasReferredResources", (Throwable)aMConsoleException);
            }
            if (policyManager == null) break block4;
            try {
                ResourceManager resourceManager = policyManager.getResourceManager();
                Set set = resourceManager.getManagedResourceNames();
                bl = set != null && set.size() > 0;
            }
            catch (PolicyException policyException) {
                AMModelBase.debug.error("PMProfileModelBase.hasReferredResources", (Throwable)policyException);
            }
        }
        return bl;
    }

    private Set getServiceTypeNames() {
        Set set = null;
        try {
            ServiceTypeManager serviceTypeManager = new ServiceTypeManager(this.ssoToken);
            set = serviceTypeManager.getServiceTypeNames();
        }
        catch (SSOException sSOException) {
            AMModelBase.debug.warning("PMProfileModelBase.getServiceTypeNames", (Throwable)sSOException);
        }
        catch (NoPermissionException noPermissionException) {
            AMModelBase.debug.warning("PMProfileModelBase.getServiceTypeNames", (Throwable)noPermissionException);
        }
        return set == null ? Collections.EMPTY_SET : set;
    }

    public boolean hasPolicyNameChanged() {
        PMPolicyCacher pMPolicyCacher;
        PMCachedPolicy pMCachedPolicy;
        boolean bl = false;
        if (this.cachedID != null && this.policy != null && (pMCachedPolicy = (pMPolicyCacher = PMPolicyCacher.getInstance()).getPolicy(this.ssoToken, this.cachedID)) != null) {
            String string;
            String string2 = this.policy.getName();
            bl = !string2.equals(string = pMCachedPolicy.getTrackPolicyName());
        }
        return bl;
    }

    public String getRuleLabel() {
        return this.getLocalizedString("rules-menuitem.label");
    }

    public String getConditionLabel() {
        return this.getLocalizedString("conditions-menuitem.label");
    }

    public String getSubjectLabel() {
        return this.getLocalizedString("subjects-menuitem.label");
    }

    public String getReferralLabel() {
        return this.getLocalizedString("referrals-menuitem.label");
    }

    public String getWizardInformation(String string) {
        return this.getLocalizedString("selectType.message");
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

