/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.am.console.policy.model;

import com.iplanet.am.console.base.model.AMConsoleException;
import com.iplanet.am.console.base.model.AMModelBase;
import com.iplanet.am.console.policy.model.PMCachedPolicy;
import com.iplanet.am.console.policy.model.PMNavViewModelBase;
import com.iplanet.am.console.policy.model.PMPolicyCacher;
import com.iplanet.am.console.policy.model.PMPolicyNavViewModel;
import com.iplanet.am.console.settings.Setting;
import com.iplanet.am.sdk.AMException;
import com.iplanet.am.sdk.AMTemplate;
import com.iplanet.am.util.OrderedSet;
import com.iplanet.sso.SSOException;
import com.sun.identity.policy.NameNotFoundException;
import com.sun.identity.policy.NoPermissionException;
import com.sun.identity.policy.Policy;
import com.sun.identity.policy.PolicyException;
import com.sun.identity.policy.PolicyManager;
import com.sun.identity.policy.ResourceManager;
import com.sun.identity.policy.ServiceTypeManager;
import com.sun.identity.sm.SchemaType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;

public class PMPolicyNavViewModelImpl
extends PMNavViewModelBase
implements PMPolicyNavViewModel {
    private PolicyManager policyMgr = null;
    private Set policies = null;
    private String searchError = null;

    public PMPolicyNavViewModelImpl(HttpServletRequest httpServletRequest, Map map) {
        super(httpServletRequest, map);
    }

    public boolean hasPolicies(String string) {
        boolean bl;
        block3: {
            bl = false;
            try {
                this.policies = this.getPolicies(string);
                if (this.policies != null && !this.policies.isEmpty()) {
                    bl = true;
                }
            }
            catch (AMConsoleException aMConsoleException) {
                if (!AMModelBase.debug.warningEnabled()) break block3;
                AMModelBase.debug.warning("PMPolicyNavViewModelImpl.hasPolicies, ", (Throwable)aMConsoleException);
            }
        }
        return bl;
    }

    public Set getPolicies(String string) throws AMConsoleException {
        if (this.policies == null) {
            this.policies = Collections.EMPTY_SET;
            try {
                Set set;
                PolicyManager policyManager = this.getPolicyManager();
                if (policyManager != null && (set = policyManager.getPolicyNames(string)) != null) {
                    this.policies = this.getPolicyData(set);
                }
            }
            catch (SSOException sSOException) {
                AMModelBase.debug.warning("PMPolicyNavViewModelImpl.getPolicies", (Throwable)sSOException);
                throw new AMConsoleException(this.getErrorString((Exception)((Object)sSOException)));
            }
            catch (NameNotFoundException nameNotFoundException) {
                AMModelBase.debug.warning("PMPolicyNavViewModelImpl.getPolicies", (Throwable)nameNotFoundException);
                throw new AMConsoleException(this.getErrorString((Exception)((Object)nameNotFoundException)));
            }
            catch (PolicyException policyException) {
                AMModelBase.debug.warning("PMPolicyNavViewModelImpl.getPolicies", (Throwable)policyException);
                throw new AMConsoleException(this.getErrorString((Exception)((Object)policyException)));
            }
        }
        return this.policies;
    }

    public String getSelectLabel() {
        return this.getLocalizedString("select.label");
    }

    public String getPropertiesLabel() {
        return this.getLocalizedString("properties.label");
    }

    public String getCreateBtnLabel() {
        return this.getLocalizedString("new.button");
    }

    public String getDeleteSelectedBtnLabel() {
        return this.getLocalizedString("deleteSelected.button");
    }

    public List deletePolicies(List list) {
        ArrayList<String> arrayList = new ArrayList<String>(list.size());
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            if (this.deletePolicy(string)) continue;
            arrayList.add(string);
        }
        return arrayList;
    }

    private boolean deletePolicy(String string) {
        boolean bl;
        block4: {
            bl = false;
            PolicyManager policyManager = this.getPolicyManager();
            if (policyManager == null) break block4;
            try {
                policyManager.removePolicy(string);
                bl = true;
                this.writeFormatLog("policyDeleted.message", string, this.locationDN);
            }
            catch (SSOException sSOException) {
                AMModelBase.debug.error("PMPolicyNavViewModelImpl.deletePolicy", (Throwable)sSOException);
            }
            catch (NoPermissionException noPermissionException) {
                AMModelBase.debug.error("PMPolicyNavViewModelImpl.deletePolicy", (Throwable)noPermissionException);
            }
            catch (PolicyException policyException) {
                if (!AMModelBase.debug.warningEnabled()) break block4;
                AMModelBase.debug.warning("PMPolicyNavViewModelImpl.deletePolicy", (Throwable)policyException);
            }
        }
        return bl;
    }

    private PolicyManager getPolicyManager() {
        block3: {
            if (this.policyMgr != null) break block3;
            try {
                this.policyMgr = new PolicyManager(this.ssoToken, this.locationDN);
            }
            catch (SSOException sSOException) {
                AMModelBase.debug.error("PMPolicyNavViewModelImpl.getPolicyManager", (Throwable)sSOException);
            }
            catch (PolicyException policyException) {
                AMModelBase.debug.error("PMPolicyNavViewModelImpl.getPolicyManager", (Throwable)policyException);
            }
        }
        return this.policyMgr;
    }

    public String getDeletePolicyFailTitle() {
        return this.getLocalizedString("warningMessage.title");
    }

    public String getDeletePolicyFailMessage() {
        return this.getLocalizedString("deletePolicyFail.message");
    }

    public boolean hasReferredResources() {
        boolean bl;
        block2: {
            bl = false;
            PolicyManager policyManager = this.getPolicyManager();
            if (policyManager == null) break block2;
            try {
                ResourceManager resourceManager = policyManager.getResourceManager();
                Set set = resourceManager.getManagedResourceNames();
                bl = set != null && set.size() > 0;
            }
            catch (PolicyException policyException) {
                AMModelBase.debug.error("PMPolicyNavViewModelImpl.hasReferredResources", (Throwable)policyException);
            }
        }
        return bl;
    }

    public String getCannotCreatePolicyTitle() {
        return this.getLocalizedString("cannotCreatePolicy.title");
    }

    public String getNoReferralForOrgMessage() {
        return this.getLocalizedString("noReferralForOrg.message");
    }

    public boolean hasPolicyConfigSvcRegistered() {
        block3: {
            try {
                AMTemplate aMTemplate = this.getServiceTemplate("iPlanetAMPolicyConfigService", SchemaType.ORGANIZATION);
                return aMTemplate != null;
            }
            catch (AMException aMException) {
                if (!AMModelBase.debug.warningEnabled()) break block3;
                AMModelBase.debug.warning("PMPolicyNavViewModelImpl.hasPolicyConfigSvcRegistered: cannot get service template for policy configuration service", (Throwable)aMException);
            }
            catch (SSOException sSOException) {
                if (!AMModelBase.debug.warningEnabled()) break block3;
                AMModelBase.debug.warning("PMPolicyNavViewModelImpl.hasPolicyConfigSvcRegistered: cannot get service template for policy configuration service", (Throwable)sSOException);
            }
        }
        return false;
    }

    public String getNoPolicyConfigSvcMessage() {
        return this.getLocalizedString("noPolicyConfigSvc.message");
    }

    public boolean canCreateNewResource() {
        Set set;
        ResourceManager resourceManager;
        boolean bl = false;
        PolicyManager policyManager = this.getPolicyManager();
        if (policyManager != null && (resourceManager = policyManager.getResourceManager()) != null && (set = this.getServiceTypeNames()) != null && set.size() > 0) {
            Iterator iterator = set.iterator();
            while (iterator.hasNext() && !bl) {
                String string = (String)iterator.next();
                bl = this.canCreateNewResForSvc(resourceManager, string);
            }
        }
        return bl;
    }

    private boolean canCreateNewResForSvc(ResourceManager resourceManager, String string) {
        boolean bl = false;
        try {
            bl = resourceManager.canCreateNewResource(string);
        }
        catch (PolicyException policyException) {
            AMModelBase.debug.error("PMPolicyNavViewModelImpl.canCreateNewResForSvc", (Throwable)policyException);
        }
        return bl;
    }

    private Set getServiceTypeNames() {
        Set set = null;
        try {
            ServiceTypeManager serviceTypeManager = new ServiceTypeManager(this.ssoToken);
            set = serviceTypeManager.getServiceTypeNames();
            if (set == null) {
                set = Collections.EMPTY_SET;
            }
        }
        catch (SSOException sSOException) {
            AMModelBase.debug.warning("PMPolicyNavViewModelImpl.getServiceTypeNames", (Throwable)sSOException);
        }
        catch (NoPermissionException noPermissionException) {
            AMModelBase.debug.warning("PMPolicyNavViewModelImpl.getServiceTypeNames", (Throwable)noPermissionException);
        }
        return set;
    }

    public String getCannotFindPolicyTitle() {
        return this.getLocalizedString("policyNotFound.title");
    }

    public String cachePolicy(String string) throws AMConsoleException {
        Policy policy = this.getPolicy(string);
        if (policy != null) {
            PMPolicyCacher pMPolicyCacher = PMPolicyCacher.getInstance();
            return pMPolicyCacher.cachePolicy(this.ssoToken, new PMCachedPolicy(policy));
        }
        throw new AMConsoleException(this.getLocalizedString("policyNotFound.message"));
    }

    private Policy getPolicy(String string) {
        Policy policy = null;
        PolicyManager policyManager = this.getPolicyManager();
        try {
            if (policyManager != null && string != null && string.length() > 0) {
                policy = policyManager.getPolicy(string);
            }
        }
        catch (PolicyException policyException) {
            AMModelBase.debug.error("PMPolicyNavViewModelImpl.getPolicy", (Throwable)policyException);
        }
        catch (SSOException sSOException) {
            AMModelBase.debug.error("PMPolicyNavViewModelImpl.getPolicy", (Throwable)sSOException);
        }
        return policy;
    }

    public String getSelectedOption() {
        return "policies";
    }

    public String getHeaderLabel() {
        return this.getLocalizedString("policies.header");
    }

    public String getNoEntrySelectedForDelTitle() {
        return this.getLocalizedString("noPolicySelectForDeletion.title");
    }

    public String getNoEntrySelectedForDelMessage() {
        return this.getLocalizedString("noPolicySelectForDeletion.message");
    }

    public Set getAttrList() {
        return this.policies;
    }

    public void setAttrList(Set set) {
        this.policies = set;
    }

    public int getPolicyCnt() {
        if (this.policies == null) {
            return 0;
        }
        return this.policies.size();
    }

    public Set getPolicyDisplayList(String string, int n, int n2) throws AMConsoleException {
        this.policies = this.getPolicies(string);
        Set set = Collections.EMPTY_SET;
        if (this.policies != null && !this.policies.isEmpty()) {
            int n3 = n;
            Object[] objectArray = this.policies.toArray();
            int n4 = objectArray.length;
            int n5 = n4 - n2;
            if (n3 > n5) {
                n3 = n5;
            }
            set = new OrderedSet();
            int n6 = n2;
            while (n6 < n3 + n2) {
                set.add(objectArray[n6]);
                ++n6;
            }
        }
        return set;
    }

    public String getSearchErrorMsg() {
        return this.searchError;
    }

    public String getErrorTitle() {
        return this.getLocalizedString("warningMessage.title");
    }

    private Set getPolicyData(Set set) {
        if (set == null) {
            return null;
        }
        int n = this.getSearchLimit();
        int n2 = set.size();
        if (n2 <= n) {
            this.policies = set;
        } else {
            this.searchError = this.getLocalizedString("sizeLimitExceeded.message");
            this.policies = new OrderedSet();
            Iterator iterator = set.iterator();
            int n3 = 0;
            while (n3 < n && iterator.hasNext()) {
                this.policies.add(iterator.next());
                ++n3;
            }
        }
        return this.policies;
    }

    public String getPoliciesDisplayOffMessage() {
        return this.getLocalizedString("policiesDisplayOff.message");
    }

    public boolean hasPrivilegeToViewPolicies() {
        return this.getPolicyManager() != null;
    }

    public String getNoPrivilegeMessage() {
        return this.getLocalizedString("noPrivilegeToViewPolicy.message");
    }

    public boolean canViewCurLocationProperties() {
        boolean bl = false;
        switch (this.locationType) {
            case 1: {
                bl = this.canPerform(Setting.ACTION_USER, "viewproperties");
                break;
            }
            case 2: {
                bl = this.canPerform(Setting.ACTION_ORGANIZATION, "viewproperties");
                break;
            }
            case 3: {
                bl = this.canPerform(Setting.ACTION_ORGANIZATIONAL_UNIT, "viewproperties");
                break;
            }
            case 4: {
                bl = this.canPerform(Setting.ACTION_GROUP_CONTAINER, "viewproperties");
                break;
            }
            case 5: {
                bl = this.canPerform(Setting.ACTION_PEOPLE_CONTAINER, "viewproperties");
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                bl = this.canPerform(Setting.ACTION_ROLE, "viewproperties");
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                bl = this.canPerform(Setting.ACTION_GROUP, "viewproperties");
                break;
            }
            case 13: 
            case 15: {
                bl = this.canPerform(Setting.ACTION_SERVICE, "viewproperties");
            }
            case 14: {
                bl = this.canPerform(Setting.ACTION_POLICY, "viewproperties");
                break;
            }
            default: {
                AMModelBase.debug.error("UMNavModelImpl.canViewCurLocationProperties: cannot process this object type, " + Integer.toString(this.locationType));
            }
        }
        return bl;
    }
}

