/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.am.console.policy.model;

import com.iplanet.am.console.base.model.AMFormatUtils;
import com.iplanet.am.console.base.model.AMModelBase;
import com.iplanet.am.console.policy.model.PMHomeViewModelImpl;
import com.iplanet.am.console.policy.model.PMNavViewModel;
import com.iplanet.am.sdk.AMException;
import com.iplanet.am.sdk.AMObject;
import com.iplanet.am.sdk.AMRole;
import com.iplanet.sso.SSOException;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;

public abstract class PMNavViewModelBase
extends PMHomeViewModelImpl
implements PMNavViewModel {
    public PMNavViewModelBase(HttpServletRequest httpServletRequest, Map map) {
        super(httpServletRequest, map);
        this.setOrganization();
    }

    public String getTitleString() {
        return AMFormatUtils.DNToName(this, this.locationDN);
    }

    public String getTypeLabel() {
        return this.getLocalizedString("view.label");
    }

    public String getFilterLabel() {
        return this.getLocalizedString("filter.label");
    }

    public String getSearchButtonLabel() {
        return this.getLocalizedString("search.button");
    }

    public String getFilterBtnLabel() {
        return this.getLocalizedString("filter.button");
    }

    public String getNameLabel() {
        return this.getLocalizedString("name.label");
    }

    private void setOrganization() {
        if (this.locationType != 2 && this.locationType != 3) {
            AMObject aMObject = this.getAMObjectObj();
            try {
                this.locationDN = aMObject != null ? aMObject.getOrganizationDN() : this.startDN;
            }
            catch (SSOException sSOException) {
                AMModelBase.debug.error("PMPolicyNavModelImpl.setOrganization ", (Throwable)sSOException);
            }
            catch (AMException aMException) {
                AMModelBase.debug.error("PMPolicyNavModelImpl.setOrganization ", (Throwable)aMException);
            }
            if (AMModelBase.debug.messageEnabled()) {
                AMModelBase.debug.message("reset locationDN to " + this.locationDN);
            }
            this.updateLocationType();
        }
    }

    private AMObject getAMObjectObj() {
        AMRole aMRole = null;
        try {
            switch (this.locationType) {
                case 6: {
                    aMRole = this.dpStoreConn.getRole(this.locationDN);
                    break;
                }
                case 5: {
                    aMRole = this.dpStoreConn.getPeopleContainer(this.locationDN);
                    break;
                }
                case 4: {
                    aMRole = this.dpStoreConn.getGroupContainer(this.locationDN);
                    break;
                }
                case 9: 
                case 10: {
                    aMRole = this.dpStoreConn.getStaticGroup(this.locationDN);
                    break;
                }
                case 11: {
                    aMRole = this.dpStoreConn.getDynamicGroup(this.locationDN);
                    break;
                }
                case 12: {
                    aMRole = this.dpStoreConn.getAssignableDynamicGroup(this.locationDN);
                }
            }
        }
        catch (SSOException sSOException) {
            AMModelBase.debug.error("PMPolicyNavModelImpl.getAMObjectObj ", (Throwable)sSOException);
        }
        return aMRole;
    }

    private void updateLocationType() {
        try {
            this.locationType = this.getObjectType(this.locationDN);
        }
        catch (AMException aMException) {
            AMModelBase.debug.error("PMPolicyNavModelImpl.updateLocationType ", (Throwable)aMException);
        }
        catch (SSOException sSOException) {
            AMModelBase.debug.error("PMPolicyNavModelImpl.updateLocationType ", (Throwable)sSOException);
        }
    }

    public String getMessageTitle() {
        return this.getLocalizedString("warningMessage.title");
    }

    public String getNoEntriesMsg() {
        return this.getLocalizedString("noEntries.message");
    }

    public String getRowsLabel() {
        return this.getLocalizedString("rows.label");
    }

    public String getRowLabel() {
        return this.getLocalizedString("row.label");
    }
}

