/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.am.console.policy.model;

import com.iplanet.am.console.base.model.AMAdminUtils;
import com.iplanet.am.console.base.model.AMConsoleException;
import com.iplanet.am.console.base.model.AMModelBase;
import com.iplanet.am.console.policy.model.PMLDAPSubjectModelImpl;
import com.iplanet.am.console.policy.model.PMLDAPUserSubjectModel;
import com.iplanet.am.sdk.AMException;
import com.iplanet.am.sdk.AMTemplate;
import com.iplanet.am.sdk.AMUser;
import com.iplanet.am.util.Debug;
import com.iplanet.sso.SSOException;
import com.sun.identity.common.admin.AdminInterfaceUtils;
import com.sun.identity.policy.PolicyException;
import com.sun.identity.policy.ValidValues;
import com.sun.identity.policy.interfaces.Subject;
import com.sun.identity.policy.plugins.LDAPUsers;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.SchemaType;
import com.sun.identity.sm.ServiceSchemaManager;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import javax.servlet.http.HttpServletRequest;

public class PMLDAPUserSubjectModelImpl
extends PMLDAPSubjectModelImpl
implements PMLDAPUserSubjectModel {
    private List searchAttributesList;
    private String[] searchAttributes;
    private String columnSep;
    private Map mapUserDNToAttrValues;

    public PMLDAPUserSubjectModelImpl(HttpServletRequest httpServletRequest, Map map) {
        super(httpServletRequest, map);
        this.getSearchReturnAttributeList();
        this.columnSep = this.getLocalizedString("attributeValuesColumnSeparator");
    }

    public String getHelpAnchorTag() {
        String string = this.getLocalizedString("policyLDAPUserSubject.help");
        if (string.equals("policyLDAPUserSearch.help")) {
            string = "contents.html";
        }
        return this.getHelpURL(string);
    }

    public String getUserAttributes(String string) throws AMConsoleException {
        String string2 = null;
        if (this.mapUserDNToAttrValues != null) {
            Map map = (Map)this.mapUserDNToAttrValues.get(string);
            if (map == null || map.isEmpty()) {
                map = this.getUserAtributesFromAMUser(string);
            }
            StringBuffer stringBuffer = new StringBuffer(1000);
            int n = 0;
            while (n < this.searchAttributes.length) {
                String string3 = this.searchAttributes[n];
                Object[] objectArray = new String[]{this.getUserValues((String[])map.get(string3))};
                String string4 = MessageFormat.format(this.columnSep, objectArray);
                stringBuffer.append(" ").append(string4);
                ++n;
            }
            string2 = stringBuffer.toString();
        }
        return string2 != null ? string2 : "";
    }

    private Map getUserAtributesFromAMUser(String string) {
        HashMap<String, String[]> hashMap = new HashMap<String, String[]>(this.searchAttributes.length * 2);
        String[] stringArray = new String[]{};
        try {
            AMUser aMUser = this.dpStoreConn.getUser(string);
            int n = 0;
            while (n < this.searchAttributes.length) {
                String string2 = this.searchAttributes[n];
                Set set = aMUser.getAttribute(string2);
                if (set != null && !set.isEmpty()) {
                    int n2 = 0;
                    String[] stringArray2 = new String[set.size()];
                    Iterator iterator = set.iterator();
                    while (iterator.hasNext()) {
                        stringArray2[n2++] = (String)iterator.next();
                    }
                    hashMap.put(string2, stringArray2);
                } else {
                    hashMap.put(string2, stringArray);
                }
                ++n;
            }
        }
        catch (AMException aMException) {
            AMModelBase.debug.warning("PMLDAPUserSubjectModelImpl.getUserAtributesFromAMUser", (Throwable)aMException);
        }
        catch (SSOException sSOException) {
            AMModelBase.debug.warning("PMLDAPUserSubjectModelImpl.getUserAtributesFromAMUser", (Throwable)sSOException);
        }
        return hashMap;
    }

    private String getUserValues(String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer(100);
        if (stringArray != null && stringArray.length > 0) {
            int n = 0;
            while (n < stringArray.length) {
                if (stringBuffer.length() > 0) {
                    stringBuffer.append(this.getLocalizedString("multiValuedAttrSeparator")).append(" ");
                }
                stringBuffer.append(stringArray[n]);
                ++n;
            }
        }
        return stringBuffer.toString();
    }

    private void getSearchReturnAttributeList() {
        ArrayList<String> arrayList = Collections.EMPTY_LIST;
        String string = this.getSearchReturnAttributes();
        if (string != null && string.length() > 0) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
            arrayList = new ArrayList<String>(stringTokenizer.countTokens());
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken().toLowerCase();
                if (arrayList.contains(string2)) continue;
                arrayList.add(string2);
            }
        }
        if (arrayList.isEmpty()) {
            this.searchAttributes = new String[1];
            this.searchAttributes[0] = AdminInterfaceUtils.getNamingAttribute((int)1, (Debug)AMModelBase.debug);
        } else {
            int n = arrayList.size();
            this.searchAttributes = new String[n];
            int n2 = 0;
            while (n2 < n) {
                this.searchAttributes[n2] = (String)arrayList.get(n2);
                ++n2;
            }
        }
    }

    private String getSearchReturnAttributes() {
        String string = null;
        try {
            AMTemplate aMTemplate = this.getOrgTemplate();
            if (aMTemplate != null) {
                string = AMAdminUtils.getStringAttribute(aMTemplate, "iplanet-am-admin-console-user-return-attribute");
            } else {
                ServiceSchemaManager serviceSchemaManager = this.getServiceSchemaManager("iPlanetAMAdminConsoleService");
                if (serviceSchemaManager != null) {
                    string = AMAdminUtils.getStringAttribute(serviceSchemaManager, SchemaType.ORGANIZATION, "iplanet-am-admin-console-user-return-attribute");
                }
            }
        }
        catch (SMSException sMSException) {
            AMModelBase.debug.warning("PMLDAPSubjectModelImpl.getSearchReturnAttributes", (Throwable)sMSException);
        }
        catch (SSOException sSOException) {
            AMModelBase.debug.warning("PMLDAPSubjectModelImpl.getSearchReturnAttributes", (Throwable)sSOException);
        }
        catch (AMException aMException) {
            AMModelBase.debug.warning("PMLDAPSubjectModelImpl.getSearchReturnAttributes", (Throwable)aMException);
        }
        return string;
    }

    public String getWizardInformation() {
        return this.getLocalizedString("LDAPUserWizard.message");
    }

    public Set getPossibleValues(String string, String string2) throws AMConsoleException {
        this.searchError = null;
        Set set = null;
        try {
            LDAPUsers lDAPUsers;
            ValidValues validValues;
            Subject subject = this.getSubjectObj(string);
            if (subject != null && (validValues = (lDAPUsers = (LDAPUsers)subject).getValidEntries(this.ssoToken, string2, this.searchAttributes)) != null) {
                int n;
                Set set2 = validValues.getSearchResults();
                if (set2 != null && !set2.isEmpty()) {
                    this.mapUserDNToAttrValues = (Map)set2.iterator().next();
                    set = this.getPossibleValues();
                }
                if ((n = validValues.getErrorCode()) == 1) {
                    this.searchError = this.getLocalizedString("sizeLimitExceeded.message");
                } else if (n == 2) {
                    this.searchError = this.getLocalizedString("timeLimitExceeded.message");
                }
            }
        }
        catch (SSOException sSOException) {
            AMModelBase.debug.warning("PMProfileSubjectsModelImpl.getPossibleValues", (Throwable)sSOException);
            throw new AMConsoleException(this.getErrorString((Exception)((Object)sSOException)));
        }
        catch (PolicyException policyException) {
            AMModelBase.debug.error("PMProfileSubjectsModelImpl.getPossibleValues", (Throwable)policyException);
            throw new AMConsoleException(this.getErrorString((Exception)((Object)policyException)));
        }
        return set != null ? set : Collections.EMPTY_SET;
    }

    private Set getPossibleValues() {
        HashSet<String> hashSet = new HashSet<String>(this.mapUserDNToAttrValues.size() * 2);
        Iterator iterator = this.mapUserDNToAttrValues.keySet().iterator();
        while (iterator.hasNext()) {
            hashSet.add((String)iterator.next());
        }
        return hashSet;
    }
}

