/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.am.console.policy.model;

import com.iplanet.am.console.base.model.AMAdminUtils;
import com.iplanet.am.console.base.model.AMConsoleException;
import com.iplanet.am.console.base.model.AMFormatUtils;
import com.iplanet.am.console.base.model.AMModelBase;
import com.iplanet.am.console.policy.model.PMAdminNavViewModel;
import com.iplanet.am.console.policy.model.PMNavViewModelBase;
import com.iplanet.am.sdk.AMException;
import com.iplanet.am.sdk.AMObject;
import com.iplanet.am.sdk.AMOrganization;
import com.iplanet.am.sdk.AMRole;
import com.iplanet.am.sdk.AMSearchControl;
import com.iplanet.am.sdk.AMSearchResults;
import com.iplanet.am.sdk.AMTemplate;
import com.iplanet.am.util.Debug;
import com.iplanet.am.util.OrderedSet;
import com.iplanet.sso.SSOException;
import com.sun.identity.common.admin.AdminInterfaceUtils;
import com.sun.identity.sm.AttributeSchema;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.SchemaType;
import com.sun.identity.sm.ServiceSchema;
import com.sun.identity.sm.ServiceSchemaManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import javax.servlet.http.HttpServletRequest;

public class PMAdminNavViewModelImpl
extends PMNavViewModelBase
implements PMAdminNavViewModel {
    private Map resultsMap = null;
    private List searchReturnAttrs = null;
    private Map localizedAttrNames = null;
    private Set admins = null;
    private String searchError = null;

    public PMAdminNavViewModelImpl(HttpServletRequest httpServletRequest, Map map) {
        super(httpServletRequest, map);
    }

    public String getSelectLabel() {
        return this.getLocalizedString("select.label");
    }

    public String getPropertiesLabel() {
        return this.getLocalizedString("properties.label");
    }

    public String getAddBtnLabel() {
        return this.getLocalizedString("add.button");
    }

    public String getRemoveBtnLabel() {
        return this.getLocalizedString("remove.button");
    }

    public String getSelectedOption() {
        return "policyadministrator";
    }

    public String getErrorTitle() {
        return this.getLocalizedString("warningMessage.title");
    }

    public Set getPolicyAdmins(String string) {
        this.admins = Collections.EMPTY_SET;
        AMRole aMRole = this.getPolicyAdminRole();
        if (aMRole != null) {
            AMSearchResults aMSearchResults = null;
            try {
                String string2 = aMRole.getOrganizationDN();
                AMOrganization aMOrganization = this.dpStoreConn.getOrganization(string2);
                AMSearchControl aMSearchControl = new AMSearchControl();
                aMSearchControl.setSearchScope(1);
                this.setSearchControlAttributes(aMOrganization, aMSearchControl);
                this.setSearchControlLimits((AMObject)aMOrganization, aMSearchControl);
                aMSearchResults = aMRole.searchUsers(aMSearchControl, this.getSearchFilter(aMOrganization, string));
            }
            catch (AMException aMException) {
                this.searchError = this.getErrorString((Exception)((Object)aMException));
            }
            catch (SSOException sSOException) {
                this.searchError = this.getErrorString((Exception)((Object)sSOException));
            }
            if (aMSearchResults != null) {
                this.admins = aMSearchResults.getSearchResults();
                this.resultsMap = aMSearchResults.getResultAttributes();
                this.searchError = AMAdminUtils.getSearchResultWarningMessage(aMSearchResults, this);
            }
        }
        return this.admins;
    }

    public String getSearchErrorMsg() {
        return this.searchError;
    }

    public void unassignUsersFromPolicyAdminRole(Set set) throws AMConsoleException {
        AMRole aMRole;
        if (set != null && !set.isEmpty() && (aMRole = this.getPolicyAdminRole()) != null) {
            try {
                aMRole.removeUsers(set);
                if (this.logger.isEnabled()) {
                    StringBuffer stringBuffer = new StringBuffer(100);
                    stringBuffer.append(this.getLocalizedString("removedUserFromPolicyAdminRole.message")).append(" " + aMRole.getDN()).append(":" + set);
                    this.logger.doLog(stringBuffer.toString());
                }
            }
            catch (AMException aMException) {
                throw new AMConsoleException(this.getErrorString((Exception)((Object)aMException)));
            }
            catch (SSOException sSOException) {
                throw new AMConsoleException(this.getErrorString((Exception)((Object)sSOException)));
            }
        }
    }

    public String getRoleDN() {
        AMRole aMRole = this.getPolicyAdminRole();
        return aMRole != null ? aMRole.getDN() : null;
    }

    public String createPolicyAdminRole() {
        String string;
        block4: {
            AMRole aMRole;
            block5: {
                string = null;
                aMRole = this.getPolicyAdminRole();
                if (aMRole == null) break block5;
                string = aMRole.getDN();
                break block4;
            }
            if (this.isRootSuffix() || this.getLocationType() != 2) break block4;
            try {
                AMOrganization aMOrganization = (AMOrganization)this.getAMObject(this.locationDN);
                String[] stringArray = this.getPolicyAdminACI();
                if (stringArray == null) break block4;
                HashMap hashMap = new HashMap(1);
                HashMap hashMap2 = new HashMap(3);
                HashSet<String> hashSet = new HashSet<String>(1);
                hashSet.add("Organization-Policy-Admin-Role");
                hashMap2.put("iplanet-am-role-description", hashSet);
                hashSet = new HashSet(1);
                hashSet.add(Integer.toString(2));
                hashMap2.put("iplanet-am-role-type", hashSet);
                hashSet = new HashSet(1);
                hashSet.add(stringArray[0]);
                hashMap2.put("iplanet-am-role-aci-description", hashSet);
                hashSet = new HashSet(1);
                hashSet.add(stringArray[1]);
                hashMap2.put("iplanet-am-role-aci-list", hashSet);
                hashSet = new HashSet(1);
                hashSet.add(this.locationDN);
                hashMap2.put("iplanet-am-role-managed-container-dn", hashSet);
                hashMap.put("Organization Policy Admin Role", hashMap2);
                aMOrganization.createRoles(hashMap);
                this.logger.doLog("roleCreated.message", "Organization Policy Admin Role");
                aMRole = this.getPolicyAdminRole();
                if (aMRole != null) {
                    string = aMRole.getDN();
                }
            }
            catch (AMException aMException) {
                AMModelBase.debug.error("PMAdminNavViewModelImpl.createPolicyAdminRole", (Throwable)aMException);
            }
            catch (SSOException sSOException) {
                AMModelBase.debug.error("PMAdminNavViewModelImpl.createPolicyAdminRole", (Throwable)sSOException);
            }
        }
        return string;
    }

    public List getSearchReturnAttributes() {
        if (this.searchReturnAttrs != null) {
            return this.searchReturnAttrs;
        }
        AMRole aMRole = this.getPolicyAdminRole();
        if (aMRole != null) {
            try {
                String string = aMRole.getOrganizationDN();
                AMOrganization aMOrganization = this.dpStoreConn.getOrganization(string);
                this.searchReturnAttrs = this.getValidatedAttributes(this.getUserSearchReturnAttribute(aMOrganization));
            }
            catch (AMException aMException) {
                AMModelBase.debug.warning("PMAdminNavViewModelImpl.getSearchReturnAttributes", (Throwable)aMException);
            }
            catch (SSOException sSOException) {
                AMModelBase.debug.error("PMAdminNavViewModelImpl.getSearchReturnAttributes", (Throwable)sSOException);
            }
        }
        if (this.searchReturnAttrs == null) {
            this.searchReturnAttrs = new ArrayList(1);
            this.searchReturnAttrs.add(AdminInterfaceUtils.getNamingAttribute((int)1, (Debug)AMModelBase.debug));
        }
        return this.searchReturnAttrs;
    }

    public String getAttributeValue(String string) {
        this.getSearchReturnAttributes();
        if (this.searchReturnAttrs.isEmpty()) {
            return AMFormatUtils.DNToName(this, string);
        }
        int n = this.searchReturnAttrs.size();
        return this.getAttributeValue(string, (String)this.searchReturnAttrs.get(n - 1));
    }

    public String getAttributeValue(String string, String string2) {
        if (this.resultsMap == null) {
            return AMFormatUtils.DNToName(this, string);
        }
        Map map = (Map)this.resultsMap.get(string);
        if (map == null) {
            return AMFormatUtils.DNToName(this, string);
        }
        Set set = (Set)map.get(string2);
        if (set == null || set.isEmpty()) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer(25);
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            if (stringBuffer.length() != 0) {
                stringBuffer.append("&nbsp;");
            }
            stringBuffer.append((String)iterator.next());
        }
        return stringBuffer.toString();
    }

    public String getAttributeLocalizedName(String string) {
        String string2;
        if (this.localizedAttrNames == null) {
            this.localizedAttrNames = this.getLocalizedAttributes();
        }
        if ((string2 = (String)this.localizedAttrNames.get(string)) == null) {
            string2 = string;
        }
        return string2;
    }

    public String getAttributeLocalizedName() {
        this.getSearchReturnAttributes();
        if (this.searchReturnAttrs.isEmpty()) {
            return this.getAttributeLocalizedName(AdminInterfaceUtils.getNamingAttribute((int)1, (Debug)AMModelBase.debug));
        }
        int n = this.searchReturnAttrs.size();
        return this.getAttributeLocalizedName((String)this.searchReturnAttrs.get(n - 1));
    }

    public String getPolicyAdminRoleNotFoundMsg() {
        return this.getLocalizedString("policyAdminNotFound.message");
    }

    private Map getLocalizedAttributes() {
        Set set = null;
        ServiceSchemaManager serviceSchemaManager = null;
        ServiceSchema serviceSchema = null;
        try {
            serviceSchemaManager = this.getServiceSchemaManager("iPlanetAMUserService");
            if (serviceSchemaManager != null) {
                serviceSchema = serviceSchemaManager.getSchema(SchemaType.USER);
                set = serviceSchema.getAttributeSchemaNames();
            }
        }
        catch (SMSException sMSException) {
            AMModelBase.debug.warning("PMAdminNavViewModelImpl.getUserSearchAttribute", (Throwable)sMSException);
        }
        catch (SSOException sSOException) {
            AMModelBase.debug.warning("PMAdminNavViewModelImpl.getUserSearchAttribute", (Throwable)sSOException);
        }
        if (set == null) {
            return new HashMap(0);
        }
        HashMap<String, String> hashMap = new HashMap<String, String>(set.size());
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            String string;
            String string2 = (String)iterator.next();
            AttributeSchema attributeSchema = serviceSchema.getAttributeSchema(string2);
            if (attributeSchema == null || (string = attributeSchema.getI18NKey()) == null || string.length() == 0) continue;
            hashMap.put(string2, this.getL10NAttributeName(serviceSchemaManager, string));
        }
        return hashMap;
    }

    private AMRole getPolicyAdminRole() {
        AMRole aMRole;
        block5: {
            String string = this.isRootSuffix() ? "Top-level Policy Admin Role" : "Organization Policy Admin Role";
            String string2 = AdminInterfaceUtils.getNamingAttribute((int)6, (Debug)AMModelBase.debug) + "=" + string + "," + this.getLocationDN();
            aMRole = null;
            try {
                if (this.getObjectType(string2) == 6) {
                    aMRole = (AMRole)this.getAMObject(string2);
                }
            }
            catch (AMException aMException) {
                if (AMModelBase.debug.warningEnabled()) {
                    AMModelBase.debug.warning("PMAdminNavViewModelImpl.getPolicyAdminRole: unable to get role object", (Throwable)aMException);
                }
            }
            catch (SSOException sSOException) {
                if (!AMModelBase.debug.warningEnabled()) break block5;
                AMModelBase.debug.warning("PMAdminNavViewModelImpl.getPolicyAdminRole: unable to get role object", (Throwable)sSOException);
            }
        }
        return aMRole;
    }

    private void setSearchControlAttributes(AMOrganization aMOrganization, AMSearchControl aMSearchControl) {
        if (this.searchReturnAttrs == null) {
            this.searchReturnAttrs = this.getValidatedAttributes(this.getUserSearchReturnAttribute(aMOrganization));
        }
        String string = (String)this.searchReturnAttrs.get(0);
        String[] stringArray = new String[]{string};
        aMSearchControl.setSortKeys(stringArray);
        aMSearchControl.setReturnAttributes(new HashSet(this.searchReturnAttrs));
    }

    private String getSearchFilter(AMOrganization aMOrganization, String string) throws SSOException {
        String string2 = this.getUserSearchAttribute(aMOrganization);
        StringBuffer stringBuffer = new StringBuffer(10);
        stringBuffer.append("(").append(string2).append("=").append(string).append(")");
        return stringBuffer.toString();
    }

    private String getUserSearchAttribute(AMOrganization aMOrganization) {
        String string = null;
        try {
            AMTemplate aMTemplate = this.getOrgTemplate(aMOrganization);
            if (aMTemplate != null) {
                string = AMAdminUtils.getStringAttribute(aMTemplate, "iplanet-am-admin-console-user-search-key");
            } else {
                ServiceSchemaManager serviceSchemaManager = this.getServiceSchemaManager("iPlanetAMAdminConsoleService");
                if (serviceSchemaManager != null) {
                    string = AMAdminUtils.getStringAttribute(serviceSchemaManager, SchemaType.ORGANIZATION, "iplanet-am-admin-console-user-search-key");
                }
            }
        }
        catch (SMSException sMSException) {
            AMModelBase.debug.warning("PMAdminNavViewModelImpl.getUserSearchAttribute", (Throwable)sMSException);
        }
        catch (SSOException sSOException) {
            AMModelBase.debug.warning("PMAdminNavViewModelImpl.getUserSearchAttribute", (Throwable)sSOException);
        }
        catch (AMException aMException) {
            AMModelBase.debug.warning("PMAdminNavViewModelImpl.getUserSearchAttribute", (Throwable)aMException);
        }
        if (string == null) {
            string = AdminInterfaceUtils.getNamingAttribute((int)1, (Debug)AMModelBase.debug);
        }
        return string;
    }

    private String getUserSearchReturnAttribute(AMOrganization aMOrganization) {
        String string = null;
        try {
            AMTemplate aMTemplate = this.getOrgTemplate(aMOrganization);
            if (aMTemplate != null) {
                string = AMAdminUtils.getStringAttribute(aMTemplate, "iplanet-am-admin-console-user-return-attribute");
            } else {
                ServiceSchemaManager serviceSchemaManager = this.getServiceSchemaManager("iPlanetAMAdminConsoleService");
                if (serviceSchemaManager != null) {
                    string = AMAdminUtils.getStringAttribute(serviceSchemaManager, SchemaType.ORGANIZATION, "iplanet-am-admin-console-user-return-attribute");
                }
            }
        }
        catch (SMSException sMSException) {
            AMModelBase.debug.warning("PMAdminNavViewModelImpl.getUserSearchReturnAttribute", (Throwable)sMSException);
        }
        catch (SSOException sSOException) {
            AMModelBase.debug.warning("PMAdminNavViewModelImpl.getUserSearchReturnAttribute", (Throwable)sSOException);
        }
        catch (AMException aMException) {
            AMModelBase.debug.warning("PMAdminNavViewModelImpl.getUserSearchReturnAttribute", (Throwable)aMException);
        }
        return string;
    }

    private List getValidatedAttributes(String string) {
        ArrayList<String> arrayList = null;
        if (string == null || string.length() == 0) {
            arrayList = new ArrayList<String>(1);
            arrayList.add(AdminInterfaceUtils.getNamingAttribute((int)1, (Debug)AMModelBase.debug));
            return arrayList;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        arrayList = new ArrayList(stringTokenizer.countTokens());
        Set set = this.getUserAttributeNames();
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken().toLowerCase();
            if (!set.contains(string2) || arrayList.contains(string2)) continue;
            arrayList.add(string2);
        }
        if (arrayList.isEmpty()) {
            arrayList.add(AdminInterfaceUtils.getNamingAttribute((int)1, (Debug)AMModelBase.debug));
        }
        return arrayList;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String[] getPolicyAdminACI() {
        String[] stringArray = null;
        try {
            ServiceSchemaManager serviceSchemaManager = this.getServiceSchemaManager("iPlanetAMAdminConsoleService");
            ServiceSchema serviceSchema = serviceSchemaManager.getSchema(SchemaType.GLOBAL);
            Map map = serviceSchema.getAttributeDefaults();
            Set set = (Set)map.get("iplanet-am-admin-console-role-default-acis");
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                String string;
                if (stringArray != null) {
                    return stringArray;
                }
                String string2 = (String)iterator.next();
                int n = 0;
                int n2 = string2.indexOf("|");
                if (n2 == -1 || !(string = string2.substring(n, n2)).equals("Organization Policy Admin") || (n2 = string2.indexOf("|", n = n2 + 1)) == -1) continue;
                String string3 = string2.substring(n, n2);
                n = n2 + 1;
                n2 = string2.length();
                String string4 = string2.substring(n, n2);
                stringArray = new String[]{string3, string4};
            }
            return stringArray;
        }
        catch (SSOException sSOException) {
            AMModelBase.debug.warning("PMAdminNavViewModelImpl.getPolicyAdminACI", (Throwable)sSOException);
            return stringArray;
        }
        catch (SMSException sMSException) {
            AMModelBase.debug.error("PMAdminNavViewModelImpl.getPolicyAdminACI", (Throwable)sMSException);
            return stringArray;
        }
    }

    public Map getDNToUserMap() {
        return this.resultsMap;
    }

    public String getHeaderLabel() {
        return this.getLocalizedString("policyAdmins.header");
    }

    public String getNoEntrySelectedForDelTitle() {
        return this.getLocalizedString("noPolicyAdminSelectForDeletion.title");
    }

    public String getNoEntrySelectedForDelMessage() {
        return this.getLocalizedString("noPolicyAdminSelectForDeletion.message");
    }

    public Set getAttrList() {
        return this.admins;
    }

    public void setAttrList(Set set) {
        this.admins = set;
    }

    public int getPolicyAdminCnt() {
        if (this.admins == null) {
            return 0;
        }
        return this.admins.size();
    }

    public Set getPolicyAdminDisplayList(String string, int n, int n2) {
        this.admins = this.getPolicyAdmins(string);
        Set set = Collections.EMPTY_SET;
        if (this.admins != null && !this.admins.isEmpty()) {
            int n3 = n;
            Object[] objectArray = this.admins.toArray();
            int n4 = objectArray.length;
            int n5 = n4 - n2;
            if (n3 > n5) {
                n3 = n5;
            }
            set = new OrderedSet();
            int n6 = n2;
            while (n6 < n3 + n2) {
                set.add(objectArray[n6]);
                ++n6;
            }
        }
        return set;
    }

    public Map getAttrMap() {
        return this.resultsMap;
    }

    public void setAttrMap(Map map) {
        this.resultsMap = map;
    }
}

