/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.am.console.federation.model;

import com.iplanet.am.console.federation.model.FSNavModelImpl;
import com.iplanet.am.console.federation.model.FSProvidersModel;
import com.sun.identity.federation.alliance.FSAllianceManagementException;
import com.sun.identity.federation.alliance.FSAllianceManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;

public class FSProvidersModelImpl
extends FSNavModelImpl
implements FSProvidersModel {
    private Set hostedProviders = null;
    private Set remoteProviders = null;
    private FSAllianceManager manager;

    public FSProvidersModelImpl(HttpServletRequest httpServletRequest, Map map) {
        super(httpServletRequest, map);
    }

    public String getRemoteHeaderLabel() {
        return this.getLocalizedString("remoteProviders.header");
    }

    public String getHostedHeaderLabel() {
        return this.getLocalizedString("hostedProviders.header");
    }

    public String getNoRemoteProviderSelectedForDelTitle() {
        return this.getLocalizedString("noRemoteProviderSelectedForDeletion.title");
    }

    public String getNoRemoteProviderSelectedForDelMessage() {
        return this.getLocalizedString("noRemoteProviderSelectedForDeletion.message");
    }

    public String getNoHostedProviderSelectedForDelTitle() {
        return this.getLocalizedString("noHostedProviderSelectedForDeletion.title");
    }

    public String getNoHostedProviderSelectedForDelMessage() {
        return this.getLocalizedString("noHostedProviderSelectedForDeletion.message");
    }

    private void getManager() throws FSAllianceManagementException {
        this.manager = new FSAllianceManager(this.ssoToken);
    }

    public String getSelectedOption(int n) {
        return Integer.toString(n);
    }

    public boolean hasRemoteProviders(String string) {
        this.remoteProviders = this.getRemoteProviders(string);
        if (this.remoteProviders != null) {
            return !this.remoteProviders.isEmpty();
        }
        return false;
    }

    public Set getRemoteProviderList() {
        return this.remoteProviders;
    }

    public boolean hasHostedProviders(String string) {
        this.hostedProviders = this.getHostedProviders(string);
        if (this.hostedProviders != null) {
            return !this.hostedProviders.isEmpty();
        }
        return false;
    }

    public Set getHostedProviderList() {
        return this.hostedProviders;
    }

    public int getHostedProviderCount() {
        if (this.hostedProviders == null) {
            return 0;
        }
        return this.hostedProviders.size();
    }

    public int getRemoteProviderCount() {
        if (this.remoteProviders == null) {
            return 0;
        }
        return this.remoteProviders.size();
    }

    public Set getRemoteProviders() {
        try {
            return new FSAllianceManager(this.ssoToken).getAllRemoteProviderIds();
        }
        catch (FSAllianceManagementException fSAllianceManagementException) {
            if (this.warningEnabled()) {
                this.debugWarning("Error in getting FSAllianceManager", (Exception)((Object)fSAllianceManagementException));
            }
            this.setErrorMessage(this.getErrorString((Exception)((Object)fSAllianceManagementException)));
            return null;
        }
    }

    public Set getHostedProviders() {
        try {
            return new FSAllianceManager(this.ssoToken).getAllHostedProviderIds();
        }
        catch (FSAllianceManagementException fSAllianceManagementException) {
            if (this.warningEnabled()) {
                this.debugWarning("Error in getting FSAllianceManager", (Exception)((Object)fSAllianceManagementException));
            }
            this.setErrorMessage(this.getErrorString((Exception)((Object)fSAllianceManagementException)));
            return null;
        }
    }

    public Set getRemoteProviders(String string) {
        try {
            this.getManager();
            if (this.manager == null) {
                return null;
            }
            return this.manager.getAllRemoteProviderIds(string);
        }
        catch (FSAllianceManagementException fSAllianceManagementException) {
            if (this.warningEnabled()) {
                this.debugWarning("Error in getting FSAllianceManager", (Exception)((Object)fSAllianceManagementException));
            }
            this.setErrorMessage(this.getErrorString((Exception)((Object)fSAllianceManagementException)));
            return null;
        }
    }

    public Set getHostedProviders(String string) {
        try {
            this.getManager();
            if (this.manager == null) {
                return null;
            }
            return this.manager.getAllHostedProviderIds(string);
        }
        catch (FSAllianceManagementException fSAllianceManagementException) {
            if (this.warningEnabled()) {
                this.debugWarning("Error in getting FSAllianceManager", (Exception)((Object)fSAllianceManagementException));
            }
            this.setErrorMessage(this.getErrorString((Exception)((Object)fSAllianceManagementException)));
            return null;
        }
    }

    public boolean deleteRemoteProviders(Set set) {
        try {
            new FSAllianceManager(this.ssoToken).deleteProviders(set);
            return true;
        }
        catch (FSAllianceManagementException fSAllianceManagementException) {
            if (this.warningEnabled()) {
                this.debugWarning("Error in getting FSAllianceManager", (Exception)((Object)fSAllianceManagementException));
            }
            this.setErrorMessage(this.getErrorString((Exception)((Object)fSAllianceManagementException)));
            return false;
        }
    }

    public boolean deleteHostedProviders(Set set) {
        try {
            new FSAllianceManager(this.ssoToken).deleteProviders(set);
            return true;
        }
        catch (FSAllianceManagementException fSAllianceManagementException) {
            if (this.warningEnabled()) {
                this.debugWarning("Error in getting FSAllianceManager", (Exception)((Object)fSAllianceManagementException));
            }
            this.setErrorMessage(this.getErrorString((Exception)((Object)fSAllianceManagementException)));
            return false;
        }
    }

    public List getProviderDisplayList(List list, int n, int n2) {
        ArrayList<Object> arrayList = Collections.EMPTY_LIST;
        if (list != null && !list.isEmpty()) {
            int n3 = n;
            Object[] objectArray = list.toArray();
            int n4 = objectArray.length;
            int n5 = n4 - n2;
            if (n3 > n5) {
                n3 = n5;
            }
            arrayList = new ArrayList<Object>(n3);
            int n6 = n2;
            while (n6 < n3 + n2) {
                arrayList.add(objectArray[n6]);
                ++n6;
            }
        }
        return arrayList;
    }
}

