/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.am.console.federation.model;

import com.iplanet.am.console.base.model.AMMenuValidator;
import com.iplanet.am.console.base.model.AMMenuValidatorImpl;
import com.iplanet.am.console.base.model.AMModelBase;
import com.iplanet.am.console.base.model.AMProfileModelBase;
import com.iplanet.am.console.federation.model.FSProviderProfileModel;
import com.sun.identity.federation.alliance.FSAllianceManagementException;
import com.sun.identity.federation.alliance.FSAllianceManager;
import com.sun.identity.federation.alliance.FSContactPerson;
import com.sun.identity.federation.alliance.FSHostedProviderDescriptor;
import com.sun.identity.federation.alliance.FSLocalConfigurationDescriptor;
import com.sun.identity.federation.alliance.FSOrganization;
import com.sun.identity.federation.alliance.FSProviderDescriptor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;

public class FSProviderProfileModelImpl
extends AMProfileModelBase
implements FSProviderProfileModel {
    public static final int DEFAULT_VIEW = 0;
    public static final int GENERAL_VIEW = 1;
    public static final int AUTHENTICATION_DOMAIN_VIEW = 4;
    public static final int CREATE_PROVIDERS = 7;
    public String errorMessage = null;
    protected String affiliateId = null;
    private FSOrganization fsorg = null;
    private FSProviderDescriptor affiliate = null;
    private FSAllianceManager manager = null;
    private FSLocalConfigurationDescriptor isConfigDescriptor = null;
    private int providerType = 1;

    public FSProviderProfileModelImpl(HttpServletRequest httpServletRequest, Map map) {
        super(httpServletRequest, "amAdminModuleMsgs", map);
        String string = httpServletRequest.getParameter("AffiliateID");
        if (string == null || string.length() == 0) {
            string = (String)map.get("ProviderID");
        }
        if (string != null && string.length() > 0) {
            this.setAffiliateId(string);
        } else {
            AMModelBase.debug.message("FSProviderProfileModelImpl, affiliate ID is null");
        }
    }

    public String getNoContactPersonsAvailableMessage() {
        return this.getLocalizedString("noContactPersons.message");
    }

    public String getNoProviderWarning() {
        return this.getLocalizedString("txtNoProvider.warning");
    }

    public String getShowLabel() {
        return this.getLocalizedString("view.label");
    }

    public String getCmnAttrsLabel() {
        return this.getLocalizedString("commonAttributes.label");
    }

    public String getDescriptionLabel() {
        return this.getLocalizedString("af.description.label");
    }

    public String getAliasLabel() {
        return this.getLocalizedString("af.alias.label");
    }

    public String getProviderIdLabel() {
        return this.getLocalizedString("af.providerId.label");
    }

    public String getKeyInfoLabel() {
        return this.getLocalizedString("af.keyInfo.label");
    }

    public String getSoapEndpointLabel() {
        return this.getLocalizedString("af.soapEndpoint.label");
    }

    public String getLogoutUrlLabel() {
        return this.getLocalizedString("af.logoutUrl.label");
    }

    public String getLoginUrlLabel() {
        return this.getLocalizedString("af.loginUrl.label");
    }

    public String getTermNotificationUrlLabel() {
        return this.getLocalizedString("af.termnotificationUrl.label");
    }

    public String getAssertionConsumerUrlIdLabel() {
        return this.getLocalizedString("af.assertionConsumerUrlId.label");
    }

    public String getAssertionConsumerURLIdHelp() {
        return this.getLocalizedString("af.assertionConsumerUrlId.help");
    }

    public String getAssertionConsumerUrlIsDefLabel() {
        return this.getLocalizedString("af.assertionConsumerUrlIsDef.label");
    }

    public String getNameIdMapBindLabel() {
        return this.getLocalizedString("af.nameIdMapBind.label");
    }

    public String getEditToListLabel() {
        return this.getLocalizedString("editableListEdit.button");
    }

    public String getNewButtonLabel() {
        return this.getLocalizedString("new.button");
    }

    public String getDeleteButtonLabel() {
        return this.getLocalizedString("delete.button");
    }

    public String getFinishButtonLabel() {
        return this.getLocalizedString("finish.button");
    }

    public String getOrganizationLabel() {
        return this.getLocalizedString("af.organization.label");
    }

    public String getAddMetaLocnLabel() {
        return this.getLocalizedString("af.addMetaLocn.label");
    }

    public String getContactPersonLabel() {
        return this.getLocalizedString("af.providercontactPerson.label");
    }

    public String getExtensionLabel() {
        return this.getLocalizedString("af.extension.label");
    }

    public String getSignCertAliasLabel() {
        return this.getLocalizedString("af.signCertAlias.label");
    }

    public String getValidUntilLabel() {
        return this.getLocalizedString("af.validUntil.label");
    }

    public String getCacheDurationLabel() {
        return this.getLocalizedString("af.cacheDuration.label");
    }

    public String getProtSuppEnumLabel() {
        return this.getLocalizedString("af.protSuppEnum.label");
    }

    public String getIntrNotificationLabel() {
        return this.getLocalizedString("af.intrNotification.label");
    }

    public String getLogoutReturnUrlLabel() {
        return this.getLocalizedString("af.logoutReturnUrl.label");
    }

    public String getTerminationServiceUrlLabel() {
        return this.getLocalizedString("af.terminationServiceUrl.label");
    }

    public String getTerminationReturnUrlLabel() {
        return this.getLocalizedString("af.terminationReturnUrl.label");
    }

    public String getStatusLabel() {
        return this.getLocalizedString("af.status.label");
    }

    public String getIsIDPLabel() {
        return this.getLocalizedString("af.isIDP.label");
    }

    public String getIsLocalLabel() {
        return this.getLocalizedString("af.isLocal.label");
    }

    public String getConsumerUrlLabel() {
        return this.getLocalizedString("af.consumerUrl.label");
    }

    public String getTerminationProtocolLabel() {
        return this.getLocalizedString("af.terminationProfile.label");
    }

    public String getLogoutProtocolLabel() {
        return this.getLocalizedString("af.logoutProfile.label");
    }

    public String getProfilesLabel() {
        return this.getLocalizedString("profiles.label");
    }

    public String getAuthDomainsLabel() {
        return this.getLocalizedString("showauthenticationdomain.label");
    }

    public String getTrustedProvidersLabel() {
        return this.getLocalizedString("showtrustedproviders.label");
    }

    public String getLocalConfigLabel() {
        return this.getLocalizedString("af.ISConfig-tab.label");
    }

    public String getSPLabel() {
        return this.getLocalizedString("af.sp-tab.label");
    }

    public String getNameRegisProfileLabel() {
        return this.getLocalizedString("af.nameRegisProfile.label");
    }

    public String getNameRegisUrlLabel() {
        return this.getLocalizedString("af.nameRegisUrl.label");
    }

    public String getNameRegisReturnUrlLabel() {
        return this.getLocalizedString("af.nameRegisReturnUrl.label");
    }

    public String getNameRegisAfterSSOLabel() {
        return this.getLocalizedString("af.nameRegisAfterSso.label");
    }

    public String getRequestSignedLabel() {
        return this.getLocalizedString("af.requestSigned.label");
    }

    public String getLogonServiceLabel() {
        return this.getLocalizedString("af.logonService.label");
    }

    public String getProviderUrlLabel() {
        return this.getLocalizedString("af.providerUrl.label");
    }

    public String getProviderUrlHelp() {
        return this.getLocalizedString("af.providerUrl.help");
    }

    public String getCommunicationUrlsLabel() {
        return this.getLocalizedString("communicationUrls.label");
    }

    public String getIDPLabel() {
        return this.getLocalizedString("af.idp.label");
    }

    public String getNotPartOfLabel() {
        return this.getLocalizedString("af.notPartOfLabel.label");
    }

    public String getPartOfLabel() {
        return this.getLocalizedString("af.partOfLabel.label");
    }

    public String getAddButtonLabel() {
        return this.getLocalizedString("selectableListAdd.button");
    }

    public String getAddAllButtonLabel() {
        return this.getLocalizedString("selectableListAddAll.button");
    }

    public String getRemoveButtonLabel() {
        return this.getLocalizedString("selectableListRemove.button");
    }

    public String getRemoveAllButtonLabel() {
        return this.getLocalizedString("selectableListRemoveAll.button");
    }

    public String getCreateErrorTitle() {
        return this.getLocalizedString("createAffiliateFailed.title");
    }

    public String getModifyErrorTitle() {
        return this.getLocalizedString("modifyAffiliateFailed.title");
    }

    public String getRequiredFieldLabel() {
        return this.getLocalizedString("required.label");
    }

    public String getCreateButtonLabel() {
        return this.getLocalizedString("create.button");
    }

    public String getNextButtonLabel() {
        return this.getLocalizedString("nextPage.button");
    }

    public String getBackButtonLabel() {
        return this.getLocalizedString("back.button");
    }

    public String getSaveButtonLabel() {
        return this.getLocalizedString("save.button");
    }

    public String getCancelButtonLabel() {
        return this.getLocalizedString("cancel.button");
    }

    public String getTabErrorTitle() {
        return this.getLocalizedString("tabError.Title");
    }

    public String getMissingAttributeMessage() {
        return this.getLocalizedString("missingAttributes.message");
    }

    public String getInvalidTimeErrorMessage() {
        return this.getLocalizedString("invalidTime.message");
    }

    public String getInvalidIntegerErrorMessage() {
        return this.getLocalizedString("invalidInteger.message");
    }

    public String getLogoutProfileInconsistentErrorMessage() {
        return this.getLocalizedString("logoutProfileInconsistent.message");
    }

    public String getInvalidSuccinctIdMessage() {
        return this.getLocalizedString("invalidSuccinctId.message");
    }

    public String getParameterizedInvalidURLMessage() {
        return this.getLocalizedString("parameterizedInvalidURL.message");
    }

    public String getResetButtonLabel() {
        return this.getLocalizedString("reset.button");
    }

    public String getAuthnFedProfileLabel() {
        return this.getLocalizedString("sc.authnFedProfile.label");
    }

    public String getForceAuthenLabel() {
        return this.getLocalizedString("sc.forceAuthentication.label");
    }

    public String getIsPassiveLabel() {
        return this.getLocalizedString("sc.isPassive.label");
    }

    public String getLibertyVersionURILabel() {
        return this.getLocalizedString("sc.libertyVersionURI.label");
    }

    public String getNameIdentifierImplLabel() {
        return this.getLocalizedString("sc.nameIdentifierImpl.label");
    }

    public String getAuthnContextLabel() {
        return this.getLocalizedString("authncontext.label");
    }

    public String getAuthnContextSupportedLabel() {
        return this.getLocalizedString("authncontext.supported.head");
    }

    public String getAuthnContextRefHead() {
        return this.getLocalizedString("authncontext.ref.head");
    }

    public String getAuthnContextKeyHead() {
        return this.getLocalizedString("authncontext.key.head");
    }

    public String getAuthnContextValueHead() {
        return this.getLocalizedString("authncontext.value.head");
    }

    public String getAuthnContextLevelHead() {
        return this.getLocalizedString("authncontext.level.head");
    }

    public String getAuthnContextPriorityHead() {
        return this.getLocalizedString("authncontext.priority.head");
    }

    public String getInvalidLevelMessage() {
        return this.getLocalizedString("ac.invalidLevel.message");
    }

    public String getMissingUrlInAuthContextMessage() {
        return this.getLocalizedString("ac.missingUrl.message");
    }

    public String getAuthnFedProfileValue() {
        String string = null;
        if (this.fetchAffiliateDescriptor()) {
            string = this.affiliate.getSingleSignOnProtocolProfile();
        }
        return string == null ? "" : string;
    }

    public Map getAuthnFedProfiles() {
        HashMap<String, String> hashMap = new HashMap<String, String>(4);
        hashMap.put(this.getLocalizedString("authnFedProfile.browserArtifact"), "http://projectliberty.org/profiles/brws-art");
        hashMap.put(this.getLocalizedString("authnFedProfile.browserPost"), "http://projectliberty.org/profiles/brws-post");
        hashMap.put(this.getLocalizedString("authnFedProfile.lecp"), "http://projectliberty.org/profiles/lecp");
        return hashMap;
    }

    public Map getAuthTypes() {
        HashMap<String, String> hashMap = new HashMap<String, String>(4);
        hashMap.put(this.getLocalizedString("authType.local"), "local");
        hashMap.put(this.getLocalizedString("authType.remote"), "remote");
        return hashMap;
    }

    public String getForceAuthenValue() {
        boolean bl = false;
        this.fetchAffiliateDescriptor();
        if (this.isConfigDescriptor != null) {
            bl = this.isConfigDescriptor.getForceAuthentication();
        }
        return !bl ? "false" : "true";
    }

    public String getIsPassiveValue() {
        boolean bl = false;
        this.fetchAffiliateDescriptor();
        if (this.isConfigDescriptor != null) {
            bl = this.isConfigDescriptor.getIsPassive();
        }
        return !bl ? "false" : "true";
    }

    public String getLibertyVersionURIValue() {
        String string = null;
        this.fetchAffiliateDescriptor();
        if (this.isConfigDescriptor != null) {
            string = this.isConfigDescriptor.getLibertyVersionURI();
        }
        return string == null ? "" : string;
    }

    public String getNameIdentifierImplValue() {
        String string = null;
        this.fetchAffiliateDescriptor();
        if (this.isConfigDescriptor != null) {
            string = this.isConfigDescriptor.getNameIdentifierImpl();
        }
        return string == null ? "" : string;
    }

    public String getAuthTypeLabel() {
        return this.getLocalizedString("sc.authType.label");
    }

    public String getAuthTypeValue() {
        String string = null;
        if (this.fetchAffiliateDescriptor() && this.isConfigDescriptor != null) {
            string = this.isConfigDescriptor.getProviderAuthType();
        }
        return string == null ? "" : string;
    }

    public String getOrgDNLabel() {
        return this.getLocalizedString("sc.orgDN.label");
    }

    public String getOrgDNValue() {
        String string = null;
        if (this.fetchAffiliateDescriptor() && this.isConfigDescriptor != null) {
            string = this.isConfigDescriptor.getAssociatedOrgDN();
        }
        return string == null ? "" : string;
    }

    public String getNameRegistrationIndicatorLabel() {
        return this.getLocalizedString("sc.nameRegistrationIndicator.label");
    }

    public String getHomePageUrlLabel() {
        return this.getLocalizedString("sc.homePageUrl.label");
    }

    public String getSSOFailUrlLabel() {
        return this.getLocalizedString("sc.ssoFailUrl.label");
    }

    public String getSSOFailUrlValue() {
        String string = null;
        if (this.fetchAffiliateDescriptor() && this.isConfigDescriptor != null) {
            string = this.isConfigDescriptor.getProviderCommonLoginPageURL();
        }
        return string == null ? "" : string;
    }

    public String getHomePageUrlValue() {
        String string = null;
        if (this.fetchAffiliateDescriptor() && this.isConfigDescriptor != null) {
            string = this.isConfigDescriptor.getProviderHomePageURL();
        }
        return string == null ? "" : string;
    }

    public String getDefaultAuthnContextLabel() {
        return this.getLocalizedString("sc.defaultAuthnContext.label");
    }

    public String getDefaultAuthnContextValue() {
        String string = null;
        if (this.fetchAffiliateDescriptor() && this.isConfigDescriptor != null) {
            string = this.isConfigDescriptor.getDefaultAuthenticationContext();
        }
        return string == null ? "" : string;
    }

    public String getSAMLAttributesLabel() {
        return this.getLocalizedString("sc.SAMLAttributes.label");
    }

    public String getAssertionIntervalLabel() {
        return this.getLocalizedString("sc.assertionInterval.label");
    }

    public String getAssertionIntervalValue() {
        String string = null;
        if (this.fetchAffiliateDescriptor() && this.isConfigDescriptor != null) {
            string = Integer.toString(this.isConfigDescriptor.getAssertionInterval());
        }
        return string == null ? "" : string;
    }

    public String getCleanupIntervalLabel() {
        return this.getLocalizedString("sc.cleanupInterval.label");
    }

    public String getCleanupIntervalValue() {
        String string = null;
        if (this.fetchAffiliateDescriptor() && this.isConfigDescriptor != null) {
            string = Integer.toString(this.isConfigDescriptor.getCleanupInterval());
        }
        return string == null ? "" : string;
    }

    public String getArtifactTimeoutLabel() {
        return this.getLocalizedString("sc.artifactTimeout.label");
    }

    public String getArtifactTimeoutValue() {
        String string = null;
        if (this.fetchAffiliateDescriptor() && this.isConfigDescriptor != null) {
            string = Integer.toString(this.isConfigDescriptor.getArtifactTimeout());
        }
        return string == null ? "" : string;
    }

    public String getAssertionLimitLabel() {
        return this.getLocalizedString("sc.assertionLimit.label");
    }

    public String getAssertionLimitValue() {
        String string = null;
        if (this.fetchAffiliateDescriptor() && this.isConfigDescriptor != null) {
            string = Integer.toString(this.isConfigDescriptor.getAssertionLimit());
        }
        return string == null ? "" : string;
    }

    public boolean createProvider(FSProviderDescriptor fSProviderDescriptor) {
        try {
            this.debugMessage("FSProviderProfileModelImpl.createProvider");
            FSAllianceManager fSAllianceManager = new FSAllianceManager(this.ssoToken);
            fSAllianceManager.createProvider(fSProviderDescriptor);
            this.setAffiliateId(fSProviderDescriptor.getProviderID());
            return true;
        }
        catch (FSAllianceManagementException fSAllianceManagementException) {
            if (this.warningEnabled()) {
                this.debugWarning("error in createProvider ", (Exception)((Object)fSAllianceManagementException));
            }
            this.errorMessage = this.getErrorString((Exception)((Object)fSAllianceManagementException));
            return false;
        }
    }

    public String getCreatedEntry() {
        if (this.affiliateId == null) {
            return "";
        }
        return this.affiliateId;
    }

    public boolean modifyAffiliate(FSProviderDescriptor fSProviderDescriptor) {
        try {
            this.debugMessage("FSProviderProfileModelImpl.modifyAffiliate");
            FSAllianceManager fSAllianceManager = new FSAllianceManager(this.ssoToken);
            fSAllianceManager.modifyProvider(fSProviderDescriptor);
            return true;
        }
        catch (FSAllianceManagementException fSAllianceManagementException) {
            if (this.warningEnabled()) {
                this.debugWarning("error in createAffiliate ", (Exception)((Object)fSAllianceManagementException));
            }
            this.errorMessage = this.getErrorString((Exception)((Object)fSAllianceManagementException));
            return false;
        }
    }

    public Map getStatusTypes() {
        HashMap<String, String> hashMap = new HashMap<String, String>(4);
        hashMap.put(this.getLocalizedString("statusType.active"), "active");
        hashMap.put(this.getLocalizedString("statusType.inactive"), "inactive");
        return hashMap;
    }

    public Map getLogoutProtocolTypes() {
        HashMap<String, String> hashMap = new HashMap<String, String>(6);
        hashMap.put(this.getLocalizedString("protocolType.soap"), "http://projectliberty.org/profiles/slo-sp-soap");
        hashMap.put(this.getLocalizedString("protocolType.httpRedirect"), "http://projectliberty.org/profiles/slo-sp-http");
        if (this.getRoleValue().equals("IDP/SP") || this.getRoleValue().equals("IDP")) {
            hashMap.put(this.getLocalizedString("protocolType.httpGet"), "http://projectliberty.org/profiles/slo-idp-http-get");
        }
        return hashMap;
    }

    public Map getFedTerminateProtocolTypes() {
        HashMap<String, String> hashMap = new HashMap<String, String>(4);
        hashMap.put(this.getLocalizedString("protocolType.soap"), "http://projectliberty.org/profiles/fedterm-sp-soap");
        hashMap.put(this.getLocalizedString("protocolType.httpRedirect"), "http://projectliberty.org/profiles/fedterm-sp-http");
        return hashMap;
    }

    public Map getNameRegisProfileTypes() {
        HashMap<String, String> hashMap = new HashMap<String, String>(4);
        hashMap.put(this.getLocalizedString("protocolType.soap"), "http://projectliberty.org/profiles/rni-sp-soap");
        hashMap.put(this.getLocalizedString("protocolType.httpRedirect"), "http://projectliberty.org/profiles/rni-sp-http");
        return hashMap;
    }

    public Set getCOTList() {
        try {
            this.debugMessage("FSProviderProfileModelImpl.getCOTList");
            FSAllianceManager fSAllianceManager = new FSAllianceManager(this.ssoToken);
            return fSAllianceManager.getAllCirclesOfTrust();
        }
        catch (FSAllianceManagementException fSAllianceManagementException) {
            if (this.warningEnabled()) {
                this.debugWarning("error in createAffiliate ", (Exception)((Object)fSAllianceManagementException));
            }
            this.errorMessage = this.getErrorString((Exception)((Object)fSAllianceManagementException));
            return null;
        }
    }

    public String getAffilateDescription() {
        return this.getDescriptionLabel();
    }

    public String getTabLocalizedName(String string) {
        String string2 = null;
        string2 = string.equals("general") ? this.getLocalizedString("af.general-tab.label") : (string.equals("providers") ? this.getLocalizedString("showproviders.label") : string);
        return string2;
    }

    public void setAffiliateId(String string) {
        this.affiliateId = string;
    }

    private boolean fetchAffiliateDescriptor() {
        boolean bl;
        block8: {
            bl = false;
            if (this.affiliate == null) {
                if (this.messageEnabled()) {
                    this.debugMessage("Getting affiliate for - " + this.affiliateId);
                }
                try {
                    this.manager = new FSAllianceManager(this.ssoToken);
                    this.affiliate = this.manager.getProvider(this.affiliateId);
                    if (this.affiliate != null && this.affiliate instanceof FSHostedProviderDescriptor) {
                        this.isConfigDescriptor = ((FSHostedProviderDescriptor)this.affiliate).getLocalConfiguration();
                        this.fsorg = this.affiliate.getOrganization();
                        bl = true;
                    } else if (this.affiliate != null) {
                        this.fsorg = this.affiliate.getOrganization();
                        bl = true;
                    }
                    break block8;
                }
                catch (FSAllianceManagementException fSAllianceManagementException) {
                    if (this.warningEnabled()) {
                        this.debugWarning("error getting Provider for " + this.affiliateId, (Exception)((Object)fSAllianceManagementException));
                    }
                    break block8;
                }
            }
            bl = true;
        }
        return bl;
    }

    public String getProviderIdValue() {
        String string = null;
        if (this.fetchAffiliateDescriptor()) {
            string = this.affiliate.getProviderID();
        }
        return string == null ? "-" : string;
    }

    public String getInvalidUrlMessage() {
        return this.getLocalizedString("invalidURL.message");
    }

    public String getInvalidProviderUrlMessage() {
        return this.getLocalizedString("invalidProviderURL.message");
    }

    public String getInvalidProtocolMessage() {
        return this.getLocalizedString("invalidProtocol.message");
    }

    public FSProviderDescriptor getProvider(String string) throws FSAllianceManagementException {
        if (this.messageEnabled()) {
            this.debugMessage("Getting Provider for - " + string);
        }
        FSAllianceManager fSAllianceManager = new FSAllianceManager(this.ssoToken);
        return fSAllianceManager.getProvider(string);
    }

    public FSHostedProviderDescriptor getHostedProvider(String string) throws FSAllianceManagementException {
        if (this.messageEnabled()) {
            this.debugMessage("Getting HostedProvider for - " + string);
        }
        FSAllianceManager fSAllianceManager = new FSAllianceManager(this.ssoToken);
        return fSAllianceManager.getHostedProvider(string);
    }

    private void getManager() throws FSAllianceManagementException {
        this.manager = new FSAllianceManager(this.ssoToken);
    }

    public String getDescriptionValue() {
        String string = null;
        if (this.fetchAffiliateDescriptor()) {
            string = this.affiliate.getProviderName();
        }
        return string == null ? "" : string;
    }

    public String getAliasValue() {
        String string = null;
        if (this.fetchAffiliateDescriptor() && this.isConfigDescriptor != null) {
            string = this.isConfigDescriptor.getProviderAlias();
        }
        return string == null ? "" : string;
    }

    public String getProviderSuccinctIdValue() {
        String string = null;
        if (this.fetchAffiliateDescriptor()) {
            string = this.affiliate.getProviderSuccinctID();
        }
        return string == null ? "" : string;
    }

    public String getKeyInfoValue() {
        String string = null;
        if (this.fetchAffiliateDescriptor()) {
            string = this.affiliate.getKeyInfo();
        }
        return string == null ? "" : string;
    }

    public String getKeyUseValue() {
        return this.fetchAffiliateDescriptor() ? this.affiliate.getKeyUse() : "";
    }

    public String getKeySizeValue() {
        return this.fetchAffiliateDescriptor() ? Integer.toString(this.affiliate.getKeySize()) : "";
    }

    public String getEcryptionMethodValue() {
        return this.fetchAffiliateDescriptor() ? this.affiliate.getEncryptionMethod() : "";
    }

    public String getSoapEndpointValue() {
        String string = null;
        if (this.fetchAffiliateDescriptor()) {
            string = this.affiliate.getSOAPEndPoint();
        }
        return string == null ? "" : string;
    }

    public String getLogoutUrlValue() {
        String string = null;
        if (this.fetchAffiliateDescriptor()) {
            string = this.affiliate.getSLOServiceURL();
        }
        return string == null ? "" : string;
    }

    public String getTermNotificationUrlValue() {
        String string = null;
        if (this.fetchAffiliateDescriptor()) {
            string = this.affiliate.getRelationshipTerminationNotificationProfile();
        }
        return string == null ? "" : string;
    }

    public Set getNameIdMapBindValue() {
        Set set = null;
        if (this.fetchAffiliateDescriptor()) {
            set = this.affiliate.getNameIdMapBind();
        }
        return set == null ? Collections.EMPTY_SET : set;
    }

    public Set getAddMetaLocnValue() {
        Set set = null;
        if (this.fetchAffiliateDescriptor()) {
            set = this.affiliate.getAdditionalMetaLocation();
        }
        return set == null ? Collections.EMPTY_SET : set;
    }

    public Set getContactPersonValue() {
        Set set = null;
        if (this.fetchAffiliateDescriptor()) {
            set = this.affiliate.getContactPerson();
        }
        return set == null ? Collections.EMPTY_SET : set;
    }

    public String getExtensionValue() {
        String string = null;
        if (this.fetchAffiliateDescriptor()) {
            string = this.affiliate.getExtension();
        }
        return string == null ? "" : string;
    }

    public String getSignCertAliasValue() {
        String string = null;
        if (this.fetchAffiliateDescriptor()) {
            string = this.affiliate.getSignCertAlias();
        }
        return string == null ? "" : string;
    }

    public String getValidUntilValue() {
        String string = null;
        if (this.fetchAffiliateDescriptor()) {
            string = this.affiliate.getValidUntil();
        }
        return string == null ? "" : string;
    }

    public String getProviderRole() {
        String string = null;
        if (this.fetchAffiliateDescriptor()) {
            string = this.affiliate.getProviderRole();
        }
        return string == null ? "" : string;
    }

    public String getCacheDurationValue() {
        String string = null;
        if (this.fetchAffiliateDescriptor()) {
            string = this.affiliate.getCacheDuration();
        }
        return string == null ? "" : string;
    }

    public String getProtSuppEnumValue() {
        String string = null;
        if (this.fetchAffiliateDescriptor()) {
            string = this.affiliate.getProtocolSupportEnum();
        }
        return string == null ? "" : string;
    }

    public String getIntrNotificationValue() {
        String string = null;
        if (this.fetchAffiliateDescriptor()) {
            string = this.affiliate.getIntroductionNotificationProtocolProfile();
        }
        return string == null ? "" : string;
    }

    public Map getEnumTypes() {
        HashMap<String, String> hashMap = new HashMap<String, String>(4);
        hashMap.put(this.getLocalizedString("enumType.zero"), "urn:liberty:iff:2002-12");
        hashMap.put(this.getLocalizedString("enumType.one"), "urn:liberty:iff:2003-08");
        return hashMap;
    }

    public Map getKeyUsePossibleValues() {
        HashMap<String, String> hashMap = new HashMap<String, String>(4);
        hashMap.put(this.getLocalizedString("af.keytype.signing"), "signing");
        hashMap.put(this.getLocalizedString("af.keytype.encryption"), "encryption");
        return hashMap;
    }

    public Map getTermTypes() {
        HashMap<String, String> hashMap = new HashMap<String, String>(2);
        hashMap.put(this.getLocalizedString("termType.zero"), "http://projectliberty.org/profiles/rel-term-soap");
        return hashMap;
    }

    public String getLogoutReturnUrlValue() {
        String string = null;
        if (this.fetchAffiliateDescriptor()) {
            string = this.affiliate.getSLOServiceReturnURL();
        }
        return string == null ? "" : string;
    }

    public String getTerminationServiceUrlValue() {
        String string = null;
        if (this.fetchAffiliateDescriptor()) {
            string = this.affiliate.getFederationTerminationServiceURL();
        }
        return string == null ? "" : string;
    }

    public String getAssertionConsumerUrlIdValue() {
        String string = null;
        if (this.fetchAffiliateDescriptor()) {
            string = this.affiliate.getAssertionConsumerServiceURLId();
        }
        return string == null ? "" : string;
    }

    public String getAssertionConsumerUrlIsDefValue() {
        if (this.fetchAffiliateDescriptor()) {
            return this.affiliate.getAssertionConsumerServiceURLIsDefault() ? "true" : "false";
        }
        return "false";
    }

    public String getTerminationReturnUrlValue() {
        String string = null;
        if (this.fetchAffiliateDescriptor()) {
            string = this.affiliate.getFederationTerminationServiceReturnURL();
        }
        return string == null ? "" : string;
    }

    public String getStatusValue() {
        String string = null;
        if (this.fetchAffiliateDescriptor()) {
            string = this.affiliate.getProviderStatus();
        }
        return string == null ? "" : string;
    }

    public String getConsumerUrlValue() {
        String string = null;
        if (this.fetchAffiliateDescriptor()) {
            string = this.affiliate.getAssertionConsumerServiceURL();
        }
        return string == null ? "" : string;
    }

    public String getTerminationProtocolValue() {
        String string = null;
        if (this.fetchAffiliateDescriptor()) {
            string = this.affiliate.getFederationTerminationProtocolProfile();
        }
        return string == null ? "" : string;
    }

    public String getLogoutProtocolValue() {
        String string = null;
        if (this.fetchAffiliateDescriptor()) {
            string = this.affiliate.getSLOProtocolProfile();
        }
        return string == null ? "" : string;
    }

    public String getNameRegistrationIndicatorValue() {
        if (this.fetchAffiliateDescriptor()) {
            return this.affiliate.getNameRegistrationIndicator() ? "true" : "false";
        }
        return "false";
    }

    public String getNameRegistrationProfileValue() {
        String string = null;
        if (this.fetchAffiliateDescriptor()) {
            string = this.affiliate.getNameRegistrationProfile();
        }
        return string == null ? "" : string;
    }

    public String getNameRegistrationURLValue() {
        String string = null;
        if (this.fetchAffiliateDescriptor()) {
            string = this.affiliate.getNameRegistrationURL();
        }
        return string == null ? "" : string;
    }

    public String getNameRegistrationReturnURLValue() {
        String string = null;
        if (this.fetchAffiliateDescriptor()) {
            string = this.affiliate.getNameRegistrationReturnURL();
        }
        return string == null ? "" : string;
    }

    public String getNameRegistrationAfterSSOValue() {
        if (this.fetchAffiliateDescriptor()) {
            return this.affiliate.getNameRegistrationAfterSSO() ? "true" : "false";
        }
        return "false";
    }

    public String getRequestSignedValue() {
        if (this.fetchAffiliateDescriptor()) {
            return this.affiliate.getAuthnRequestSigned() ? "true" : "false";
        }
        return "false";
    }

    public String getRoleValue() {
        String string = null;
        if (this.fetchAffiliateDescriptor()) {
            string = this.affiliate.getProviderRole();
        }
        return string == null ? "" : string;
    }

    public String getLogonServiceUrlValue() {
        String string = null;
        if (this.fetchAffiliateDescriptor()) {
            string = this.affiliate.getSSOServiceURL();
        }
        return string == null ? "" : string;
    }

    public Set getNotPartOfCOTs() {
        Set set = null;
        try {
            this.getManager();
            set = this.manager.getAllCirclesOfTrust();
        }
        catch (FSAllianceManagementException fSAllianceManagementException) {
            if (this.warningEnabled()) {
                this.debugWarning("error in getAllCirclesOfTrust ", (Exception)((Object)fSAllianceManagementException));
            }
            this.errorMessage = this.getErrorString((Exception)((Object)fSAllianceManagementException));
        }
        return set == null ? Collections.EMPTY_SET : set;
    }

    public Set getPartOfCOTs() {
        Set set = null;
        if (this.fetchAffiliateDescriptor()) {
            set = this.affiliate.getListOfCOTs();
        }
        return set == null ? Collections.EMPTY_SET : set;
    }

    public Set getAvailableTrustedProviders() {
        Set set = null;
        try {
            this.getManager();
            set = this.manager.getProspectiveTrustedProviders(this.affiliateId);
        }
        catch (FSAllianceManagementException fSAllianceManagementException) {
            if (this.warningEnabled()) {
                this.debugWarning("error in getAvailableTrustedProviders ", (Exception)((Object)fSAllianceManagementException));
            }
            this.errorMessage = this.getErrorString((Exception)((Object)fSAllianceManagementException));
        }
        return set == null ? Collections.EMPTY_SET : set;
    }

    public Set getSelectedTrustedProviders() {
        Set set = null;
        if (this.fetchAffiliateDescriptor() && this.isConfigDescriptor != null) {
            set = this.isConfigDescriptor.getTrustedProviders();
        }
        return set == null ? Collections.EMPTY_SET : set;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public Map getIDPAuthContextInfo() {
        Map map = null;
        this.fetchAffiliateDescriptor();
        if (this.isConfigDescriptor != null) {
            map = this.isConfigDescriptor.getIDPAuthContextInfo();
        }
        return map == null ? Collections.EMPTY_MAP : map;
    }

    public Map getSPAuthContextInfo() {
        Map map = null;
        this.fetchAffiliateDescriptor();
        if (this.isConfigDescriptor != null) {
            map = this.isConfigDescriptor.getSPAuthContextInfo();
        }
        return map == null ? Collections.EMPTY_MAP : map;
    }

    public Map getModuleIndicatorKeys() {
        HashMap<String, String> hashMap = new HashMap<String, String>(10);
        hashMap.put(this.getLocalizedString("authn.keyType.role"), "Role".toLowerCase());
        hashMap.put(this.getLocalizedString("authn.keyType.user"), "User".toLowerCase());
        hashMap.put(this.getLocalizedString("authn.keyType.level"), "AuthLevel".toLowerCase());
        hashMap.put(this.getLocalizedString("authn.keyType.module"), "Module".toLowerCase());
        hashMap.put(this.getLocalizedString("authn.keyType.service"), "Service".toLowerCase());
        return hashMap;
    }

    public Map getAutnContextRefNames() {
        HashMap<String, String> hashMap = new HashMap<String, String>(20);
        hashMap.put(this.getLocalizedString("authncontext.MobileContract"), "http://www.projectliberty.org/schemas/authctx/classes/MobileContract");
        hashMap.put(this.getLocalizedString("authncontext.MobileDigitalID"), "http://www.projectliberty.org/schemas/authctx/classes/MobileDigitalID");
        hashMap.put(this.getLocalizedString("authncontext.MobileUnregistered"), "http://www.projectliberty.org/schemas/authctx/classes/MobileUnregistered");
        hashMap.put(this.getLocalizedString("authncontext.Password"), "http://www.projectliberty.org/schemas/authctx/classes/Password");
        hashMap.put(this.getLocalizedString("authncontext.Password-ProtectedTransport"), "http://www.projectliberty.org/schemas/authctx/classes/Password-ProtectedTransport");
        hashMap.put(this.getLocalizedString("authncontext.Previous-Session"), "http://www.projectliberty.org/schemas/authctx/classes/Previous-Session");
        hashMap.put(this.getLocalizedString("authncontext.Smartcard"), "http://www.projectliberty.org/schemas/authctx/classes/Smartcard");
        hashMap.put(this.getLocalizedString("authncontext.Smartcard-PKI"), "http://www.projectliberty.org/schemas/authctx/classes/Smartcard-PKI");
        hashMap.put(this.getLocalizedString("authncontext.Software-PKI"), "http://www.projectliberty.org/schemas/authctx/classes/Software-PKI");
        hashMap.put(this.getLocalizedString("authncontext.Time-Sync-Token"), "http://www.projectliberty.org/schemas/authctx/classes/Time-Sync-Token");
        return hashMap;
    }

    public void setProviderView(int n) {
        this.providerType = n;
    }

    public String getHelpAnchorTag() {
        String string = this.getLocalizedString("providerProfile.help");
        if (string.equals("providerProfile.help")) {
            string = "contents.html";
        }
        return this.getHelpURL(string);
    }

    public List getSubViews() {
        ArrayList<String> arrayList = new ArrayList<String>(2);
        arrayList.add("general");
        arrayList.add("providers");
        AMMenuValidator aMMenuValidator = AMMenuValidatorImpl.getInstance();
        Set set = aMMenuValidator.getEntityDescriptorProfileMenuOptions(this);
        if (set != null && !set.isEmpty()) {
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                if (set.contains(iterator.next())) continue;
                iterator.remove();
            }
        }
        return arrayList;
    }

    public String getDefaultSubView() {
        List list;
        String string = "general";
        String string2 = null;
        if (string2 != null && string2.length() > 0 && (list = this.getSubViews()).contains(string2)) {
            string = string2;
        }
        return string;
    }

    public Class getViewBeanTypeClass(String string) {
        Class clazz = FSProviderProfileModel.CLASS_GENERAL_VIEWBEAN;
        return clazz;
    }

    public boolean isProviderExists() {
        return this.fetchAffiliateDescriptor();
    }

    public String getInvalidProviderMessage() {
        return this.getLocalizedString("invalidFederationProviderProfile.message");
    }

    public String getProviderValidUntilHelp() {
        return this.getLocalizedString("af.providerValidUntil.inlineHelp");
    }

    public String getProviderCacheDurationHelp() {
        return this.getLocalizedString("af.providerCacheDuration.inlineHelp");
    }

    public String getProviderKeyInfoHelp() {
        return this.getLocalizedString("af.KeyInfo.inlineHelp");
    }

    public String getProviderNameIdHelp() {
        return this.getLocalizedString("af.providerNameId.inlineHelp");
    }

    public String getProviderSelectLabel() {
        return this.getLocalizedString("af.providerSelect.label");
    }

    public String getNewContactPersonLabel() {
        return this.getLocalizedString("af.newContactPersonPage.label");
    }

    public String getProviderEditLabel() {
        return this.getLocalizedString("head1.label");
    }

    public Set getOrgNameValues() {
        Set set = null;
        if (this.fetchAffiliateDescriptor() && this.fsorg != null) {
            set = this.fsorg.getOrgName();
        }
        if (this.messageEnabled()) {
            this.debugMessage("Getting org for - " + set);
        }
        return set == null ? Collections.EMPTY_SET : set;
    }

    public Set getOrgDispNameValues() {
        Set set = null;
        if (this.fetchAffiliateDescriptor() && this.fsorg != null) {
            set = this.fsorg.getOrgDisplayName();
        }
        if (this.messageEnabled()) {
            this.debugMessage("Getting orgdisp for - " + set);
        }
        return set == null ? Collections.EMPTY_SET : set;
    }

    public Set getOrgURLValues() {
        Set set = null;
        if (this.fetchAffiliateDescriptor() && this.fsorg != null) {
            set = this.fsorg.getOrgURL();
        }
        if (this.messageEnabled()) {
            this.debugMessage("Getting orgurl for - " + set);
        }
        return set == null ? Collections.EMPTY_SET : set;
    }

    public String getOrgExtnValue() {
        String string = null;
        if (this.fetchAffiliateDescriptor() && this.fsorg != null) {
            string = this.fsorg.getExtension();
        }
        return string == null ? "" : string;
    }

    public String getContactPersonEditLabel() {
        return this.getLocalizedString("af.edit.label");
    }

    public Map getContactPersons() {
        Iterator iterator;
        FSContactPerson fSContactPerson;
        Set set;
        HashMap hashMap = null;
        if (this.fetchAffiliateDescriptor() && (set = this.affiliate.getContactPerson()) != null && !set.isEmpty() && (fSContactPerson = (FSContactPerson)((Map.Entry)(iterator = set.iterator()).next()).getValue()) != null) {
            hashMap = (HashMap)fSContactPerson.getAttributes(false);
        }
        return hashMap == null ? Collections.EMPTY_MAP : hashMap;
    }

    public String getCPNameLabel() {
        return this.getLocalizedString("contactPersonName.label");
    }

    public String getCPActionsLabel() {
        return this.getLocalizedString("contactPersonActions.label");
    }

    public String getCPCompanyLabel() {
        return this.getLocalizedString("contactPersonCompany.label");
    }

    public String getCPEmailLabel() {
        return this.getLocalizedString("contactPersonEmail.label");
    }

    public String getCPTypeLabel() {
        return this.getLocalizedString("contactPersonType.label");
    }

    public String getFirstNameLabel() {
        return this.getLocalizedString("contactPersonFirstName.label");
    }

    public String getLastNameLabel() {
        return this.getLocalizedString("contactPersonLastName.label");
    }

    public String getPhoneLabel() {
        return this.getLocalizedString("contactPersonPhone.label");
    }

    public String getLibertyPrinIdLabel() {
        return this.getLocalizedString("contactPersonLibertyPrinId.label");
    }

    public String getAddToListLabel() {
        return this.getLocalizedString("editableListAdd.button");
    }

    public String getRemoveFromListLabel() {
        return this.getLocalizedString("editableListRemove.button");
    }

    public Map getContactTypes() {
        HashMap<String, String> hashMap = new HashMap<String, String>(8);
        hashMap.put(this.getLocalizedString("contactType.tech"), "technical");
        hashMap.put(this.getLocalizedString("contactType.admin"), "administrative");
        hashMap.put(this.getLocalizedString("contactType.bill"), "billing");
        hashMap.put(this.getLocalizedString("contactType.other"), "other");
        return hashMap;
    }

    public Set getEmailAddressValues(String string) {
        Set set;
        Set set2 = null;
        if (this.fetchAffiliateDescriptor() && (set = this.affiliate.getContactPerson()) != null && !set.isEmpty()) {
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                FSContactPerson fSContactPerson = (FSContactPerson)((Map.Entry)iterator.next()).getValue();
                if (fSContactPerson == null || !fSContactPerson.getCPID().equalsIgnoreCase(string)) continue;
                set2 = fSContactPerson.getEmailAddress();
                break;
            }
        }
        return set2 == null ? Collections.EMPTY_SET : set2;
    }

    public Set getPhoneValues(String string) {
        Set set;
        Set set2 = null;
        if (this.fetchAffiliateDescriptor() && (set = this.affiliate.getContactPerson()) != null && !set.isEmpty()) {
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                FSContactPerson fSContactPerson = (FSContactPerson)((Map.Entry)iterator.next()).getValue();
                if (fSContactPerson == null || !fSContactPerson.getCPID().equalsIgnoreCase(string)) continue;
                set2 = fSContactPerson.getTelephoneNumber();
                break;
            }
        }
        return set2 == null ? Collections.EMPTY_SET : set2;
    }

    public String getFirstNameValue(String string) {
        Set set;
        String string2 = null;
        if (this.fetchAffiliateDescriptor() && (set = this.affiliate.getContactPerson()) != null && !set.isEmpty()) {
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                FSContactPerson fSContactPerson = (FSContactPerson)((Map.Entry)iterator.next()).getValue();
                if (fSContactPerson == null || !fSContactPerson.getCPID().equalsIgnoreCase(string)) continue;
                string2 = fSContactPerson.getGivenName();
                break;
            }
        }
        return string2 == null ? "" : string2;
    }

    public String getLastNameValue(String string) {
        Set set;
        String string2 = null;
        if (this.fetchAffiliateDescriptor() && (set = this.affiliate.getContactPerson()) != null && !set.isEmpty()) {
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                FSContactPerson fSContactPerson = (FSContactPerson)((Map.Entry)iterator.next()).getValue();
                if (fSContactPerson == null || !fSContactPerson.getCPID().equalsIgnoreCase(string)) continue;
                string2 = fSContactPerson.getSurName();
                break;
            }
        }
        return string2 == null ? "" : string2;
    }

    public String getLibertyPrinIdValue(String string) {
        Set set;
        String string2 = null;
        if (this.fetchAffiliateDescriptor() && (set = this.affiliate.getContactPerson()) != null && !set.isEmpty()) {
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                FSContactPerson fSContactPerson = (FSContactPerson)((Map.Entry)iterator.next()).getValue();
                if (fSContactPerson == null || !fSContactPerson.getCPID().equalsIgnoreCase(string)) continue;
                string2 = fSContactPerson.getlibertyPrincipalIdentifier();
                break;
            }
        }
        return string2 == null ? "" : string2;
    }

    public String getContactTypeValue(String string) {
        Set set;
        String string2 = null;
        if (this.fetchAffiliateDescriptor() && (set = this.affiliate.getContactPerson()) != null && !set.isEmpty()) {
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                FSContactPerson fSContactPerson = (FSContactPerson)((Map.Entry)iterator.next()).getValue();
                if (fSContactPerson == null || !fSContactPerson.getCPID().equalsIgnoreCase(string)) continue;
                string2 = fSContactPerson.getContactType();
                break;
            }
        }
        return string2 == null ? "" : string2;
    }

    public String getCompanyValue(String string) {
        Set set;
        String string2 = null;
        if (this.fetchAffiliateDescriptor() && (set = this.affiliate.getContactPerson()) != null && !set.isEmpty()) {
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                FSContactPerson fSContactPerson = (FSContactPerson)((Map.Entry)iterator.next()).getValue();
                if (fSContactPerson == null || !fSContactPerson.getCPID().equalsIgnoreCase(string)) continue;
                string2 = fSContactPerson.getCompany();
                break;
            }
        }
        return string2 == null ? "" : string2;
    }

    public boolean deleteContactPersons(String string, Set set) {
        boolean bl = false;
        try {
            if (set != null && !set.isEmpty()) {
                this.getManager();
                Iterator iterator = set.iterator();
                while (iterator.hasNext()) {
                    String string2 = (String)iterator.next();
                    this.manager.deleteProviderContactPerson(string, string2);
                }
                bl = true;
            }
        }
        catch (FSAllianceManagementException fSAllianceManagementException) {
            if (this.warningEnabled()) {
                this.debugWarning("Error in getting FSAllianceManager", (Exception)((Object)fSAllianceManagementException));
            }
            this.errorMessage = this.getErrorString((Exception)((Object)fSAllianceManagementException));
        }
        return bl;
    }

    public String getNoContactPersonSelectedForDelTitle() {
        return this.getLocalizedString("noContactPersonSelectedForDeletion.title");
    }

    public String getNoContactPersonSelectedForDelMessage() {
        return this.getLocalizedString("noContactPersonSelectedForDeletion.message");
    }

    public FSContactPerson getContactPerson(String string) {
        Set set;
        FSContactPerson fSContactPerson = null;
        if (this.fetchAffiliateDescriptor() && (set = this.affiliate.getContactPerson()) != null && !set.isEmpty()) {
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                FSContactPerson fSContactPerson2 = (FSContactPerson)((Map.Entry)iterator.next()).getValue();
                if (fSContactPerson2 == null || !fSContactPerson2.getCPID().equalsIgnoreCase(string)) continue;
                fSContactPerson = fSContactPerson2;
                break;
            }
        }
        return fSContactPerson;
    }

    public String getKeySizeLabel() {
        return this.getLocalizedString("af.keySize.label");
    }

    public String getKeySizeHelp() {
        return this.getLocalizedString("af.keySize.help");
    }

    public String getKeyUseLabel() {
        return this.getLocalizedString("af.keyUse.label");
    }

    public String getEncryptionMethodLabel() {
        return this.getLocalizedString("af.encryptionMethod.label");
    }

    public String getEncryptionMethodHelp() {
        return this.getLocalizedString("af.encryptionMethod.help");
    }

    public String getAssertionIssuerLabel() {
        return this.getLocalizedString("sc.assertionIssuer.label");
    }

    public String getAssertionIssuerHelp() {
        return this.getLocalizedString("sc.assertionIssuer.help");
    }

    public String getAssertionIssuer() {
        String string = null;
        if (this.fetchAffiliateDescriptor() && this.isConfigDescriptor != null) {
            string = this.isConfigDescriptor.getAssertionIssuer();
        }
        return string == null ? "" : string;
    }
}

