/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.am.console.federation.model;

import com.iplanet.am.console.base.model.AMConsoleException;
import com.iplanet.am.console.base.model.AMMenuValidator;
import com.iplanet.am.console.base.model.AMMenuValidatorImpl;
import com.iplanet.am.console.base.model.AMModelBase;
import com.iplanet.am.console.base.model.AMProfileModelBase;
import com.iplanet.am.console.federation.model.FSEntityDescProfileModel;
import com.iplanet.am.console.settings.Setting;
import com.iplanet.am.util.Locale;
import com.sun.identity.federation.alliance.FSAffiliationDescriptor;
import com.sun.identity.federation.alliance.FSAllianceManagementException;
import com.sun.identity.federation.alliance.FSAllianceManager;
import com.sun.identity.federation.alliance.FSContactPerson;
import com.sun.identity.federation.alliance.FSEntityDescriptor;
import com.sun.identity.federation.alliance.FSOrganization;
import com.sun.identity.federation.alliance.FSProviderDescriptor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;

public class FSEntityDescProfileModelImpl
extends AMProfileModelBase
implements FSEntityDescProfileModel {
    public String errorMessage = null;
    protected String entityId = null;
    protected String isAffiliateValue = null;
    protected FSProviderDescriptor fspd = null;
    private FSOrganization fsorg = null;
    private FSContactPerson fscp = null;
    private FSEntityDescriptor fsd = null;
    private FSAffiliationDescriptor fsad = null;
    private FSAllianceManager manager = null;
    private int entityType = 1;

    public FSEntityDescProfileModelImpl(HttpServletRequest httpServletRequest, Map map) {
        super(httpServletRequest, "amAdminModuleMsgs", map);
        String string = httpServletRequest.getParameter("AffiliateID");
        if (string == null || string.length() == 0) {
            string = (String)map.get("AffiliateID");
        }
        if (string != null && string.length() > 0) {
            this.setEntityId(string);
        } else {
            AMModelBase.debug.message("FSEntityDescProfileModelImpl, affiliate ID is null");
        }
    }

    public String getCreateEntityTitle() {
        return this.getLocalizedString("af.createEntity.title");
    }

    public String getNoEntityWarning() {
        return this.getLocalizedString("txtNoEntity.warning");
    }

    public String getShowLabel() {
        return this.getLocalizedString("view.label");
    }

    public String getAffiliateMemberLabel() {
        return this.getLocalizedString("af.affiliateMember.label");
    }

    public String getKeyInfoLabel() {
        return this.getLocalizedString("af.keyInfo.label");
    }

    public String getKeyUseLabel() {
        return this.getLocalizedString("af.keyUse.label");
    }

    public String getKeySizeLabel() {
        return this.getLocalizedString("af.keySize.label");
    }

    public String getKeySizeHelp() {
        return this.getLocalizedString("af.keySize.help");
    }

    public String getEncryptionMethodLabel() {
        return this.getLocalizedString("af.encryptionMethod.label");
    }

    public String getEncryptionMethodHelp() {
        return this.getLocalizedString("af.encryptionMethod.help");
    }

    public String getAffiliateIdLabel() {
        return this.getLocalizedString("af.affiliateId.label");
    }

    public String getAffiliateOwnerIdLabel() {
        return this.getLocalizedString("af.affiliateOwnerId.label");
    }

    public String getHeading1Label() {
        return this.getLocalizedString("head1.label");
    }

    public String getHeading2Label() {
        return this.getLocalizedString("head2.label");
    }

    public String getProvidersLabel() {
        return this.getLocalizedString("providers.label");
    }

    public String getCmnAttrsLabel() {
        return this.getLocalizedString("commonAttributes.label");
    }

    public String getDescriptionLabel() {
        return this.getLocalizedString("af.description.label");
    }

    public String getEntityIdLabel() {
        return this.getLocalizedString("af.entityId.label");
    }

    public String getAffiliateSelectLabel() {
        return this.getLocalizedString("af.affiliateSelect.label");
    }

    public String getEntityValidUntilHelp() {
        return this.getLocalizedString("af.entityValidUntil.inlineHelp");
    }

    public String getEntityKeyInfoHelp() {
        return this.getLocalizedString("af.KeyInfo.inlineHelp");
    }

    public String getEntityCacheDurationHelp() {
        return this.getLocalizedString("af.entityCacheDuration.inlineHelp");
    }

    public String getEntityOrgNameInlineHelp() {
        return this.getLocalizedString("orgName.inlineHelp");
    }

    public String getEntityOrgDispNameInlineHelp() {
        return this.getLocalizedString("orgDispName.inlineHelp");
    }

    public String getEntityOrgURLInlineHelp() {
        return this.getLocalizedString("orgURL.inlineHelp");
    }

    public String getAddButtonLabel() {
        return this.getLocalizedString("selectableListAdd.button");
    }

    public String getNewButtonLabel() {
        return this.getLocalizedString("new.button");
    }

    public String getDeleteButtonLabel() {
        return this.getLocalizedString("delete.button");
    }

    public String getCreateErrorTitle() {
        return this.getLocalizedString("createEntityFailed.title");
    }

    public String getModifyErrorTitle() {
        return this.getLocalizedString("modifyEntityFailed.title");
    }

    public String getRequiredFieldLabel() {
        return this.getLocalizedString("required.label");
    }

    public String getNoProvidersAvailableMessage() {
        return this.getLocalizedString("noProvider.message");
    }

    public String getCreateButtonLabel() {
        return this.getLocalizedString("create.button");
    }

    public String getSaveButtonLabel() {
        return this.getLocalizedString("save.button");
    }

    public String getCancelButtonLabel() {
        return this.getLocalizedString("cancel.button");
    }

    public String getCPCompanyLabel() {
        return this.getLocalizedString("contactPersonCompany.label");
    }

    public String getCPEmailLabel() {
        return this.getLocalizedString("contactPersonEmail.label");
    }

    public String getCPTypeLabel() {
        return this.getLocalizedString("contactPersonType.label");
    }

    public String getMissingAttributeMessage() {
        return this.getLocalizedString("missingAttributes.message");
    }

    public String getInvalidTimeErrorMessage() {
        return this.getLocalizedString("invalidTime.message");
    }

    public String getResetButtonLabel() {
        return this.getLocalizedString("reset.button");
    }

    public void createEntityDescriptor(String string, String string2, boolean bl, String string3, String string4) throws AMConsoleException {
        FSEntityDescriptor fSEntityDescriptor;
        if (bl) {
            if (string3 != null && string3.trim().length() == 0) {
                throw new AMConsoleException(this.getLocalizedString("af.missingAffiliateId"));
            }
            if (string4 != null && string4.trim().length() == 0) {
                throw new AMConsoleException(this.getLocalizedString("af.missingAffiliateOwnerId"));
            }
        }
        try {
            fSEntityDescriptor = new FSEntityDescriptor(string, "active");
            fSEntityDescriptor.setEntityDescription(string2);
            if (bl) {
                fSEntityDescriptor.setType("urn:liberty:iff:affiliate");
            } else {
                fSEntityDescriptor.setType("urn:liberty:iff:provider");
            }
            this.createEntityDescriptor(fSEntityDescriptor);
        }
        catch (FSAllianceManagementException fSAllianceManagementException) {
            throw new AMConsoleException(fSAllianceManagementException);
        }
        if (bl) {
            try {
                fSEntityDescriptor = new FSAffiliationDescriptor(string3);
                fSEntityDescriptor.setAffiliationOwnerID(string4);
                this.addAffiliate((FSAffiliationDescriptor)fSEntityDescriptor);
            }
            catch (FSAllianceManagementException fSAllianceManagementException) {
                this.deleteEntityDescriptor();
                throw new AMConsoleException(fSAllianceManagementException);
            }
        }
    }

    private void deleteEntityDescriptor() {
        try {
            FSAllianceManager fSAllianceManager = new FSAllianceManager(this.ssoToken);
            HashSet<String> hashSet = new HashSet<String>(2);
            hashSet.add(this.entityId);
            fSAllianceManager.deleteEntity(hashSet);
        }
        catch (FSAllianceManagementException fSAllianceManagementException) {
            AMModelBase.debug.error("FSEntityDescProfileModelImpl.deleteEntityDescriptor", (Throwable)fSAllianceManagementException);
        }
    }

    private void createEntityDescriptor(FSEntityDescriptor fSEntityDescriptor) throws AMConsoleException {
        try {
            FSAllianceManager fSAllianceManager = new FSAllianceManager(this.ssoToken);
            fSAllianceManager.createEntityProvider(fSEntityDescriptor);
            this.setEntityId(fSEntityDescriptor.getEntityID());
        }
        catch (FSAllianceManagementException fSAllianceManagementException) {
            throw new AMConsoleException(fSAllianceManagementException);
        }
    }

    public String getCreatedEntry() {
        if (this.entityId == null) {
            this.debugMessage("FSEntityDescProfileModelImpl.getCreateEntry() : the entityID is null");
            return "";
        }
        return this.entityId;
    }

    public boolean modifyEntity(FSEntityDescriptor fSEntityDescriptor) {
        boolean bl = false;
        try {
            this.debugMessage("FSEntityDescProfileModelImpl.modifyEntity");
            FSAllianceManager fSAllianceManager = new FSAllianceManager(this.ssoToken);
            fSAllianceManager.modifyEntity(fSEntityDescriptor);
            bl = true;
        }
        catch (FSAllianceManagementException fSAllianceManagementException) {
            if (this.warningEnabled()) {
                this.debugWarning("error in modifyEntity ", (Exception)((Object)fSAllianceManagementException));
            }
            this.errorMessage = this.getErrorString((Exception)((Object)fSAllianceManagementException));
        }
        return bl;
    }

    public Map getStatusTypes() {
        HashMap<String, String> hashMap = new HashMap<String, String>(4);
        hashMap.put(this.getLocalizedString("statusType.active"), "active");
        hashMap.put(this.getLocalizedString("statusType.inactive"), "inactive");
        return hashMap;
    }

    public String getTabLocalizedName(String string) {
        String string2 = null;
        string2 = string.equals("general") ? this.getLocalizedString("af.general-tab.label") : (string.equals("providers") ? this.getLocalizedString("af.provider-tab.label") : (string.equals("authenticationdomain") ? this.getLocalizedString("af.authenticationDomain-tab.label") : (string.equals("affiliates") ? this.getLocalizedString("af.affiliates-tab.label") : string)));
        return string2;
    }

    public void setEntityId(String string) {
        this.entityId = string;
    }

    public String getEntityId() {
        this.entityId = this.entityId;
        return this.entityId;
    }

    private boolean fetchEntityDescriptor() {
        if (this.fsd == null) {
            block5: {
                if (this.messageEnabled()) {
                    this.debugMessage("Getting fsd for - " + this.entityId);
                }
                try {
                    this.manager = new FSAllianceManager(this.ssoToken);
                    this.fsd = this.manager.getEntity(this.entityId);
                    this.fscp = this.fsd.getContactPerson();
                    this.fsorg = this.fsd.getOrganization();
                    this.fsad = this.fsd.getAffiliationDescriptor();
                    if (this.fsd != null) {
                        return true;
                    }
                }
                catch (FSAllianceManagementException fSAllianceManagementException) {
                    if (!this.warningEnabled()) break block5;
                    this.debugWarning("error getting Entity for " + this.entityId, (Exception)((Object)fSAllianceManagementException));
                }
            }
            return false;
        }
        this.fscp = this.fsd.getContactPerson();
        this.fsorg = this.fsd.getOrganization();
        this.fsad = this.fsd.getAffiliationDescriptor();
        return true;
    }

    public String getEntityIdValue() {
        String string = null;
        if (this.fetchEntityDescriptor()) {
            string = this.fsd.getEntityID();
        }
        return string == null ? "-" : string;
    }

    public FSEntityDescriptor getEntity(String string) throws FSAllianceManagementException {
        if (this.messageEnabled()) {
            this.debugMessage("Getting Entity for - " + string);
        }
        FSAllianceManager fSAllianceManager = new FSAllianceManager(this.ssoToken);
        return fSAllianceManager.getEntity(string);
    }

    private void getManager() throws FSAllianceManagementException {
        this.manager = new FSAllianceManager(this.ssoToken);
    }

    public String getDescriptionValue() {
        String string = null;
        if (this.fetchEntityDescriptor()) {
            string = this.fsd.getEntityDescription();
        }
        return string == null ? "" : string;
    }

    public String getValidUntilValue() {
        String string = null;
        if (this.fetchEntityDescriptor()) {
            string = this.fsd.getValidUntil();
        }
        return string == null ? "" : string;
    }

    public String getAffiliateIdValue() {
        String string = null;
        if (this.fetchEntityDescriptor() && this.fsad != null) {
            string = this.fsad.getAffiliationID();
        }
        return string == null ? "" : string;
    }

    public String getAffiliateOwnerIdValue() {
        String string = null;
        if (this.fetchEntityDescriptor() && this.fsad != null) {
            string = this.fsad.getAffiliationOwnerID();
        }
        return string == null ? "" : string;
    }

    public String getCacheDurationValue() {
        String string = null;
        if (this.fetchEntityDescriptor()) {
            string = this.fsd.getCacheDuration();
        }
        return string == null ? "" : string;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public List getErrorMsg() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(this.errorMessage);
        return arrayList;
    }

    public void setEntityView(int n) {
        this.entityType = n;
    }

    public String getHelpAnchorTag() {
        String string = null;
        switch (this.entityType) {
            case 9: {
                string = this.getHelpAnchorTag("createEntityDescriptor.help");
                break;
            }
            case 4: {
                string = this.getHelpAnchorTag("affiliateProfile.help");
                break;
            }
            case 3: {
                string = this.getHelpAnchorTag("providerProfile.help");
                break;
            }
            default: {
                string = this.getHelpAnchorTag("entityDescriptorProfile.help");
            }
        }
        return this.getHelpURL(string);
    }

    protected String getHelpAnchorTag(String string) {
        String string2 = this.getLocalizedString(string);
        return string2.equals(string) ? "contents.html" : string2;
    }

    public List getSubViews() {
        ArrayList<String> arrayList = new ArrayList<String>(2);
        arrayList.add("general");
        if (this.getIsAffiliateValue().equalsIgnoreCase("true")) {
            arrayList.add("affiliates");
        } else {
            arrayList.add("providers");
        }
        AMMenuValidator aMMenuValidator = AMMenuValidatorImpl.getInstance();
        Set set = aMMenuValidator.getEntityDescriptorProfileMenuOptions(this);
        if (set != null && !set.isEmpty()) {
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                if (set.contains(iterator.next())) continue;
                iterator.remove();
            }
        }
        return arrayList;
    }

    public String getDefaultSubView() {
        String string = null;
        Set set = this.getUserSettings(Setting.DEFAULT_ENTITY_DESCRIPTOR_PROFILE_VIEW);
        if (set != null && !set.isEmpty()) {
            String string2 = (String)set.iterator().next();
            string = string2.toLowerCase();
        }
        if (string == null) {
            string = "general";
        }
        return string;
    }

    public Class getViewBeanTypeClass(String string) {
        Class clazz = FSEntityDescProfileModel.CLASS_GENERAL_VIEWBEAN;
        if (string.equals("providers")) {
            clazz = FSEntityDescProfileModel.CLASS_PROVIDER_VIEWBEAN;
        } else if (string.equals("authenticationdomain")) {
            clazz = FSEntityDescProfileModel.CLASS_AUTH_DOMAIN_VIEWBEAN;
        } else if (string.equals("affiliates")) {
            clazz = FSEntityDescProfileModel.CLASS_AFFILIATE_VIEWBEAN;
        }
        return clazz;
    }

    public String getEntityDescriptorTypeLabel() {
        return this.getLocalizedString("af.entityDescriptorType.label");
    }

    public String getAffiliateTypeLabel() {
        return this.getLocalizedString("af.affiliateType.label");
    }

    public String getProviderTypeLabel() {
        return this.getLocalizedString("af.providerType.label");
    }

    public String getExtensionLabel() {
        return this.getLocalizedString("af.extension.label");
    }

    public String getContactPersonLabel() {
        return this.getLocalizedString("af.contactPerson.label");
    }

    public String getOrgLabel() {
        return this.getLocalizedString("af.entityOrg.label");
    }

    public String getValidUntilLabel() {
        return this.getLocalizedString("af.validUntil.label");
    }

    public String getCacheDurationLabel() {
        return this.getLocalizedString("af.cacheDuration.label");
    }

    public String getFirstNameLabel() {
        return this.getLocalizedString("contactPersonFirstName.label");
    }

    public String getLastNameLabel() {
        return this.getLocalizedString("contactPersonLastName.label");
    }

    public String getPhoneLabel() {
        return this.getLocalizedString("contactPersonPhone.label");
    }

    public String getLibertyPrinIdLabel() {
        return this.getLocalizedString("contactPersonLibertyPrinId.label");
    }

    public String getOrgNameLabel() {
        return this.getLocalizedString("orgName.label");
    }

    public String getOrgDispNameLabel() {
        return this.getLocalizedString("orgDispName.label");
    }

    public String getOrgURLLabel() {
        return this.getLocalizedString("orgURL.label");
    }

    public String getOrgExtnLabel() {
        return this.getLocalizedString("orgExtn.label");
    }

    public String getProvIdLabel() {
        return this.getLocalizedString("af.providerId.label");
    }

    public String getProvActionLabel() {
        return this.getLocalizedString("af.providerAction.label");
    }

    public String getProvEditLabel() {
        return this.getLocalizedString("af.edit.label");
    }

    public String getProvNameLabel() {
        return this.getLocalizedString("af.name.label");
    }

    public Map getContactTypes() {
        HashMap<String, String> hashMap = new HashMap<String, String>(8);
        hashMap.put(this.getLocalizedString("contactType.tech"), "technical");
        hashMap.put(this.getLocalizedString("contactType.admin"), "administrative");
        hashMap.put(this.getLocalizedString("contactType.bill"), "billing");
        hashMap.put(this.getLocalizedString("contactType.other"), "other");
        return hashMap;
    }

    public Set getOrgNameValues() {
        Set set = null;
        if (this.fetchEntityDescriptor() && this.fsorg != null) {
            set = this.fsorg.getOrgName();
        }
        return set == null ? Collections.EMPTY_SET : set;
    }

    public Set getOrgDispNameValues() {
        Set set = null;
        if (this.fetchEntityDescriptor() && this.fsorg != null) {
            set = this.fsorg.getOrgDisplayName();
        }
        return set == null ? Collections.EMPTY_SET : set;
    }

    public Set getOrgURLValues() {
        Set set = null;
        if (this.fetchEntityDescriptor() && this.fsorg != null) {
            set = this.fsorg.getOrgURL();
        }
        return set == null ? Collections.EMPTY_SET : set;
    }

    public String getOrgExtnValue() {
        String string = null;
        if (this.fetchEntityDescriptor() && this.fsorg != null) {
            string = this.fsorg.getExtension();
        }
        return string == null ? "" : string;
    }

    public String getFirstNameValue() {
        String string = null;
        if (this.fetchEntityDescriptor() && this.fscp != null) {
            string = this.fscp.getGivenName();
        }
        return string == null ? "" : string;
    }

    public String getLastNameValue() {
        String string = null;
        if (this.fetchEntityDescriptor() && this.fscp != null) {
            string = this.fscp.getSurName();
        }
        return string == null ? "" : string;
    }

    public String getLibertyPrinIdValue() {
        String string = null;
        if (this.fetchEntityDescriptor() && this.fscp != null) {
            string = this.fscp.getlibertyPrincipalIdentifier();
        }
        return string == null ? "" : string;
    }

    public String getContactTypeValue() {
        String string = null;
        if (this.fetchEntityDescriptor() && this.fscp != null) {
            string = this.fscp.getContactType();
        }
        return string == null ? "" : string;
    }

    public String getCompanyValue() {
        String string = null;
        if (this.fetchEntityDescriptor() && this.fscp != null) {
            string = this.fscp.getCompany();
        }
        return string == null ? "" : string;
    }

    public Set getEmailAddressValues() {
        Set set = null;
        if (this.fetchEntityDescriptor() && this.fscp != null) {
            set = this.fscp.getEmailAddress();
        }
        return set == null ? Collections.EMPTY_SET : set;
    }

    public Set getPhoneValues() {
        Set set = null;
        if (this.fetchEntityDescriptor() && this.fscp != null) {
            set = this.fscp.getTelephoneNumber();
        }
        return set == null ? Collections.EMPTY_SET : set;
    }

    public boolean validateDateString(String string) throws AMConsoleException {
        Date date;
        boolean bl = true;
        if (string != null && string.length() > 0 && (date = Locale.parseDateString((String)string, (java.util.Locale)this.getUserLocale(), (String)this.getLocalizedString("validUntil.syntax"))) == null) {
            AMModelBase.debug.error("date syntax = " + this.getLocalizedString("validUntil.syntax"));
            AMModelBase.debug.error("date string = " + string + " was invalid.");
            throw new AMConsoleException(this.getLocalizedString("invalidValidUntilSyntax.message"));
        }
        return bl;
    }

    public Set getDateInDefaultLocale(Set set) throws AMConsoleException {
        return super.getDateInDefaultLocale(set);
    }

    public String getIsAffiliateValue() {
        String string = null;
        if (this.fetchEntityDescriptor()) {
            if (this.fsd.getType().equalsIgnoreCase("urn:liberty:iff:affiliate")) {
                string = "true";
            } else if (this.fsd.getType().equalsIgnoreCase("urn:liberty:iff:provider")) {
                string = "false";
            }
        }
        return string == null ? "" : string;
    }

    public void setIsAffiliateValue(String string) {
        this.isAffiliateValue = string;
    }

    public void setProviderDescriptor(FSProviderDescriptor fSProviderDescriptor) {
        this.fspd = fSProviderDescriptor;
    }

    public FSProviderDescriptor getProviderDescriptor() {
        return this.fspd;
    }

    public Map getProviderDisplay() {
        HashMap<String, String> hashMap;
        block5: {
            Set set;
            Set set2;
            String string;
            String string2;
            Iterator iterator;
            block6: {
                hashMap = null;
                iterator = null;
                string2 = null;
                string = null;
                if (!this.fetchEntityDescriptor()) break block5;
                set2 = this.fsd.getSPDescriptor();
                set = this.fsd.getIDPDescriptor();
                if (set2 != null && !set2.isEmpty() || set != null && !set.isEmpty()) break block6;
                if (!this.messageEnabled()) break block5;
                AMModelBase.debug.message("FSEntityDescProfileModelImpl, list is empty");
                break block5;
            }
            if (set2 != null && !set2.isEmpty()) {
                iterator = set2.iterator();
                while (iterator.hasNext()) {
                    FSProviderDescriptor fSProviderDescriptor = (FSProviderDescriptor)((Map.Entry)iterator.next()).getValue();
                    string2 = fSProviderDescriptor.getProviderID();
                    string = fSProviderDescriptor.getProviderName();
                    hashMap = new HashMap<String, String>(2);
                    hashMap.put(string2, string);
                }
            } else if (set != null && !set.isEmpty()) {
                iterator = set.iterator();
                while (iterator.hasNext()) {
                    FSProviderDescriptor fSProviderDescriptor = (FSProviderDescriptor)((Map.Entry)iterator.next()).getValue();
                    string2 = fSProviderDescriptor.getProviderID();
                    string = fSProviderDescriptor.getProviderName();
                    hashMap = new HashMap(2);
                    hashMap.put(string2, string);
                }
            }
        }
        return hashMap == null ? Collections.EMPTY_MAP : hashMap;
    }

    public String getProviderID() {
        String string;
        block5: {
            Set set;
            Set set2;
            Iterator iterator;
            block6: {
                iterator = null;
                string = null;
                if (!this.fetchEntityDescriptor()) break block5;
                set2 = this.fsd.getSPDescriptor();
                set = this.fsd.getIDPDescriptor();
                if (set2 != null && !set2.isEmpty() || set != null && !set.isEmpty()) break block6;
                if (!this.messageEnabled()) break block5;
                AMModelBase.debug.message("FSEntityDescProfileModelImpl,  list is empty");
                break block5;
            }
            if (set2 != null && !set2.isEmpty()) {
                AMModelBase.debug.message("FSEntityDescProfileModelImpl, sp size : " + set2.size());
                iterator = set2.iterator();
                while (iterator.hasNext()) {
                    FSProviderDescriptor fSProviderDescriptor = (FSProviderDescriptor)((Map.Entry)iterator.next()).getValue();
                    string = fSProviderDescriptor.getProviderID();
                }
            } else if (set != null && !set.isEmpty()) {
                AMModelBase.debug.message("FSEntityDescProfileModelImpl, idp size : " + set.size());
                iterator = set.iterator();
                while (iterator.hasNext()) {
                    FSProviderDescriptor fSProviderDescriptor = (FSProviderDescriptor)((Map.Entry)iterator.next()).getValue();
                    string = fSProviderDescriptor.getProviderID();
                }
            }
        }
        return string == null ? "" : string;
    }

    public boolean addProvider(FSProviderDescriptor fSProviderDescriptor) {
        boolean bl;
        block9: {
            bl = false;
            try {
                block13: {
                    boolean bl2;
                    block15: {
                        Set set;
                        String string;
                        block14: {
                            String string2;
                            block10: {
                                block12: {
                                    Set set2;
                                    block11: {
                                        if (!this.fetchEntityDescriptor()) break block9;
                                        string = fSProviderDescriptor.getProviderID();
                                        string2 = fSProviderDescriptor.getProviderRole();
                                        bl2 = false;
                                        AMModelBase.debug.message("ModelImpl Role " + string2);
                                        if (!string2.equalsIgnoreCase("sp")) break block10;
                                        set2 = this.fsd.getSPDescriptor();
                                        if (set2 != null && !set2.isEmpty()) break block11;
                                        if (!this.messageEnabled()) break block12;
                                        AMModelBase.debug.message("FSEntityDescProfileModelImpl, sp list is empty");
                                        break block12;
                                    }
                                    AMModelBase.debug.message("FSEntityDescProfileModelImpl, sp size:" + set2.size());
                                    Iterator iterator = set2.iterator();
                                    while (iterator.hasNext()) {
                                        FSProviderDescriptor fSProviderDescriptor2 = (FSProviderDescriptor)((Map.Entry)iterator.next()).getValue();
                                        if (!string.equalsIgnoreCase(fSProviderDescriptor2.getProviderID())) continue;
                                        bl2 = true;
                                        break;
                                    }
                                }
                                if (bl2) {
                                    this.fsd.modifySPDescriptor(fSProviderDescriptor);
                                } else {
                                    this.fsd.addSPDescriptor(fSProviderDescriptor);
                                }
                                break block13;
                            }
                            if (!string2.equalsIgnoreCase("idp")) break block13;
                            set = this.fsd.getIDPDescriptor();
                            if (set != null && !set.isEmpty()) break block14;
                            if (!this.messageEnabled()) break block15;
                            AMModelBase.debug.message("FSEntityDescProfileModelImpl,idp list is empty");
                            break block15;
                        }
                        AMModelBase.debug.message("FSEntityDescProfileModelImpl,idp size:" + set.size());
                        Iterator iterator = set.iterator();
                        while (iterator.hasNext()) {
                            FSProviderDescriptor fSProviderDescriptor3 = (FSProviderDescriptor)((Map.Entry)iterator.next()).getValue();
                            if (!string.equalsIgnoreCase(fSProviderDescriptor3.getProviderID())) continue;
                            bl2 = true;
                            break;
                        }
                    }
                    if (bl2) {
                        this.fsd.modifyIDPDescriptor(fSProviderDescriptor);
                    } else {
                        this.fsd.addIDPDescriptor(fSProviderDescriptor);
                    }
                }
                bl = this.modifyEntity(this.fsd);
            }
            catch (FSAllianceManagementException fSAllianceManagementException) {
                if (this.warningEnabled()) {
                    this.debugWarning("error in FSEntityDescProfileModelImpl: addProvider ", (Exception)((Object)fSAllianceManagementException));
                }
                this.errorMessage = this.getErrorString((Exception)((Object)fSAllianceManagementException));
            }
        }
        return bl;
    }

    public boolean deleteProviders(Set set) {
        boolean bl = false;
        try {
            if (set != null && !set.isEmpty()) {
                new FSAllianceManager(this.ssoToken).deleteProviders(set);
                bl = true;
            }
        }
        catch (FSAllianceManagementException fSAllianceManagementException) {
            if (this.warningEnabled()) {
                this.debugWarning("Error in getting FSAllianceManager", (Exception)((Object)fSAllianceManagementException));
            }
            this.errorMessage = this.getErrorString((Exception)((Object)fSAllianceManagementException));
        }
        return bl;
    }

    public String getNoProviderSelectedForDelTitle() {
        return this.getLocalizedString("noProviderSelectedForDeletion.title");
    }

    public String getNoProviderSelectedForDelMessage() {
        return this.getLocalizedString("noProviderSelectedForDeletion.message");
    }

    public boolean addAffiliate(FSAffiliationDescriptor fSAffiliationDescriptor) {
        boolean bl = false;
        if (this.fetchEntityDescriptor()) {
            this.fsd.setAffiliationDescriptor(fSAffiliationDescriptor);
            bl = this.modifyEntity(this.fsd);
        }
        return bl;
    }

    public String getAffiliateKeyInfoValue() {
        String string = null;
        if (this.fetchEntityDescriptor() && this.fsad != null) {
            string = this.fsad.getKeyInfo();
        }
        return string == null ? "" : string;
    }

    public String getAffiliateKeyUseValue() {
        String string = null;
        if (this.fetchEntityDescriptor() && this.fsad != null) {
            string = this.fsad.getKeyUse();
        }
        return string != null ? string : "";
    }

    public String getAffiliateKeySizeValue() {
        String string = null;
        if (this.fetchEntityDescriptor() && this.fsad != null) {
            string = Integer.toString(this.fsad.getKeySize());
        }
        return string != null ? string : "";
    }

    public String getAffiliateEncryptionMethodValue() {
        String string = null;
        if (this.fetchEntityDescriptor() && this.fsad != null) {
            string = this.fsad.getEncryptionMethod();
        }
        return string != null ? string : "";
    }

    public String getAffiliateExtensionValue() {
        String string = null;
        if (this.fetchEntityDescriptor() && this.fsad != null) {
            string = this.fsad.getExtension();
        }
        return string == null ? "" : string;
    }

    public String getAffiliateValidUntilValue() {
        String string = null;
        if (this.fetchEntityDescriptor() && this.fsad != null) {
            string = this.fsad.getValidUntil();
        }
        return string == null ? "" : string;
    }

    public String getAffiliateCacheDurationValue() {
        String string = null;
        if (this.fetchEntityDescriptor() && this.fsad != null) {
            string = this.fsad.getCacheDuration();
        }
        return string == null ? "" : string;
    }

    public Set getAvailableAffiliateMembers() {
        Set set = null;
        try {
            this.getManager();
            set = this.manager.getAllProviderIds();
        }
        catch (FSAllianceManagementException fSAllianceManagementException) {
            if (this.warningEnabled()) {
                this.debugWarning("FSEntityDescProfileImpl:getAvailableAffiliateMembers ", (Exception)((Object)fSAllianceManagementException));
            }
            this.errorMessage = this.getErrorString((Exception)((Object)fSAllianceManagementException));
        }
        return set == null ? Collections.EMPTY_SET : set;
    }

    public Set getPartOfAffiliateMembers() {
        Set set = null;
        if (this.fetchEntityDescriptor() && this.fsad != null) {
            set = this.fsad.getAffiliationMember();
        }
        return set == null ? Collections.EMPTY_SET : set;
    }

    public String getAffiliateRequiredLabel() {
        return this.getLocalizedString("af.affiliateRequired.label");
    }

    public String createProviderMessage() {
        return this.getLocalizedString("af.createProvider.message");
    }

    public String getCreateProviderButtonLabel() {
        return this.getLocalizedString("af.createProvider.button");
    }

    public Map getKeyUsePossibleValues() {
        HashMap<String, String> hashMap = new HashMap<String, String>(4);
        hashMap.put(this.getLocalizedString("af.keytype.signing"), "signing");
        hashMap.put(this.getLocalizedString("af.keytype.encryption"), "encryption");
        return hashMap;
    }
}

