/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.am.console.federation.model;

import com.iplanet.am.console.base.model.AMConsoleException;
import com.iplanet.am.console.base.model.AMModelBase;
import com.iplanet.am.console.base.model.AMProfileModelBase;
import com.iplanet.am.console.federation.model.FSContactPersonEntry;
import com.iplanet.am.console.federation.model.FSCreateProviderWizardModel;
import com.iplanet.am.util.Locale;
import com.sun.identity.federation.alliance.FSAllianceManagementException;
import com.sun.identity.federation.alliance.FSAllianceManager;
import com.sun.identity.federation.alliance.FSContactPerson;
import com.sun.identity.federation.alliance.FSEntityDescriptor;
import com.sun.identity.federation.alliance.FSHostedProviderDescriptor;
import com.sun.identity.federation.alliance.FSLocalConfigurationDescriptor;
import com.sun.identity.federation.alliance.FSOrganization;
import com.sun.identity.federation.alliance.FSProviderDescriptor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;

public class FSCreateProviderWizardModelImpl
extends AMProfileModelBase
implements FSCreateProviderWizardModel {
    private FSAllianceManager allianceManager;
    private String entityId;

    public FSCreateProviderWizardModelImpl(HttpServletRequest httpServletRequest, Map map) {
        super(httpServletRequest, "amAdminModuleMsgs", map);
        this.entityId = httpServletRequest.getParameter("AffiliateID");
        if (this.entityId == null || this.entityId.length() == 0) {
            this.entityId = (String)map.get("AffiliateID");
        }
    }

    private FSAllianceManager getAllianceManager() throws FSAllianceManagementException {
        if (this.allianceManager == null) {
            this.allianceManager = new FSAllianceManager(this.ssoToken);
        }
        return this.allianceManager;
    }

    public String getRequiredFieldLabel() {
        return this.getLocalizedString("required.label");
    }

    public String getCreateProviderTitle(int n) {
        return this.getLocalizedString("af.createProviderPage" + n + ".title");
    }

    public String getCreateProviderSubTitle(int n) {
        return this.getLocalizedString("af.createProviderPage" + n + ".subtitle");
    }

    public String getLabel(String string) {
        return this.getLocalizedString(string);
    }

    public Map getProtocolSupportEnumPossibleValues() {
        HashMap<String, String> hashMap = new HashMap<String, String>(4);
        hashMap.put(this.getLocalizedString("enumType.zero"), "urn:liberty:iff:2002-12");
        hashMap.put(this.getLocalizedString("enumType.one"), "urn:liberty:iff:2003-08");
        return hashMap;
    }

    public Map getKeyUsePossibleValues() {
        HashMap<String, String> hashMap = new HashMap<String, String>(4);
        hashMap.put(this.getLocalizedString("af.keytype.signing"), "signing");
        hashMap.put(this.getLocalizedString("af.keytype.encryption"), "encryption");
        return hashMap;
    }

    public Map getFedTerminateProtocolTypes() {
        HashMap<String, String> hashMap = new HashMap<String, String>(4);
        hashMap.put(this.getLocalizedString("protocolType.soap"), "http://projectliberty.org/profiles/fedterm-sp-soap");
        hashMap.put(this.getLocalizedString("protocolType.httpRedirect"), "http://projectliberty.org/profiles/fedterm-sp-http");
        return hashMap;
    }

    public Map getLogoutProtocolTypes() {
        HashMap<String, String> hashMap = new HashMap<String, String>(4);
        hashMap.put(this.getLocalizedString("protocolType.soap"), "http://projectliberty.org/profiles/slo-sp-soap");
        hashMap.put(this.getLocalizedString("protocolType.httpRedirect"), "http://projectliberty.org/profiles/slo-sp-http");
        return hashMap;
    }

    public Map getNameRegistrationProfileTypes() {
        HashMap<String, String> hashMap = new HashMap<String, String>(4);
        hashMap.put(this.getLocalizedString("protocolType.soap"), "http://projectliberty.org/profiles/rni-sp-soap");
        hashMap.put(this.getLocalizedString("protocolType.httpRedirect"), "http://projectliberty.org/profiles/rni-sp-http");
        return hashMap;
    }

    public Map getTerminationTypes() {
        HashMap<String, String> hashMap = new HashMap<String, String>(2);
        hashMap.put(this.getLocalizedString("termType.zero"), "http://projectliberty.org/profiles/rel-term-soap");
        return hashMap;
    }

    public Map getAllAuthenticationDomains() {
        HashMap<String, String> hashMap;
        block3: {
            hashMap = Collections.EMPTY_MAP;
            try {
                FSAllianceManager fSAllianceManager = this.getAllianceManager();
                Set set = fSAllianceManager.getAllCirclesOfTrust();
                if (set == null || set.isEmpty()) break block3;
                hashMap = new HashMap<String, String>(set.size() * 2);
                Iterator iterator = set.iterator();
                while (iterator.hasNext()) {
                    String string = (String)iterator.next();
                    hashMap.put(string, string);
                }
            }
            catch (FSAllianceManagementException fSAllianceManagementException) {
                AMModelBase.debug.error("FSCreateProviderWizardModelImpl.getAllAuthenticationDomains", (Throwable)fSAllianceManagementException);
            }
        }
        return hashMap;
    }

    public Map getAuthenticationTypes() {
        HashMap<String, String> hashMap = new HashMap<String, String>(4);
        hashMap.put(this.getLocalizedString("authType.local"), "local");
        hashMap.put(this.getLocalizedString("authType.remote"), "remote");
        return hashMap;
    }

    public Map getAuthnFedProfiles() {
        HashMap<String, String> hashMap = new HashMap<String, String>(4);
        hashMap.put(this.getLocalizedString("authnFedProfile.browserArtifact"), "http://projectliberty.org/profiles/brws-art");
        hashMap.put(this.getLocalizedString("authnFedProfile.browserPost"), "http://projectliberty.org/profiles/brws-post");
        hashMap.put(this.getLocalizedString("authnFedProfile.lecp"), "http://projectliberty.org/profiles/lecp");
        return hashMap;
    }

    public Map getAutnContextRefNames() {
        HashMap<String, String> hashMap = new HashMap<String, String>(20);
        hashMap.put(this.getLocalizedString("authncontext.MobileContract"), "http://www.projectliberty.org/schemas/authctx/classes/MobileContract");
        hashMap.put(this.getLocalizedString("authncontext.MobileDigitalID"), "http://www.projectliberty.org/schemas/authctx/classes/MobileDigitalID");
        hashMap.put(this.getLocalizedString("authncontext.MobileUnregistered"), "http://www.projectliberty.org/schemas/authctx/classes/MobileUnregistered");
        hashMap.put(this.getLocalizedString("authncontext.Password"), "http://www.projectliberty.org/schemas/authctx/classes/Password");
        hashMap.put(this.getLocalizedString("authncontext.Password-ProtectedTransport"), "http://www.projectliberty.org/schemas/authctx/classes/Password-ProtectedTransport");
        hashMap.put(this.getLocalizedString("authncontext.Previous-Session"), "http://www.projectliberty.org/schemas/authctx/classes/Previous-Session");
        hashMap.put(this.getLocalizedString("authncontext.Smartcard"), "http://www.projectliberty.org/schemas/authctx/classes/Smartcard");
        hashMap.put(this.getLocalizedString("authncontext.Smartcard-PKI"), "http://www.projectliberty.org/schemas/authctx/classes/Smartcard-PKI");
        hashMap.put(this.getLocalizedString("authncontext.Software-PKI"), "http://www.projectliberty.org/schemas/authctx/classes/Software-PKI");
        hashMap.put(this.getLocalizedString("authncontext.Time-Sync-Token"), "http://www.projectliberty.org/schemas/authctx/classes/Time-Sync-Token");
        return hashMap;
    }

    public boolean validateDateString(String string) throws AMConsoleException {
        Date date;
        boolean bl = true;
        if (string != null && string.length() > 0 && (date = Locale.parseDateString((String)string, (java.util.Locale)this.getUserLocale(), (String)this.getLocalizedString("validUntil.syntax"))) == null) {
            AMModelBase.debug.error("date syntax = " + this.getLocalizedString("validUntil.syntax"));
            AMModelBase.debug.error("date string = " + string + " was invalid.");
            throw new AMConsoleException(this.getLocalizedString("invalidValidUntilSyntax.message"));
        }
        return bl;
    }

    public String getInvalidDateMessage() {
        return this.getLocalizedString("invalidDate.message");
    }

    public String getNonURLMessage() {
        return this.getLocalizedString("nonURL.message");
    }

    public String getNonIntegerMessage() {
        return this.getLocalizedString("nonInteger.message");
    }

    public String getMissingAttributeMessage() {
        return this.getLocalizedString("missingAttributeValue");
    }

    public String getCommunicationURLTitle() {
        return this.getLocalizedString("communicationUrls.label");
    }

    public String getCommunicationProfileTitle() {
        return this.getLocalizedString("profiles.label");
    }

    public String getServiceProviderTitle() {
        return this.getLocalizedString("af.sp-tab.label");
    }

    public String getIdentityServerConfigTitle() {
        return this.getLocalizedString("af.ISConfig-tab.label");
    }

    public String getSAMLTitle() {
        return this.getLocalizedString("sc.SAMLAttributes.label");
    }

    public String getOrganizationTitle() {
        return this.getLocalizedString("af.organization.label");
    }

    public String getAuthenticationDomainsTitle() {
        return this.getLocalizedString("af.authenticationDomain-tab.label");
    }

    public String getContactPersonsTitle() {
        return this.getLocalizedString("af.providercontactPerson.label");
    }

    public String getContactPersonNameLabel() {
        return this.getLocalizedString("contactPersonName.label");
    }

    public String getContactPersonCompanyLabel() {
        return this.getLocalizedString("contactPersonCompany.label");
    }

    public String getContactPersonEmailsLabel() {
        return this.getLocalizedString("contactPersonEmail.label");
    }

    public String getContactPersonPhonesLabel() {
        return this.getLocalizedString("contactPersonPhone.label");
    }

    public String getContactPersonContactTypeLabel() {
        return this.getLocalizedString("contactPersonType.label");
    }

    public String getContactPersonLastNameLabel() {
        return this.getLocalizedString("contactPersonLastName.label");
    }

    public String getContactPersonFirstNameLabel() {
        return this.getLocalizedString("contactPersonFirstName.label");
    }

    public String getContactPersonPrincipalIdLabel() {
        return this.getLocalizedString("contactPersonLibertyPrinId.label");
    }

    public String getHasNoContactPersonMessage() {
        return this.getLocalizedString("noContactPersons.message");
    }

    public String getContactPersonEditLabel() {
        return this.getLocalizedString("af.edit.label");
    }

    public String getContactPersonActionLabel() {
        return this.getLocalizedString("contactPersonActions.label");
    }

    public String getAddContactPersonTitle() {
        return this.getLocalizedString("newContactPerson.title");
    }

    public Map getPossibleContactTypes() {
        HashMap<String, String> hashMap = new HashMap<String, String>(8);
        hashMap.put(this.getLocalizedString("contactType.tech"), "technical");
        hashMap.put(this.getLocalizedString("contactType.admin"), "administrative");
        hashMap.put(this.getLocalizedString("contactType.bill"), "billing");
        hashMap.put(this.getLocalizedString("contactType.other"), "other");
        return hashMap;
    }

    public String getNoContactPersonSelectedForDeletionTitle() {
        return this.getLocalizedString("noContactPersonSelectedForDeletion.title");
    }

    public String getNoContactPersonSelectedForDeletionMessage() {
        return this.getLocalizedString("noContactPersonSelectedForDeletion.message");
    }

    public String getContactPersonHeader() {
        return this.getLocalizedString("contactPersons.header");
    }

    public String getRowLabel() {
        return this.getLocalizedString("row.label");
    }

    public String getRowsLabel() {
        return this.getLocalizedString("rows.label");
    }

    public void createProvider(Map map) throws AMConsoleException {
        try {
            FSAllianceManager fSAllianceManager = this.getAllianceManager();
            FSProviderDescriptor fSProviderDescriptor = this.createProviderDescriptor(map);
            FSEntityDescriptor fSEntityDescriptor = this.allianceManager.getEntity(this.entityId);
            if (this.getBooleanValue(map, "isIDP")) {
                fSEntityDescriptor.addIDPDescriptor(fSProviderDescriptor);
            } else {
                fSEntityDescriptor.addSPDescriptor(fSProviderDescriptor);
            }
            fSAllianceManager.modifyEntity(fSEntityDescriptor);
        }
        catch (FSAllianceManagementException fSAllianceManagementException) {
            throw new AMConsoleException(fSAllianceManagementException);
        }
    }

    private FSProviderDescriptor createProviderDescriptor(Map map) throws AMConsoleException {
        String string = this.getBooleanValue(map, "isIDP") ? "IDP" : "SP";
        FSProviderDescriptor fSProviderDescriptor = this.createProviderDescriptor(map, string);
        fSProviderDescriptor.setOrganization(this.createOrganization(map));
        fSProviderDescriptor.setListOfCOTs(this.getSetValue(map, "authenticationDomains"));
        this.setCommunicationURLs(fSProviderDescriptor, map);
        this.setCommunicationProfile(fSProviderDescriptor, map);
        if (string.equals("SP")) {
            this.setServiceProviderAttributes(fSProviderDescriptor, map);
        }
        if (this.getBooleanValue(map, "isLocal")) {
            FSHostedProviderDescriptor fSHostedProviderDescriptor = (FSHostedProviderDescriptor)fSProviderDescriptor;
            fSHostedProviderDescriptor.setLocalConfiguration(this.createLocalConfigDescriptor(map));
        }
        this.addContactPersons(fSProviderDescriptor, map);
        return fSProviderDescriptor;
    }

    private void addContactPersons(FSProviderDescriptor fSProviderDescriptor, Map map) throws AMConsoleException {
        List list = (List)map.get("contactPersonList");
        if (list != null && !list.isEmpty()) {
            ArrayList<FSContactPerson> arrayList = new ArrayList<FSContactPerson>(list.size());
            int n = 1;
            try {
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    FSContactPersonEntry fSContactPersonEntry = (FSContactPersonEntry)iterator.next();
                    FSContactPerson fSContactPerson = new FSContactPerson("ContactPerson" + n);
                    ++n;
                    fSContactPerson.setGivenName(fSContactPersonEntry.firstName);
                    fSContactPerson.setSurName(fSContactPersonEntry.lastName);
                    fSContactPerson.setCompany(fSContactPersonEntry.company);
                    fSContactPerson.setLibertyPrincipalIdentifier(fSContactPersonEntry.principalId);
                    fSContactPerson.setContactType(fSContactPersonEntry.contactType);
                    fSContactPerson.setEmailAddress(fSContactPersonEntry.emails);
                    fSContactPerson.setTelephoneNumber(fSContactPersonEntry.phones);
                    arrayList.add(fSContactPerson);
                }
            }
            catch (FSAllianceManagementException fSAllianceManagementException) {
                throw new AMConsoleException(fSAllianceManagementException);
            }
            fSProviderDescriptor.setContactPerson(arrayList);
        }
    }

    private FSProviderDescriptor createProviderDescriptor(Map map, String string) throws AMConsoleException {
        Object object = null;
        try {
            String string2 = this.getStringValue(map, "providerId");
            object = this.getBooleanValue(map, "isLocal") ? new FSHostedProviderDescriptor(string2, "active", string) : new FSProviderDescriptor(string2, "active", string);
            object.setProviderName(this.getStringValue(map, "description"));
            object.setValidUntil(this.getStringValue(map, "validUntil"));
            object.setCacheDuration(this.getStringValue(map, "cachingDuration"));
            object.setProtocolSuppEnum(this.getStringValue(map, "protocolSupportEnum"));
            object.setKeyInfo(this.getStringValue(map, "keyInfo"));
            object.setKeyUse(this.getStringValue(map, "keyUse"));
            object.setKeySize(this.getIntegerValue(map, "keySize"));
            object.setEncryptionMethod(this.getStringValue(map, "encryptionMethod"));
            object.setNameIdMapBind(this.getSetValue(map, "serverNameIdMapping"));
            object.setAdditionalMetaLocation(this.getSetValue(map, "additionMetaLocations"));
            object.setExtension(this.getStringValue(map, "extension"));
        }
        catch (FSAllianceManagementException fSAllianceManagementException) {
            throw new AMConsoleException(fSAllianceManagementException);
        }
        return object;
    }

    private FSOrganization createOrganization(Map map) throws AMConsoleException {
        try {
            String string = "Organization1";
            FSOrganization fSOrganization = new FSOrganization(string);
            fSOrganization.setOrgName(this.getSetValue(map, "orgNames"));
            fSOrganization.setOrgDisplayName(this.getSetValue(map, "orgDisplayNames"));
            fSOrganization.setOrgURL(this.getSetValue(map, "orgURLs"));
            fSOrganization.setExtension(this.getStringValue(map, "orgExtension"));
            return fSOrganization;
        }
        catch (FSAllianceManagementException fSAllianceManagementException) {
            throw new AMConsoleException(fSAllianceManagementException);
        }
    }

    private void setCommunicationURLs(FSProviderDescriptor fSProviderDescriptor, Map map) {
        fSProviderDescriptor.setSOAPEndPoint(this.getStringValue(map, "soapEndPointURL"));
        if (this.getBooleanValue(map, "isIDP")) {
            fSProviderDescriptor.setSSOServiceURL(this.getStringValue(map, "singleLoginServiceURL"));
        }
        fSProviderDescriptor.setSLOServiceURL(this.getStringValue(map, "singleLogoutServiceURL"));
        fSProviderDescriptor.setSLOServiceReturnURL(this.getStringValue(map, "singleLogoutReturnURL"));
        fSProviderDescriptor.setFederationTerminationServiceURL(this.getStringValue(map, "fedTerminationServiceURL"));
        fSProviderDescriptor.setFederationTerminationServiceReturnURL(this.getStringValue(map, "fedTerminationReturnURL"));
        fSProviderDescriptor.setNameRegistrationURL(this.getStringValue(map, "nameRegistrationServiceURL"));
        fSProviderDescriptor.setNameRegistrationReturnURL(this.getStringValue(map, "nameRegistrationReturnURL"));
    }

    private void setCommunicationProfile(FSProviderDescriptor fSProviderDescriptor, Map map) {
        fSProviderDescriptor.setFederationTerminationProtocolProfile(this.getSetValue(map, "fedTerminationProfile"));
        fSProviderDescriptor.setSLOProtocolProfile(this.getStringValue(map, "singleLogoutProfile"));
        fSProviderDescriptor.setNameRegistrationProfile(this.getStringValue(map, "nameRegistrationProfile"));
        fSProviderDescriptor.setRelationshipTerminationNotificationProfile(this.getStringValue(map, "serverRelationTermNotificationURL"));
        fSProviderDescriptor.setSingleSignOnProtocolProfile(this.getStringValue(map, "singleSignOnProfile"));
    }

    private void setServiceProviderAttributes(FSProviderDescriptor fSProviderDescriptor, Map map) {
        fSProviderDescriptor.setAssertionConsumerServiceURL(this.getStringValue(map, "assertConsumerURL"));
        fSProviderDescriptor.setNameRegistrationIndicator(this.getBooleanValue(map, "nameRegistrationAfterFed"));
        fSProviderDescriptor.setAuthnRequestSigned(this.getBooleanValue(map, "signAuthenticationRequest"));
        fSProviderDescriptor.setAssertionConsumerServiceURLId(this.getStringValue(map, "assertConsumerServiceURLId"));
        fSProviderDescriptor.setAssertionConsumerServiceURLIsDefault(this.getBooleanValue(map, "defaultAssertConsumerServiceURL"));
    }

    private FSLocalConfigurationDescriptor createLocalConfigDescriptor(Map map) throws AMConsoleException {
        String string = this.getStringValue(map, "providerURL");
        String string2 = this.getStringValue(map, "alias");
        try {
            FSLocalConfigurationDescriptor fSLocalConfigurationDescriptor = new FSLocalConfigurationDescriptor(string, string2);
            fSLocalConfigurationDescriptor.setAuthnfedProfile(this.getStringValue(map, "singleSignOnProfile"));
            fSLocalConfigurationDescriptor.setForceAuthentication(this.getBooleanValue(map, "forceAuthenticationAtIDP"));
            fSLocalConfigurationDescriptor.setIsPassive(this.getBooleanValue(map, "reqIDPPassive"));
            fSLocalConfigurationDescriptor.setLibertyVersionURI(this.getStringValue(map, "libertyVersionURI"));
            fSLocalConfigurationDescriptor.setNameIdentifierImpl(this.getStringValue(map, "nameIdentitifierImpl"));
            fSLocalConfigurationDescriptor.setProviderAuthType(this.getStringValue(map, "authenticationType"));
            fSLocalConfigurationDescriptor.setAssociatedOrgDN(this.getStringValue(map, "organizationDN"));
            fSLocalConfigurationDescriptor.setProviderHomePageURL(this.getStringValue(map, "providerHomepageURL"));
            fSLocalConfigurationDescriptor.setProviderCommonLoginPageURL(this.getStringValue(map, "singleSignonFailureRedirectURL"));
            fSLocalConfigurationDescriptor.setDefaultAuthenticationContext(this.getStringValue(map, "defaultAuthContext"));
            fSLocalConfigurationDescriptor.setAssertionInterval(this.getIntegerValue(map, "assertionInterval"));
            fSLocalConfigurationDescriptor.setCleanupInterval(this.getIntegerValue(map, "cleanupInterval"));
            fSLocalConfigurationDescriptor.setArtifactTimeout(this.getIntegerValue(map, "artifactTimeout"));
            fSLocalConfigurationDescriptor.setAssertionLimit(this.getIntegerValue(map, "assertionLimit"));
            fSLocalConfigurationDescriptor.setAssertionIssuer(this.getStringValue(map, "assertionIssuer"));
            return fSLocalConfigurationDescriptor;
        }
        catch (FSAllianceManagementException fSAllianceManagementException) {
            throw new AMConsoleException(fSAllianceManagementException);
        }
    }

    private boolean getBooleanValue(Map map, String string) {
        return this.getStringValue(map, string).equals("true");
    }

    private Set getSetValue(Map map, String string) {
        Set set = (Set)map.get(string);
        return set != null ? set : Collections.EMPTY_SET;
    }

    private String getStringValue(Map map, String string) {
        String string2 = null;
        Set set = (Set)map.get(string);
        if (set != null && !set.isEmpty()) {
            string2 = (String)set.iterator().next();
        }
        return string2 != null ? string2 : "";
    }

    private int getIntegerValue(Map map, String string) {
        int n;
        block2: {
            n = 0;
            Set set = (Set)map.get(string);
            if (set == null || set.isEmpty()) break block2;
            try {
                n = Integer.parseInt((String)set.iterator().next());
            }
            catch (NumberFormatException numberFormatException) {
                n = 0;
            }
        }
        return n;
    }

    public String getHelpAnchorTag() {
        String string = this.getLocalizedString("createProvider.help");
        if (string.equals("createProvider.help")) {
            string = "contents.html";
        }
        return this.getHelpURL(string);
    }
}

