/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.am.console.components.view.html;

public class Time {
    public static final String DELIMITER = ":";
    protected String hour = "";
    protected String minute = "";
    protected boolean amInterval = true;
    private String[] intervalArray = new String[]{"AM", "PM"};

    public Time() {
    }

    public Time(int n, int n2, boolean bl, String[] stringArray) {
        this.hour = String.valueOf(n);
        this.minute = String.valueOf(n2);
        this.amInterval = bl;
        this.intervalArray = stringArray;
    }

    public Time(String string, String string2, boolean bl, String[] stringArray) {
        this.hour = string;
        this.minute = string2;
        this.amInterval = bl;
        this.intervalArray = stringArray;
    }

    public String getHour() {
        return this.hour;
    }

    public String getMinute() {
        return this.minute;
    }

    public boolean getAmInterval() {
        return this.amInterval;
    }

    public void setHour(String string) {
        this.hour = string;
    }

    public void setMinute(String string) {
        this.minute = string;
    }

    public void setInterval(boolean bl) {
        this.amInterval = bl;
    }

    public void setAmPmArray(String[] stringArray) {
        this.intervalArray = stringArray;
    }

    public void setValue(String string, String string2, boolean bl) {
        this.hour = string;
        this.minute = string2;
        this.amInterval = bl;
    }

    public String toString() {
        if (!(this.hour != null && this.hour.length() != 0 || this.minute != null && this.minute.length() != 0)) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getHour());
        stringBuffer.append(DELIMITER);
        stringBuffer.append(this.getMinute());
        stringBuffer.append(" ");
        if (this.amInterval) {
            stringBuffer.append(this.intervalArray[0]);
        } else {
            stringBuffer.append(this.intervalArray[1]);
        }
        return stringBuffer.toString();
    }

    public String toMilitary() {
        int n = 0;
        int n2 = 0;
        try {
            n = Integer.parseInt(this.hour);
            n2 = Integer.parseInt(this.minute);
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
        if (!this.amInterval) {
            if (n != 12) {
                n += 12;
            }
        } else if (n == 12) {
            n = 0;
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(String.valueOf(n));
        stringBuffer.append(DELIMITER);
        stringBuffer.append(String.valueOf(n2));
        return stringBuffer.toString();
    }

    public boolean isAm() {
        return this.amInterval;
    }

    private boolean isValidHour() {
        if (this.hour.length() > 0) {
            try {
                int n = Integer.parseInt(this.hour);
                return n > 0 && n <= 12;
            }
            catch (NumberFormatException numberFormatException) {
                return false;
            }
        }
        return false;
    }

    private boolean isValidMinute() {
        if (this.minute.length() > 0) {
            try {
                int n = Integer.parseInt(this.minute);
                return n >= 0 && n <= 59;
            }
            catch (NumberFormatException numberFormatException) {
                return false;
            }
        }
        return false;
    }

    public boolean isValid() {
        return this.isValidHour() && this.isValidMinute();
    }

    public static void main(String[] stringArray) {
        String string = stringArray[0];
        String string2 = stringArray[1];
        boolean bl = Boolean.valueOf(stringArray[2]);
        String[] stringArray2 = new String[]{"AM", "PM"};
        System.out.println(" ");
        Time time = new Time(string, string2, bl, stringArray2);
        System.out.println("Time is " + time.toString());
        if (time.isValid()) {
            System.out.println("Time is Valid");
        } else {
            System.out.println("Time is NOT valid");
        }
    }
}

