/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.am.console.base.model;

import com.iplanet.am.console.base.model.AMAdminConstants;
import com.iplanet.am.console.base.model.AMNodeComparator;
import com.iplanet.am.util.Debug;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.StringTokenizer;
import java.util.TreeSet;

public class AMTree
implements AMAdminConstants {
    private Node root = null;
    private Set hierarchy = null;
    private Map localeLookup = null;
    protected static final Debug debug = Debug.getInstance((String)"amConsole");
    private Locale locale = null;
    private int size = 0;

    public AMTree(Set set, Set set2, Locale locale) {
        this.initObj(set, set2, null, locale);
    }

    public AMTree(Set set, Set set2, Map map, Locale locale) {
        this.initObj(set, set2, map, locale);
    }

    private void initObj(Set set, Set set2, Map map, Locale locale) {
        this.hierarchy = set;
        this.localeLookup = map;
        this.locale = locale;
        this.root = new Node(null, "root", false, locale);
        if (set != null && set2 != null && !set.isEmpty() && !set2.isEmpty()) {
            this.populate(set2);
        }
    }

    private void populate(Set set) {
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            String string2 = this.getPath(string);
            if (string2 != null) {
                StringTokenizer stringTokenizer = new StringTokenizer(string2, "/");
                int n = stringTokenizer.countTokens();
                String[] stringArray = new String[n];
                int n2 = 0;
                while (stringTokenizer.hasMoreTokens()) {
                    stringArray[n2++] = stringTokenizer.nextToken();
                }
                this.addNodes(stringArray);
                continue;
            }
            if (!debug.messageEnabled()) continue;
            debug.message("AMtree.populate: No hierarchy for " + string + ". - Ignored");
        }
    }

    private String getPath(String string) {
        String string2 = null;
        Iterator iterator = this.hierarchy.iterator();
        block0: while (iterator.hasNext()) {
            String string3 = (String)iterator.next();
            StringTokenizer stringTokenizer = new StringTokenizer(string3, "/");
            while (stringTokenizer.hasMoreTokens()) {
                String string4 = stringTokenizer.nextToken();
                if (!string4.equals(string)) continue;
                int n = string3.indexOf("/" + string);
                if (n == -1) continue block0;
                string2 = string3.substring(0, n + string.length() + 1);
                continue block0;
            }
        }
        return string2;
    }

    private void addNodes(String[] stringArray) {
        Node node = this.root;
        String string = this.getLocalizedName(stringArray[0]);
        Node node2 = new Node(node, stringArray[0], string, false, this.locale);
        node = this.addNode(node, node2);
        int n = stringArray.length;
        int n2 = 1;
        while (n2 < n - 1) {
            string = this.getLocalizedName(stringArray[n2]);
            node2 = new Node(node, stringArray[n2], string, false, this.locale);
            node = this.addNode(node, node2);
            ++n2;
        }
        string = this.getLocalizedName(stringArray[n - 1]);
        node2 = new Node(node, stringArray[n - 1], string, true, this.locale);
        this.addNode(node, node2);
    }

    private String getLocalizedName(String string) {
        String string2 = null;
        if (this.localeLookup == null) {
            string2 = string;
        } else {
            string2 = (String)this.localeLookup.get(string);
            if (string2 == null || string2.length() == 0) {
                string2 = string;
            }
        }
        return string2;
    }

    private Node addNode(Node node, Node node2) {
        Node node3 = null;
        boolean bl = node.children.add(node2);
        if (!bl) {
            Node node4 = null;
            SortedSet<Node> sortedSet = node.children.tailSet(node2);
            node4 = sortedSet.first();
            if (node2.hasProperty) {
                node4.hasProperty = true;
            }
            node3 = node4;
        } else {
            node3 = node2;
            ++this.size;
        }
        return node3;
    }

    public int getSize() {
        return this.size;
    }

    public List getRows() {
        ArrayList arrayList = new ArrayList(this.size);
        this.listRows(arrayList, this.root);
        return arrayList;
    }

    private void listRows(List list, Node node) {
        if (node != this.root) {
            list.add(node);
        }
        if (node.children.isEmpty()) {
            return;
        }
        Iterator iterator = node.children.iterator();
        while (iterator.hasNext()) {
            this.listRows(list, (Node)iterator.next());
        }
    }

    class Node {
        public Node parent = null;
        public TreeSet children = null;
        public String name = null;
        public String localizedName = null;
        public int indent = 0;
        public boolean hasProperty = false;

        public Node(Node node, String string, String string2, boolean bl, Locale locale) {
            this.initObj(node, string, string2, bl, locale);
        }

        public Node(Node node, String string, boolean bl, Locale locale) {
            this.initObj(node, string, string, bl, locale);
        }

        private void initObj(Node node, String string, String string2, boolean bl, Locale locale) {
            this.parent = node;
            this.name = string;
            this.localizedName = string2;
            this.hasProperty = bl;
            if (node != null) {
                this.indent = node.indent + 1;
            }
            Collator collator = Collator.getInstance(locale);
            AMNodeComparator aMNodeComparator = new AMNodeComparator(collator);
            this.children = new TreeSet(aMNodeComparator);
        }
    }
}

