/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.am.console.base.model;

import com.iplanet.am.console.base.model.AMAdminConstants;
import com.iplanet.am.console.base.model.AMAdminUtils;
import com.iplanet.am.console.base.model.AMConsoleException;
import com.iplanet.am.util.Debug;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.common.ISResourceBundle;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class AMResourceBundleCache
implements AMAdminConstants {
    private static AMResourceBundleCache instance = new AMResourceBundleCache();
    private Map mapBundles = new HashMap(30);
    private Debug debug = Debug.getInstance((String)"amSDK");

    private AMResourceBundleCache() {
    }

    public static AMResourceBundleCache getInstance() {
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResourceBundle getResBundle(String string, Locale locale) {
        ResourceBundle resourceBundle = null;
        HashMap<Locale, ResourceBundle> hashMap = (HashMap<Locale, ResourceBundle>)this.mapBundles.get(string);
        if (hashMap != null) {
            resourceBundle = (ResourceBundle)hashMap.get(locale);
        }
        if (resourceBundle == null) {
            try {
                resourceBundle = ResourceBundle.getBundle(string, locale);
            }
            catch (MissingResourceException missingResourceException) {
                resourceBundle = this.getResourceFromDS(string, locale);
            }
            Map map = this.mapBundles;
            synchronized (map) {
                if (hashMap == null) {
                    hashMap = new HashMap<Locale, ResourceBundle>(5);
                    this.mapBundles.put(string, hashMap);
                }
                hashMap.put(locale, resourceBundle);
            }
        }
        return resourceBundle;
    }

    private ResourceBundle getResourceFromDS(String string, Locale locale) {
        ResourceBundle resourceBundle = null;
        try {
            SSOToken sSOToken = (SSOToken)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    try {
                        return AMAdminUtils.getSuperAdminSSOToken();
                    }
                    catch (AMConsoleException aMConsoleException) {
                        AMResourceBundleCache.this.debug.error("AMResourceBundleCache.getResBundle", (Throwable)aMConsoleException);
                        return null;
                    }
                }
            });
            if (sSOToken != null) {
                resourceBundle = ISResourceBundle.getResourceBundle((SSOToken)sSOToken, (String)string, (Locale)locale);
            }
        }
        catch (SSOException sSOException) {
            this.debug.error("AMResourceBundleCache.getResourceFromDS", (Throwable)sSOException);
        }
        catch (MissingResourceException missingResourceException) {
            this.debug.error("AMResourceBundleCache.getResourceFromDS", (Throwable)missingResourceException);
        }
        return resourceBundle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Map map = this.mapBundles;
        synchronized (map) {
            this.mapBundles.clear();
        }
    }
}

