/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.am.console.base.model;

import com.iplanet.am.console.base.model.AMAdminUtils;
import com.iplanet.am.console.base.model.AMConsoleException;
import com.iplanet.am.console.base.model.AMFormatUtils;
import com.iplanet.am.console.base.model.AMModelBase;
import com.iplanet.am.console.base.model.AMQuickSearchModel;
import com.iplanet.am.sdk.AMException;
import com.iplanet.am.sdk.AMGroup;
import com.iplanet.am.sdk.AMGroupContainer;
import com.iplanet.am.sdk.AMObject;
import com.iplanet.am.sdk.AMOrganization;
import com.iplanet.am.sdk.AMOrganizationalUnit;
import com.iplanet.am.sdk.AMPeopleContainer;
import com.iplanet.am.sdk.AMRole;
import com.iplanet.am.sdk.AMSearchControl;
import com.iplanet.am.sdk.AMSearchResults;
import com.iplanet.am.sdk.AMStaticGroup;
import com.iplanet.am.sdk.AMTemplate;
import com.iplanet.am.util.Debug;
import com.iplanet.sso.SSOException;
import com.sun.identity.common.admin.AdminInterfaceUtils;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.SchemaType;
import com.sun.identity.sm.ServiceSchemaManager;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;

public class AMQuickSearchModelImpl
extends AMModelBase
implements AMQuickSearchModel {
    private String searchErrorMsg = null;

    public AMQuickSearchModelImpl(HttpServletRequest httpServletRequest, Map map) {
        super(httpServletRequest, map);
    }

    public String getHTMLPageTitle() {
        Object[] objectArray = new String[]{this.getQuickSearchTitle(), this.getLocalizedString("console.title")};
        return MessageFormat.format(this.getLocalizedString("quickSearchTitle.format"), objectArray);
    }

    public String getQuickSearchTitle() {
        return this.getLocalizedString("quickSearch.title");
    }

    public String getPathTitle() {
        return this.getLocalizedString("quickSearchPath.label");
    }

    public String getQuickSearchLabel() {
        return this.getLocalizedString("quickSearch.label");
    }

    public String getInlineHelpString() {
        return this.getLocalizedString("quickSearchInlineHelp.label");
    }

    public String getQuickSearchTopDownBtnLabel() {
        return this.getLocalizedString("quickSearchTopDown.button");
    }

    public String getQuickSearchDownBtnLabel() {
        return this.getLocalizedString("quickSearchDown.button");
    }

    public List getSearchTypes() throws AMConsoleException {
        List list = Collections.EMPTY_LIST;
        int n = this.getStartLocType();
        if (n != -1) {
            switch (n) {
                case 2: 
                case 3: {
                    list = this.getOrgSearchTypes();
                    break;
                }
                case 4: 
                case 9: 
                case 10: 
                case 11: 
                case 12: {
                    list = this.getGroupSearchTypes();
                    break;
                }
                case 5: {
                    list = this.getUserSearchTypes();
                    break;
                }
                case 6: 
                case 8: {
                    list = this.getRoleSearchTypes();
                }
            }
        }
        return list;
    }

    public String getSearchResultsLabel() {
        return this.getLocalizedString("searchResults.label");
    }

    public String getSearchTypeLabel(String string) {
        String string2 = "";
        String string3 = this.getLocalizedString("name.label");
        try {
            int n = Integer.parseInt(string);
            switch (n) {
                case 2: {
                    string2 = this.getLocalizedString("organizations.label");
                    break;
                }
                case 3: {
                    string2 = this.getLocalizedString("orgunits.label");
                    break;
                }
                case 4: {
                    string2 = this.getLocalizedString("groupcontainers.label");
                    break;
                }
                case 9: {
                    string2 = this.getLocalizedString("groups.label");
                    break;
                }
                case 5: {
                    string2 = this.getLocalizedString("containers.label");
                    break;
                }
                case 1: {
                    string2 = this.getLocalizedString("users.label");
                    string3 = this.getL10NAttributeName("iPlanetAMUserService", SchemaType.USER, this.getUserSearchAttribute(this.getStartDN()));
                    break;
                }
                case 6: {
                    string2 = this.getLocalizedString("roles.label");
                    break;
                }
                case 14: {
                    string2 = this.getLocalizedString("policies.label");
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
            AMModelBase.debug.error("AMHeaderViewModelImpl.getSearchTypeLabel", (Throwable)numberFormatException);
        }
        Object[] objectArray = new String[]{string2, string3};
        return MessageFormat.format(this.getLocalizedString("searchCriteria.label"), objectArray);
    }

    private int getStartLocType() {
        int n = -1;
        try {
            n = this.getObjectType(this.startDN);
        }
        catch (SSOException sSOException) {
            AMModelBase.debug.warning("AMHeaderViewModelImpl.getStartLocType", (Throwable)sSOException);
        }
        catch (AMException aMException) {
            AMModelBase.debug.error("AMHeaderViewModelImpl.getStartLocType", (Throwable)aMException);
        }
        return n;
    }

    private List getOrgSearchTypes() {
        ArrayList<String> arrayList = new ArrayList<String>(6);
        if (this.isUserMgtEnabled()) {
            arrayList.add(Integer.toString(2));
            if (this.showOrgUnits()) {
                arrayList.add(Integer.toString(3));
            }
            if (this.showGroupContainers()) {
                arrayList.add(Integer.toString(4));
            }
            arrayList.add(Integer.toString(9));
            if (this.showPeopleContainers()) {
                arrayList.add(Integer.toString(5));
            }
            if (!this.isServiceDenied("iPlanetAMUserService")) {
                arrayList.add(Integer.toString(1));
            }
            arrayList.add(Integer.toString(6));
        }
        return arrayList;
    }

    private List getGroupSearchTypes() {
        ArrayList<String> arrayList = new ArrayList<String>(3);
        if (this.isUserMgtEnabled()) {
            if (this.showGroupContainers()) {
                arrayList.add(Integer.toString(4));
            }
            arrayList.add(Integer.toString(9));
            if (!this.isServiceDenied("iPlanetAMUserService")) {
                arrayList.add(Integer.toString(1));
            }
        }
        return arrayList;
    }

    private List getUserSearchTypes() {
        ArrayList<String> arrayList = new ArrayList<String>(2);
        if (this.isUserMgtEnabled()) {
            if (this.showPeopleContainers()) {
                arrayList.add(Integer.toString(5));
            }
            if (!this.isServiceDenied("iPlanetAMUserService")) {
                arrayList.add(Integer.toString(1));
            }
        }
        return arrayList;
    }

    private List getRoleSearchTypes() {
        ArrayList<String> arrayList = new ArrayList<String>(1);
        if (this.isUserMgtEnabled()) {
            arrayList.add(Integer.toString(1));
        }
        return arrayList;
    }

    public String getStartLocLabel() {
        Object[] objectArray = new String[]{AMFormatUtils.DNToName(this, this.getStartDN())};
        return MessageFormat.format(this.getLocalizedString("quickSearchStartLocDN.label"), objectArray);
    }

    public String getErrorTitle() {
        return this.getLocalizedString("errorMessage.title");
    }

    public String getNoEntriesMsg() {
        return this.getLocalizedString("noEntries.message");
    }

    public boolean isRoleType(String string) {
        boolean bl = false;
        try {
            int n = Integer.parseInt(string);
            bl = n == 6 || n == 8;
        }
        catch (NumberFormatException numberFormatException) {
            AMModelBase.debug.error("AMQuickSearchModelImpl.isRoleType", (Throwable)numberFormatException);
        }
        return bl;
    }

    public boolean isUserOrGroupType(String string) {
        boolean bl = false;
        try {
            int n = Integer.parseInt(string);
            bl = n == 1;
        }
        catch (NumberFormatException numberFormatException) {
            AMModelBase.debug.error("AMQuickSearchModelImpl.isUserOrGroupType", (Throwable)numberFormatException);
        }
        return bl;
    }

    public String getRoleDisplayName(String string) {
        return AMFormatUtils.DNToName(this, string, true);
    }

    public Set searchForObjects(String string, String string2, Map map) throws AMConsoleException {
        Set set = Collections.EMPTY_SET;
        if (string2 == null || string2.length() == 0) {
            string2 = "*";
        }
        try {
            int n = Integer.parseInt(string);
            switch (n) {
                case 2: {
                    set = this.searchOrganizations(string2, map);
                    break;
                }
                case 3: {
                    set = this.searchOrganizationUnits(string2, map);
                    break;
                }
                case 4: {
                    set = this.searchGroupContainers(string2, map);
                    break;
                }
                case 9: 
                case 10: 
                case 11: 
                case 12: {
                    set = this.searchGroups(string2, map);
                    break;
                }
                case 6: 
                case 8: {
                    set = this.searchRoles(string2, map);
                    break;
                }
                case 5: {
                    set = this.searchPeopleContainers(string2, map);
                    break;
                }
                case 1: {
                    set = this.searchUsers(string2, map);
                    break;
                }
                default: {
                    throw new AMConsoleException(this.getLocalizedString("invalidObjectType.message"));
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
            AMModelBase.debug.error("AMQuickSearchModelImpl.searchForObjects", (Throwable)numberFormatException);
        }
        return set;
    }

    protected Set searchOrganizations(String string, Map map) throws AMConsoleException {
        this.searchErrorMsg = null;
        AMSearchResults aMSearchResults = null;
        AMSearchControl aMSearchControl = new AMSearchControl();
        aMSearchControl.setSearchScope(2);
        try {
            switch (this.locationType) {
                case 2: {
                    AMOrganization aMOrganization = this.dpStoreConn.getOrganization(this.locationDN);
                    this.setSearchControlLimits((AMObject)aMOrganization, aMSearchControl);
                    aMSearchResults = aMOrganization.searchSubOrganizations(string, aMSearchControl);
                    break;
                }
                case 3: {
                    AMOrganizationalUnit aMOrganizationalUnit = this.dpStoreConn.getOrganizationalUnit(this.locationDN);
                    this.setSearchControlLimits((AMObject)aMOrganizationalUnit, aMSearchControl);
                    aMSearchResults = aMOrganizationalUnit.searchOrganizations(string, aMSearchControl);
                    break;
                }
                default: {
                    throw new AMConsoleException(this.getLocalizedString("invalidObjectType.message"));
                }
            }
        }
        catch (SSOException sSOException) {
            AMModelBase.debug.warning("AMQuickSearchModelImpl.searchOrganizations", (Throwable)sSOException);
        }
        catch (AMException aMException) {
            AMModelBase.debug.warning("AMQuickSearchModelImpl.searchOrganizations", (Throwable)aMException);
            throw new AMConsoleException(this.getErrorString((Exception)((Object)aMException)));
        }
        return this.processResults(aMSearchResults, map, false, false);
    }

    protected Set searchOrganizationUnits(String string, Map map) throws AMConsoleException {
        this.searchErrorMsg = null;
        AMSearchResults aMSearchResults = null;
        AMSearchControl aMSearchControl = new AMSearchControl();
        aMSearchControl.setSearchScope(2);
        try {
            switch (this.locationType) {
                case 2: {
                    AMOrganization aMOrganization = this.dpStoreConn.getOrganization(this.locationDN);
                    this.setSearchControlLimits((AMObject)aMOrganization, aMSearchControl);
                    aMSearchResults = aMOrganization.searchOrganizationalUnits(string, aMSearchControl);
                    break;
                }
                case 3: {
                    AMOrganizationalUnit aMOrganizationalUnit = this.dpStoreConn.getOrganizationalUnit(this.locationDN);
                    this.setSearchControlLimits((AMObject)aMOrganizationalUnit, aMSearchControl);
                    aMSearchResults = aMOrganizationalUnit.searchSubOrganizationalUnits(string, aMSearchControl);
                    break;
                }
                default: {
                    throw new AMConsoleException(this.getLocalizedString("invalidObjectType.message"));
                }
            }
        }
        catch (SSOException sSOException) {
            AMModelBase.debug.warning("AMQuickSearchModelImpl.searchOrganizationUnits", (Throwable)sSOException);
        }
        catch (AMException aMException) {
            AMModelBase.debug.warning("AMQuickSearchModelImpl.searchOrganizationUnits", (Throwable)aMException);
            throw new AMConsoleException(this.getErrorString((Exception)((Object)aMException)));
        }
        return this.processResults(aMSearchResults, map, false, false);
    }

    protected Set searchGroupContainers(String string, Map map) throws AMConsoleException {
        this.searchErrorMsg = null;
        AMSearchResults aMSearchResults = null;
        AMSearchControl aMSearchControl = new AMSearchControl();
        aMSearchControl.setSearchScope(2);
        try {
            switch (this.locationType) {
                case 2: {
                    AMOrganization aMOrganization = this.dpStoreConn.getOrganization(this.locationDN);
                    this.setSearchControlLimits((AMObject)aMOrganization, aMSearchControl);
                    aMSearchResults = aMOrganization.searchGroupContainers(string, null, aMSearchControl);
                    break;
                }
                case 3: {
                    AMOrganizationalUnit aMOrganizationalUnit = this.dpStoreConn.getOrganizationalUnit(this.locationDN);
                    this.setSearchControlLimits((AMObject)aMOrganizationalUnit, aMSearchControl);
                    aMSearchResults = aMOrganizationalUnit.searchGroupContainers(string, null, aMSearchControl);
                    break;
                }
                case 4: {
                    AMGroupContainer aMGroupContainer = this.dpStoreConn.getGroupContainer(this.locationDN);
                    this.setSearchControlLimits((AMObject)aMGroupContainer, aMSearchControl);
                    aMSearchResults = aMGroupContainer.searchSubGroupContainers(string, null, aMSearchControl);
                }
                default: {
                    throw new AMConsoleException(this.getLocalizedString("invalidObjectType.message"));
                }
            }
        }
        catch (SSOException sSOException) {
            AMModelBase.debug.warning("AMQuickSearchModelImpl.searchGroupContainer", (Throwable)sSOException);
        }
        catch (AMException aMException) {
            AMModelBase.debug.warning("AMQuickSearchModelImpl.searchGroupContainer", (Throwable)aMException);
            throw new AMConsoleException(this.getErrorString((Exception)((Object)aMException)));
        }
        return this.processResults(aMSearchResults, map, false, false);
    }

    protected Set searchPeopleContainers(String string, Map map) throws AMConsoleException {
        this.searchErrorMsg = null;
        AMSearchResults aMSearchResults = null;
        AMSearchControl aMSearchControl = new AMSearchControl();
        aMSearchControl.setSearchScope(2);
        try {
            switch (this.locationType) {
                case 2: {
                    AMOrganization aMOrganization = this.dpStoreConn.getOrganization(this.locationDN);
                    this.setSearchControlLimits((AMObject)aMOrganization, aMSearchControl);
                    aMSearchResults = aMOrganization.searchPeopleContainers(string, null, aMSearchControl);
                    break;
                }
                case 3: {
                    AMOrganizationalUnit aMOrganizationalUnit = this.dpStoreConn.getOrganizationalUnit(this.locationDN);
                    this.setSearchControlLimits((AMObject)aMOrganizationalUnit, aMSearchControl);
                    aMSearchResults = aMOrganizationalUnit.searchPeopleContainers(string, null, aMSearchControl);
                    break;
                }
                case 5: {
                    AMPeopleContainer aMPeopleContainer = this.dpStoreConn.getPeopleContainer(this.locationDN);
                    this.setSearchControlLimits((AMObject)aMPeopleContainer, aMSearchControl);
                    return aMPeopleContainer.searchSubPeopleContainers(string, 2);
                }
                default: {
                    throw new AMConsoleException(this.getLocalizedString("invalidObjectType.message"));
                }
            }
        }
        catch (SSOException sSOException) {
            AMModelBase.debug.warning("AMQuickSearchModelImpl.searchPeopleContainer", (Throwable)sSOException);
        }
        catch (AMException aMException) {
            AMModelBase.debug.warning("AMQuickSearchModelImpl.searchPeopleContainer", (Throwable)aMException);
            throw new AMConsoleException(this.getErrorString((Exception)((Object)aMException)));
        }
        return this.processResults(aMSearchResults, map, false, false);
    }

    protected Set searchRoles(String string, Map map) throws AMConsoleException {
        this.searchErrorMsg = null;
        AMSearchResults aMSearchResults = null;
        AMSearchControl aMSearchControl = new AMSearchControl();
        aMSearchControl.setSearchScope(2);
        try {
            switch (this.locationType) {
                case 2: {
                    AMOrganization aMOrganization = this.dpStoreConn.getOrganization(this.locationDN);
                    this.setSearchControlLimits((AMObject)aMOrganization, aMSearchControl);
                    aMSearchResults = aMOrganization.searchAllRoles(string, aMSearchControl);
                    break;
                }
                case 3: {
                    AMOrganizationalUnit aMOrganizationalUnit = this.dpStoreConn.getOrganizationalUnit(this.locationDN);
                    this.setSearchControlLimits((AMObject)aMOrganizationalUnit, aMSearchControl);
                    aMSearchResults = aMOrganizationalUnit.searchAllRoles(string, aMSearchControl);
                    break;
                }
                default: {
                    throw new AMConsoleException(this.getLocalizedString("invalidObjectType.message"));
                }
            }
        }
        catch (SSOException sSOException) {
            AMModelBase.debug.warning("AMQuickSearchModelImpl.searchRoles", (Throwable)sSOException);
        }
        catch (AMException aMException) {
            AMModelBase.debug.warning("AMQuickSearchModelImpl.searchRoles", (Throwable)aMException);
            throw new AMConsoleException(this.getErrorString((Exception)((Object)aMException)));
        }
        return this.processResults(aMSearchResults, map, false, true);
    }

    protected Set searchUsers(String string, Map map) throws AMConsoleException {
        this.searchErrorMsg = null;
        AMSearchResults aMSearchResults = null;
        AMSearchControl aMSearchControl = new AMSearchControl();
        aMSearchControl.setSearchScope(2);
        int n = this.locationType;
        String string2 = this.locationDN;
        while (n != 2 && n != 3) {
            string2 = AMAdminUtils.getParent(string2);
            n = this.getLocationType(string2);
        }
        HashSet<String> hashSet = new HashSet<String>(1);
        hashSet.add(this.getUserSearchAttribute(string2));
        aMSearchControl.setReturnAttributes(hashSet);
        try {
            switch (this.locationType) {
                case 2: {
                    AMOrganization aMOrganization = this.dpStoreConn.getOrganization(this.locationDN);
                    this.setSearchControlLimits((AMObject)aMOrganization, aMSearchControl);
                    aMSearchResults = aMOrganization.searchUsers(aMSearchControl, this.getSearchFilter(this.locationDN, string));
                    break;
                }
                case 3: {
                    AMOrganizationalUnit aMOrganizationalUnit = this.dpStoreConn.getOrganizationalUnit(this.locationDN);
                    this.setSearchControlLimits((AMObject)aMOrganizationalUnit, aMSearchControl);
                    aMSearchResults = aMOrganizationalUnit.searchUsers(aMSearchControl, this.getSearchFilter(this.locationDN, string));
                    break;
                }
                case 5: {
                    aMSearchResults = this.getUsersUnderPC(aMSearchControl, string);
                    break;
                }
                case 6: 
                case 8: {
                    aMSearchResults = this.getUsersUnderRole(aMSearchControl, string);
                    break;
                }
                case 9: 
                case 10: 
                case 11: 
                case 12: {
                    aMSearchResults = this.getUsersUnderGroup(aMSearchControl, string);
                    break;
                }
                default: {
                    throw new AMConsoleException(this.getLocalizedString("invalidObjectType.message"));
                }
            }
        }
        catch (SSOException sSOException) {
            AMModelBase.debug.warning("AMQuickSearchModelImpl.searchUsers", (Throwable)sSOException);
        }
        catch (AMException aMException) {
            AMModelBase.debug.warning("AMQuickSearchModelImpl.searchUsers", (Throwable)aMException);
            throw new AMConsoleException(this.getErrorString((Exception)((Object)aMException)));
        }
        return this.processResults(aMSearchResults, map, true, false);
    }

    private AMSearchResults getUsersUnderPC(AMSearchControl aMSearchControl, String string) throws SSOException, AMException {
        AMPeopleContainer aMPeopleContainer = this.dpStoreConn.getPeopleContainer(this.locationDN);
        String string2 = aMPeopleContainer.getOrganizationDN();
        int n = this.getObjectType(string2);
        if (n == 2) {
            AMOrganization aMOrganization = this.dpStoreConn.getOrganization(string2);
            this.setSearchControlLimits((AMObject)aMOrganization, aMSearchControl);
        } else {
            AMOrganizationalUnit aMOrganizationalUnit = this.dpStoreConn.getOrganizationalUnit(string2);
            this.setSearchControlLimits((AMObject)aMOrganizationalUnit, aMSearchControl);
        }
        return aMPeopleContainer.searchUsers(aMSearchControl, this.getSearchFilter(string2, string));
    }

    private AMSearchResults getUsersUnderRole(AMSearchControl aMSearchControl, String string) throws SSOException, AMException {
        AMRole aMRole = (AMRole)this.getAMObject(this.locationDN);
        String string2 = aMRole.getOrganizationDN();
        int n = this.getObjectType(string2);
        if (n == 2) {
            AMOrganization aMOrganization = this.dpStoreConn.getOrganization(string2);
            this.setSearchControlLimits((AMObject)aMOrganization, aMSearchControl);
        } else {
            AMOrganizationalUnit aMOrganizationalUnit = this.dpStoreConn.getOrganizationalUnit(string2);
            this.setSearchControlLimits((AMObject)aMOrganizationalUnit, aMSearchControl);
        }
        return aMRole.searchUsers(aMSearchControl, this.getSearchFilter(string2, string));
    }

    private AMSearchResults getUsersUnderGroup(AMSearchControl aMSearchControl, String string) throws SSOException, AMException {
        AMGroup aMGroup = (AMGroup)this.getAMObject(this.locationDN);
        String string2 = aMGroup.getOrganizationDN();
        int n = this.getObjectType(string2);
        if (n == 2) {
            AMOrganization aMOrganization = this.dpStoreConn.getOrganization(string2);
            this.setSearchControlLimits((AMObject)aMOrganization, aMSearchControl);
        } else {
            AMOrganizationalUnit aMOrganizationalUnit = this.dpStoreConn.getOrganizationalUnit(string2);
            this.setSearchControlLimits((AMObject)aMOrganizationalUnit, aMSearchControl);
        }
        return aMGroup.searchUsers(aMSearchControl, this.getSearchFilter(string2, string));
    }

    private String getSearchFilter(String string, String string2) throws SSOException {
        String string3 = this.getUserSearchAttribute(string);
        StringBuffer stringBuffer = new StringBuffer(10);
        stringBuffer.append("(").append(string3).append("=").append(string2).append(")");
        return stringBuffer.toString();
    }

    private String getUserSearchAttribute(String string) {
        String string2 = null;
        try {
            AMTemplate aMTemplate = this.getOrgTemplate(string);
            if (aMTemplate != null) {
                string2 = AMAdminUtils.getStringAttribute(aMTemplate, "iplanet-am-admin-console-user-search-key");
            } else {
                ServiceSchemaManager serviceSchemaManager = this.getServiceSchemaManager("iPlanetAMAdminConsoleService");
                if (serviceSchemaManager != null) {
                    string2 = AMAdminUtils.getStringAttribute(serviceSchemaManager, SchemaType.ORGANIZATION, "iplanet-am-admin-console-user-search-key");
                }
            }
        }
        catch (SSOException sSOException) {
            AMModelBase.debug.warning("AMQuickSearchModelImpl.getUserSearchAttribute", (Throwable)sSOException);
        }
        catch (AMException aMException) {
            AMModelBase.debug.warning("AMQuickSearchModelImpl.getUserSearchAttribute", (Throwable)aMException);
        }
        catch (SMSException sMSException) {
            AMModelBase.debug.warning("AMQuickSearchModelImpl.getUserSearchAttribute", (Throwable)sMSException);
        }
        if (string2 == null) {
            string2 = AdminInterfaceUtils.getNamingAttribute((int)1, (Debug)AMModelBase.debug);
        }
        return string2;
    }

    protected Set searchGroups(String string, Map map) throws AMConsoleException {
        Object object;
        Object object2;
        Set set = Collections.EMPTY_SET;
        AMStaticGroup aMStaticGroup = null;
        try {
            switch (this.locationType) {
                case 2: {
                    object2 = this.dpStoreConn.getOrganization(this.locationDN);
                    set = object2.searchGroups(string, null, 2);
                    if (!this.isAdminGroupsEnabled()) {
                        set = this.removeHiddenGroups(set);
                    }
                    break;
                }
                case 3: {
                    object = this.dpStoreConn.getOrganizationalUnit(this.locationDN);
                    set = object.searchGroups(string, null, 2);
                    if (!this.isAdminGroupsEnabled()) {
                        set = this.removeHiddenGroups(set);
                    }
                    break;
                }
                case 4: {
                    AMGroupContainer aMGroupContainer = this.dpStoreConn.getGroupContainer(this.locationDN);
                    set = aMGroupContainer.searchGroups(string, null, 2);
                    if (!this.isAdminGroupsEnabled()) {
                        set = this.removeHiddenGroups(set);
                    }
                    break;
                }
                case 9: 
                case 10: {
                    aMStaticGroup = this.dpStoreConn.getStaticGroup(this.locationDN);
                    set = aMStaticGroup.searchGroups(string, null, 2);
                    if (!this.isAdminGroupsEnabled()) {
                        set = this.removeHiddenGroups(set);
                    }
                    break;
                }
                case 11: {
                    aMStaticGroup = this.dpStoreConn.getDynamicGroup(this.locationDN);
                    set = aMStaticGroup.searchGroups(string, null, 2);
                    if (!this.isAdminGroupsEnabled()) {
                        set = this.removeHiddenGroups(set);
                    }
                    break;
                }
                case 12: {
                    aMStaticGroup = this.dpStoreConn.getAssignableDynamicGroup(this.locationDN);
                    set = aMStaticGroup.searchGroups(string, null, 2);
                    if (!this.isAdminGroupsEnabled()) {
                        set = this.removeHiddenGroups(set);
                    }
                    break;
                }
                default: {
                    if (AMModelBase.debug.warningEnabled()) {
                        AMModelBase.debug.warning("AMQuickSearchModelImpl.searchGroups invalid location " + this.locationDN);
                    }
                    break;
                }
            }
        }
        catch (SSOException sSOException) {
            AMModelBase.debug.warning("AMQuickSearchModelImpl.searchGroups", (Throwable)sSOException);
        }
        catch (AMException aMException) {
            AMModelBase.debug.warning("AMQuickSearchModelImpl.searchGroups", (Throwable)aMException);
            throw new AMConsoleException(this.getErrorString((Exception)((Object)aMException)));
        }
        if (set == null) {
            set = Collections.EMPTY_SET;
        } else {
            object2 = set.iterator();
            while (object2.hasNext()) {
                object = (String)object2.next();
                map.put(object, AMFormatUtils.DNToName(this, (String)object, false));
            }
        }
        return set;
    }

    private Set removeHiddenGroups(Set set) {
        HashSet<String> hashSet = new HashSet<String>(set.size());
        String string = null;
        String string2 = null;
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            string = (String)iterator.next();
            string2 = AMFormatUtils.DNToName(this, string, false);
            if (string2.equalsIgnoreCase("DomainAdministrators") || string2.equalsIgnoreCase("DomainHelpDeskAdministrators") || string2.equalsIgnoreCase("ServiceAdministrators") || string2.equalsIgnoreCase("ServiceHelpDeskAdministrators")) continue;
            hashSet.add(string);
        }
        return hashSet;
    }

    private Set processResults(AMSearchResults aMSearchResults, Map map, boolean bl, boolean bl2) {
        Set set = Collections.EMPTY_SET;
        if (aMSearchResults != null) {
            set = aMSearchResults.getSearchResults();
            set.remove(this.locationDN);
            if (bl) {
                Map map2 = aMSearchResults.getResultAttributes();
                Iterator iterator = map2.keySet().iterator();
                while (iterator.hasNext()) {
                    String string = (String)iterator.next();
                    Map map3 = (Map)map2.get(string);
                    Iterator iterator2 = map3.keySet().iterator();
                    Set set2 = (Set)map3.get(iterator2.next());
                    map.put(string, set2.iterator().next());
                }
            } else {
                Iterator iterator = set.iterator();
                while (iterator.hasNext()) {
                    String string = (String)iterator.next();
                    map.put(string, AMFormatUtils.DNToName(this, string, bl2));
                }
            }
            this.searchErrorMsg = AMAdminUtils.getSearchResultWarningMessage(aMSearchResults, this);
        }
        return set;
    }

    public String getCloseButtonLabel() {
        return this.getLocalizedString("close.button");
    }

    public String getQuickSearchTableTitle() {
        return this.getLocalizedString("quickSearchTable.label");
    }

    public String getRowsLabel() {
        return this.getLocalizedString("rows.label");
    }

    public String getRowLabel() {
        return this.getLocalizedString("row.label");
    }

    public String getPromptSearchMessage() {
        return this.getLocalizedString("doSearch.message");
    }
}

