/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.am.console.base.model;

import com.iplanet.am.console.base.model.AMIndentedListModel;
import com.iplanet.am.console.base.model.AMModelBase;
import com.iplanet.am.console.base.model.AMProfileModelBase;
import com.iplanet.am.console.base.model.AMTree;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;

public abstract class AMIndentedListModelImpl
extends AMProfileModelBase
implements AMIndentedListModel {
    protected List rowNodes = Collections.EMPTY_LIST;

    public AMIndentedListModelImpl(HttpServletRequest httpServletRequest, String string, Map map) {
        super(httpServletRequest, string, map);
    }

    public void process(Set set, Set set2, Map map) {
        if (set == null || set2 == null || set.isEmpty() || set2.isEmpty()) {
            AMModelBase.debug.error("AMIndentedListModelImpl.process: Names or hierarchy null/empty.");
        } else {
            AMModelBase.debug.message("AMIndentedListModelImpl.process: create tree");
            AMTree aMTree = new AMTree(set, set2, map, this.getUserLocale());
            this.rowNodes = aMTree.getRows();
            if (AMModelBase.debug.messageEnabled()) {
                AMModelBase.debug.message("AMIndentedListModelImpl.process: number of rows in indented list = " + this.rowNodes.size());
            }
        }
    }

    public int getSize() {
        return this.rowNodes.size();
    }

    public String getSvcName(int n) {
        String string = "";
        if (n > -1 && n < this.rowNodes.size()) {
            string = ((AMTree.Node)this.rowNodes.get((int)n)).name;
        }
        return string;
    }

    public String getL10SvcName(int n) {
        String string = "";
        if (n > -1 && n < this.rowNodes.size()) {
            string = ((AMTree.Node)this.rowNodes.get((int)n)).localizedName;
        }
        return string;
    }

    public String getIndent(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        if (n > -1 && n < this.rowNodes.size()) {
            int n2 = ((AMTree.Node)this.rowNodes.get((int)n)).indent;
            int n3 = 1;
            while (n3 < n2) {
                stringBuffer.append("&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;");
                ++n3;
            }
        }
        return stringBuffer.toString();
    }

    public boolean hasProperty(int n) {
        boolean bl = false;
        if (n > -1 && n < this.rowNodes.size()) {
            bl = ((AMTree.Node)this.rowNodes.get((int)n)).hasProperty;
        }
        return bl;
    }

    public String getPropertiesLabel() {
        return this.getLocalizedString("properties.label");
    }
}

