/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.am.console.base.model;

import com.iplanet.am.console.base.model.AMAdminConstants;
import com.iplanet.am.console.base.model.AMModelBase;
import com.iplanet.am.util.Debug;
import com.iplanet.services.cdm.Client;
import com.iplanet.services.cdm.ClientException;
import com.iplanet.services.cdm.ClientsManager;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import java.util.Locale;

public class AMI18NUtils
implements AMAdminConstants {
    public static final String DEFAULT_CHARSET = "UTF-8";
    public static final String KEY_CLIENT_TYPE = "clientType";
    private static Debug debug = Debug.getInstance((String)"amConsole");

    public static String getClientType(SSOToken sSOToken) {
        String string = "";
        try {
            string = sSOToken.getProperty(KEY_CLIENT_TYPE);
            if (debug.messageEnabled()) {
                debug.message("AMI18NUtils.getClientType, " + string);
            }
        }
        catch (SSOException sSOException) {
            debug.error("AMI18NUtils.getClientType", (Throwable)sSOException);
        }
        return string;
    }

    public static String getCharset(String string, Locale locale) {
        String string2;
        try {
            Client client = ClientsManager.getInstance((String)string);
            string2 = client.getCharset(locale);
            if (debug.messageEnabled()) {
                debug.message("AMI18NUtils.getCharset, " + string2);
            }
        }
        catch (ClientException clientException) {
            debug.error("AMI18NUtils.getCharset", (Throwable)clientException);
            string2 = DEFAULT_CHARSET;
        }
        return string2;
    }

    public static String getContentType(String string) {
        String string2 = "";
        try {
            Client client = ClientsManager.getInstance((String)string);
            string2 = client.getProperty("contentType");
            if (debug.messageEnabled()) {
                debug.message("AMI18NUtils.getContentType, " + string2);
            }
        }
        catch (ClientException clientException) {
            debug.error("AMI18NUtils.getContentType", (Throwable)clientException);
        }
        return string2;
    }

    public static String getLocalizedStringForLocType(AMModelBase aMModelBase, int n) {
        String string = null;
        switch (n) {
            case 2: {
                string = aMModelBase.getLocalizedString("organizations.label");
                break;
            }
            case 3: {
                string = aMModelBase.getLocalizedString("orgunits.label");
                break;
            }
            case 9: {
                string = aMModelBase.getLocalizedString("groups.label");
                break;
            }
            case 6: {
                string = aMModelBase.getLocalizedString("roles.label");
                break;
            }
            case 1: {
                string = aMModelBase.getLocalizedString("users.label");
                break;
            }
            case 5: {
                string = aMModelBase.getLocalizedString("containers.label");
                break;
            }
            case 4: {
                string = aMModelBase.getLocalizedString("groupcontainers.label");
                break;
            }
            case 15: {
                string = aMModelBase.getLocalizedString("services.label");
                break;
            }
            case 14: 
            case 300: {
                string = aMModelBase.getLocalizedString("policies.label");
                break;
            }
            case 99: {
                string = aMModelBase.getLocalizedString("policyAdmins.label");
                break;
            }
            case 16: {
                string = aMModelBase.getLocalizedString("roleProfile.label");
                break;
            }
            case 17: {
                string = aMModelBase.getLocalizedString("groupProfile.label");
                break;
            }
            default: {
                string = "";
            }
        }
        return string;
    }

    public static String getMenuEntryName(AMModelBase aMModelBase, String string) {
        return aMModelBase.getLocalizedString("show" + string + ".label");
    }
}

