/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.am.console.base.model;

import com.iplanet.am.console.base.model.AMAdminConstants;
import com.iplanet.am.console.base.model.AMAttrSchemaComparator;
import com.iplanet.am.console.base.model.AMModel;
import com.iplanet.am.console.base.model.AMModelBase;
import com.iplanet.am.console.base.model.AMSystemConfig;
import com.iplanet.am.sdk.AMException;
import com.iplanet.am.util.Debug;
import com.iplanet.am.util.Locale;
import com.iplanet.sso.SSOException;
import com.sun.identity.common.admin.AdminInterfaceUtils;
import java.io.UnsupportedEncodingException;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import netscape.ldap.LDAPDN;
import netscape.ldap.util.DN;
import netscape.ldap.util.RDN;

public class AMFormatUtils
implements AMAdminConstants {
    private static Debug debug = Debug.getInstance((String)"amConsole");
    static final String BREAD_CRUMB_SEPARATOR = "&nbsp;&gt;&nbsp;";

    public static List pathToDisplayString(AMModel aMModel, String string) {
        int n = aMModel.getLocationType(string);
        boolean bl = n == 6 || n == 8;
        return AMFormatUtils.pathToDisplayString(aMModel, string, aMModel.getStartDN(), bl);
    }

    public static List pathToDisplayString(AMModel aMModel, String string, String string2, boolean bl) {
        List<String> list = null;
        DN dN = new DN(string);
        DN dN2 = new DN(string2);
        if (dN.equals(dN2)) {
            list = new ArrayList(1);
            if (string.equalsIgnoreCase(AMSystemConfig.rootSuffix)) {
                list.add(AMSystemConfig.rootSuffix);
            } else {
                list.add(AMFormatUtils.DNToName(aMModel, string2, bl));
            }
        } else {
            list = AMFormatUtils.pathToDisplayString(aMModel, LDAPDN.explodeDN((String)string, (boolean)false), string, bl);
        }
        return list;
    }

    public static String DNToName(AMModel aMModel, String string) {
        return AMFormatUtils.DNToName(aMModel, string, false);
    }

    public static String DNToName(AMModel aMModel, String string, boolean bl) {
        String string2 = string;
        if (DN.isDN((String)string)) {
            String[] stringArray = LDAPDN.explodeDN((String)string, (boolean)true);
            string2 = stringArray[0];
            if (bl) {
                String string3 = "help_desk_" + AdminInterfaceUtils.getNamingAttribute((int)9, (Debug)debug) + "=";
                String string4 = aMModel.getLocalizedString("admin_suffix.name");
                if (string2.startsWith(string3)) {
                    string2 = string2.substring(string3.length());
                    string4 = aMModel.getLocalizedString("help_desk_admin_suffix.name");
                    int n = string2.indexOf("_");
                    if (n == -1) {
                        n = string2.length();
                    }
                    string2 = string2.substring(0, n) + " " + string4;
                } else {
                    String string5 = AdminInterfaceUtils.getNamingAttribute((int)9, (Debug)debug);
                    String string6 = AdminInterfaceUtils.getNamingAttribute((int)5, (Debug)debug);
                    if (string2.startsWith(string5 + "=")) {
                        int n = 3;
                        int n2 = string2.indexOf("_" + string5 + "=");
                        if (n2 == -1 && (n2 = string2.lastIndexOf("_" + AdminInterfaceUtils.getNamingAttribute((int)4, (Debug)debug))) == -1) {
                            n2 = string2.length();
                        }
                        string2 = string2.substring(n, n2) + " " + string4;
                    } else if (string2.startsWith(string6 + "=")) {
                        int n = 3;
                        int n3 = (string2 = string2.substring(n)).indexOf("_");
                        if (n3 == -1) {
                            n3 = string2.length();
                        }
                        string2 = string2.substring(0, n3) + " " + string4;
                    }
                }
            }
        }
        return string2;
    }

    private static List pathToDisplayString(AMModel aMModel, String[] stringArray, String string, boolean bl) {
        int n = stringArray.length;
        ArrayList<String> arrayList = new ArrayList<String>(n);
        DN dN = null;
        DN dN2 = new DN(aMModel.getStartDN());
        int n2 = n - 1;
        while (n2 >= 0) {
            String string2 = AMSystemConfig.rootSuffix;
            if (dN == null) {
                dN = new DN(stringArray[n2]);
            } else {
                dN.addRDN(new RDN(stringArray[n2]));
            }
            if (dN2.equals(dN)) {
                String string3 = dN.toString();
                if (string2.equalsIgnoreCase(string3)) {
                    arrayList.add(string2);
                } else {
                    arrayList.add(string3);
                }
                int n3 = n2 - 1;
                while (n3 > 0) {
                    dN.addRDN(new RDN(stringArray[n3]));
                    string3 = dN.toString();
                    if (AMFormatUtils.showComponent(aMModel, string3)) {
                        arrayList.add(string3);
                    }
                    --n3;
                }
                break;
            }
            --n2;
        }
        arrayList.add(AMFormatUtils.DNToName(aMModel, string, bl));
        return arrayList;
    }

    private static boolean showComponent(AMModel aMModel, String string) {
        boolean bl;
        block7: {
            bl = true;
            if (string == null || string.length() <= 0) break block7;
            int n = -1;
            try {
                n = aMModel.getObjectType(string);
                if (n == 4) {
                    bl = aMModel.showGroupContainers();
                } else if (n == 3) {
                    bl = aMModel.showOrgUnits();
                }
            }
            catch (AMException aMException) {
                if (debug.warningEnabled()) {
                    debug.warning("couldn't get the object type for " + string);
                }
            }
            catch (SSOException sSOException) {
                if (!debug.warningEnabled()) break block7;
                debug.warning("couldn't get the object type for " + string);
            }
        }
        return bl;
    }

    public static List sortMapByValue(Map map, java.util.Locale locale) {
        ArrayList arrayList = Collections.EMPTY_LIST;
        if (map != null && map.size() > 0) {
            Map map2 = AMFormatUtils.reverseMap(map);
            List list = AMFormatUtils.sortKeyInMap(map2, locale);
            arrayList = new ArrayList(list.size());
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                arrayList.addAll((Set)map2.get(string));
            }
        }
        return arrayList;
    }

    public static Map reverseMap(Map map) {
        HashMap<String, HashSet<String>> hashMap = new HashMap<String, HashSet<String>>();
        if (map != null && map.size() > 0) {
            hashMap = new HashMap(map.size());
            Iterator iterator = map.keySet().iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                String string2 = (String)map.get(string);
                if (string2 == null) continue;
                HashSet<String> hashSet = (HashSet<String>)hashMap.get(string2);
                if (hashSet == null) {
                    hashSet = new HashSet<String>(3);
                }
                hashSet.add(string);
                hashMap.put(string2, hashSet);
            }
        }
        return hashMap;
    }

    public static List sortKeyInMap(Map map, java.util.Locale locale) {
        List list = Collections.EMPTY_LIST;
        if (map != null && map.size() > 0) {
            list = AMFormatUtils.sortItemsInSet(map.keySet(), locale);
        }
        return list;
    }

    public static List sortItemsInSet(Set set, java.util.Locale locale) {
        ArrayList arrayList = Collections.EMPTY_LIST;
        if (set != null && set.size() > 0) {
            arrayList = new ArrayList(set.size());
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                arrayList.add(iterator.next());
            }
            Collator collator = Collator.getInstance(locale);
            Collections.sort(arrayList, collator);
        }
        return arrayList;
    }

    public static Set listToSet(List list) {
        HashSet hashSet = Collections.EMPTY_SET;
        if (list != null && list.size() > 0) {
            hashSet = new HashSet(list.size());
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                hashSet.add(iterator.next());
            }
        }
        return hashSet;
    }

    public static List chunkList(List list, int n, int n2) {
        ArrayList arrayList = new ArrayList(n);
        int n3 = n * (n2 - 1);
        int n4 = n + n3;
        if (n4 > list.size()) {
            n4 = list.size();
        }
        int n5 = n3;
        while (n5 < n4) {
            arrayList.add(list.get(n5));
            ++n5;
        }
        return arrayList;
    }

    public static String dequote(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "'");
        if (stringTokenizer.countTokens() > 1) {
            StringBuffer stringBuffer = new StringBuffer(string.length() + stringTokenizer.countTokens() * 2);
            while (stringTokenizer.hasMoreTokens()) {
                stringBuffer.append(stringTokenizer.nextToken()).append("\\'");
            }
            return stringBuffer.toString();
        }
        return string;
    }

    public static String encodeString(String string, String string2) {
        try {
            return Locale.URLEncodeField((String)string2, (String)string);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return string2;
        }
    }

    public static String getDisplayName(AMModelBase aMModelBase, String string, boolean bl) {
        String string2 = string;
        if (string != null && string.length() > 0 && DN.isDN((String)string)) {
            String[] stringArray = LDAPDN.explodeDN((String)string, (boolean)true);
            int n = stringArray.length;
            StringBuffer stringBuffer = new StringBuffer(50);
            int n2 = n - 1;
            while (n2 > 0) {
                stringBuffer.append(stringArray[n2]);
                stringBuffer.append(BREAD_CRUMB_SEPARATOR);
                --n2;
            }
            stringBuffer.append(AMFormatUtils.DNToName(aMModelBase, string, bl));
            string2 = stringBuffer.toString();
        }
        return string2;
    }

    public static List sortAttrSchema(Set set, java.util.Locale locale) {
        Collator collator = Collator.getInstance(locale);
        AMAttrSchemaComparator aMAttrSchemaComparator = new AMAttrSchemaComparator(collator);
        ArrayList arrayList = new ArrayList(set);
        Collections.sort(arrayList, aMAttrSchemaComparator);
        return arrayList;
    }

    public static String replaceString(String string, String string2, String string3) {
        int n = string2.length();
        int n2 = string.indexOf(string2);
        while (n2 != -1) {
            string = string.substring(0, n2) + string3 + string.substring(n2 + n);
            n2 = string.indexOf(string2, n2 + n);
        }
        return string;
    }

    public static HashSet formatMapToSet(Map map) {
        HashSet<String> hashSet = new HashSet<String>(map.size() * 2);
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            String string = (String)entry.getKey();
            Map map2 = (Map)entry.getValue();
            if (map2 == null || map2.isEmpty()) continue;
            StringBuffer stringBuffer = new StringBuffer(100);
            stringBuffer.append(string).append("\t\t\t");
            AMFormatUtils.formatMapToString(map2, stringBuffer);
            hashSet.add(stringBuffer.toString());
        }
        return hashSet;
    }

    private static void formatMapToString(Map map, StringBuffer stringBuffer) {
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            String string = (String)entry.getKey();
            Set set = (Set)entry.getValue();
            stringBuffer.append(string).append("\t\t");
            AMFormatUtils.formatSetToString(set, stringBuffer);
            stringBuffer.append("\n");
        }
    }

    private static void formatSetToString(Set set, StringBuffer stringBuffer) {
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            if (string.length() <= 0) continue;
            stringBuffer.append(string).append("\t");
        }
    }

    public static Map formatSetToMap(Set set) {
        HashMap<String, Map> hashMap = new HashMap<String, Map>(set.size() * 2);
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            int n = string.indexOf("\t\t\t");
            if (n == -1) continue;
            String string2 = string.substring(0, n);
            string = string.substring(n + 3);
            hashMap.put(string2, AMFormatUtils.formatStringToMap(string));
        }
        return hashMap;
    }

    private static Map formatStringToMap(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\n");
        HashMap<String, Set> hashMap = new HashMap<String, Set>(stringTokenizer.countTokens() * 2);
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            int n = string2.indexOf("\t\t");
            if (n == -1) continue;
            String string3 = string2.substring(0, n);
            string2 = string2.substring(n + 2);
            hashMap.put(string3, AMFormatUtils.formatStringToSet(string2));
        }
        return hashMap;
    }

    private static Set formatStringToSet(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\t");
        HashSet<String> hashSet = new HashSet<String>(stringTokenizer.countTokens() * 2);
        while (stringTokenizer.hasMoreTokens()) {
            hashSet.add(stringTokenizer.nextToken());
        }
        return hashSet;
    }
}

