/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.am.console.base.model;

import com.iplanet.am.console.base.model.AMAdminConstants;
import com.iplanet.am.console.base.model.AMAdminUtils;
import com.iplanet.am.console.base.model.AMConsoleException;
import com.iplanet.am.console.base.model.AMConsoleListener;
import com.iplanet.am.console.base.model.AMModel;
import com.iplanet.am.sdk.AMException;
import com.iplanet.am.sdk.AMObject;
import com.iplanet.am.sdk.AMOrganization;
import com.iplanet.am.sdk.AMOrganizationalUnit;
import com.iplanet.am.sdk.AMStoreConnection;
import com.iplanet.am.sdk.AMTemplate;
import com.iplanet.am.util.Debug;
import com.iplanet.am.util.SystemProperties;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenManager;
import com.sun.identity.authentication.internal.AuthPrincipal;
import com.sun.identity.security.AdminDNAction;
import com.sun.identity.security.AdminPasswordAction;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.SchemaType;
import com.sun.identity.sm.ServiceConfigManager;
import com.sun.identity.sm.ServiceListener;
import com.sun.identity.sm.ServiceSchemaManager;
import java.security.AccessController;
import java.security.Principal;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;

public class AMConsoleListenerManager
implements AMAdminConstants,
ServiceListener {
    private static Debug debug = Debug.getInstance((String)"amConsole");
    private static AMConsoleListenerManager manager = new AMConsoleListenerManager();
    private static ServiceSchemaManager serviceSchemaManager;
    private static ServiceConfigManager serviceConfigManager;
    private static AMStoreConnection storeConnection;
    private Map mapOrgDNToListeners = new HashMap();
    private Set mandatoryListeners = new HashSet();
    private static final String CONSOLE_LISTENER_CLASSES_PROPERTIES_NAME = "com.iplanet.am.console.listener.classes";
    private static final String ROOT = "root_suffix";
    private static Set propertiesConsoleListenerClasses;
    static /* synthetic */ Class class$com$iplanet$am$console$base$model$AMConsoleListener;

    private AMConsoleListenerManager() {
        AMConsoleListenerManager.initManager(this);
    }

    private static void initManager(AMConsoleListenerManager aMConsoleListenerManager) {
        block4: {
            try {
                SSOToken sSOToken = AMConsoleListenerManager.getAdminSSOToken();
                if (sSOToken != null) {
                    serviceSchemaManager = new ServiceSchemaManager("iPlanetAMAdminConsoleService", sSOToken);
                    serviceConfigManager = new ServiceConfigManager("iPlanetAMAdminConsoleService", sSOToken);
                    serviceConfigManager.addListener((ServiceListener)aMConsoleListenerManager);
                    serviceSchemaManager.addListener((ServiceListener)aMConsoleListenerManager);
                    storeConnection = new AMStoreConnection(sSOToken);
                    break block4;
                }
                debug.error("AMConsoleListenerManager.initManager:cannot get application sso token");
            }
            catch (SMSException sMSException) {
                debug.error("AMConsoleListenerManager.initManager", (Throwable)sMSException);
            }
            catch (SSOException sSOException) {
                debug.error("AMConsoleListenerManager.initManager", (Throwable)sSOException);
            }
        }
    }

    private static SSOToken getAdminSSOToken() {
        SSOToken sSOToken = null;
        try {
            SSOTokenManager sSOTokenManager = SSOTokenManager.getInstance();
            String string = (String)AccessController.doPrivileged(new AdminDNAction());
            String string2 = (String)AccessController.doPrivileged(new AdminPasswordAction());
            return sSOTokenManager.createSSOToken((Principal)new AuthPrincipal(string), string2);
        }
        catch (Exception exception) {
            debug.error("AMConsoleListenerManager.getSSOToken", (Throwable)exception);
            return sSOToken;
        }
    }

    public static AMConsoleListenerManager getInstance() {
        return manager;
    }

    public void addMandatoryListener(String string) {
        if (!this.mandatoryListeners.contains(string)) {
            this.mandatoryListeners.add(string);
            this.clearAllListeners();
        }
    }

    public boolean removeMandatoryListener(String string) {
        boolean bl = this.mandatoryListeners.remove(string);
        if (bl) {
            this.clearAllListeners();
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set addConsoleListeners(String string, AMTemplate aMTemplate) {
        HashSet hashSet = null;
        try {
            if (aMTemplate != null) {
                hashSet = aMTemplate.getAttribute("iplanet-am-console-service-listeners");
            } else if (serviceSchemaManager != null) {
                hashSet = AMAdminUtils.getAttribute(serviceSchemaManager, SchemaType.ORGANIZATION, "iplanet-am-console-service-listeners");
            } else {
                debug.error("AMConsoleListenerManager.addConsoleListeners: listeners are not added because Console cannot get an instance of service schema manager.");
            }
        }
        catch (SMSException sMSException) {
            debug.warning("AMConsoleListenerManager.addConsoleListeners", (Throwable)sMSException);
        }
        catch (SSOException sSOException) {
            debug.warning("AMConsoleListenerManager.addConsoleListeners", (Throwable)sSOException);
        }
        catch (AMException aMException) {
            debug.warning("AMConsoleListenerManager.addConsoleListeners", (Throwable)aMException);
        }
        if (hashSet == null || hashSet.isEmpty()) {
            hashSet = AMConsoleListenerManager.getListenerClassesFromSystemProp();
        }
        if (hashSet == null || hashSet.isEmpty()) {
            hashSet = new HashSet(this.mandatoryListeners.size());
        }
        hashSet.addAll(this.mandatoryListeners);
        Set set = this.getListeners(hashSet);
        Map map = this.mapOrgDNToListeners;
        synchronized (map) {
            this.mapOrgDNToListeners.put(string, set);
        }
        return set;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearAllListeners() {
        Map map = this.mapOrgDNToListeners;
        synchronized (map) {
            this.mapOrgDNToListeners.clear();
        }
    }

    private Set getListeners(Set set) {
        HashSet hashSet = new HashSet(set.size());
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            try {
                Object obj = Class.forName(string).newInstance();
                if ((class$com$iplanet$am$console$base$model$AMConsoleListener == null ? AMConsoleListenerManager.class$("com.iplanet.am.console.base.model.AMConsoleListener") : class$com$iplanet$am$console$base$model$AMConsoleListener).isInstance(obj)) {
                    hashSet.add(obj);
                    if (!debug.messageEnabled()) continue;
                    debug.message("AMConsoleListenerManager.addListeners: " + string + " is added");
                    continue;
                }
                debug.error("AMConsoleListenerManager.addListeners: " + string + " is not an instance of " + "com.iplanet.am.console.base.model.AMConsoleListener");
            }
            catch (Exception exception) {
                debug.error("AMConsoleListenerManager.addListeners", (Throwable)exception);
            }
        }
        return hashSet;
    }

    private String getOrganizationDN(String string) {
        int n = this.getLocationType(string);
        while (n != 2 && n != 3 && string.length() > 0) {
            string = AMAdminUtils.getParent(string);
            n = this.getLocationType(string);
        }
        return string;
    }

    private AMTemplate getOrgTemplate(String string) {
        AMTemplate aMTemplate;
        block5: {
            aMTemplate = null;
            if (storeConnection == null) break block5;
            int n = this.getLocationType(string);
            try {
                if (n == 2) {
                    AMOrganization aMOrganization = storeConnection.getOrganization(string);
                    if (!aMOrganization.orgTemplateExists("iPlanetAMAdminConsoleService")) break block5;
                    aMTemplate = aMOrganization.getTemplate("iPlanetAMAdminConsoleService", 302);
                    break block5;
                }
                if (n == 3) {
                    AMOrganizationalUnit aMOrganizationalUnit = storeConnection.getOrganizationalUnit(string);
                    if (!aMOrganizationalUnit.orgTemplateExists("iPlanetAMAdminConsoleService")) break block5;
                    aMTemplate = aMOrganizationalUnit.getTemplate("iPlanetAMAdminConsoleService", 302);
                    break block5;
                }
                debug.error("AMConsoleListenerManager.getOrgTemplate: invalid DN type " + string);
            }
            catch (SSOException sSOException) {
                debug.error("AMConsoleListenerManager.getOrgTemplate", (Throwable)sSOException);
            }
            catch (AMException aMException) {
                debug.error("AMConsoleListenerManager.getOrgTemplate", (Throwable)aMException);
            }
        }
        return aMTemplate;
    }

    public Set getListeners(String string) {
        Set set = null;
        if (string.equals(ROOT)) {
            set = (Set)this.mapOrgDNToListeners.get(ROOT);
            if (set == null) {
                set = this.addConsoleListeners(string, null);
            }
        } else {
            String string2 = this.getOrganizationDN(string);
            set = (Set)this.mapOrgDNToListeners.get(string2);
            if (set == null) {
                set = this.addConsoleListeners(string2, this.getOrgTemplate(string2));
            }
        }
        return set;
    }

    public boolean notifyOnBeforeDisplayModuleTab(AMModel aMModel, String string) {
        boolean bl = true;
        Set set = this.getListeners(aMModel.getLocationDN());
        Iterator iterator = set.iterator();
        while (iterator.hasNext() && bl) {
            AMConsoleListener aMConsoleListener = (AMConsoleListener)iterator.next();
            bl = aMConsoleListener.onBeforeDisplayModuleTab(aMModel, string);
        }
        return bl;
    }

    public void notifyOnBeforeCreateObject(AMModel aMModel, int n, AMObject aMObject, String string, Map map) throws AMConsoleException {
        Set set = this.getListeners(aMObject.getDN());
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            AMConsoleListener aMConsoleListener = (AMConsoleListener)iterator.next();
            aMConsoleListener.onBeforeCreateObject(aMModel, n, aMObject, string, map);
        }
    }

    public void notifyOnAfterCreateObject(AMModel aMModel, AMObject aMObject) {
        Set set = this.getListeners(aMObject.getParentDN());
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            AMConsoleListener aMConsoleListener = (AMConsoleListener)iterator.next();
            aMConsoleListener.onAfterCreateObject(aMModel, aMObject);
        }
    }

    public void notifyOnBeforeDeleteObject(AMModel aMModel, int n, String string) throws AMConsoleException {
        Set set = this.getListeners(aMModel.getLocationDN());
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            AMConsoleListener aMConsoleListener = (AMConsoleListener)iterator.next();
            aMConsoleListener.onBeforeDeleteObject(aMModel, n, string);
        }
    }

    public void notifyOnAfterDeleteObject(AMModel aMModel, int n, String string) {
        Set set = this.getListeners(aMModel.getLocationDN());
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            AMConsoleListener aMConsoleListener = (AMConsoleListener)iterator.next();
            aMConsoleListener.onAfterDeleteObject(aMModel, n, string);
        }
    }

    public void notifyOnBeforeUpdateValues(AMModel aMModel, int n, AMObject aMObject, Map map) throws AMConsoleException {
        Set set = this.getListeners(aMObject.getDN());
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            AMConsoleListener aMConsoleListener = (AMConsoleListener)iterator.next();
            aMConsoleListener.onBeforeUpdateValues(aMModel, n, aMObject, map);
        }
    }

    public void notifyOnAfterUpdateValues(AMModel aMModel, int n, AMObject aMObject) {
        Set set = this.getListeners(aMObject.getDN());
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            AMConsoleListener aMConsoleListener = (AMConsoleListener)iterator.next();
            aMConsoleListener.onAfterUpdateValues(aMModel, n, aMObject);
        }
    }

    public void notifyOnBeforeUpdateDefaultServiceValues(AMModel aMModel, String string, Map map) throws AMConsoleException {
        Set set = this.getListeners(ROOT);
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            AMConsoleListener aMConsoleListener = (AMConsoleListener)iterator.next();
            aMConsoleListener.onBeforeUpdateDefaultServiceValues(aMModel, string, map);
        }
    }

    public void notifyOnAfterUpdateDefaultServiceValues(AMModel aMModel, String string) {
        Set set = this.getListeners(ROOT);
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            AMConsoleListener aMConsoleListener = (AMConsoleListener)iterator.next();
            aMConsoleListener.onAfterUpdateDefaultServiceValues(aMModel, string);
        }
    }

    public void notifyOnRetrieveAttributeValues(AMModel aMModel, AMObject aMObject, int n, int n2, String string, SchemaType schemaType, Map map) {
        String string2 = null;
        string2 = n == 1 ? aMModel.getLocationDN() : (aMObject != null ? aMObject.getDN() : ROOT);
        Set set = this.getListeners(string2);
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            AMConsoleListener aMConsoleListener = (AMConsoleListener)iterator.next();
            aMConsoleListener.onRetrieveAttributeValues(aMModel, aMObject, n, n2, string, schemaType, map);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void schemaChanged(String string, String string2) {
        Map map = this.mapOrgDNToListeners;
        synchronized (map) {
            this.mapOrgDNToListeners.remove(ROOT);
        }
    }

    public void globalConfigChanged(String string, String string2, String string3, String string4, int n) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void organizationConfigChanged(String string, String string2, String string3, String string4, String string5, int n) {
        Map map = this.mapOrgDNToListeners;
        synchronized (map) {
            this.mapOrgDNToListeners.remove(string3);
        }
    }

    private int getLocationType(String string) {
        block3: {
            try {
                return storeConnection.getAMObjectType(string);
            }
            catch (SSOException sSOException) {
                debug.error("AMConsoleListenerManager.getLocationType", (Throwable)sSOException);
            }
            catch (AMException aMException) {
                if (!debug.messageEnabled()) break block3;
                debug.message("AMConsoleListenerManager.getLocationType: couldn't get the type of object for " + string + ". It could be a service");
            }
        }
        return -1;
    }

    private static synchronized Set getListenerClassesFromSystemProp() {
        if (propertiesConsoleListenerClasses == null) {
            String string = SystemProperties.get((String)CONSOLE_LISTENER_CLASSES_PROPERTIES_NAME);
            if (string != null && string.length() > 0) {
                StringTokenizer stringTokenizer = new StringTokenizer(string, ":");
                propertiesConsoleListenerClasses = new HashSet(stringTokenizer.countTokens());
                while (stringTokenizer.hasMoreTokens()) {
                    String string2 = stringTokenizer.nextToken();
                    propertiesConsoleListenerClasses.add(string2.trim());
                }
            } else {
                propertiesConsoleListenerClasses = Collections.EMPTY_SET;
            }
        }
        return propertiesConsoleListenerClasses;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

