/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.am.console.base.model;

import com.iplanet.am.console.base.model.AMAdminConstants;
import com.iplanet.am.console.base.model.AMAdminTypesManager;
import com.iplanet.am.console.base.model.AMAdminUtils;
import com.iplanet.am.console.base.model.AMConsoleException;
import com.iplanet.am.console.base.model.AMModelBase;
import com.iplanet.am.sdk.AMException;
import com.iplanet.am.sdk.AMRole;
import com.iplanet.am.sdk.AMStoreConnection;
import com.iplanet.am.sdk.AMUser;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Iterator;
import java.util.Set;

public class AMAdminTypes
implements AMAdminConstants {
    private AMStoreConnection dpsc = null;
    private AMUser userObj = null;
    private SSOToken token = null;
    private String dn = null;

    public AMAdminTypes(SSOToken sSOToken) {
        this.token = sSOToken;
        try {
            this.dpsc = (AMStoreConnection)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    try {
                        return AMAdminUtils.getStoreConnAsAdmin();
                    }
                    catch (AMConsoleException aMConsoleException) {
                        AMModelBase.debug.error("AMAdminTypes", (Throwable)aMConsoleException);
                        return null;
                    }
                }
            });
            this.dn = sSOToken.getPrincipal().getName();
            if (AMModelBase.debug.messageEnabled()) {
                AMModelBase.debug.message("AMAdminTypes - dn = " + this.dn);
            }
            this.userObj = this.dpsc.getUser(this.dn);
        }
        catch (Exception exception) {
            AMModelBase.debug.error("getting users dn from token", (Throwable)exception);
        }
    }

    public int getRoleType(String string) throws AMException, SSOException {
        if (this.dpsc != null) {
            AMRole aMRole = this.dpsc.getRole(string);
            return aMRole.getRoleType();
        }
        return -1;
    }

    public int getUserType() throws SSOException {
        AMAdminTypesManager aMAdminTypesManager = AMAdminTypesManager.getInstance();
        int n = 3;
        if (this.dn.equalsIgnoreCase(AMAdminTypesManager.superAdmin)) {
            AMModelBase.debug.message("user dn equals super admin dn");
            n = 1;
        } else {
            Integer n2 = (Integer)AMAdminTypesManager.getEntry(this.token);
            if (n2 != null) {
                AMModelBase.debug.message("returning hashed user type");
                n = n2;
            } else {
                String string = this.getUserAdminStartDN();
                if (string != null && string.length() != 0 && !string.equalsIgnoreCase(this.dn)) {
                    AMModelBase.debug.message("start dn is assigned to user");
                    n = 2;
                } else {
                    n = this.getUserHighestAdminRole();
                }
            }
        }
        if (n == 3) {
            AMModelBase.debug.message("user has no admin privilege, end user admin page is shown");
        }
        AMAdminTypesManager.addEntry(this.token, new Integer(n));
        return n;
    }

    private String getUserAdminStartDN() {
        String string;
        block5: {
            string = null;
            try {
                string = this.userObj.getStringAttribute("iplanet-am-user-admin-start-dn");
                if (AMModelBase.debug.messageEnabled()) {
                    AMModelBase.debug.message("AMAdminTypes, iplanet-am-user-admin-start-dn = " + string);
                    AMModelBase.debug.message("AMAdminTypes, user-dn = " + this.dn);
                }
            }
            catch (AMException aMException) {
                if (AMModelBase.debug.warningEnabled()) {
                    AMModelBase.debug.warning("AMAdminTypes.getUserAdminStartDN, user admin start-dn was null");
                }
            }
            catch (SSOException sSOException) {
                if (!AMModelBase.debug.warningEnabled()) break block5;
                AMModelBase.debug.warning("AMAdminTypes.getUserAdminStartDN, couldn't get user admin start-dn");
            }
        }
        return string;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int getUserHighestAdminRole() {
        int n = 3;
        AMModelBase.debug.message("checking if user has any admin roles");
        if (this.dpsc == null) return n;
        try {
            Set set = this.userObj.getRoleDNs();
            set.addAll(this.userObj.getFilteredRoleDNs());
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                if (n == 1) {
                    return n;
                }
                try {
                    AMRole aMRole = this.dpsc.getRole((String)iterator.next());
                    int n2 = aMRole.getRoleType();
                    if (n2 == 3) continue;
                    if (AMModelBase.debug.warningEnabled()) {
                        AMModelBase.debug.warning("AMAdminTypes.getUserOtherAdminRole, user is an administrator");
                    }
                    n = n2;
                }
                catch (AMException aMException) {
                    AMModelBase.debug.warning("AMAdminTypes.getUserHighestAdminRole", (Throwable)aMException);
                }
            }
            return n;
        }
        catch (SSOException sSOException) {
            AMModelBase.debug.error("AMAdminTypes.getUserHighestAdminRole", (Throwable)sSOException);
            return n;
        }
        catch (AMException aMException) {
            AMModelBase.debug.error("AMAdminTypes.getUserHighestAdminRole", (Throwable)aMException);
            return n;
        }
    }
}

