/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.am.console.auth.model;

import com.iplanet.am.console.auth.model.ACServiceInstanceModel;
import com.iplanet.am.console.base.model.AMConsoleException;
import com.iplanet.am.console.base.model.AMModelBase;
import com.iplanet.am.console.service.model.SMDataModelImpl;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.authentication.config.AMAuthConfigUtils;
import com.sun.identity.authentication.config.AMConfigurationException;
import com.sun.identity.sm.AttributeSchema;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.SchemaType;
import com.sun.identity.sm.ServiceSchema;
import com.sun.identity.sm.ServiceSchemaManager;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;

public class ACServiceInstanceModelImpl
extends SMDataModelImpl
implements ACServiceInstanceModel {
    public static final String CONFIGURATION_SCHEMA = "Configurations";
    public static final String NAMED_CONFIGURATION_SCHEMA = "NamedConfiguration";
    protected ServiceSchema confSchema = null;
    protected ServiceSchema namedSchema = null;
    private boolean update = false;
    private String instanceName = null;
    private Map tmpMap = null;

    public ACServiceInstanceModelImpl(HttpServletRequest httpServletRequest, String string, Map map, String string2) {
        super(httpServletRequest, string, map, string2, false);
    }

    public String getUpdateServiceInstanceTitle() {
        StringBuffer stringBuffer = new StringBuffer(100);
        stringBuffer.append(this.instanceName);
        stringBuffer.append(" ");
        stringBuffer.append(this.getLocalizedString("properties.label"));
        return stringBuffer.toString();
    }

    public String getCreateServiceInstanceTitle() {
        return this.getLocalizedString("createServiceInstanceTitle.label");
    }

    public String getCancelButtonLabel() {
        return this.getLocalizedString("cancel.button");
    }

    public String getErrorTitle() {
        return this.getLocalizedString("error.title");
    }

    private void updateServiceInstance(String string, String string2, Map map) throws AMConsoleException {
        this.tmpMap = map;
        try {
            AMAuthConfigUtils.replaceNamedConfig((String)string2, (int)0, (Map)map, (String)string, (SSOToken)this.ssoToken);
            this.writeLog(string2, string, "authConfigChanged.message", map, this.orgAttrs);
        }
        catch (SMSException sMSException) {
            AMModelBase.debug.warning("ACServiceInstanceModelImpl.updateServiceInstance", (Throwable)sMSException);
            this.errorMessage = this.getErrorString((Exception)((Object)sMSException));
            throw new AMConsoleException(this.errorMessage);
        }
        catch (AMConfigurationException aMConfigurationException) {
            AMModelBase.debug.warning("ACServiceInstanceModelImpl.updateServiceInstance", (Throwable)aMConfigurationException);
            this.errorMessage = this.getErrorString((Exception)((Object)aMConfigurationException));
            throw new AMConsoleException(this.errorMessage);
        }
        catch (SSOException sSOException) {
            AMModelBase.debug.warning("ACServiceInstanceModelImpl.updateServiceInstance", (Throwable)sSOException);
            this.errorMessage = this.getErrorString((Exception)((Object)sSOException));
            throw new AMConsoleException(this.errorMessage);
        }
        this.tmpMap = null;
    }

    protected void getOrgSchema() {
        block5: {
            try {
                ServiceSchemaManager serviceSchemaManager = this.getServiceSchemaManager(this.svcName);
                this.orgSvcSchema = serviceSchemaManager.getSchema(SchemaType.ORGANIZATION);
                if (this.orgSvcSchema == null) break block5;
                this.confSchema = this.orgSvcSchema.getSubSchema(CONFIGURATION_SCHEMA);
                if (this.confSchema == null) break block5;
                this.namedSchema = this.confSchema.getSubSchema(NAMED_CONFIGURATION_SCHEMA);
                if (this.namedSchema == null) break block5;
                this.orgAttrSchemaList = this.getAttributeSchemas(this.namedSchema);
                if (this.update) {
                    this.orgSize = this.orgAttrSchemaList.size();
                    this.orgAttrs = this.getInstanceValues(this.instanceName, this.getLocationDN());
                    break block5;
                }
                this.removeEdit(this.orgAttrSchemaList);
                this.orgSize = this.orgAttrSchemaList.size();
                if (this.tmpMap == null) {
                    this.orgAttrs = this.getAuthAttributes(this.orgAttrSchemaList);
                    break block5;
                }
                this.orgAttrs = this.tmpMap;
            }
            catch (SSOException sSOException) {
                this.orgAttrSchemaList = Collections.EMPTY_LIST;
                this.orgSize = 0;
                AMModelBase.debug.warning("ACServiceInstanceModelImpl.getOrgSchema", (Throwable)sSOException);
            }
            catch (SMSException sMSException) {
                this.orgAttrSchemaList = Collections.EMPTY_LIST;
                this.orgSize = 0;
                AMModelBase.debug.error("ACServiceInstanceModelImpl.getOrgSchema", (Throwable)sMSException);
            }
        }
    }

    public void store(int n, Map map) throws AMConsoleException {
        String string = this.getLocationDN();
        if (map != null && !map.isEmpty()) {
            if (!this.processed) {
                this.process();
            }
            switch (n) {
                case 1: {
                    if (this.update) {
                        this.updateServiceInstance(string, this.instanceName, map);
                        break;
                    }
                    this.createServiceInstance(string, this.instanceName, map);
                    break;
                }
                default: {
                    this.errorTitle = this.getLocalizedString("errorMessage.title");
                    this.errorMessage = this.getLocalizedString("invalidServiceType.message");
                    AMModelBase.debug.error("SMDataModelImpl.store: " + this.errorMessage);
                    throw new AMConsoleException(this.errorMessage);
                }
            }
        }
    }

    public void setInstanceName(String string) {
        this.instanceName = string;
    }

    public String getInstanceNameLabel() {
        return this.getLocalizedString("instanceName.label");
    }

    public String getMissingInstanceNameMessage() {
        return this.getLocalizedString("missingInstanceName.message");
    }

    public String getRequiredLabel() {
        return this.getLocalizedString("required.label");
    }

    private void createServiceInstance(String string, String string2, Map map) throws AMConsoleException {
        this.tmpMap = map;
        try {
            AMAuthConfigUtils.createNamedConfig((String)string2, (int)0, (Map)map, (String)string, (SSOToken)this.ssoToken);
            this.writeLog(string2, string, "authConfigCreated.message");
        }
        catch (SMSException sMSException) {
            AMModelBase.debug.warning("ACServiceInstanceModelImpl.createServiceInstance", (Throwable)sMSException);
            this.errorMessage = this.getErrorString((Exception)((Object)sMSException));
            throw new AMConsoleException(this.errorMessage);
        }
        catch (AMConfigurationException aMConfigurationException) {
            AMModelBase.debug.warning("ACServiceInstanceModelImpl.createServiceInstance", (Throwable)aMConfigurationException);
            this.errorMessage = this.getErrorString((Exception)((Object)aMConfigurationException));
            throw new AMConsoleException(this.errorMessage);
        }
        catch (SSOException sSOException) {
            AMModelBase.debug.warning("ACServiceInstanceModelImpl.createServiceInstance", (Throwable)sSOException);
            this.errorMessage = this.getErrorString((Exception)((Object)sSOException));
            throw new AMConsoleException(this.errorMessage);
        }
        this.tmpMap = null;
    }

    public void setUpdateState(boolean bl) {
        this.update = bl;
    }

    public Map getInstanceValues(String string, String string2) {
        Map map = Collections.EMPTY_MAP;
        try {
            map = AMAuthConfigUtils.getNamedConfig((String)string, (String)string2, (SSOToken)this.ssoToken);
        }
        catch (SSOException sSOException) {
            AMModelBase.debug.error("ACServiceInstanceModelImpl.populateInstanceValues", (Throwable)sSOException);
        }
        catch (SMSException sMSException) {
            AMModelBase.debug.error("ACServiceInstanceModelImpl.populateInstanceValues", (Throwable)sMSException);
        }
        catch (AMConfigurationException aMConfigurationException) {
            AMModelBase.debug.error("ACServiceInstanceModelImpl.populateInstanceValues", (Throwable)aMConfigurationException);
        }
        return map;
    }

    private Map getAuthAttributes(List list) {
        HashMap<String, Set> hashMap = Collections.EMPTY_MAP;
        if (list != null && !list.isEmpty()) {
            int n = list.size();
            hashMap = new HashMap<String, Set>(n);
            int n2 = 0;
            while (n2 < n) {
                AttributeSchema attributeSchema = (AttributeSchema)list.get(n2);
                hashMap.put(attributeSchema.getName(), Collections.EMPTY_SET);
                ++n2;
            }
        }
        return hashMap;
    }

    private void removeEdit(List list) {
        int n = list.size();
        int n2 = 0;
        while (n2 < n) {
            AttributeSchema attributeSchema = (AttributeSchema)list.get(n2);
            String string = attributeSchema.getName();
            if (string.equals("iplanet-am-auth-configuration")) {
                list.remove(n2);
                break;
            }
            ++n2;
        }
    }

    private void writeLog(String string, String string2, String string3) {
        if (this.logger.isEnabled()) {
            Object[] objectArray = new String[]{string, this.svcName, string2};
            this.writeFormatLog(string3, objectArray);
        }
    }

    private void writeLog(String string, String string2, String string3, Map map, Map map2) {
        if (map2 == null) {
            return;
        }
        if (this.logger.isEnabled()) {
            Iterator iterator = map2.keySet().iterator();
            while (iterator.hasNext()) {
                String string4 = (String)iterator.next();
                Set set = (Set)map2.get(string4);
                Set set2 = (Set)map.get(string4);
                Object[] objectArray = new String[3];
                objectArray[0] = this.svcName;
                objectArray[2] = string2;
                if (set2 == null || set2.equals(set)) continue;
                objectArray[1] = string + ":" + string4 + " " + set + "->" + set2;
                this.writeFormatLog(string3, objectArray);
            }
        }
    }

    public String getHelpAnchorTag() {
        String string = this.getLocalizedString("authServiceInstance.help");
        if (string.equals("authServiceInstance.help")) {
            string = "contents.html";
        }
        return this.getHelpURL(string);
    }
}

